/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.udf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.FunctionParameter;
import org.teiid.designer.metamodels.function.FunctionPlugin;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.util.PushdownFunctionData;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.udf.FunctionMethodDescriptor;
import org.teiid.designer.udf.FunctionParameterDescriptor;
import org.teiid.designer.udf.IFunctionDescriptor;
import org.teiid.designer.udf.IFunctionForm;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfPlugin;

public final class UdfManager
implements IResourceChangeListener {
    public static final String RELATIONAL_EXT_PROP_PREFIX = "relational:";
    public static final String FUNCTION_CATEGORY_PROP = "relational:function-category";
    public static final String JAVA_CLASS_PROP = "relational:java-class";
    public static final String JAVA_METHOD_PROP = "relational:java-method";
    private static UdfManager INSTANCE;
    private ModelObjectAnnotationHelper ANNOTATION_HELPER = new ModelObjectAnnotationHelper();
    private IFunctionLibrary systemFunctionLibrary;
    private IFunctionLibrary cachedFunctionLibrary;
    private Set<ModelResource> functionModels = new HashSet<ModelResource>();
    private volatile boolean initialized;
    private boolean changed = false;
    private ITeiidServerVersionListener teiidServerVersionListener = new ITeiidServerVersionListener(){

        public void serverChanged(ITeiidServer server) {
        }

        public void versionChanged(ITeiidServerVersion version) {
            UdfManager.this.systemFunctionLibrary = null;
            UdfManager.this.cachedFunctionLibrary = null;
        }
    };

    public static UdfManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UdfManager();
            try {
                INSTANCE.initialize();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return INSTANCE;
    }

    private UdfManager() {
    }

    public synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ModelerCore.addTeiidServerVersionListener((ITeiidServerVersionListener)this.teiidServerVersionListener);
        Collection allResources = WorkspaceResourceFinderUtil.getProjectFileResources();
        try {
            for (IResource next : allResources) {
                Collection<Procedure> functionProcs;
                if (!ModelUtil.isModelFile((IResource)next, (boolean)true)) continue;
                ModelResource mr = ModelUtil.getModelResource((IFile)((IFile)next), (boolean)true);
                int theModelType = mr.getModelType().getValue();
                if (theModelType == ModelType.FUNCTION) {
                    this.registerFunctionModel(mr, false);
                    continue;
                }
                if (theModelType != ModelType.PHYSICAL && theModelType != ModelType.VIRTUAL || (functionProcs = this.getFunctions(mr)).isEmpty()) continue;
                this.registerFunctionModel(mr, false);
            }
        }
        catch (Exception err) {
            UdfPlugin.UTIL.log((Throwable)err);
        }
        this.initialized = true;
    }

    private boolean isFunctionObjectErrorFree(EObject functionEObject, IMarker[] markers, ModelResource udfModelResource) {
        if (markers != null && markers.length > 0) {
            int ndx = markers.length;
            while (--ndx >= 0) {
                Object attribute;
                block8: {
                    IMarker iMarker = markers[ndx];
                    EObject targetEObject = null;
                    try {
                        targetEObject = ModelWorkspaceManager.getModelWorkspaceManager().getMarkerManager().getMarkedEObject(udfModelResource.getCorrespondingResource(), iMarker);
                    }
                    catch (ModelWorkspaceException ex) {
                        UdfPlugin.UTIL.log((Throwable)ex);
                    }
                    if (targetEObject != functionEObject) continue;
                    attribute = null;
                    if (iMarker != null) {
                        try {
                            attribute = iMarker.getAttribute("severity");
                        }
                        catch (CoreException e) {
                            if (!(e instanceof ModelerCoreException)) break block8;
                            UdfPlugin.UTIL.log((Throwable)e);
                        }
                    }
                }
                if (attribute == null) {
                    return true;
                }
                int severity = (Integer)attribute;
                if (severity != 2) continue;
                return false;
            }
        }
        return true;
    }

    private IMarker[] getMarkers(ModelResource udfModelResource) {
        IResource resrc = null;
        if (udfModelResource != null && udfModelResource.exists()) {
            resrc = udfModelResource.getResource();
        }
        if (resrc != null) {
            IMarker[] markers = null;
            try {
                markers = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
            catch (CoreException ex) {
                UdfPlugin.UTIL.log((Throwable)ex);
                return new Marker[0];
            }
            return markers;
        }
        return new Marker[0];
    }

    private synchronized boolean makeModification(ModelResource modelResource, boolean deleted) throws Exception {
        boolean result = false;
        result = deleted ? this.functionModels.remove(modelResource) : this.functionModels.add(modelResource);
        return result;
    }

    public void registerFunctionModel(ModelResource modelResource, boolean delete) throws Exception {
        this.makeModification(modelResource, delete);
        this.changed = true;
    }

    public void notifySourceModelChanged(ModelResource modelResource, boolean delete) {
        this.changed = true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject project;
        if (!this.initialized) {
            return;
        }
        if (ResourceChangeUtilities.isPreClose((IResourceChangeEvent)event)) {
            IProject project2 = (IProject)event.getResource();
            if (ModelerCore.hasModelNature((IProject)project2)) {
                this.modelProjectClosed(project2);
            }
        } else if (ResourceChangeUtilities.isPreDelete((IResourceChangeEvent)event) && ModelerCore.hasModelNature((IProject)(project = (IProject)event.getResource()))) {
            this.modelProjectDeleted(project);
        }
    }

    private void modelProjectClosed(IProject project) {
        this.unregisterProject(project);
    }

    private void modelProjectDeleted(IProject project) {
        if (!project.isOpen()) {
            return;
        }
        this.unregisterProject(project);
    }

    private void unregisterProject(IProject project) {
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    this.folderDeleted((IFolder)res);
                } else if (res instanceof IFile) {
                    this.fileDeleted((IFile)res);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            UdfPlugin.UTIL.log((Throwable)ex);
        }
        catch (Exception ex) {
            UdfPlugin.UTIL.log((Throwable)ex);
        }
    }

    private void folderDeleted(IFolder folder) throws CoreException, Exception {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                this.folderDeleted((IFolder)res);
            } else if (res instanceof IFile) {
                this.fileDeleted((IFile)res);
            }
            ++n2;
        }
    }

    private void fileDeleted(IFile file) throws ModelWorkspaceException, Exception {
        ModelResource modelResource = ModelerCore.getModelEditor().findModelResource((IResource)file);
        if (modelResource != null) {
            INSTANCE.registerFunctionModel(modelResource, true);
        }
    }

    public void shutdown() {
        ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ModelerCore.removeTeiidServerVersionListener((ITeiidServerVersionListener)this.teiidServerVersionListener);
    }

    public IFunctionLibrary<IFunctionForm, IFunctionDescriptor> getSystemFunctionLibrary() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        if (this.systemFunctionLibrary == null) {
            this.systemFunctionLibrary = queryService.createFunctionLibrary();
        }
        return this.systemFunctionLibrary;
    }

    public synchronized IFunctionLibrary<IFunctionForm, IFunctionDescriptor> getFunctionLibrary() {
        FunctionParameterDescriptor outputParam;
        Object returnParamName;
        if (!this.changed && this.cachedFunctionLibrary != null) {
            return this.cachedFunctionLibrary;
        }
        ArrayList<FunctionMethodDescriptor> functionMethodDescriptors = new ArrayList<FunctionMethodDescriptor>();
        for (ModelResource functionModelResource : this.functionModels) {
            ScalarFunction[] functions = this.getScalarFunctions(functionModelResource);
            if (functions.length == 0) continue;
            IMarker[] markers = this.getMarkers(functionModelResource);
            String schema = FileUtils.getFilenameWithoutExtension((String)functionModelResource.getItemName());
            ScalarFunction[] scalarFunctionArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                ScalarFunction function = scalarFunctionArray[n2];
                if (this.isFunctionObjectErrorFree((EObject)function.getReturnParameter(), markers, functionModelResource) && function.getReturnParameter() != null && this.isFunctionObjectErrorFree((EObject)function.getReturnParameter(), markers, functionModelResource)) {
                    String description = null;
                    try {
                        description = ModelerCore.getModelEditor().getDescription((EObject)function);
                    }
                    catch (ModelerCoreException ex) {
                        UdfPlugin.UTIL.log((Throwable)ex);
                    }
                    boolean functionPamameterHasError = false;
                    ArrayList<FunctionParameterDescriptor> fParams = new ArrayList<FunctionParameterDescriptor>();
                    for (Object inputParam : function.getInputParameters()) {
                        if (!(inputParam instanceof FunctionParameter)) continue;
                        FunctionParameter param = (FunctionParameter)inputParam;
                        fParams.add(new FunctionParameterDescriptor(param.getName(), param.getType()));
                        if (functionPamameterHasError || this.isFunctionObjectErrorFree((EObject)param, markers, functionModelResource)) continue;
                        functionPamameterHasError = true;
                    }
                    if (!functionPamameterHasError) {
                        returnParamName = ModelerCore.getModelEditor().getName((EObject)function.getReturnParameter());
                        outputParam = new FunctionParameterDescriptor((String)returnParamName, function.getReturnParameter().getType());
                        FunctionMethodDescriptor fMethodDescriptor = new FunctionMethodDescriptor((Object)function, function.getName(), description, function.getCategory(), function.getInvocationClass(), function.getInvocationMethod(), fParams.toArray(new FunctionParameterDescriptor[0]), outputParam, schema);
                        fMethodDescriptor.setPushDown(function.getPushDown().getLiteral());
                        fMethodDescriptor.setDeterministic(function.isDeterministic());
                        boolean varArgs = false;
                        String propValue = FunctionPlugin.getExtensionProperty((EObject)function, (String)"function:varargs");
                        if (propValue != null && propValue.length() > 0) {
                            varArgs = Boolean.parseBoolean(propValue);
                        }
                        fMethodDescriptor.setVariableArgs(varArgs);
                        functionMethodDescriptors.add(fMethodDescriptor);
                    }
                }
                ++n2;
            }
        }
        for (ModelResource sourceModel : this.getRelationalModels()) {
            IMarker[] markers = this.getMarkers(sourceModel);
            String schema = FileUtils.getFilenameWithoutExtension((String)sourceModel.getItemName());
            for (Procedure procedure : this.getFunctions(sourceModel)) {
                boolean isPhysical = ModelUtil.isPhysical((Object)procedure);
                ProcedureWrapper wrappedProcedure = new ProcedureWrapper(procedure);
                if (!this.isFunctionObjectErrorFree((EObject)wrappedProcedure.getReturnParameter(), markers, sourceModel) || wrappedProcedure.getReturnParameter() == null || !this.isFunctionObjectErrorFree((EObject)wrappedProcedure.getReturnParameter(), markers, sourceModel)) continue;
                String description = null;
                try {
                    description = ModelerCore.getModelEditor().getDescription((EObject)procedure);
                }
                catch (ModelerCoreException ex) {
                    UdfPlugin.UTIL.log((Throwable)ex);
                }
                boolean functionPamameterHasError = false;
                ArrayList<FunctionParameterDescriptor> fParams = new ArrayList<FunctionParameterDescriptor>();
                for (ProcedureParameter inputParam : wrappedProcedure.getInputParameters()) {
                    String dTypeName = ModelerCore.getModelEditor().getName(inputParam.getType());
                    fParams.add(new FunctionParameterDescriptor(inputParam.getName(), dTypeName));
                    if (functionPamameterHasError || this.isFunctionObjectErrorFree((EObject)inputParam, markers, sourceModel)) continue;
                    functionPamameterHasError = true;
                }
                if (functionPamameterHasError) continue;
                String dTypeName = ModelerCore.getModelEditor().getName(wrappedProcedure.getReturnParameter().getType());
                returnParamName = ModelerCore.getModelEditor().getName((EObject)wrappedProcedure.getReturnParameter());
                outputParam = new FunctionParameterDescriptor((String)returnParamName, dTypeName);
                String category = wrappedProcedure.getCategory();
                String javaClass = wrappedProcedure.getJavaClass();
                String javaMethod = wrappedProcedure.getJavaMethod();
                boolean javaClassAndMethodEmpty = javaClass == null && javaMethod == null;
                boolean isPushdown = false;
                if (isPhysical && javaClassAndMethodEmpty) {
                    isPushdown = true;
                    category = sourceModel.getItemName();
                    if (category.endsWith(".xmi")) {
                        category = category.replaceAll(".xmi", "");
                    }
                }
                FunctionMethodDescriptor fMethodDescriptor = new FunctionMethodDescriptor((Object)procedure, wrappedProcedure.getName(), description, category, javaClass, javaMethod, fParams.toArray(new FunctionParameterDescriptor[0]), outputParam, schema);
                if (isPushdown) {
                    fMethodDescriptor.setPushDown(Boolean.toString(true));
                }
                fMethodDescriptor.setDeterministic(wrappedProcedure.isDeterministic());
                boolean varArgs = false;
                String propValue = RelationalPlugin.getExtensionProperty((EObject)procedure, (String)"relational:varargs");
                if (propValue != null && propValue.length() > 0) {
                    varArgs = Boolean.parseBoolean(propValue);
                }
                fMethodDescriptor.setVariableArgs(varArgs);
                functionMethodDescriptors.add(fMethodDescriptor);
            }
        }
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        this.cachedFunctionLibrary = queryService.createFunctionLibrary(functionMethodDescriptors);
        this.changed = false;
        return this.cachedFunctionLibrary;
    }

    private Collection<Procedure> getFunctions(ModelResource relationalModel) {
        ArrayList<Procedure> functions = new ArrayList<Procedure>();
        try {
            ModelObjectCollector moc = new ModelObjectCollector(relationalModel.getEmfResource());
            for (Object eObj : moc.getEObjects()) {
                if (!(eObj instanceof Procedure) || !((Procedure)eObj).isFunction()) continue;
                functions.add((Procedure)eObj);
            }
        }
        catch (CoreException ex) {
            UdfPlugin.UTIL.log((Throwable)ex);
        }
        return functions;
    }

    private Collection<ModelResource> getRelationalModels() {
        ArrayList<ModelResource> relationalMdls = new ArrayList<ModelResource>();
        try {
            ModelResource[] allModels;
            ModelResource[] modelResourceArray = allModels = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().getModelResources();
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                ModelResource model = modelResourceArray[n2];
                String uri = model.getPrimaryMetamodelUri();
                if ("http://www.metamatrix.com/metamodels/Relational".equalsIgnoreCase(uri)) {
                    relationalMdls.add(model);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            UdfPlugin.UTIL.log((Throwable)ex);
        }
        return relationalMdls;
    }

    private ScalarFunction[] getScalarFunctions(ModelResource mr) {
        ScalarFunctionFinder visitor = new ScalarFunctionFinder();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor, 1);
        try {
            processor.walk(mr, 2);
        }
        catch (ModelerCoreException ex) {
            UdfPlugin.UTIL.log((Throwable)ex);
        }
        return visitor.getFunctions();
    }

    class ProcedureWrapper {
        Procedure procedure;
        ProcedureParameter returnParam;
        Collection<ProcedureParameter> inputParams;
        boolean deterministic = false;
        String category;
        String javaClass;
        String javaMethod;

        public ProcedureWrapper(Procedure procedure) {
            this.procedure = procedure;
            this.init();
        }

        private void init() {
            this.inputParams = new ArrayList<ProcedureParameter>();
            for (Object obj : this.procedure.getParameters()) {
                ProcedureParameter param = (ProcedureParameter)obj;
                if (param.getDirection() == DirectionKind.IN_LITERAL) {
                    this.inputParams.add(param);
                    continue;
                }
                if (param.getDirection() != DirectionKind.RETURN_LITERAL) continue;
                this.returnParam = param;
            }
            try {
                Object determValue;
                Properties relationalProps = UdfManager.this.ANNOTATION_HELPER.getProperties((EObject)this.procedure, UdfManager.RELATIONAL_EXT_PROP_PREFIX);
                Properties extProps = UdfManager.this.ANNOTATION_HELPER.getExtendedProperties((EObject)this.procedure);
                if (extProps != null && extProps.size() > 0 && (determValue = extProps.get(PushdownFunctionData.DETERMINISTIC_PROPERTY_KEY)) != null) {
                    this.deterministic = Boolean.valueOf((String)determValue);
                }
                if (relationalProps != null && relationalProps.size() > 0) {
                    Object javaMethodValue;
                    Object javaClassValue;
                    Object categoryValue = relationalProps.get(UdfManager.FUNCTION_CATEGORY_PROP);
                    if (categoryValue != null && !((String)categoryValue).isEmpty()) {
                        this.category = (String)categoryValue;
                    }
                    if ((javaClassValue = relationalProps.get(UdfManager.JAVA_CLASS_PROP)) != null && !((String)javaClassValue).isEmpty()) {
                        this.javaClass = (String)javaClassValue;
                    }
                    if ((javaMethodValue = relationalProps.get(UdfManager.JAVA_METHOD_PROP)) != null && !((String)javaMethodValue).isEmpty()) {
                        this.javaMethod = (String)javaMethodValue;
                    }
                }
            }
            catch (ModelerCoreException ex) {
                UdfPlugin.UTIL.log((Throwable)ex);
            }
        }

        public ProcedureParameter getReturnParameter() {
            return this.returnParam;
        }

        public Collection<ProcedureParameter> getInputParameters() {
            return this.inputParams;
        }

        public String getName() {
            return ModelerCore.getModelEditor().getName((EObject)this.procedure);
        }

        public boolean isDeterministic() {
            return this.deterministic;
        }

        public String getCategory() {
            return this.category;
        }

        public String getJavaClass() {
            return this.javaClass;
        }

        public String getJavaMethod() {
            return this.javaMethod;
        }
    }

    class ScalarFunctionFinder
    implements ModelVisitor {
        Collection<ScalarFunction> functions;

        ScalarFunctionFinder() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof ScalarFunction) {
                if (this.functions == null) {
                    this.functions = new ArrayList<ScalarFunction>();
                }
                this.functions.add((ScalarFunction)object);
                return true;
            }
            return false;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }

        public ScalarFunction[] getFunctions() {
            if (this.functions == null) {
                this.functions = new ArrayList<ScalarFunction>();
            }
            return this.functions.toArray(new ScalarFunction[0]);
        }
    }
}

