/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IFromClause;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.IInto;
import org.teiid.designer.query.sql.lang.IOption;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.util.SqlAspectHelper;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class AddJoinExpressionAction
extends TransformationAction {
    public AddJoinExpressionAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        boolean enable = this.shouldEnable();
        this.setEnabled(enable);
    }

    @Override
    protected void doRun() {
        ISelection theSelection = this.getSelection();
        List selectedEObjs = SelectionUtilities.getSelectedEObjects((ISelection)theSelection);
        Object selection1 = selectedEObjs.get(0);
        Object selection2 = selectedEObjs.get(1);
        if (selection1 != null && selection2 != null && selection1 instanceof EObject && selection2 instanceof EObject) {
            TransformationObjectEditorPage transOEP;
            SqlEditorPanel sqlEditor;
            ICommand command;
            ModelObjectEditorPage moep;
            EObject col1 = (EObject)selection1;
            EObject col2 = (EObject)selection2;
            String joinClause = this.buildJoinFromClause(col1, col2);
            IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage && (command = (sqlEditor = (transOEP = (TransformationObjectEditorPage)moep).getCurrentSqlEditor()).getCommand()) instanceof IQuery) {
                IQuery query = (IQuery)command;
                ISelect select = query.getSelect();
                String newQuery = "SELECT " + select.toString() + joinClause;
                sqlEditor.setText(newQuery);
            }
        }
    }

    private String buildJoinFromClause(EObject col1, EObject col2) {
        EObject col1Parent = col1.eContainer();
        EObject col2Parent = col2.eContainer();
        String col1Name = TransformationHelper.getSqlEObjectFullName((EObject)col1);
        String col1ParentName = TransformationHelper.getSqlEObjectFullName((EObject)col1Parent);
        String col2Name = TransformationHelper.getSqlEObjectFullName((EObject)col2);
        String col2ParentName = TransformationHelper.getSqlEObjectFullName((EObject)col2Parent);
        StringBuffer sb = new StringBuffer(" FROM ");
        sb.append(col1ParentName);
        sb.append(" INNER JOIN ");
        sb.append(col2ParentName);
        sb.append(" ON ");
        sb.append(col1Name);
        sb.append(" = ");
        sb.append(col2Name);
        return sb.toString();
    }

    private boolean shouldEnable() {
        boolean enable = false;
        List selectedEObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        if (!selectedEObjs.isEmpty() && selectedEObjs.size() == 2 && !ModelObjectUtilities.isReadOnly((EObject)this.getTransformation()) && !this.isDependencyDiagram() && this.getTransformation() != null && this.areEObjectsSelected()) {
            TransformationObjectEditorPage transOEP;
            ModelObjectEditorPage moep;
            boolean editorOpen = false;
            SqlEditorPanel sqlEditor = null;
            IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) instanceof TransformationObjectEditorPage && (sqlEditor = (transOEP = (TransformationObjectEditorPage)moep).getCurrentSqlEditor()) != null) {
                editorOpen = true;
            }
            if (editorOpen && this.isSimpleQuery(sqlEditor)) {
                Object selection1 = selectedEObjs.get(0);
                Object selection2 = selectedEObjs.get(1);
                if (selection1 instanceof EObject && selection2 instanceof EObject) {
                    EObject eObj1 = (EObject)selection1;
                    EObject eObj2 = (EObject)selection2;
                    EObject eObj1Parent = eObj1.eContainer();
                    EObject eObj2Parent = eObj2.eContainer();
                    if (eObj1Parent != null && eObj2Parent != null && org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper.isColumn((EObject)eObj1) && org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper.isColumn((EObject)eObj2) && !SqlAspectHelper.isInputParameter((EObject)eObj1) && !SqlAspectHelper.isInputParameter((EObject)eObj2)) {
                        EList transOutputs = ((SqlTransformationMappingRoot)this.getTransformation()).getOutputs();
                        if (transOutputs.contains(eObj1Parent) || transOutputs.contains(eObj2Parent)) {
                            return false;
                        }
                        if (eObj1Parent.equals(eObj2Parent)) {
                            return false;
                        }
                        enable = true;
                    }
                }
            }
        }
        return enable;
    }

    private boolean isSimpleQuery(SqlEditorPanel sqlEditor) {
        boolean isSimpleQuery = false;
        ICommand command = sqlEditor.getCommand();
        if (command != null && command instanceof IQuery) {
            List fromClauses;
            IQuery query = (IQuery)command;
            ISelect select = query.getSelect();
            IFrom from = query.getFrom();
            ICriteria criteria = query.getCriteria();
            IGroupBy groupBy = query.getGroupBy();
            ICriteria having = query.getHaving();
            IInto into = query.getInto();
            IOption option = query.getOption();
            IOrderBy orderBy = query.getOrderBy();
            if (select != null && from != null && criteria == null && groupBy == null && having == null && into == null && option == null && orderBy == null && (fromClauses = from.getClauses()).size() == 2) {
                boolean allUnary = true;
                for (IFromClause fromClause : fromClauses) {
                    if (fromClause instanceof IUnaryFromClause) continue;
                    allUnary = false;
                    break;
                }
                if (allUnary) {
                    isSimpleQuery = true;
                }
            }
        }
        return isSimpleQuery;
    }
}

