/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.AliasEntryDialog;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class AliasEntryPanel
extends Composite
implements ModifyListener {
    private static final int LABEL_GRID_STYLE = 32;
    private static final String LEADING_TEXT = UiConstants.Util.getString("AliasEntryPanel.leadingText", new Object[0]);
    private static final String ALIAS_LABEL_TEXT = UiConstants.Util.getString("AliasEntryPanel.aliasLabel.text", new Object[0]);
    private static final String SOURCE_LABEL_TEXT = UiConstants.Util.getString("AliasEntryPanel.tableText", new Object[0]);
    private static final String NO_ALIAS_ENTERED = UiConstants.Util.getString("AliasEntryPanel.noAliasEntered", new Object[0]);
    private static final String DUPLICATE_ALIAS_ENTERED = UiConstants.Util.getString("AliasEntryPanel.duplicateAliasEntered", new Object[0]);
    private Text aliasText;
    private String tableString;
    private CLabel messageLabel;
    private Object sourceEObject;
    private Object transRoot;
    private AliasEntryDialog dlg;

    public AliasEntryPanel(AliasEntryDialog dlg, Composite parent, String tableName, Object transRoot, Object sourceEObject) {
        super(parent, 0);
        this.tableString = tableName;
        this.transRoot = transRoot;
        this.sourceEObject = sourceEObject;
        this.dlg = dlg;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        WidgetFactory.createLabel((Composite)this, (int)32, (int)1, (String)LEADING_TEXT);
        Composite aliasPanel = new Composite((Composite)this, 0);
        GridLayout aliasLayout = new GridLayout();
        aliasPanel.setLayout((Layout)aliasLayout);
        aliasLayout.numColumns = 2;
        Label tableLabel = new Label(aliasPanel, 0);
        tableLabel.setText(String.valueOf(SOURCE_LABEL_TEXT) + " ");
        Label sourceLabel = new Label(aliasPanel, 0);
        sourceLabel.setText(this.tableString);
        Label aliasLabel = new Label(aliasPanel, 0);
        aliasLabel.setText(String.valueOf(ALIAS_LABEL_TEXT) + " ");
        this.aliasText = WidgetFactory.createTextField((Composite)aliasPanel);
        this.aliasText.setTextLimit(50);
        this.aliasText.addModifyListener((ModifyListener)this);
        GridData aliasTextGridData = new GridData();
        this.aliasText.setLayoutData((Object)aliasTextGridData);
        this.messageLabel = WidgetFactory.createLabel((Composite)this);
        this.messageLabel.setText(" ");
        GridData messageData = new GridData(1808);
        messageData.grabExcessHorizontalSpace = true;
        messageData.grabExcessVerticalSpace = true;
        this.messageLabel.setLayoutData((Object)messageData);
    }

    public String getAliasName() {
        return this.aliasText.getText();
    }

    public void modifyText(ModifyEvent e) {
        String text = this.aliasText.getText();
        if (text == null || text.trim().equals("")) {
            this.setError(NO_ALIAS_ENTERED);
            this.dlg.setOkEnabled(false);
        } else if (!this.isValidAlias(text)) {
            this.setError(DUPLICATE_ALIAS_ENTERED);
            this.dlg.setOkEnabled(false);
        } else {
            this.setError(null);
            this.dlg.setOkEnabled(true);
        }
    }

    private boolean isValidAlias(String text) {
        return !TransformationHelper.containsSqlAliasName((Object)this.transRoot, (String)text, (Object)this.sourceEObject);
    }

    private void setError(String message) {
        if (message == null) {
            this.messageLabel.setImage(null);
        } else {
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            this.messageLabel.setImage(image);
        }
        this.messageLabel.setText(message);
        this.messageLabel.redraw();
    }
}

