/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.functions.ConvertFunctionModelDialog;
import org.teiid.designer.transformation.ui.wizards.functions.ConvertFunctionModelHelper;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class ConvertFunctionsToVirtualProceduresAction
extends SortableSelectionAction {
    public static final String OPEN_EDITOR_TITLE = UiConstants.Util.getString("ConvertFunctionsToVirtualProceduresAction.openModelEditorTitle", new Object[0]);
    public static final String OPEN_EDITOR_MESSAGE = UiConstants.Util.getString("ConvertFunctionsToVirtualProceduresAction.openModelEditorMessage", new Object[0]);
    public static final String ALWAY_FORCE_OPEN_MESSAGE = UiConstants.Util.getString("ConvertFunctionsToVirtualProceduresAction.alwaysForceOpenMessage", new Object[0]);

    public ConvertFunctionsToVirtualProceduresAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/materialized_views.png"));
    }

    public boolean isValidSelection(ISelection selection) {
        return this.functionModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource functionModel = null;
            try {
                functionModel = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (functionModel != null) {
                    ConvertFunctionModelHelper helper = new ConvertFunctionModelHelper(functionModel);
                    System.out.println("ConvertFunctionsToVirtualProceduresAction.run() called.  Model = " + functionModel.getItemName());
                    ConvertFunctionModelDialog dialog = new ConvertFunctionModelDialog(Display.getCurrent().getActiveShell(), helper);
                    if (dialog.open() == 0) {
                        helper.generateProcedures();
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.functionModelSelected(selection);
    }

    private boolean functionModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isFunctionModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }
}

