/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialog;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.TransformationDialogModel;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.actions.INewChildAction;
import org.teiid.designer.ui.actions.INewSiblingAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateViewProcedureAction
extends Action
implements INewChildAction,
INewSiblingAction {
    private IFile selectedModel;
    private Collection<String> datatypes;
    private Properties designerProperties;
    private EObject newViewProcedure;
    private RelationalViewProcedure relationalViewProcedure;
    Button procedureRB;
    Button userDefinedFunctionRB;

    public CreateViewProcedureAction() {
        super(Messages.createRelationalViewProcedureActionText);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-view-procedure.png"));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        this.datatypes = new ArrayList<String>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            this.datatypes.add((String)dType);
            ++n2;
        }
    }

    public CreateViewProcedureAction(Properties properties) {
        this();
        this.designerProperties = properties;
    }

    public boolean canCreateChild(EObject parent) {
        return false;
    }

    public boolean canCreateChild(IFile modelFile) {
        return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
    }

    public boolean canCreateSibling(EObject parent) {
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)parent);
        if (mr != null) {
            IFile modelFile = null;
            try {
                modelFile = (IFile)mr.getCorrespondingResource();
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log((Throwable)ex);
            }
            if (modelFile != null) {
                return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
            }
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        IResource iRes;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && ModelIdentifier.isRelationalViewModel((IResource)(iRes = (IResource)obj))) {
            this.selectedModel = (IFile)obj;
            result = true;
        }
        return result;
    }

    public void run() {
        IFile propsViewModel;
        if (this.designerProperties != null && (propsViewModel = DesignerPropertiesUtil.getViewModel((Properties)this.designerProperties)) != null) {
            this.selectedModel = propsViewModel;
        }
        if (this.selectedModel != null) {
            ModelResource mr = ModelUtilities.getModelResource((Object)this.selectedModel);
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            this.relationalViewProcedure = new RelationalViewProcedure();
            SelectProcedureTypeDialog procedureTypeDialog = new SelectProcedureTypeDialog(shell, this.relationalViewProcedure);
            procedureTypeDialog.open();
            if (procedureTypeDialog.getReturnCode() == 0) {
                TransformationDialogModel dialogModel = new TransformationDialogModel((RelationalReference)this.relationalViewProcedure, this.selectedModel);
                EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, (EditRelationalObjectDialogModel)dialogModel);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    this.newViewProcedure = this.createViewProcedureInTxn(mr, this.relationalViewProcedure);
                } else {
                    this.relationalViewProcedure = null;
                    this.newViewProcedure = null;
                }
            }
        }
    }

    private EObject createViewProcedureInTxn(ModelResource modelResource, RelationalViewProcedure viewProcedure) {
        EObject newTable;
        block13: {
            newTable = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalViewProcedureTitle, (Object)((Object)this));
            boolean succeeded = false;
            try {
                try {
                    ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                    if (editor == null) break block13;
                    boolean isDirty = editor.isDirty();
                    RelationalViewModelFactory factory = new RelationalViewModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)viewProcedure);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                    for (Object child : modelResource.getEObjects()) {
                        EObject eObj = (EObject)child;
                        if (!ModelerCore.getModelEditor().getName(eObj).equalsIgnoreCase(this.relationalViewProcedure.getName())) continue;
                        newTable = eObj;
                        break;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalViewProcedureExceptionMessage, (String)e.getMessage());
                    Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalViewProcedureExceptionMessage, (Throwable)e);
                    UiConstants.Util.log((IStatus)status);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    return null;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return newTable;
    }

    public EObject getNewViewProcedure() {
        return this.newViewProcedure;
    }

    class SelectProcedureTypeDialog
    extends TitleAreaDialog {
        RelationalProcedure relationalProcedure;

        public SelectProcedureTypeDialog(Shell parentShell, RelationalViewProcedure procedure) {
            super(parentShell);
            this.relationalProcedure = procedure;
        }

        protected void constrainShellSize() {
            super.constrainShellSize();
            Shell shell = this.getShell();
            shell.setText(Messages.selectProcedureTypeDialogTitle);
            Rectangle r = shell.getBounds();
            shell.setBounds(r.x, r.y, (int)((double)r.width * 0.67), r.height);
            Shell parentShell = (Shell)shell.getParent();
            Rectangle parentBounds = parentShell.getBounds();
            Point parentCenter = new Point(parentBounds.x + parentBounds.width / 2, parentBounds.y + parentBounds.height / 2);
            Rectangle r2 = shell.getBounds();
            Point shellLocation = new Point(parentCenter.x - r2.width / 2, parentCenter.y - r2.height / 2);
            shell.setBounds(Math.max(0, shellLocation.x), Math.max(0, shellLocation.y), r2.width, r2.height);
        }

        protected Control createDialogArea(Composite parent) {
            Composite pnlOuter = (Composite)super.createDialogArea(parent);
            Composite panel = new Composite(pnlOuter, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginLeft = 20;
            gridLayout.marginRight = 20;
            panel.setLayout((Layout)gridLayout);
            panel.setLayoutData((Object)new GridData(1808));
            this.setTitle(Messages.selectProcedureTypeDialogSubTitle);
            CreateViewProcedureAction.this.procedureRB = new Button(panel, 16);
            CreateViewProcedureAction.this.procedureRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            CreateViewProcedureAction.this.procedureRB.setText(Messages.procedureLabel);
            CreateViewProcedureAction.this.procedureRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProcedureTypeDialog.this.handleInfoChanged();
                }
            });
            CreateViewProcedureAction.this.procedureRB.setSelection(!this.relationalProcedure.isFunction());
            Text descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalViewProcedureDescription);
            CreateViewProcedureAction.this.userDefinedFunctionRB = new Button(panel, 16);
            CreateViewProcedureAction.this.userDefinedFunctionRB.setLayoutData((Object)new GridData(16384, 128, false, false));
            CreateViewProcedureAction.this.userDefinedFunctionRB.setText(Messages.userDefinedFunctionLabel);
            CreateViewProcedureAction.this.userDefinedFunctionRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProcedureTypeDialog.this.handleInfoChanged();
                }
            });
            descText = new Text(panel, 74);
            descText.setBackground(parent.getBackground());
            descText.setForeground(Display.getCurrent().getSystemColor(10));
            descText.setLayoutData((Object)new GridData(16384, 128, true, true));
            ((GridData)descText.getLayoutData()).horizontalIndent = 20;
            ((GridData)descText.getLayoutData()).heightHint = 3 * descText.getLineHeight();
            descText.setText(Messages.createRelationalViewUserDefinedFunctionDescription);
            return pnlOuter;
        }

        private void handleInfoChanged() {
            if (CreateViewProcedureAction.this.procedureRB.getSelection()) {
                this.relationalProcedure.setProcedureType(RelationalProcedure.PROCEDURE_TYPE.PROCEDURE);
            } else {
                this.relationalProcedure.setProcedureType(RelationalProcedure.PROCEDURE_TYPE.FUNCTION);
            }
        }
    }
}

