/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationGlobalActionsManager;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;

public class DeleteAction
extends TransformationAction
implements UiConstants {
    private static final String PROBLEM = "org.teiid.designer.transformation.ui.actions.DeleteAction.problem";
    private static final String ACTION_DESCRIPTION = "Delete From Transformation";

    public DeleteAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        boolean enable = false;
        if (!this.isDependencyDiagram() && this.areEObjectsSelected()) {
            List<Object> sourceEObjects = Collections.EMPTY_LIST;
            if (this.isEObjectSelected()) {
                sourceEObjects = new ArrayList(1);
                Object o = SelectionUtilities.getSelectedObject((ISelection)selection);
                sourceEObjects.add(o);
            } else if (this.areEObjectsSelected()) {
                sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)selection);
            }
            enable = !sourceEObjects.isEmpty() ? TransformationGlobalActionsManager.canDelete(this.getTransformation(), sourceEObjects) : false;
        }
        this.setEnabled(enable);
    }

    @Override
    protected void doRun() {
        block15: {
            List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            if (selectedEObjects != null) {
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)ACTION_DESCRIPTION, (Object)this);
                boolean succeeded = false;
                try {
                    try {
                        TransformationGlobalActionsManager.delete(selectedEObjects);
                        succeeded = true;
                    }
                    catch (ModelerCoreException theException) {
                        String msg = Util.getString(PROBLEM, new Object[0]);
                        this.getPluginUtils().log(4, (Throwable)theException, msg);
                        this.setEnabled(false);
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    throw throwable;
                }
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.setEnabled(false);
    }
}

