/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.query.ui.UiPlugin;

public class ExportTransformationSqlToTextAction
extends SortableSelectionAction
implements UiConstants {
    private static final String EXPORT_PROBLEM = "ExportTransformationSqlToTextAction.exportProb";
    private static final String EXPORT_SQL_DIALOG_TITLE = "ExportTransformationSqlToTextAction.exportSqlDialog.title";
    private static final String EXPORT_DEFAULT_FILENAME = "ExportTransformationSqlToTextAction.exportDefaultFile.text";
    private static final String EXPORT_DEFAULT_FILEEXT = "ExportTransformationSqlToTextAction.exportDefaultExtension.text";
    private static final String DELIMETER = "|";
    private static final String SPACE = " ";
    private static final String LEFT_BRACKET = "[ ";
    private static final String RIGHT_BRACKET = " ]";

    public boolean isValidSelection(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource modelResource = null;
            try {
                String fileName;
                modelResource = ModelUtil.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (modelResource != null && (fileName = this.askUserForOutputFilename()) != null) {
                    String fileOuputString = this.getSqlOutputString(modelResource);
                    this.exportSqlToFile(fileName, UiConstants.Util.getString(EXPORT_DEFAULT_FILEEXT, new Object[0]), fileOuputString);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    private boolean virtualModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalViewModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public File exportSqlToFile(String fileNameString, String fileExtension, String fileOuputString) {
        block27: {
            CoreArgCheck.isNotNull((Object)fileNameString);
            CoreArgCheck.isNotNull((Object)fileExtension);
            CoreArgCheck.isNotNull((Object)fileOuputString);
            CoreArgCheck.isNotEmpty((String)fileNameString);
            CoreArgCheck.isNotEmpty((String)fileExtension);
            CoreArgCheck.isNotEmpty((String)fileOuputString);
            if (fileNameString.indexOf(46) == -1 && fileExtension != null) {
                fileNameString = String.valueOf(fileNameString) + "." + fileExtension;
            }
            FileWriter fileWriter = null;
            BufferedWriter outputBufferWriter = null;
            PrintWriter printWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(fileNameString);
                    outputBufferWriter = new BufferedWriter(fileWriter);
                    printWriter = new PrintWriter(outputBufferWriter);
                    printWriter.write(fileOuputString);
                }
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString(EXPORT_PROBLEM, new Object[0]));
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    try {
                        if (outputBufferWriter != null) {
                            outputBufferWriter.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block27;
                    }
                    catch (IOException iOException) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (printWriter != null) {
                    printWriter.close();
                }
                try {
                    if (outputBufferWriter != null) {
                        outputBufferWriter.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (printWriter != null) {
                printWriter.close();
            }
            try {
                if (outputBufferWriter != null) {
                    outputBufferWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new File(fileNameString);
    }

    public String askUserForOutputFilename() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dlg = new FileDialog(shell, 8192);
        dlg.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dlg.setText(UiConstants.Util.getString(EXPORT_SQL_DIALOG_TITLE, new Object[0]));
        dlg.setFileName(UiConstants.Util.getString(EXPORT_DEFAULT_FILENAME, new Object[0]));
        return dlg.open();
    }

    public String getSqlOutputString(ModelResource modelResource) throws ModelWorkspaceException {
        List transformations = modelResource.getModelTransformations().getTransformations();
        int nTransforms = transformations.size();
        int initBufferSize = nTransforms * 200;
        StringBuffer sb = new StringBuffer(initBufferSize);
        String relativeTablePath = null;
        boolean hasMissingSelects = false;
        boolean hasMissingInserts = false;
        boolean hasMissingUpdates = false;
        boolean hasMissingDeletes = false;
        for (Object obj : transformations) {
            boolean tableSupportsUpdates;
            String rowString = null;
            if (!(obj instanceof SqlTransformationMappingRoot)) continue;
            EObject table = ((SqlTransformationMappingRoot)obj).getTarget();
            relativeTablePath = ModelerCore.getModelEditor().getModelRelativePath(table).toString();
            String userString = TransformationHelper.getSelectSqlString(obj);
            if (userString != null && relativeTablePath != null) {
                rowString = this.createRowForFile(0, relativeTablePath, userString);
                if (rowString != null && rowString.length() > 0) {
                    sb.append(rowString);
                }
            } else {
                hasMissingSelects = true;
            }
            if (!(tableSupportsUpdates = TransformationHelper.tableSupportsUpdate((EObject)table))) continue;
            if (TransformationHelper.supportsInsert((EObject)((EObject)obj), null)) {
                userString = TransformationHelper.getInsertSqlString(obj);
                if (userString != null && relativeTablePath != null) {
                    rowString = this.createRowForFile(1, relativeTablePath, userString);
                    if (rowString != null && rowString.length() > 0) {
                        sb.append(rowString);
                    }
                } else {
                    hasMissingInserts = true;
                }
            }
            if (TransformationHelper.supportsUpdate((EObject)((EObject)obj), null)) {
                userString = TransformationHelper.getUpdateSqlString(obj);
                if (userString != null && relativeTablePath != null) {
                    rowString = this.createRowForFile(2, relativeTablePath, userString);
                    if (rowString != null && rowString.length() > 0) {
                        sb.append(rowString);
                    }
                } else {
                    hasMissingUpdates = true;
                }
            }
            if (!TransformationHelper.supportsDelete((EObject)((EObject)obj), null)) continue;
            userString = TransformationHelper.getDeleteSqlString(obj);
            if (userString != null && relativeTablePath != null) {
                rowString = this.createRowForFile(3, relativeTablePath, userString);
                if (rowString == null || rowString.length() <= 0) continue;
                sb.append(rowString);
                continue;
            }
            hasMissingDeletes = true;
        }
        if (hasMissingSelects || hasMissingInserts || hasMissingUpdates || hasMissingDeletes) {
            int count = 0;
            StringBuffer msgBuff = new StringBuffer(UiConstants.Util.getString("ExportTransformationSqlToTextAction.exportQueryProblem", (Object)modelResource.getItemName()));
            msgBuff.append(" [ ");
            if (hasMissingSelects) {
                msgBuff.append("SELECT");
                ++count;
            }
            if (hasMissingInserts) {
                if (count > 0) {
                    msgBuff.append(" | ");
                }
                msgBuff.append("INSERT");
                ++count;
            }
            if (hasMissingUpdates) {
                if (count > 0) {
                    msgBuff.append(" | ");
                }
                msgBuff.append("UPDATE");
                ++count;
            }
            if (hasMissingDeletes) {
                if (count > 0) {
                    msgBuff.append(" | ");
                }
                msgBuff.append("DELETE");
                ++count;
            }
            msgBuff.append(RIGHT_BRACKET);
            UiConstants.Util.log(4, msgBuff.toString());
        }
        return sb.toString();
    }

    private String createRowForFile(int sqlType, String relativeTablePath, String theSql) {
        StringBuffer sb = new StringBuffer(relativeTablePath.length() + theSql.length() + 20);
        theSql = theSql.replaceAll("\\\\", Matcher.quoteReplacement("\\\\"));
        theSql = theSql.replaceAll("\\n", Matcher.quoteReplacement("\\n"));
        theSql = theSql.replaceAll("\\r", Matcher.quoteReplacement("\\r"));
        sb.append(relativeTablePath).append(DELIMETER).append(this.getSqlTypeString(sqlType)).append(DELIMETER).append(theSql).append('\r');
        return sb.toString();
    }

    private String getSqlTypeString(int sqlType) {
        switch (sqlType) {
            case 0: {
                return "SELECT";
            }
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
        }
        return "UNKNOWN";
    }
}

