/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.editors.QueryEditorStatusEvent;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.ui.reconciler.ReconcilerDialog;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.SqlTransformationStatusChangeEvent;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.query.ui.sqleditor.component.QueryDisplayNode;

public class ReconcileTransformationAction
extends TransformationAction
implements EventObjectListener {
    private static final String DIALOG_TITLE_TEXT = UiConstants.Util.getString("ReconcilerDialog.title.text", new Object[0]);
    private static final String SUBQUERY_RECONCILE_TITLE_TEXT = UiConstants.Util.getString("ReconcilerDialog.subQueryReconcile.title.text", new Object[0]);
    private static final String SUBQUERY_RECONCILE_MESSAGE_TEXT = UiConstants.Util.getString("ReconcilerDialog.subQueryMessage.text", new Object[0]);
    TransformationObjectEditorPage tObjEditorPage = null;
    boolean txnOK = true;

    public ReconcileTransformationAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_reconcile_sql.gif"));
        SqlMappingRootCache.addEventListener((EventObjectListener)this);
    }

    public void setTransObjectEditorPage(TransformationObjectEditorPage toePage) {
        if (toePage != null) {
            this.tObjEditorPage = toePage;
            this.tObjEditorPage.addEventListener(this);
            this.setEnabled(this.shouldEnable((EObject)toePage.getCurrentMappingRoot()));
        }
    }

    @Override
    public void setTransformation(EObject transformationEObject) {
        EObject transMappingRoot;
        super.setTransformation(transformationEObject);
        boolean enable = false;
        if (!this.isDependencyDiagram() && (transMappingRoot = this.getTransformation()) != null && TransformationHelper.isTransformationMappingRoot((Object)transMappingRoot)) {
            enable = this.shouldEnable(transMappingRoot);
        }
        this.setEnabled(enable);
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        if (this.tObjEditorPage != null) {
            this.setEnabled(this.shouldEnable((EObject)this.tObjEditorPage.getCurrentMappingRoot()));
        }
    }

    public void processEvent(EventObject e) {
        if (e instanceof SqlTransformationStatusChangeEvent) {
            boolean enable = false;
            EObject eventMappingRoot = ((SqlTransformationStatusChangeEvent)e).getMappingRoot();
            if (eventMappingRoot != null && eventMappingRoot.equals(this.getTransformation())) {
                enable = this.shouldEnable(this.getTransformation());
                this.setEnabled(enable);
            }
        } else if (e instanceof QueryEditorStatusEvent) {
            this.setEnabled(this.shouldEnable(this.getTransformation()));
        }
    }

    private boolean shouldEnable(EObject transMappingRoot) {
        boolean shouldEnable = false;
        if (this.rootIsValid(transMappingRoot)) {
            boolean canUseReconciler = true;
            boolean isReadOnly = ModelObjectUtilities.isReadOnly((EObject)transMappingRoot);
            if (canUseReconciler && !isReadOnly) {
                shouldEnable = true;
            }
        }
        if (shouldEnable) {
            boolean currentTabIsSelect = true;
            boolean hasPendingChanges = false;
            if (this.tObjEditorPage != null) {
                if (!this.tObjEditorPage.isCurrentTabSelect()) {
                    currentTabIsSelect = false;
                } else {
                    hasPendingChanges = this.tObjEditorPage.hasPendingChanges();
                }
            }
            if (!currentTabIsSelect || hasPendingChanges) {
                shouldEnable = false;
            } else if (this.tObjEditorPage != null) {
                SqlEditorPanel sePanel = this.tObjEditorPage.getCurrentSqlEditor();
                boolean isUnion = sePanel.isCommandUnion();
                if (isUnion) {
                    ICommand command = sePanel.getCommand();
                    int uIndex = sePanel.getCurrentUnionCommandSegmentIndex();
                    if (uIndex == -1) {
                        if (!command.isResolved()) {
                            shouldEnable = false;
                        }
                    } else {
                        TransformationValidator validator;
                        QueryValidationResult result;
                        QueryDisplayNode qdn = (QueryDisplayNode)sePanel.getCurrentCommandDisplayNode();
                        command = (IQuery)qdn.getLanguageObject();
                        if (!command.isResolved() && !(result = (validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot)).validateSql(command.toString(), 0, false)).isResolvable()) {
                            shouldEnable = false;
                        }
                    }
                } else {
                    ICommand command = sePanel.getCommand();
                    if (command != null && !command.isResolved()) {
                        shouldEnable = false;
                    }
                }
            }
        }
        return shouldEnable;
    }

    @Override
    protected void doRun() {
        ReconcilerDialog reconcilerDialog;
        int returnStatus;
        Shell shell = super.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.tObjEditorPage == null) {
            return;
        }
        if (this.tObjEditorPage.getParentModelEditor().isResourceDirty()) {
            MessageDialog.openWarning((Shell)shell, (String)UiConstants.Util.getString("ReconcileTransformationAction.pendingChangesTitle", new Object[0]), (String)UiConstants.Util.getString("ReconcileTransformationAction.pendingChangesMessage", new Object[0]));
            return;
        }
        int subIndex = -1;
        List builderGroups = null;
        boolean isUnion = false;
        SqlEditorPanel sePanel = null;
        if (this.tObjEditorPage == null || this.tObjEditorPage.getCurrentMappingRoot() == null) {
            ModelEditorManager.edit((EObject)this.getTransformation());
        }
        if (this.tObjEditorPage != null) {
            if (this.tObjEditorPage.getCurrentSqlEditor().getText() == null || this.tObjEditorPage.getCurrentSqlEditor().getText().trim().length() == 0) {
                MessageDialog.openWarning((Shell)shell, (String)UiConstants.Util.getString("ReconcileTransformationAction.emptySQLTitle", new Object[0]), (String)UiConstants.Util.getString("ReconcileTransformationAction.emptySQLMessage", new Object[0]));
                return;
            }
            SqlTransformationResult existingStatus = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.tObjEditorPage.getCurrentMappingRoot(), (int)0, (boolean)true, null);
            if (existingStatus != null && !existingStatus.isParsable()) {
                MessageDialog.openWarning((Shell)shell, (String)UiConstants.Util.getString("ReconcileTransformationAction.sqlNotParsableTitle", new Object[0]), (String)UiConstants.Util.getString("ReconcileTransformationAction.sqlNotParsableMessage", new Object[0]));
                return;
            }
            sePanel = this.tObjEditorPage.getCurrentSqlEditor();
            isUnion = sePanel.isCommandUnion();
            boolean isSubQuerySelected = sePanel.isSubQuerySelected();
            if (isSubQuerySelected) {
                MessageDialog.openWarning((Shell)shell, (String)SUBQUERY_RECONCILE_TITLE_TEXT, (String)SUBQUERY_RECONCILE_MESSAGE_TEXT);
                return;
            }
            if (isUnion) {
                subIndex = sePanel.getCurrentUnionCommandSegmentIndex();
            }
            builderGroups = sePanel.getGroupsForBuilderTree(true);
        }
        if ((returnStatus = (reconcilerDialog = new ReconcilerDialog(shell, this.getTransformation(), DIALOG_TITLE_TEXT, isUnion, subIndex, builderGroups)).open()) == 0 && reconcilerDialog.hasValidModifications()) {
            final int index = subIndex;
            final ReconcilerDialog dialog = reconcilerDialog;
            this.txnOK = true;
            if (reconcilerDialog.hasPreModifications()) {
                final boolean requiredStartPre = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Reconcile Transformation", (Object)((Object)this));
                UiBusyIndicator.showWhile((Display)UiUtil.getWorkbenchShellOnlyIfUiThread().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean succeeded = false;
                        try {
                            dialog.applyPreModifications(ModelerCore.getCurrentUoW().getSource());
                            succeeded = true;
                        }
                        finally {
                            if (requiredStartPre) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                    ReconcileTransformationAction.this.tObjEditorPage.refreshEditorContent();
                                } else {
                                    ModelerCore.rollbackTxn();
                                    ReconcileTransformationAction.this.txnOK = false;
                                }
                            }
                            TransformationMappingHelper.setCreateTargetAttributes((boolean)true);
                        }
                    }
                });
            }
            if (this.txnOK) {
                final boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Reconcile Transformation", (Object)((Object)this));
                UiBusyIndicator.showWhile((Display)UiUtil.getWorkbenchShellOnlyIfUiThread().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean succeeded = false;
                        try {
                            dialog.applyAllModifications(index, ModelerCore.getCurrentUoW().getSource());
                            succeeded = true;
                        }
                        finally {
                            if (requiredStart) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                    ReconcileTransformationAction.this.tObjEditorPage.refreshEditorContent();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            TransformationMappingHelper.setCreateTargetAttributes((boolean)true);
                        }
                    }
                });
            }
        }
    }

    private boolean rootIsValid(EObject transMappingRoot) {
        return transMappingRoot != null && transMappingRoot.eResource() != null;
    }

    public void dispose() {
        SqlMappingRootCache.removeEventListener((EventObjectListener)this);
        super.dispose();
    }
}

