/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;

public class RemoveTransformationSourceAction
extends TransformationAction {
    private static final String ACTION_DESCRIPTION_1 = UiConstants.Util.getString("RemoveTransformationSourceAction.actionTitleSingle", new Object[0]);
    private static final String ACTION_DESCRIPTION_MANY = "Remove Transformation Sources";
    private static final String CONFIRM_TITLE = UiConstants.Util.getString("RemoveTransformationSourceAction.confirmTitle", new Object[0]);
    private static final String CONFIRM_MULTIPLE = UiConstants.Util.getString("RemoveTransformationSourceAction.confirmMultiple", new Object[0]);
    private static final String SQL_NOT_UPDATEABLE_TITLE = UiConstants.Util.getString("TransformationUpdateError.sqlNotResolvableDialog.title", new Object[0]);
    private static final String SQL_NOT_UPDATEABLE_TEXT = UiConstants.Util.getString("TransformationUpdateError.sqlNotResolvableDialog.text", new Object[0]);

    public RemoveTransformationSourceAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_remove_from_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        boolean isSingle = SelectionUtilities.isSingleSelection((ISelection)this.getSelection());
        boolean userContinue = false;
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        if (isSingle) {
            EObject obj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            String name = ModelerCore.getModelEditor().getName(obj);
            String message = UiConstants.Util.getString("RemoveTransformationSourceAction.confirmSingle", (Object)name);
            userContinue = MessageDialog.openConfirm((Shell)shell, (String)CONFIRM_TITLE, (String)message);
        } else {
            userContinue = MessageDialog.openConfirm((Shell)shell, (String)CONFIRM_TITLE, (String)CONFIRM_MULTIPLE);
        }
        if (userContinue) {
            boolean requiredStart = false;
            boolean canUndo = true;
            boolean succeeded = false;
            try {
                requiredStart = isSingle ? ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION_1, (Object)((Object)this)) : ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION_MANY, (Object)((Object)this));
                boolean dialogAns = true;
                if (!TransformationSqlHelper.canRemoveGroupFromSelectSql((EObject)this.getTransformation())) {
                    dialogAns = MessageDialog.openConfirm(null, (String)SQL_NOT_UPDATEABLE_TITLE, (String)SQL_NOT_UPDATEABLE_TEXT);
                }
                if (dialogAns) {
                    if (SelectionUtilities.isSingleSelection((ISelection)this.getSelection())) {
                        TransformationSourceManager.removeSource(this.getTransformation(), SelectionUtilities.getSelectedEObject((ISelection)this.getSelection()));
                    } else {
                        TransformationSourceManager.removeSources(this.getTransformation(), SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()));
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                this.setEnabled(false);
            }
        }
    }

    private boolean shouldEnable() {
        ISelection sel;
        boolean enable = false;
        if (!this.isDependencyDiagram() && this.areEObjectsSelected() && !this.editorOpenWithPendingChanges() && this.getTransformation() != null && (sel = this.getSelection()) != null && this.getTransformation() != null && !sel.isEmpty()) {
            if (this.isEObjectSelected()) {
                enable = TransformationSourceManager.canRemove(this.getTransformation(), SelectionUtilities.getSelectedEObject((ISelection)sel));
            } else if (this.areEObjectsSelected()) {
                enable = TransformationSourceManager.canRemove(this.getTransformation(), SelectionUtilities.getSelectedEObjects((ISelection)sel));
            }
        }
        return enable;
    }

    private boolean editorOpenWithPendingChanges() {
        boolean openWithPending = false;
        TransformationObjectEditorPage toep = this.getTransObjectEditorPage();
        if (toep != null && toep.hasPendingChanges()) {
            openWithPending = true;
        }
        return openWithPending;
    }

    private TransformationObjectEditorPage getTransObjectEditorPage() {
        ModelObjectEditorPage moep;
        TransformationObjectEditorPage transOEP = null;
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            transOEP = (TransformationObjectEditorPage)moep;
        }
        return transOEP;
    }
}

