/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelTransformations;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ShowDependencyDiagramAction
extends TransformationAction
implements UiConstants {
    public ShowDependencyDiagramAction() {
        super(null);
        this.setUseWaitCursor(false);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && ModelUtilities.isVirtual((ModelResource)modelResource)) {
            try {
                ModelEditor editor;
                List transformations = modelResource.getModelTransformations().getTransformations(eObject);
                if (transformations != null && transformations.size() == 1 && (editor = ShowDependencyDiagramAction.getModelEditorForObject(eObject, true)) != null) {
                    ModelEditorManager.activate((ModelEditor)editor);
                    Diagram depDiagram = this.getDependencyDiagram(modelResource, eObject);
                    if (depDiagram != null) {
                        editor.closeObjectEditor();
                        editor.openModelObject((Object)depDiagram);
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("ShowDependencyDiagramAction.showDependencyDiagramError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
        }
        this.determineEnablement();
    }

    private Diagram getDependencyDiagram(ModelResource modelResource, EObject eObject) {
        Diagram depDiagram;
        block13: {
            Iterator iter = null;
            try {
                iter = modelResource.getModelDiagrams().getDiagrams(eObject).iterator();
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("ShowDependencyDiagramAction.getDiagramsError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
            if (iter != null) {
                Diagram nextDiagram = null;
                while (iter.hasNext()) {
                    nextDiagram = (Diagram)iter.next();
                    if (nextDiagram.getType() == null || !nextDiagram.getType().equals("dependencyDiagramType")) continue;
                    return nextDiagram;
                }
            }
            depDiagram = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Dependency Diagram", (Object)this);
            boolean succeeded = false;
            try {
                try {
                    depDiagram = modelResource.getModelDiagrams().createNewDiagram(eObject, false);
                    depDiagram.setType("dependencyDiagramType");
                    succeeded = true;
                }
                catch (ModelWorkspaceException mwe) {
                    String message = Util.getString("ShowDependencyDiagramAction.createDependencyDiagramError", (Object)modelResource.toString());
                    Util.log(4, (Throwable)mwe, message);
                    if (!requiredStart) break block13;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block13;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return depDiagram;
    }

    private void determineEnablement() {
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && this.canLegallyEditResource() && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && ModelUtilities.isVirtual((ModelResource)modelResource)) {
            try {
                List transformations;
                ModelTransformations modelTransformations = modelResource.getModelTransformations();
                if (modelTransformations != null && (transformations = modelTransformations.getTransformations(eObject)) != null && transformations.size() == 1) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("ShowDependencyDiagramAction.showDependencyDiagramError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
        }
        this.setEnabled(false);
    }

    private static ModelEditor getModelEditorForObject(EObject object, boolean forceOpen) {
        ModelEditor result = null;
        IFile file = null;
        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)object);
        if (mdlRsrc != null) {
            file = (IFile)mdlRsrc.getResource();
            result = ShowDependencyDiagramAction.getModelEditorForFile(file, forceOpen);
        }
        return result;
    }

    private static ModelEditor getModelEditorForFile(IFile file, boolean forceOpen) {
        IWorkbenchPage page;
        ModelEditor result = null;
        if (file != null && (page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (!(editor instanceof ModelEditor)) break;
                    result = (ModelEditor)editor;
                    break;
                }
                ++i;
            }
            if (result == null && forceOpen) {
                try {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    if (editor instanceof ModelEditor) {
                        result = (ModelEditor)editor;
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

