/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramEditorAction;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ShowDependencyTargetDiagramAction
extends DiagramEditorAction {
    private static final String textString = "org.teiid.designer.transformation.ui.actions.ShowParentDiagramAction.text";
    private static final String toolTipString = "org.teiid.designer.transformation.ui.actions.ShowParentDiagramAction.toolTip";

    public ShowDependencyTargetDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_show_parent_diagram.gif"));
        this.setToolTipText(UiConstants.Util.getString(toolTipString, new Object[0]));
        this.setText(UiConstants.Util.getString(textString, new Object[0]));
        this.setEnabled(false);
    }

    protected void doRun() {
        Diagram diagram;
        if (this.editor != null && (diagram = this.getParentDiagram()) != null) {
            UiUtil.getWorkbenchPage().getNavigationHistory().markLocation((IEditorPart)this.editor);
            ModelEditorManager.closeObjectEditor();
            this.editor.openContext((Object)diagram);
        }
        this.determineEnablement();
    }

    public void determineEnablement() {
        if (this.editor != null) {
            Diagram diagram = this.getParentDiagram();
            if (diagram != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Diagram getParentDiagram() {
        Diagram parentPackageDiagram = null;
        DiagramModelNode diagramNode = this.editor.getCurrentModel();
        if (diagramNode == null) return parentPackageDiagram;
        Diagram currentDiagram = (Diagram)diagramNode.getModelObject();
        if (currentDiagram == null) return parentPackageDiagram;
        if (currentDiagram.getType() == null) return parentPackageDiagram;
        if (!currentDiagram.getType().equals("dependencyDiagramType")) return parentPackageDiagram;
        EObject diagramTarget = currentDiagram.getTarget();
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram);
        if (diagramTarget == null) return parentPackageDiagram;
        if (!(diagramTarget instanceof EObject)) return parentPackageDiagram;
        if (modelResource == null) return parentPackageDiagram;
        EObject packageObject = diagramTarget;
        EObject parentObject = packageObject.eContainer();
        if (parentObject != null && parentObject instanceof EObject) {
            try {
                ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(parentObject));
                Iterator iter = diagramList.iterator();
                Diagram nextDiagram = null;
                while (iter.hasNext()) {
                    if (parentPackageDiagram != null) {
                        return parentPackageDiagram;
                    }
                    nextDiagram = (Diagram)iter.next();
                    if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                    parentPackageDiagram = nextDiagram;
                }
                return parentPackageDiagram;
            }
            catch (ModelWorkspaceException e) {
                String message = "ShowDependencyTargetDiagramAction cannot find parent package diagram";
                DiagramUiConstants.Util.log(4, (Throwable)e, message);
                return parentPackageDiagram;
            }
        }
        if (parentObject != null) return parentPackageDiagram;
        try {
            ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(null));
            Iterator iter = diagramList.iterator();
            Diagram nextDiagram = null;
            while (iter.hasNext()) {
                if (parentPackageDiagram != null) {
                    return parentPackageDiagram;
                }
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                parentPackageDiagram = nextDiagram;
            }
            return parentPackageDiagram;
        }
        catch (ModelWorkspaceException e) {
            String message = "ShowDependencyTargetDiagramAction cannot find parent package diagram";
            DiagramUiConstants.Util.log(4, (Throwable)e, message);
        }
        return parentPackageDiagram;
    }
}

