/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import java.util.List;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.query.ui.builder.model.CompositeLanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public abstract class AbstractCompositeLanguageObjectEditor
extends AbstractLanguageObjectEditor {
    private static final String PREFIX = "AbstractCompositeLanguageObjectEditor.";
    private ViewController controller = new ViewController();
    private ILanguageObjectEditor currentEditor;
    private List<ILanguageObjectEditor> editors;

    public AbstractCompositeLanguageObjectEditor(Composite theParent, Class theEditorType, CompositeLanguageObjectEditorModel theModel) {
        super(theParent, theEditorType, (ILanguageObjectEditorModel)theModel);
        theModel.addModelListener((ILanguageObjectEditorModelListener)this.controller);
    }

    @Override
    public void acceptFocus() {
        if (this.currentEditor != null) {
            this.currentEditor.acceptFocus();
        }
    }

    @Override
    public void clear() {
        int size = this.editors.size();
        int i = 0;
        while (i < size) {
            ILanguageObjectEditor editor = this.editors.get(i);
            editor.clear();
            ++i;
        }
        super.clear();
        this.setCurrentEditor(this.getDefaultEditor());
    }

    protected abstract List createEditors(Composite var1);

    protected void displayModelChanged() {
        CompositeLanguageObjectEditorModel model = (CompositeLanguageObjectEditorModel)this.getModel();
        ILanguageObjectEditorModel subModel = model.getCurrentModel();
        Class modelType = subModel.getModelType();
        int size = this.editors.size();
        int i = 0;
        while (i < size) {
            ILanguageObjectEditor editor = this.editors.get(i);
            if (editor.getEditorType().isAssignableFrom(modelType)) {
                this.setCurrentEditor(editor);
                break;
            }
            ++i;
        }
    }

    @Override
    protected final void createUi(Composite theControl) {
        ViewForm form = new ViewForm(theControl, 2048);
        form.setLayoutData((Object)new GridData(1808));
        Composite pnl = new Composite((Composite)form, 0);
        form.setContent((Control)pnl);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pnl.setLayout((Layout)layout);
        pnl.setLayoutData((Object)new GridData(1808));
        this.editors = this.createEditors(pnl);
        CoreArgCheck.isNotEmpty(this.editors);
    }

    protected ILanguageObjectEditor getCurrentEditor() {
        return this.currentEditor;
    }

    protected abstract ILanguageObjectEditor getDefaultEditor();

    protected List getEditors() {
        return this.editors;
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract String getToolTipText();

    protected void setCurrentEditor(ILanguageObjectEditor theEditor) {
        CoreArgCheck.isNotNull((Object)theEditor);
        CoreArgCheck.contains(this.editors, (Object)theEditor);
        this.currentEditor = theEditor;
        CompositeLanguageObjectEditorModel model = (CompositeLanguageObjectEditorModel)this.getModel();
        model.setCurrentModel(this.currentEditor.getModel());
        this.currentEditor.acceptFocus();
    }

    @Override
    public void setModel(ILanguageObjectEditorModel theModel) {
        super.setModel(theModel);
        if (!CompositeLanguageObjectEditorModel.class.isAssignableFrom(theModel.getClass())) {
            CoreArgCheck.isTrue((boolean)CompositeLanguageObjectEditorModel.class.isAssignableFrom(theModel.getClass()), (String)Util.getString("AbstractCompositeLanguageObjectEditor.wrongModelType", new Object[]{theModel.getClass().getName()}));
        }
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        this.getModel().setLanguageObject(theLanguageObject);
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("MODEL_CHANGE")) {
                AbstractCompositeLanguageObjectEditor.this.displayModelChanged();
            }
        }
    }
}

