/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.INotCriteria;
import org.teiid.designer.query.sql.lang.IPredicateCriteria;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectBuilder;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.actions.AndCriteriaAction;
import org.teiid.designer.transformation.ui.builder.actions.NotCriteriaAction;
import org.teiid.designer.transformation.ui.builder.actions.OrCriteriaAction;
import org.teiid.designer.transformation.ui.builder.criteria.CriteriaEditor;
import org.teiid.query.ui.builder.model.CriteriaEditorModel;

public class CriteriaBuilder
extends AbstractLanguageObjectBuilder {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CriteriaBuilder.class);
    private IAction andAction;
    private IAction notAction;
    private IAction orAction;
    private CriteriaEditor editor;

    public CriteriaBuilder(Shell theShell) {
        super(theShell, Util.getString(String.valueOf(PREFIX) + "title", new Object[0]));
        this.setSizeRelativeToScreen(80, 80);
        this.setCenterOnDisplay(true);
    }

    @Override
    protected void createTreeButtons(Composite theParent) {
        super.createTreeButtons(theParent);
        Runnable andRunner = new Runnable(){

            @Override
            public void run() {
                CriteriaBuilder.this.handleAndSelected();
            }
        };
        this.andAction = new AndCriteriaAction(theParent, andRunner);
        Runnable orRunner = new Runnable(){

            @Override
            public void run() {
                CriteriaBuilder.this.handleOrSelected();
            }
        };
        this.orAction = new OrCriteriaAction(theParent, orRunner);
        Runnable notRunner = new Runnable(){

            @Override
            public void run() {
                CriteriaBuilder.this.handleNotSelected();
            }
        };
        this.notAction = new NotCriteriaAction(theParent, notRunner);
    }

    @Override
    protected void fillContextMenu(IMenuManager theMenuMgr) {
        super.fillContextMenu(theMenuMgr);
        theMenuMgr.add(this.andAction);
        theMenuMgr.add(this.orAction);
        theMenuMgr.add(this.notAction);
    }

    @Override
    protected ILanguageObjectEditor createEditor(Composite theParent) {
        this.editor = new CriteriaEditor(theParent, new CriteriaEditorModel());
        this.getButton(0).setToolTipText(Util.getString(String.valueOf(PREFIX) + "okButton.tip", new Object[0]));
        this.getButton(1).setToolTipText(Util.getString(String.valueOf(PREFIX) + "cancelButton.tip", new Object[0]));
        return this.editor;
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    void handleAndSelected() {
        this.getTreeViewer().addUndefinedAndCriteria();
    }

    void handleNotSelected() {
        this.getTreeViewer().modifyNotCriteriaStatus();
    }

    void handleOrSelected() {
        this.getTreeViewer().addUndefinedOrCriteria();
    }

    @Override
    protected void setEditorLanguageObject(ILanguageObject theEditorLangObj) {
        if (theEditorLangObj instanceof ICompoundCriteria) {
            this.getEditor().clear();
        } else if (theEditorLangObj instanceof INotCriteria) {
            this.setEditorLanguageObject((ILanguageObject)((INotCriteria)theEditorLangObj).getCriteria());
        } else {
            this.getEditor().setLanguageObject(theEditorLangObj);
        }
    }

    @Override
    protected void setEnabledStatus() {
        super.setEnabledStatus();
        Object selectedObj = this.getTreeViewer().getSelectedObject();
        this.setEnabledStatus(selectedObj instanceof ILanguageObject ? (ILanguageObject)selectedObj : null);
    }

    private void setEnabledStatus(ILanguageObject theLangObj) {
        if (this.getTreeViewer().isUndefined(theLangObj)) {
            this.andAction.setEnabled(false);
            this.orAction.setEnabled(false);
            this.notAction.setEnabled(false);
            this.editor.setEnabled(true);
        } else {
            boolean enableEditor = true;
            if (theLangObj instanceof IPredicateCriteria) {
                this.andAction.setEnabled(true);
                this.orAction.setEnabled(true);
                this.notAction.setEnabled(true);
            } else if (theLangObj instanceof ICompoundCriteria) {
                ICompoundCriteria crit = (ICompoundCriteria)theLangObj;
                this.notAction.setEnabled(true);
                if (!this.getTreeViewer().hasUndefinedChild(theLangObj)) {
                    if (crit.getOperator() == 0) {
                        this.andAction.setEnabled(true);
                        this.orAction.setEnabled(false);
                    } else {
                        this.andAction.setEnabled(false);
                        this.orAction.setEnabled(true);
                    }
                } else {
                    this.andAction.setEnabled(false);
                    this.orAction.setEnabled(false);
                }
                enableEditor = false;
            } else {
                if (theLangObj instanceof INotCriteria) {
                    INotCriteria notCrit = (INotCriteria)theLangObj;
                    ICriteria subCrit = notCrit.getCriteria();
                    this.setEnabledStatus((ILanguageObject)subCrit);
                    return;
                }
                this.andAction.setEnabled(false);
                this.orAction.setEnabled(false);
                this.notAction.setEnabled(false);
                enableEditor = false;
            }
            this.editor.setEnabled(enableEditor);
            this.btnReset.setEnabled(enableEditor);
            this.btnSet.setEnabled(enableEditor);
        }
    }
}

