/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.criteria;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.builder.criteria.AbstractPredicateCriteriaTypeEditor;
import org.teiid.designer.transformation.ui.builder.criteria.CriteriaExpressionEditor;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CompareCriteriaEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class CompareCriteriaEditor
extends AbstractPredicateCriteriaTypeEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CompareCriteriaEditor.class);
    private CriteriaExpressionEditor leftEditor;
    private CriteriaExpressionEditor rightEditor;
    private Control rightComponent;
    private Control leftComponent;
    private ViewController viewController;
    CompareCriteriaEditorModel theModel;

    public CompareCriteriaEditor(Composite parent, CompareCriteriaEditorModel model) {
        super(parent, ICompareCriteria.class, (AbstractPredicateCriteriaTypeEditorModel)model);
        this.theModel = model;
        this.viewController = new ViewController();
        model.addModelListener((ILanguageObjectEditorModelListener)this.viewController);
        this.viewController.initialize();
    }

    @Override
    public String getToolTipText() {
        String toolTip = "";
        String curOperator = this.theModel.getCurrentOperator();
        if (curOperator.equals("=")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "equalsToolTipText", new Object[0]);
        } else if (curOperator.equals("<>")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "notEqualToolTipText", new Object[0]);
        } else if (curOperator.equals(">")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "greaterThanToolTipText", new Object[0]);
        } else if (curOperator.equals("<")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "lessThanToolTipText", new Object[0]);
        } else if (curOperator.equals(">=")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "greaterEqualToolTipText", new Object[0]);
        } else if (curOperator.equals("<=")) {
            toolTip = Util.getString(String.valueOf(PREFIX) + "lessEqualToolTipText", new Object[0]);
        }
        return toolTip;
    }

    @Override
    public String getTitle() {
        String title = Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
        return title;
    }

    @Override
    public Control createLeftComponent(Composite parent) {
        this.leftEditor = new CriteriaExpressionEditor(parent, this.theModel.getLeftExpressionModel());
        this.leftComponent = this.leftEditor.getUi();
        return this.leftComponent;
    }

    @Override
    public Control createRightComponent(Composite parent) {
        this.rightEditor = new CriteriaExpressionEditor(parent, this.theModel.getRightExpressionModel());
        this.rightComponent = this.rightEditor.getUi();
        return this.rightComponent;
    }

    @Override
    public IExpression getLeftExpression() {
        IExpression leftExpression = this.theModel.getLeftExpression();
        return leftExpression;
    }

    @Override
    public IExpression getRightExpression() {
        IExpression rightExpression = this.theModel.getRightExpression();
        return rightExpression;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        CoreArgCheck.isInstanceOf(ICompareCriteria.class, (Object)obj);
        this.theModel.setLanguageObject(obj);
    }

    @Override
    public String[] getOperators() {
        return this.theModel.getOperators();
    }

    @Override
    public void acceptFocus() {
        this.leftEditor.acceptFocus();
    }

    @Override
    public void setOperator(String op) {
        this.theModel.setCurrentOperator(op);
    }

    @Override
    public String getCurrentOperator() {
        return this.theModel.getCurrentOperator();
    }

    void displayLanguageObjectChange() {
        this.displayLeftExpression();
        this.displayRightExpression();
    }

    void displayLeftExpression() {
        this.leftEditor.setLanguageObject((ILanguageObject)this.theModel.getLeftExpression());
    }

    void displayRightExpression() {
        this.rightEditor.setLanguageObject((ILanguageObject)this.theModel.getRightExpression());
    }

    private class ViewController
    implements ILanguageObjectEditorModelListener {
        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).CompareCriteriaEditor.this.theModel, "SAVED"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("COMPARE CRITERIA LEFT EXPRESSION")) {
                CompareCriteriaEditor.this.displayLeftExpression();
            } else if (type.equals("COMPARE CRITERIA RIGHT EXPRESSION")) {
                CompareCriteriaEditor.this.displayRightExpression();
            } else if (type.equals("SAVED")) {
                CompareCriteriaEditor.this.displayLanguageObjectChange();
            }
        }
    }
}

