/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.criteria;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.transformation.ui.builder.AbstractCompositeLanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.criteria.CompareCriteriaEditor;
import org.teiid.designer.transformation.ui.builder.criteria.IPredicateCriteriaTypeEditor;
import org.teiid.designer.transformation.ui.builder.criteria.IsNullCriteriaEditor;
import org.teiid.designer.transformation.ui.builder.criteria.MatchCriteriaEditor;
import org.teiid.designer.transformation.ui.builder.criteria.SetCriteriaEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.query.ui.builder.model.CompositeLanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.CriteriaEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class CriteriaEditor
extends AbstractCompositeLanguageObjectEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CriteriaEditor.class);
    private ViewController controller;
    private IPredicateCriteriaTypeEditor defaultEditor;
    private Map leftControls;
    private StackLayout leftStack;
    CriteriaEditorModel model;
    private Map rightControls;
    private StackLayout rightStack;
    private Map typeEditorMap;
    private Combo cbxOperator;
    private Composite leftEditorContent;
    private Composite rightEditorContent;
    private Composite pnlLeft;
    private Composite pnlRight;

    public CriteriaEditor(Composite theParent, CriteriaEditorModel theModel) {
        super(theParent, ICriteria.class, (CompositeLanguageObjectEditorModel)theModel);
        this.model = theModel;
        this.controller = new ViewController();
        this.model.addModelListener((ILanguageObjectEditorModelListener)this.controller);
        this.cbxOperator.setItems(this.model.getOperators());
        this.controller.initialize();
    }

    @Override
    protected List createEditors(Composite theParent) {
        this.typeEditorMap = new HashMap();
        this.leftControls = new HashMap();
        this.leftStack = new StackLayout();
        this.rightControls = new HashMap();
        this.rightStack = new StackLayout();
        SashForm editorSplitter = WidgetFactory.createSplitter((Composite)theParent, (int)256);
        this.leftEditorContent = WidgetFactory.createPanel((Composite)editorSplitter, (int)0, (int)1808, (int)1, (int)1);
        this.pnlLeft = new Composite(this.leftEditorContent, 0);
        this.pnlLeft.setLayoutData((Object)new GridData(1808));
        this.pnlLeft.setLayout((Layout)this.leftStack);
        this.rightEditorContent = WidgetFactory.createPanel((Composite)editorSplitter, (int)0, (int)1808, (int)1, (int)2);
        this.cbxOperator = WidgetFactory.createCombo((Composite)this.rightEditorContent, (int)2056);
        this.cbxOperator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                CriteriaEditor.this.handleOperatorSelected();
            }
        });
        this.pnlRight = new Composite(this.rightEditorContent, 0);
        this.pnlRight.setLayoutData((Object)new GridData(1808));
        this.pnlRight.setLayout((Layout)this.rightStack);
        CriteriaEditorModel model = (CriteriaEditorModel)this.getModel();
        IPredicateCriteriaTypeEditor[] criteriaEditors = new IPredicateCriteriaTypeEditor[]{new CompareCriteriaEditor(theParent, model.getCompareCriteriaEditorModel()), new IsNullCriteriaEditor(theParent, model.getIsNullCriteriaEditorModel()), new MatchCriteriaEditor(theParent, model.getMatchCriteriaEditorModel()), new SetCriteriaEditor(theParent, model.getSetCriteriaEditorModel())};
        int i = 0;
        while (i < criteriaEditors.length) {
            Class criteriaType = criteriaEditors[i].getEditorType();
            this.typeEditorMap.put(criteriaType, criteriaEditors[i]);
            Control leftControl = criteriaEditors[i].createLeftComponent(this.pnlLeft);
            if (leftControl == null) {
                leftControl = new Composite(this.pnlLeft, 0);
            }
            this.leftControls.put(criteriaType, leftControl);
            Control rightControl = criteriaEditors[i].createRightComponent(this.pnlRight);
            if (rightControl == null) {
                rightControl = new Composite(this.pnlRight, 0);
            }
            this.rightControls.put(criteriaType, rightControl);
            if (i == 0) {
                this.defaultEditor = criteriaEditors[i];
            }
            ++i;
        }
        return Arrays.asList(criteriaEditors);
    }

    void displayModelChangeUi() {
        Class criteriaType = this.model.getCurrentModel().getModelType();
        Control control = (Control)this.leftControls.get(criteriaType);
        if (control != this.leftStack.topControl) {
            this.leftStack.topControl = control;
            this.pnlLeft.layout();
        }
        if ((control = (Control)this.rightControls.get(criteriaType)) != this.rightStack.topControl) {
            this.rightStack.topControl = control;
            this.pnlRight.layout();
        }
        this.setCurrentEditor((ILanguageObjectEditor)this.typeEditorMap.get(criteriaType));
    }

    void displayOperatorUi() {
        String operator = this.model.getOperator();
        this.cbxOperator.setText(operator);
    }

    @Override
    protected ILanguageObjectEditor getDefaultEditor() {
        return this.defaultEditor;
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    void handleOperatorSelected() {
        this.model.setOperator(this.cbxOperator.getText());
        this.cbxOperator.setToolTipText(this.getCurrentEditor().getToolTipText());
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        super.setEnabled(theEnableFlag);
        if (theEnableFlag) {
            WidgetUtil.enable((Composite)this.leftEditorContent);
            WidgetUtil.enable((Composite)this.rightEditorContent);
        } else {
            WidgetUtil.disable((Composite)this.leftEditorContent);
            WidgetUtil.disable((Composite)this.rightEditorContent);
        }
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).CriteriaEditor.this.model, "MODEL_CHANGE"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("SAVED")) {
                this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)CriteriaEditor.this.model, "MODEL_CHANGE"));
            } else if (type.equals("OPERATOR")) {
                CriteriaEditor.this.displayOperatorUi();
            } else if (type.equals("MODEL_CHANGE")) {
                CriteriaEditor.this.displayModelChangeUi();
                CriteriaEditor.this.displayOperatorUi();
            }
        }
    }
}

