/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.ISetCriteria;
import org.teiid.designer.transformation.ui.builder.ExpressionBuilder;
import org.teiid.designer.transformation.ui.builder.actions.AddSetCriteriaItemAction;
import org.teiid.designer.transformation.ui.builder.actions.DeleteSetCriteriaItemAction;
import org.teiid.designer.transformation.ui.builder.actions.EditSetCriteriaItemAction;
import org.teiid.designer.transformation.ui.builder.criteria.AbstractPredicateCriteriaTypeEditor;
import org.teiid.designer.transformation.ui.builder.criteria.CriteriaExpressionEditor;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.model.SetCriteriaEditorModel;
import org.teiid.query.ui.builder.util.ElementViewerFactory;

public class SetCriteriaEditor
extends AbstractPredicateCriteriaTypeEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(SetCriteriaEditor.class);
    private static final int HORIZONTAL_GAP_BETWEEN_BUTTONS = 7;
    private ISetCriteria setCriteria;
    private CriteriaExpressionEditor editor;
    private Control component;
    SetCriteriaEditorModel theModel;
    private ViewController viewController;
    Button listButton;
    private MenuManager listButtonMenuManager;
    private AddSetCriteriaItemAction addAction;
    private EditSetCriteriaItemAction editAction;
    private DeleteSetCriteriaItemAction deleteAction;
    Button subqueryButton;
    private Composite stackedComposite;
    private Composite listComposite;
    private SashForm subquerySashForm;
    private Text subquerySQLText;
    private TreeViewer subqueryTreeViewer;
    private Tree subqueryTree;
    private StackLayout stackLayout;
    private List curItemsList;
    private Map listItemToLangObjMap = new HashMap();
    private ILanguageObject[] objectsToSelect = new ILanguageObject[0];
    private int curType = -1;

    public SetCriteriaEditor(Composite parent, SetCriteriaEditorModel model) {
        super(parent, ISetCriteria.class, (AbstractPredicateCriteriaTypeEditorModel)model);
        this.theModel = model;
        this.viewController = new ViewController();
        this.theModel.addModelListener((ILanguageObjectEditorModelListener)this.viewController);
        this.viewController.initialize();
    }

    @Override
    public String getToolTipText() {
        String tip = Util.getString(String.valueOf(PREFIX) + "toolTipText", new Object[0]);
        return tip;
    }

    @Override
    public String getTitle() {
        String title = Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
        return title;
    }

    @Override
    public Control createLeftComponent(Composite parent) {
        this.editor = new CriteriaExpressionEditor(parent, this.theModel.getExpressionModel());
        this.component = this.editor.getUi();
        return this.component;
    }

    @Override
    public Control createRightComponent(Composite parent) {
        ViewForm rightComponentViewForm = new ViewForm(parent, 2048);
        Composite rightComponent = new Composite((Composite)rightComponentViewForm, 0);
        rightComponentViewForm.setContent((Control)rightComponent);
        GridLayout layout = new GridLayout();
        rightComponent.setLayout((Layout)layout);
        Composite topButtonPanel = new Composite(rightComponent, 0);
        RowLayout topButtonPanelLayout = new RowLayout();
        topButtonPanelLayout.wrap = false;
        topButtonPanelLayout.pack = true;
        topButtonPanelLayout.justify = false;
        topButtonPanelLayout.type = 256;
        topButtonPanelLayout.spacing = 7;
        topButtonPanel.setLayout((Layout)topButtonPanelLayout);
        GridData topButtonPanelGridData = new GridData(64);
        topButtonPanel.setLayoutData((Object)topButtonPanelGridData);
        this.listButton = new Button(topButtonPanel, 16);
        String listButtonText = Util.getString(String.valueOf(PREFIX) + "list", new Object[0]);
        this.listButton.setText(listButtonText);
        String listButtonToolTipText = Util.getString(String.valueOf(PREFIX) + "listToolTipText", new Object[0]);
        this.listButton.setToolTipText(listButtonToolTipText);
        this.listButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                if (SetCriteriaEditor.this.listButton.getSelection()) {
                    SetCriteriaEditor.this.theModel.setCurType(1);
                }
            }
        });
        this.subqueryButton = new Button(topButtonPanel, 16);
        String subqueryButtonText = Util.getString(String.valueOf(PREFIX) + "subquery", new Object[0]);
        this.subqueryButton.setText(subqueryButtonText);
        String subqueryButtonToolTipText = Util.getString(String.valueOf(PREFIX) + "subqueryToolTipText", new Object[0]);
        this.subqueryButton.setToolTipText(subqueryButtonToolTipText);
        this.subqueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                if (SetCriteriaEditor.this.subqueryButton.getSelection()) {
                    SetCriteriaEditor.this.theModel.setCurType(2);
                }
            }
        });
        this.stackedComposite = new Composite(rightComponent, 0);
        GridData stackedCompositeGridData = new GridData(1808);
        this.stackedComposite.setLayoutData((Object)stackedCompositeGridData);
        this.stackLayout = new StackLayout();
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        this.listComposite = new Composite(this.stackedComposite, 0);
        this.subquerySashForm = new SashForm(this.stackedComposite, 512);
        GridLayout listCompositeLayout = new GridLayout();
        this.listComposite.setLayout((Layout)listCompositeLayout);
        this.curItemsList = new List(this.listComposite, 2);
        GridData curItemsListGridData = new GridData(1808);
        this.curItemsList.setLayoutData((Object)curItemsListGridData);
        this.curItemsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                SetCriteriaEditor.this.curItemsListChanged();
            }
        });
        Composite buttonsPanel = new Composite(this.listComposite, 0){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                SetCriteriaEditor.this.curItemsListChanged();
            }
        };
        RowLayout buttonsPanelLayout = new RowLayout();
        buttonsPanelLayout.wrap = false;
        buttonsPanelLayout.pack = false;
        buttonsPanelLayout.justify = false;
        buttonsPanelLayout.type = 256;
        buttonsPanelLayout.spacing = 7;
        buttonsPanel.setLayout((Layout)buttonsPanelLayout);
        GridData buttonsPanelGridData = new GridData(64);
        buttonsPanel.setLayoutData((Object)buttonsPanelGridData);
        Runnable addRunnable = new Runnable(){

            @Override
            public void run() {
                SetCriteriaEditor.this.addButtonPressed();
            }
        };
        this.addAction = new AddSetCriteriaItemAction(buttonsPanel, addRunnable);
        this.addAction.setEnabled(true);
        Runnable editRunnable = new Runnable(){

            @Override
            public void run() {
                SetCriteriaEditor.this.editButtonPressed();
            }
        };
        this.editAction = new EditSetCriteriaItemAction(buttonsPanel, editRunnable);
        this.editAction.setEnabled(false);
        Runnable deleteRunnable = new Runnable(){

            @Override
            public void run() {
                SetCriteriaEditor.this.deleteButtonPressed();
            }
        };
        this.deleteAction = new DeleteSetCriteriaItemAction(buttonsPanel, deleteRunnable);
        this.deleteAction.setEnabled(false);
        this.listButtonMenuManager = new MenuManager();
        this.listButtonMenuManager.setRemoveAllWhenShown(true);
        this.listButtonMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                SetCriteriaEditor.this.fillListButtonMenu();
            }
        });
        this.listButton.setMenu(this.listButtonMenuManager.createContextMenu((Control)this.listButton));
        this.subquerySQLText = new Text((Composite)this.subquerySashForm, 2114);
        GridData sqlTextData = new GridData(768);
        this.subquerySQLText.setBackground(UiUtil.getSystemColor((int)29));
        this.subquerySQLText.setForeground(UiUtil.getSystemColor((int)28));
        this.subquerySQLText.setLayoutData((Object)sqlTextData);
        this.subqueryTreeViewer = ElementViewerFactory.createElementViewer((Composite)this.subquerySashForm);
        this.subqueryTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                SetCriteriaEditor.this.handleDoubleClick();
            }
        });
        this.theModel.setViewer(this.subqueryTreeViewer);
        this.subqueryTree = this.subqueryTreeViewer.getTree();
        this.subqueryTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent theEvent) {
                SetCriteriaEditor.this.handleTreeSelection();
            }

            public void widgetSelected(SelectionEvent theEvent) {
                SetCriteriaEditor.this.handleTreeSelection();
            }
        });
        GridData treeData = new GridData(1808);
        this.subqueryTree.setLayoutData((Object)treeData);
        this.subquerySashForm.setWeights(new int[]{1, 3});
        return rightComponentViewForm;
    }

    void fillListButtonMenu() {
        this.listButtonMenuManager.add((IAction)this.addAction);
        this.listButtonMenuManager.add((IAction)this.editAction);
        this.listButtonMenuManager.add((IAction)this.deleteAction);
    }

    private void listTypeSelected() {
        if (this.listButton.getSelection()) {
            if (this.subqueryButton.getSelection()) {
                this.subqueryButton.setSelection(false);
            }
            this.stackLayout.topControl = this.listComposite;
            this.stackedComposite.layout();
            this.theModel.setCurType(1);
        } else if (!this.subqueryButton.getSelection()) {
            this.listButton.setSelection(true);
        }
    }

    private void subqueryTypeSelected() {
        if (this.subqueryButton.getSelection()) {
            if (this.listButton.getSelection()) {
                this.listButton.setSelection(false);
            }
            this.stackLayout.topControl = this.subquerySashForm;
            this.stackedComposite.layout();
            this.theModel.setCurType(2);
        } else if (!this.listButton.getSelection()) {
            this.subqueryButton.setSelection(true);
        }
    }

    void curItemsListChanged() {
        int selectionCount = this.curItemsList.getSelectionCount();
        this.editAction.setEnabled(selectionCount == 1);
        this.deleteAction.setEnabled(selectionCount > 0);
    }

    void addButtonPressed() {
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        ExpressionBuilder expBld = new ExpressionBuilder(shell);
        int returnCode = expBld.open();
        if (returnCode == 0) {
            ILanguageObject langObj = expBld.getLanguageObject();
            this.objectsToSelect = new ILanguageObject[]{langObj};
            this.theModel.addValue(langObj);
        }
    }

    void editButtonPressed() {
        ILanguageObject newObj;
        String listItem = this.curItemsList.getSelection()[0];
        ILanguageObject obj = (ILanguageObject)this.listItemToLangObjMap.get(listItem);
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        ExpressionBuilder expBld = new ExpressionBuilder(shell);
        expBld.create();
        expBld.setLanguageObject(obj);
        int returnCode = expBld.open();
        if (returnCode == 0 && !obj.equals(newObj = expBld.getLanguageObject())) {
            this.objectsToSelect = new ILanguageObject[]{newObj};
            this.theModel.replaceValue(obj, newObj);
        }
    }

    void deleteButtonPressed() {
        int[] selectedIndices = this.curItemsList.getSelectionIndices();
        int itemCount = this.curItemsList.getItemCount();
        boolean[] stillIncludedMask = new boolean[itemCount];
        int i = 0;
        while (i < itemCount) {
            stillIncludedMask[i] = true;
            ++i;
        }
        i = 0;
        while (i < selectedIndices.length) {
            stillIncludedMask[selectedIndices[i]] = false;
            ++i;
        }
        ArrayList<ILanguageObject> newValues = new ArrayList<ILanguageObject>(itemCount);
        int i2 = 0;
        while (i2 < itemCount) {
            if (stillIncludedMask[i2]) {
                String listItem = this.curItemsList.getItem(i2);
                ILanguageObject obj = (ILanguageObject)this.listItemToLangObjMap.get(listItem);
                newValues.add(obj);
            }
            ++i2;
        }
        this.objectsToSelect = new ILanguageObject[0];
        this.theModel.setValues(newValues);
    }

    @Override
    public IExpression getLeftExpression() {
        IExpression leftExpression = null;
        if (this.setCriteria != null) {
            leftExpression = this.setCriteria.getExpression();
        }
        return leftExpression;
    }

    @Override
    public IExpression getRightExpression() {
        return null;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        CoreArgCheck.isInstanceOf(ISetCriteria.class, (Object)obj);
        this.setCriteria = (ISetCriteria)obj;
        this.editor.setLanguageObject((ILanguageObject)this.getLeftExpression());
    }

    @Override
    public String[] getOperators() {
        return this.theModel.getOperators();
    }

    @Override
    public void acceptFocus() {
        this.editor.acceptFocus();
    }

    @Override
    public void setOperator(String op) {
        this.theModel.setCurrentOperator(op);
    }

    @Override
    public String getCurrentOperator() {
        return this.theModel.getCurrentOperator();
    }

    void handleDoubleClick() {
    }

    void handleTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.subqueryTreeViewer.getSelection();
        Object firstSelection = selection.getFirstElement();
        this.theModel.setSubquerySelection(firstSelection);
    }

    void displayExpression() {
    }

    void displayValues() {
        if (this.curType == 1) {
            this.curItemsList.removeAll();
            this.listItemToLangObjMap.clear();
            ISetCriteria setCriteria = (ISetCriteria)this.theModel.getLanguageObject();
            Collection newValues = setCriteria.getValues();
            for (ILanguageObject langObj : newValues) {
                String itemName = langObj.toString();
                this.curItemsList.add(itemName);
                this.listItemToLangObjMap.put(itemName, langObj);
            }
            ArrayList<Integer> selectionLocs = new ArrayList<Integer>();
            int i = 0;
            while (i < this.objectsToSelect.length) {
                int index = this.curItemsList.indexOf(this.objectsToSelect[i].toString());
                if (index >= 0) {
                    selectionLocs.add(new Integer(index));
                }
                ++i;
            }
            int[] selectionLocsArray = new int[selectionLocs.size()];
            Iterator it = selectionLocs.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                Integer tempInt = (Integer)it.next();
                selectionLocsArray[i2] = tempInt;
                ++i2;
            }
            this.curItemsList.select(selectionLocsArray);
            this.curItemsListChanged();
        }
    }

    void displayType() {
        int newType = this.theModel.getCurType();
        if (newType != this.curType) {
            this.curType = newType;
            if (this.curType == 1) {
                if (!this.listButton.getSelection()) {
                    this.listButton.setSelection(true);
                }
                this.listTypeSelected();
            } else {
                if (!this.subqueryButton.getSelection()) {
                    this.subqueryButton.setSelection(true);
                }
                this.subqueryTypeSelected();
            }
        }
    }

    void displayCommand() {
        String displayText;
        ICommand command = this.theModel.getCommand();
        if (command == null) {
            Object selection = this.theModel.getSubquerySelection();
            displayText = selection == null ? Util.getString(String.valueOf(PREFIX) + "noSelectionMsg", new Object[0]) : this.theModel.getInvalidSelectionMessage();
        } else {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            displayText = visitor.returnSQLString((ILanguageObject)command);
        }
        this.subquerySQLText.setText(displayText);
    }

    void displayLanguageObjectChange() {
        this.displayType();
        this.displayExpression();
        this.displayValues();
        this.displayCommand();
    }

    private class ViewController
    implements ILanguageObjectEditorModelListener {
        public void initialize() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewController.this.modelChanged(new LanguageObjectEditorModelEvent((ILanguageObjectEditorModel)((ViewController)ViewController.this).SetCriteriaEditor.this.theModel, "SAVED"));
                }
            });
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            String type = theEvent.getType();
            if (type.equals("SET CRITERIA EXPRESSION")) {
                SetCriteriaEditor.this.displayExpression();
            } else if (type.equals("SET CRITERIA VALUES")) {
                SetCriteriaEditor.this.displayValues();
            } else if (type.equals("SET CRITERIA SUBQUERY COMMAND")) {
                SetCriteriaEditor.this.displayCommand();
            } else if (type.equals("SET CRITERIA SUBTYPE CHANGED")) {
                SetCriteriaEditor.this.displayType();
            } else if (type.equals("SAVED")) {
                SetCriteriaEditor.this.displayLanguageObjectChange();
            }
        }
    }
}

