/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.expression;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.query.ui.builder.model.ElementEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class ElementEditor
extends AbstractLanguageObjectEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ElementEditor.class);
    private ViewController controller = new ViewController();
    private ElementEditorModel model;
    private ICriteriaStrategy strategy;
    private Composite pnlContent;
    private TreeViewer viewer;

    public ElementEditor(Composite theParent, ElementEditorModel theModel) {
        super(theParent, IElementSymbol.class, (ILanguageObjectEditorModel)theModel);
        this.model = theModel;
        this.model.addModelListener((ILanguageObjectEditorModelListener)this.controller);
        this.strategy = ElementViewerFactory.getCriteriaStrategy((TreeViewer)this.viewer);
        this.strategy.setTreeViewer(this.viewer);
    }

    @Override
    public void acceptFocus() {
        this.viewer.getTree().setFocus();
    }

    @Override
    protected void createUi(Composite theParent) {
        this.pnlContent = new Composite(theParent, 0);
        this.pnlContent.setLayoutData((Object)new GridData(1808));
        this.pnlContent.setLayout((Layout)new FillLayout());
        this.viewer = ElementViewerFactory.createElementViewer((Composite)this.pnlContent);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                ElementEditor.this.handleDoubleClick();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                ElementEditor.this.handleTreeSelection();
            }
        });
        this.viewer.expandAll();
    }

    void displayElementSymbol() {
        CoreArgCheck.isNotNull((Object)this.viewer);
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (this.model.getElementSymbol() != null) {
            this.strategy.setTreeViewer(this.viewer);
            Object node = this.strategy.getNode((ILanguageObject)this.model.getElementSymbol());
            if (node != null) {
                selection = new StructuredSelection(node);
            }
            if (!selection.equals((Object)this.viewer.getSelection())) {
                this.viewer.setSelection((ISelection)selection);
            }
        }
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    void handleDoubleClick() {
    }

    void handleTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        IElementSymbol element = null;
        if (!selection.isEmpty()) {
            ICriteriaStrategy strategy = ElementViewerFactory.getCriteriaStrategy((TreeViewer)this.viewer);
            strategy.setTreeViewer(this.viewer);
            if (strategy.isValid(selection.getFirstElement())) {
                Object eObj = selection.getFirstElement();
                if (eObj instanceof IElementSymbol) {
                    element = (IElementSymbol)eObj;
                } else {
                    IQueryService queryService = ModelerCore.getTeiidQueryService();
                    IQueryFactory factory = queryService.createQueryFactory();
                    element = factory.createElementSymbol(strategy.getRuntimeFullName(eObj), true);
                    element.setMetadataID(eObj);
                }
            }
        }
        this.model.selectElementSymbol(element);
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        if (theLanguageObject == null) {
            this.clear();
        } else {
            if (!(theLanguageObject instanceof IElementSymbol)) {
                CoreArgCheck.isTrue((boolean)(theLanguageObject instanceof IElementSymbol), (String)Util.getString(String.valueOf(PREFIX) + "invalidLanguageObject", new Object[]{theLanguageObject.getClass().getName()}));
            }
            this.model.setLanguageObject(theLanguageObject);
        }
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            ElementEditor.this.displayElementSymbol();
        }
    }
}

