/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.expression;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.builder.AbstractLanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.ExpressionBuilder;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.builder.model.FunctionDisplayEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class FunctionDisplayEditor
extends AbstractLanguageObjectEditor {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(FunctionDisplayEditor.class);
    private static final int TEXT_AREA_WIDTH_HINT = 150;
    private static final int TEXT_AREA_HEIGHT_HINT = 150;
    private ViewController controller = new ViewController();
    private FunctionDisplayEditorModel model;
    private Composite pnlContent;
    private Button editButton;
    private Text functionText;

    public FunctionDisplayEditor(Composite theParent, FunctionDisplayEditorModel theModel) {
        super(theParent, IFunction.class, (ILanguageObjectEditorModel)theModel);
        this.model = theModel;
        this.model.addModelListener((ILanguageObjectEditorModelListener)this.controller);
        this.displayFunction();
    }

    @Override
    public void acceptFocus() {
        this.editButton.setFocus();
    }

    @Override
    protected void createUi(Composite theParent) {
        this.pnlContent = new Composite(theParent, 0);
        GridLayout layout = new GridLayout();
        this.pnlContent.setLayout((Layout)layout);
        layout.numColumns = 2;
        GridData pnlData = new GridData(1808);
        this.pnlContent.setLayoutData((Object)pnlData);
        this.editButton = new Button(this.pnlContent, 8);
        this.editButton.setText(Util.getString(String.valueOf(PREFIX) + "edit", new Object[0]));
        this.editButton.setToolTipText(Util.getString(String.valueOf(PREFIX) + "editToolTipText", new Object[0]));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                FunctionDisplayEditor.this.editButtonPressed();
            }
        });
        this.functionText = new Text(this.pnlContent, 2122);
        GridData functionTextData = new GridData(1808);
        functionTextData.widthHint = 150;
        functionTextData.heightHint = 150;
        this.functionText.setText("<undefined>");
        this.functionText.setLayoutData((Object)functionTextData);
    }

    void displayFunction() {
        IFunction function = this.model.getFunction();
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
        this.functionText.setText(visitor.returnSQLString((ILanguageObject)function));
    }

    void editButtonPressed() {
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        ExpressionBuilder dialog = new ExpressionBuilder(shell, true);
        dialog.create();
        dialog.setLanguageObject(this.model.getLanguageObject());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            ILanguageObject modifiedLanguageObject = dialog.getLanguageObject();
            this.model.setLanguageObject(modifiedLanguageObject);
        }
    }

    @Override
    public String getTitle() {
        return Util.getString(String.valueOf(PREFIX) + "title", new Object[0]);
    }

    @Override
    public String getToolTipText() {
        return Util.getString(String.valueOf(PREFIX) + "tip", new Object[0]);
    }

    @Override
    public boolean isComplete() {
        boolean complete = super.isComplete();
        return complete;
    }

    @Override
    public void setLanguageObject(ILanguageObject theLanguageObject) {
        if (theLanguageObject == null) {
            this.clear();
        } else {
            if (!(theLanguageObject instanceof IFunction)) {
                CoreArgCheck.isTrue((boolean)(theLanguageObject instanceof IFunction), (String)Util.getString(String.valueOf(PREFIX) + "invalidLanguageObject", new Object[]{theLanguageObject.getClass().getName()}));
            }
            this.model.setLanguageObject(theLanguageObject);
        }
    }

    class ViewController
    implements ILanguageObjectEditorModelListener {
        ViewController() {
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            FunctionDisplayEditor.this.displayFunction();
        }
    }
}

