/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IReference;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectEditor;
import org.teiid.designer.transformation.ui.builder.expression.ConstantEditor;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class CompositeEditorMessagePanel
extends Composite
implements UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CompositeEditorMessagePanel.class);
    private Map buttonModelMap;
    Map buttonEditorMap;
    ILanguageObjectEditor currentEditor;
    Map modelButtonMap;
    private Listener listener;
    private Object langObj;
    private CLabel lblMsg;

    public CompositeEditorMessagePanel(Composite theParent) {
        super(theParent, 0);
        this.setLayoutData(new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.buttonModelMap = new HashMap();
        this.buttonEditorMap = new HashMap();
        this.modelButtonMap = new HashMap();
        this.listener = new Listener();
        this.lblMsg = new CLabel((Composite)this, 68);
        this.lblMsg.setLayoutData((Object)new GridData(768));
        this.lblMsg.setBackground(UiUtil.getSystemColor((int)29));
        this.lblMsg.setForeground(UiUtil.getSystemColor((int)28));
    }

    public void addEditor(Button theButton, ILanguageObjectEditor theEditor) {
        ILanguageObjectEditorModel model = theEditor.getModel();
        this.buttonModelMap.put(theButton, model);
        this.buttonEditorMap.put(theButton, theEditor);
        this.modelButtonMap.put(model, theButton);
        model.addModelListener((ILanguageObjectEditorModelListener)this.listener);
        theButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void clearMsg() {
        this.lblMsg.setText("");
    }

    private boolean isConstantEditor() {
        return this.currentEditor == null ? false : this.currentEditor instanceof ConstantEditor;
    }

    private boolean isConstant() {
        return this.langObj == null ? false : this.langObj instanceof IConstant;
    }

    private boolean isElement() {
        return this.langObj == null ? false : this.langObj instanceof IElementSymbol;
    }

    private boolean isFunction() {
        return this.langObj == null ? false : this.langObj instanceof IFunction;
    }

    private boolean isReference() {
        return this.langObj == null ? false : this.langObj instanceof IReference;
    }

    public void setLanguageObject(Object theLangObj) {
        this.langObj = theLangObj;
        this.setResultMsg();
    }

    public void setResultMsg() {
        Object[] params = null;
        String id = null;
        String nodeType = "<undefined>";
        if (this.isConstant()) {
            nodeType = Util.getString(String.valueOf(PREFIX) + "constantType", new Object[0]);
        } else if (this.isElement()) {
            nodeType = Util.getString(String.valueOf(PREFIX) + "elementType", new Object[0]);
        } else if (this.isFunction()) {
            nodeType = Util.getString(String.valueOf(PREFIX) + "functionType", new Object[0]);
        } else if (this.isReference()) {
            nodeType = Util.getString(String.valueOf(PREFIX) + "referencyType", new Object[0]);
        }
        if (this.currentEditor == null) {
            this.lblMsg.setText("");
        } else {
            String title = this.currentEditor.getTitle();
            if (!nodeType.equals(title)) {
                id = this.currentEditor.hasChanged() ? String.valueOf(PREFIX) + "changeTypeApply.msg" : String.valueOf(PREFIX) + "changeType.msg";
                params = new Object[]{nodeType, title};
            } else if (this.currentEditor.hasChanged()) {
                id = this.isConstantEditor() && ((ConstantEditor)this.currentEditor).isConversionType() ? String.valueOf(PREFIX) + "changeConstantTypeValue.msg" : String.valueOf(PREFIX) + "changeValue.msg";
                params = new Object[]{nodeType};
            } else if (!this.currentEditor.hasChanged()) {
                id = String.valueOf(PREFIX) + "unchanged.msg";
                params = new Object[]{nodeType};
            }
            this.lblMsg.setText(Util.getString(id, params));
        }
    }

    class Listener
    extends SelectionAdapter
    implements ILanguageObjectEditorModelListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent theEvent) {
            Button btn = (Button)theEvent.getSource();
            if (btn.getSelection()) {
                CompositeEditorMessagePanel.this.currentEditor = (ILanguageObjectEditor)CompositeEditorMessagePanel.this.buttonEditorMap.get(btn);
                CompositeEditorMessagePanel.this.setResultMsg();
            }
        }

        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            ILanguageObjectEditorModel model = (ILanguageObjectEditorModel)theEvent.getSource();
            Button btn = (Button)CompositeEditorMessagePanel.this.modelButtonMap.get(model);
            if (btn.getSelection()) {
                CompositeEditorMessagePanel.this.currentEditor = (ILanguageObjectEditor)CompositeEditorMessagePanel.this.buttonEditorMap.get(btn);
                CompositeEditorMessagePanel.this.setResultMsg();
            }
        }
    }
}

