/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;

public class TransformationAnchorManager
implements AnchorManager {
    private List northAnchors;
    private List southAnchors;
    private List eastAnchors;
    private List westAnchors;
    private DiagramEditPart diagramEditPart;

    public TransformationAnchorManager(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
        this.init();
    }

    private void init() {
    }

    private List getEastAnchors() {
        return this.eastAnchors;
    }

    private List getNorthAnchors() {
        return this.northAnchors;
    }

    private List getSouthAnchors() {
        return this.southAnchors;
    }

    private List getWestAnchors() {
        return this.westAnchors;
    }

    private boolean addEastAnchor(NodeConnectionAnchor newAnchor) {
        if (this.eastAnchors == null) {
            this.eastAnchors = new ArrayList(1);
        }
        if (!this.eastAnchors.contains(newAnchor)) {
            this.eastAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addNorthAnchor(NodeConnectionAnchor newAnchor) {
        if (this.northAnchors == null) {
            this.northAnchors = new ArrayList(1);
        }
        if (!this.northAnchors.contains(newAnchor)) {
            this.northAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addSouthAnchor(NodeConnectionAnchor newAnchor) {
        if (this.southAnchors == null) {
            this.southAnchors = new ArrayList(1);
        }
        if (!this.southAnchors.contains(newAnchor)) {
            this.southAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addWestAnchor(NodeConnectionAnchor newAnchor) {
        if (this.westAnchors == null) {
            this.westAnchors = new ArrayList(1);
        }
        if (!this.westAnchors.contains(newAnchor)) {
            this.westAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    public boolean add(NodeConnectionAnchor targetAnchor) {
        boolean added = false;
        if (targetAnchor.getDirection() == 0) {
            added = this.addNorthAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 2) {
            added = this.addSouthAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 1) {
            added = this.addEastAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 3) {
            added = this.addWestAnchor(targetAnchor);
        }
        return added;
    }

    public boolean move(NodeConnectionAnchor targetAnchor) {
        boolean removed = this.remove(targetAnchor);
        boolean added = this.add(targetAnchor);
        return removed && added;
    }

    public boolean remove(NodeConnectionAnchor targetAnchor) {
        boolean removed = false;
        if (targetAnchor.getDirection() != 0 && this.getNorthAnchors() != null && this.getNorthAnchors().contains(targetAnchor)) {
            this.getNorthAnchors().remove(targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 2 && this.getSouthAnchors() != null && this.getSouthAnchors().contains(targetAnchor)) {
            this.getSouthAnchors().remove(targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 1 && this.getEastAnchors() != null && this.getEastAnchors().contains(targetAnchor)) {
            this.getEastAnchors().remove(targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 3 && this.getWestAnchors() != null && this.getWestAnchors().contains(targetAnchor)) {
            this.getWestAnchors().remove(targetAnchor);
            removed = true;
        }
        return removed;
    }

    public void resetSourceAnchors(boolean updateTargetEnd) {
        List sConnections = this.getSourceConnections();
        if (sConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = sConnections.iterator();
        DiagramEditPart targetEditPart = null;
        NodeConnectionAnchor sourceAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            sourceAnchor = (NodeConnectionAnchor)nextConnection.getSourceAnchor();
            targetEditPart = (DiagramEditPart)nextConnection.getTarget();
            if (targetEditPart == null || sourceAnchor == null) continue;
            this.setAnchorPosition(sourceAnchor, 3);
            if (!updateTargetEnd) continue;
            targetEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    public void resetTargetAnchors(boolean updateSourceEnd) {
        List tConnections = this.getTargetConnections();
        if (tConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = tConnections.iterator();
        DiagramEditPart sourceEditPart = null;
        NodeConnectionAnchor targetAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            targetAnchor = (NodeConnectionAnchor)nextConnection.getTargetAnchor();
            sourceEditPart = (DiagramEditPart)nextConnection.getSource();
            if (sourceEditPart == null || targetAnchor == null) continue;
            this.setAnchorPosition(targetAnchor, 1);
            if (!updateSourceEnd) continue;
            sourceEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    public List getSourceConnections() {
        return this.diagramEditPart.getSourceConnections();
    }

    public List getTargetConnections() {
        return this.diagramEditPart.getTargetConnections();
    }

    public ConnectionAnchor getSourceAnchor(NodeConnectionEditPart connection) {
        if (connection.getSourceAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createSourceAnchor();
            connection.setSourceAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getSourceAnchor();
    }

    public ConnectionAnchor getTargetAnchor(NodeConnectionEditPart connection) {
        if (connection.getTargetAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createTargetAnchor();
            connection.setTargetAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getTargetAnchor();
    }

    private NodeConnectionAnchor createTargetAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), false);
        newAnchor.setDirection(1);
        this.add(newAnchor);
        this.setAnchorPosition(newAnchor, 1);
        return newAnchor;
    }

    private NodeConnectionAnchor createSourceAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), true);
        newAnchor.setDirection(3);
        this.add(newAnchor);
        this.setAnchorPosition(newAnchor, 3);
        return newAnchor;
    }

    public boolean hasSourceAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.northAnchors != null && !this.northAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.northAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTargetAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.northAnchors != null && !this.northAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.northAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    public void setAnchorPosition(NodeConnectionAnchor theAnchor, int direction) {
        Dimension partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
        int oldDirection = theAnchor.getDirection();
        theAnchor.setDirection(direction);
        boolean moved = this.move(theAnchor);
        if (moved) {
            this.setAnchorPositions(oldDirection, direction);
        } else if (direction == 0) {
            theAnchor.setOffsetH(partSize.width / 2);
            theAnchor.setOffsetV(0);
        } else if (direction == 2) {
            theAnchor.setOffsetH(partSize.width / 2);
            theAnchor.setOffsetV(partSize.height);
        } else if (direction == 3) {
            theAnchor.setOffsetH(0);
            theAnchor.setOffsetV(partSize.height / 2);
        } else {
            theAnchor.setOffsetH(partSize.width);
            theAnchor.setOffsetV(partSize.height / 2);
        }
    }

    private void setAnchorPositions(int oldDirection, int newDirection) {
        this.setAnchorPositions(oldDirection);
        this.setAnchorPositions(newDirection);
    }

    private void setAnchorPositions(int direction) {
        block5: {
            Iterator iter;
            Dimension partSize;
            block7: {
                block6: {
                    block4: {
                        partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
                        iter = null;
                        if (direction != 0 || this.getNorthAnchors() == null || this.getNorthAnchors().isEmpty()) break block4;
                        iter = this.getNorthAnchors().iterator();
                        NodeConnectionAnchor theAnchor = null;
                        while (iter.hasNext()) {
                            theAnchor = (NodeConnectionAnchor)iter.next();
                            theAnchor.setOffsetH(partSize.width / 2);
                            theAnchor.setOffsetV(0);
                        }
                        break block5;
                    }
                    if (direction != 2 || this.getSouthAnchors() == null || this.getSouthAnchors().isEmpty()) break block6;
                    iter = this.getSouthAnchors().iterator();
                    NodeConnectionAnchor theAnchor = null;
                    while (iter.hasNext()) {
                        theAnchor = (NodeConnectionAnchor)iter.next();
                        theAnchor.setOffsetH(partSize.width / 2);
                        theAnchor.setOffsetV(partSize.height);
                    }
                    break block5;
                }
                if (direction != 3 || this.getWestAnchors() == null || this.getWestAnchors().isEmpty()) break block7;
                iter = this.getWestAnchors().iterator();
                NodeConnectionAnchor theAnchor = null;
                while (iter.hasNext()) {
                    theAnchor = (NodeConnectionAnchor)iter.next();
                    theAnchor.setOffsetH(0);
                    theAnchor.setOffsetV(partSize.height / 2);
                }
                break block5;
            }
            if (this.getEastAnchors() == null || this.getEastAnchors().isEmpty()) break block5;
            iter = this.getEastAnchors().iterator();
            NodeConnectionAnchor theAnchor = null;
            while (iter.hasNext()) {
                theAnchor = (NodeConnectionAnchor)iter.next();
                theAnchor.setOffsetH(partSize.width);
                theAnchor.setOffsetV(partSize.height / 2);
            }
        }
    }

    public void reorderAllAnchors(boolean updateBothEnds) {
        this.resetSourceAnchors(updateBothEnds);
        this.resetTargetAnchors(updateBothEnds);
    }
}

