/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.teiid.designer.diagram.ui.editor.DiagramSelectionHandler;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAttributeEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class TransformationDiagramSelectionHandler
extends DiagramSelectionHandler {
    public TransformationDiagramSelectionHandler(DiagramViewer viewer) {
        super(viewer);
    }

    public void select(EObject selectedObject) {
        super.select(selectedObject);
        this.hiliteDependencies(selectedObject);
    }

    public boolean shouldRename(EObject dClickedEObject) {
        boolean renameOK = false;
        EObject target = this.getTargetEObject();
        if (target.equals(dClickedEObject)) {
            renameOK = true;
        } else {
            EObject parentTableEObject;
            DiagramEditPart dep;
            EditPart selectedPart = this.findEditPart(dClickedEObject, false);
            if (selectedPart != null && selectedPart instanceof DiagramEditPart && (dep = DiagramUiUtilities.getTopClassifierParent((DiagramEditPart)((DiagramEditPart)selectedPart))) != null && target.equals(parentTableEObject = dep.getModelObject())) {
                renameOK = true;
            }
        }
        return renameOK;
    }

    public void hiliteDependencies(Object selectedObject) {
        EObject selectedEObject;
        EditPart selectedPart;
        this.clearDependencyHilites();
        if (selectedObject != null && selectedObject instanceof EObject && (selectedPart = this.findEditPart(selectedEObject = (EObject)selectedObject, false)) != null && selectedPart instanceof UmlAttributeEditPart) {
            super.hiliteDependencies(selectedObject);
            ArrayList allDependencies = new ArrayList(this.findAllDependencies((EObject)selectedObject));
            Iterator iter = allDependencies.iterator();
            EditPart nextEP = null;
            EObject nextEObject = null;
            while (iter.hasNext()) {
                nextEObject = (EObject)iter.next();
                nextEP = this.findEditPart(nextEObject, false);
                if (nextEP == null || !(nextEP instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEP).hiliteBackground(UiConstants.Colors.DEPENDENCY);
            }
        }
    }

    private List findAllDependencies(EObject selectedAttribute) {
        ArrayList allDependencies = new ArrayList();
        Iterator iter = null;
        Object nextObject2 = null;
        if (ModelObjectUtilities.isVirtual((EObject)selectedAttribute)) {
            ArrayList allSourceDependencies = new ArrayList();
            this.getSourceDependencies(selectedAttribute, allSourceDependencies);
            for (Object nextObject2 : allSourceDependencies) {
                if (allDependencies.contains(nextObject2)) continue;
                allDependencies.add(nextObject2);
            }
        }
        ArrayList allTargetDependencies = new ArrayList();
        this.getTargetDependencies(selectedAttribute, allTargetDependencies);
        for (Object nextObject2 : allTargetDependencies) {
            if (allDependencies.contains(nextObject2)) continue;
            allDependencies.add(nextObject2);
        }
        if (allDependencies.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return allDependencies;
    }

    private List getSourceDependencies(EObject selectedAttribute, List sourceDependencyList) {
        if (ModelObjectUtilities.isVirtual((EObject)selectedAttribute)) {
            EObject virtualTarget = selectedAttribute.eContainer();
            if (!TransformationHelper.isValidSqlTransformationTarget((Object)virtualTarget) && TransformationHelper.isSqlColumnSet((Object)virtualTarget)) {
                virtualTarget = virtualTarget.eContainer();
            }
            if (virtualTarget != null) {
                TransformationMappingRoot tmr = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)virtualTarget);
                ArrayList attrDepList = new ArrayList(TransformationHelper.getSourceAttributesForTargetAttr((Object)selectedAttribute, (Object)tmr));
                EObject nextEObject2 = null;
                for (EObject nextEObject2 : attrDepList) {
                    EditPart visibleEditPart;
                    if (nextEObject2.equals(selectedAttribute) || (visibleEditPart = this.findEditPart(nextEObject2, false)) == null || !(visibleEditPart instanceof DiagramEditPart) || sourceDependencyList.contains(nextEObject2)) continue;
                    sourceDependencyList.add(nextEObject2);
                    if (!ModelObjectUtilities.isVirtual((EObject)nextEObject2)) continue;
                    this.getSourceDependencies(nextEObject2, sourceDependencyList);
                }
            }
        }
        return sourceDependencyList;
    }

    private List getTargetDependencies(EObject selectedAttribute, List targetDependencyList) {
        EObject targetClassifier = selectedAttribute.eContainer();
        List allTargetTransformations = this.getTargetTransformationsForSource(targetClassifier);
        Iterator iter = allTargetTransformations.iterator();
        TransformationMappingRoot nextTMR = null;
        while (iter.hasNext()) {
            nextTMR = (TransformationMappingRoot)iter.next();
            ArrayList attrDepList = new ArrayList(TransformationHelper.getTargetAttributesForSourceAttr((Object)selectedAttribute, (Object)nextTMR));
            Iterator iter2 = attrDepList.iterator();
            EObject nextEObject = null;
            while (iter2.hasNext()) {
                EditPart visibleEditPart;
                nextEObject = (EObject)iter2.next();
                if (nextEObject.equals(selectedAttribute) || (visibleEditPart = this.findEditPart(nextEObject, false)) == null || !(visibleEditPart instanceof DiagramEditPart) || targetDependencyList.contains(nextEObject)) continue;
                targetDependencyList.add(nextEObject);
                this.getTargetDependencies(nextEObject, targetDependencyList);
            }
        }
        return targetDependencyList;
    }

    private List getVisibleTransformations() {
        ArrayList<EObject> visibleTransformations = Collections.EMPTY_LIST;
        if (this.getViewer().getEditor().getCurrentModel() != null) {
            visibleTransformations = new ArrayList<EObject>();
            List allDiagramModelNodes = this.getViewer().getEditor().getCurrentModel().getChildren();
            Object nextObject = null;
            Iterator iter = allDiagramModelNodes.iterator();
            EObject nextTransformation = null;
            while (iter.hasNext()) {
                nextObject = iter.next();
                if (!(nextObject instanceof TransformationNode) || visibleTransformations.contains(nextTransformation = ((DiagramModelNode)nextObject).getModelObject())) continue;
                visibleTransformations.add(nextTransformation);
            }
        }
        return visibleTransformations;
    }

    private List getTargetTransformationsForSource(EObject sourceTableObject) {
        List visibleTransformations = this.getVisibleTransformations();
        ArrayList<TransformationMappingRoot> targetTransformations = Collections.EMPTY_LIST;
        if (!visibleTransformations.isEmpty()) {
            targetTransformations = new ArrayList<TransformationMappingRoot>(visibleTransformations.size());
            TransformationMappingRoot nextMR2 = null;
            for (TransformationMappingRoot nextMR2 : visibleTransformations) {
                if (nextMR2.getInputs() == null || nextMR2.getInputs().isEmpty() || !nextMR2.getInputs().contains((Object)sourceTableObject) || targetTransformations.contains(nextMR2)) continue;
                targetTransformations.add(nextMR2);
            }
        }
        return targetTransformations;
    }

    public EditPart findEditPart(EObject selectedObject, boolean linksAllowed) {
        EObject vGroupEObject = this.getTargetEObject();
        if (vGroupEObject != null && vGroupEObject.equals(selectedObject)) {
            DiagramModelNode dmn = DiagramUiUtilities.getDiagramModelNode((EObject)vGroupEObject, (DiagramModelNode)this.getDiagramNode());
            return DiagramUiUtilities.getDiagramEditPart((DiagramEditPart)((DiagramEditPart)this.getDiagramEditPart()), (DiagramModelNode)dmn);
        }
        return super.findEditPart(selectedObject, linksAllowed);
    }

    private EObject getTargetEObject() {
        EObject diagram;
        if (this.getViewer().getEditor().getCurrentModel() != null && (diagram = this.getViewer().getEditor().getCurrentModel().getModelObject()) instanceof Diagram) {
            EObject targetEObject = ((Diagram)diagram).getTarget();
            return targetEObject;
        }
        return null;
    }

    private DiagramModelNode getDiagramNode() {
        return this.getViewer().getEditor().getCurrentModel();
    }

    private EditPart getDiagramEditPart() {
        List contents = this.getViewer().getRootEditPart().getChildren();
        Iterator iter = contents.iterator();
        if (iter.hasNext()) {
            return (EditPart)iter.next();
        }
        return null;
    }
}

