/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.diagram;

import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.AbstractDiagramType;
import org.teiid.designer.diagram.ui.editor.CanOpenContextException;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelFactory;
import org.teiid.designer.diagram.ui.part.DiagramEditPartFactory;
import org.teiid.designer.diagram.ui.preferences.DiagramColorObject;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.aspects.sql.MappingClassSqlAspect;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationActionAdapter;
import org.teiid.designer.transformation.ui.diagram.TransformationDiagramSelectionHandler;
import org.teiid.designer.transformation.ui.figure.TransformationDiagramFigureFactory;
import org.teiid.designer.transformation.ui.model.TransformationDiagramModelFactory;
import org.teiid.designer.transformation.ui.part.TransformationDiagramPartFactory;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TransformationDiagramType
extends AbstractDiagramType {
    private static DiagramEditPartFactory editPartFactory;
    private static DiagramModelFactory modelFactory;
    private static DiagramFigureFactory figureFactory;
    protected DiagramColorObject bkgdColorObject;
    public String displayName;
    private static final String CANT_OPEN_MESSAGE = "Cannot Open Transformation.\n\nModel is read-only and must be writable for underlying \ntransformation to be constructed and displayed.\n";

    public DiagramEditPartFactory getEditPartFactory() {
        if (editPartFactory == null) {
            editPartFactory = new TransformationDiagramPartFactory();
        }
        return editPartFactory;
    }

    public DiagramFigureFactory getFigureFactory() {
        if (figureFactory == null) {
            figureFactory = new TransformationDiagramFigureFactory();
        }
        return figureFactory;
    }

    public DiagramModelFactory getModelFactory() {
        if (modelFactory == null) {
            modelFactory = new TransformationDiagramModelFactory();
        }
        return modelFactory;
    }

    public IDiagramActionAdapter getActionAdapter(ModelEditorPage editor) {
        return new TransformationActionAdapter(editor);
    }

    public String getDisplayName() {
        return UiConstants.Util.getString("DiagramNames.transformationDiagram", new Object[0]);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public IDiagramSelectionHandler getSelectionHandler(DiagramViewer viewer) {
        TransformationDiagramSelectionHandler handler = new TransformationDiagramSelectionHandler(viewer);
        return handler;
    }

    public boolean canOpenContext(Object input) throws CanOpenContextException {
        boolean canOpen = false;
        boolean readOnlyFailure = false;
        if (input instanceof EObject) {
            EObject eObj = (EObject)input;
            boolean eObjectIsStale = ModelObjectUtilities.isStale((EObject)eObj);
            if (eObj instanceof Diagram && ((Diagram)eObj).getType() != null && ((Diagram)eObj).getType().equals("transformationDiagramType")) {
                EObject virtualGroupEObject = ((Diagram)eObj).getTarget();
                if (virtualGroupEObject != null && !ModelObjectUtilities.isStale((EObject)virtualGroupEObject)) {
                    EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)virtualGroupEObject);
                    if (transformation != null) {
                        canOpen = true;
                    } else if (!ModelObjectUtilities.isReadOnly((EObject)virtualGroupEObject)) {
                        canOpen = true;
                    } else {
                        readOnlyFailure = true;
                    }
                }
            } else if (!eObjectIsStale) {
                if (TransformationDiagramUtil.isStandardVirtualSqlTable(eObj)) {
                    EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)input));
                    if (transformation != null) {
                        canOpen = true;
                    } else if (!ModelObjectUtilities.isReadOnly((EObject)((EObject)input))) {
                        canOpen = true;
                    } else {
                        readOnlyFailure = true;
                    }
                } else if (TransformationHelper.isTransformationObject((Object)input)) {
                    canOpen = true;
                }
            }
        }
        if (!canOpen && readOnlyFailure) {
            throw new CanOpenContextException(CANT_OPEN_MESSAGE);
        }
        return canOpen;
    }

    public Diagram getDiagramForContext(Object actualInput) {
        Diagram transDiagram = null;
        Object input = actualInput;
        if (input instanceof DiagramProxy && (input = ((DiagramProxy)actualInput).getTarget()) == null) {
            input = ((DiagramProxy)actualInput).getModelResource();
        }
        if (input instanceof Diagram && ((Diagram)input).getType() != null && ((Diagram)input).getType().equals("transformationDiagramType")) {
            EObject virtualGroupEObject = ((Diagram)input).getTarget();
            EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)virtualGroupEObject);
            if (transformation != null) {
                transDiagram = (Diagram)input;
            } else if (!ModelObjectUtilities.isReadOnly((EObject)((EObject)input))) {
                transDiagram = (Diagram)input;
            }
        } else if (TransformationDiagramUtil.isStandardVirtualSqlTable(input)) {
            EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)input));
            if (transformation != null) {
                EObject eObject = (EObject)input;
                ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                transDiagram = TransformationDiagramUtil.getTransformationDiagram(modelResource, eObject, true, true);
            } else if (!ModelObjectUtilities.isReadOnly((EObject)((EObject)input))) {
                EObject eObject = (EObject)input;
                ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                transDiagram = TransformationDiagramUtil.getTransformationDiagram(modelResource, eObject, true, true);
            }
        } else if (TransformationHelper.isTransformationObject((Object)input)) {
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)input)) {
                EObject virtualGroup = TransformationHelper.getTransformationLinkTarget((EObject)((EObject)input));
                SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)virtualGroup);
                if (!(sqlAspect instanceof MappingClassSqlAspect)) {
                    EObject eObject = (EObject)input;
                    ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                    transDiagram = TransformationDiagramUtil.getTransformationDiagram(modelResource, eObject);
                }
            } else {
                EObject eObject = (EObject)input;
                ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                transDiagram = TransformationDiagramUtil.getTransformationDiagram(modelResource, eObject);
            }
        }
        return transDiagram;
    }

    public DiagramColorObject getBackgroundColorObject(String extensionID) {
        if (this.bkgdColorObject == null) {
            this.bkgdColorObject = new DiagramColorObject(this.getDisplayName(), "modeler.preference.diagram.transformation.backgroundcolor");
        }
        return this.bkgdColorObject;
    }

    public Diagram getDiagramForGoToMarkerEObject(EObject eObject) {
        return this.getDiagramForContext(eObject);
    }

    public String getDisplayedPath(Diagram diagram, EObject eObject) {
        String path = null;
        if (diagram.getType() != null && diagram.getType().equals("transformationDiagramType") && (diagram.getTarget() == null || !diagram.getTarget().equals(eObject))) {
            path = !ModelUtilities.areModelResourcesSame((EObject)diagram, (EObject)eObject) ? ModelObjectUtilities.getTrimmedFullPath((EObject)eObject) : ModelObjectUtilities.getTrimmedRelativePath((EObject)eObject);
        }
        return path;
    }

    public EObject getRevealedEObject(Diagram diagram, Object object) {
        if (diagram.getType() != null && (diagram.getType().equals("transformationDiagramType") || diagram.getType().equals("dependencyDiagramType"))) {
            return diagram.getTarget();
        }
        return null;
    }
}

