/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.CreateViewTableAction;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;
import org.teiid.designer.ui.wizards.NewModelWizard;
import org.teiid.designer.ui.wizards.NewModelWizardInput;

public class DefineViewTableDialog
extends TitleAreaDialog
implements IChangeListener,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefineViewTableDialog.class);
    private EObject viewTable;
    private IResource selectedModel;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button newViewModelButton;
    private Button browseModelsButton;
    private Text selectedViewModelText;
    private Button newViewTableButton;
    private Button browseButton;
    private Text selectedViewTableText;
    DesignerProperties designerProperties;

    private static String getString(String key) {
        return Util.getString(String.valueOf(PREFIX) + key, new Object[0]);
    }

    public DefineViewTableDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DefineViewTableDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = (DesignerProperties)properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DefineViewTableDialog.getString("title"));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(DefineViewTableDialog.getString("subTitle"));
        this.setMessage(DefineViewTableDialog.getString("initialMessage"));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)DefineViewTableDialog.getString("viewModelName"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedViewModelText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedViewModelText.setToolTipText(DefineViewTableDialog.getString("viewModelNameTooltip"));
        this.selectedViewModelText.setEditable(false);
        this.selectedViewModelText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedViewModelText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newViewModelButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewTableDialog.getString("newViewModelButton"));
        this.newViewModelButton.setToolTipText(DefineViewTableDialog.getString("newViewModelButtonTooltip"));
        this.newViewModelButton.setEnabled(true);
        this.newViewModelButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newViewModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewTableDialog.this.handleNewViewModelPressed();
            }
        });
        this.browseModelsButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewTableDialog.getString("browseModelsButton"));
        this.browseModelsButton.setToolTipText(DefineViewTableDialog.getString("browseModelsButtonTooltip"));
        this.browseModelsButton.setEnabled(true);
        this.browseModelsButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewTableDialog.this.handleBrowseWorkspaceForModelPressed();
            }
        });
        label = WidgetFactory.createLabel((Composite)panel, (String)DefineViewTableDialog.getString("viewTableName"));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedViewTableText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedViewTableText.setToolTipText(DefineViewTableDialog.getString("viewTableNameTooltip"));
        this.selectedViewTableText.setEditable(false);
        this.selectedViewTableText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedViewTableText.setForeground(Display.getCurrent().getSystemColor(10));
        this.newViewTableButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewTableDialog.getString("newButton"));
        this.newViewTableButton.setToolTipText(DefineViewTableDialog.getString("newButtonTooltip"));
        this.newViewTableButton.setEnabled(true);
        this.newViewTableButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.newViewTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewTableDialog.this.handleNewViewTablePressed();
            }
        });
        this.browseButton = WidgetFactory.createButton((Composite)panel, (String)DefineViewTableDialog.getString("browseButton"));
        this.browseButton.setToolTipText(DefineViewTableDialog.getString("browseButtonTooltip"));
        this.browseButton.setEnabled(true);
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DefineViewTableDialog.this.handleBrowseWorkspaceForObjectPressed();
            }
        });
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            EObject lastModelObject;
            this.selectedModel = this.designerProperties.getViewModel();
            if (this.selectedModel != null) {
                this.selectedViewModelText.setText(this.selectedModel.getName());
            }
            if ((lastModelObject = this.designerProperties.getLastViewModelObject()) != null && lastModelObject instanceof Table) {
                this.viewTable = lastModelObject;
                this.selectedViewTableText.setText(this.designerProperties.getLastViewModelObjectName());
            }
            this.updateState();
        }
        return control;
    }

    public EObject getViewTable() {
        return this.viewTable;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(DefineViewTableDialog.getString("okMsg"));
        }
    }

    private void handleNewViewTablePressed() {
        try {
            IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)this.selectedModel));
        }
        catch (PartInitException partInitException) {}
        CreateViewTableAction action = new CreateViewTableAction((Properties)this.designerProperties);
        action.run();
        this.viewTable = action.getNewViewTable();
        if (this.viewTable != null) {
            String name = ModelerCore.getModelEditor().getName(this.viewTable);
            this.selectedViewTableText.setText(name);
            this.designerProperties.setLastViewModelObjectName(name);
        }
    }

    private void handleBrowseWorkspaceForObjectPressed() {
        ModelWorkspaceDialog sdDialog = this.createViewTableSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter((Properties)this.designerProperties));
        IFile viewModel = this.designerProperties.getViewModel();
        if (viewModel != null) {
            sdDialog.setInitialSelection((Object)viewModel);
        }
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.viewTable = (EObject)selections[0];
            String name = ModelerCore.getModelEditor().getName(this.viewTable);
            this.selectedViewTableText.setText(name);
            this.designerProperties.setLastViewModelObjectName(name);
            this.designerProperties.setPreviewTargetObjectName(name);
            try {
                ModelResource mr = ModelUtilities.getModelResource((Object)this.viewTable);
                this.selectedModel = mr.getUnderlyingResource();
                this.designerProperties.setViewModelName(this.selectedModel.getName());
                this.selectedViewModelText.setText(this.selectedModel.getName());
                this.designerProperties.setPreviewTargetModelName(this.selectedModel.getName());
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
            this.updateState();
        }
    }

    private void handleNewViewModelPressed() {
        NewModelWizardInput newModelInput = new NewModelWizardInput("Relational", ModelType.VIRTUAL_LITERAL, null);
        boolean projectDefined = false;
        IWorkbenchWindow iww = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean successful = false;
        try {
            try {
                WizardDialog dialog;
                int result;
                NewModelWizard wizard = new NewModelWizard(newModelInput, (Properties)this.designerProperties);
                IContainer container = this.designerProperties.getViewsFolder();
                if (container == null) {
                    container = this.designerProperties.getProject();
                }
                if (container != null) {
                    projectDefined = true;
                    wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)container));
                }
                if ((result = (dialog = new WizardDialog(iww.getShell(), (IWizard)wizard)).open()) == 0) {
                    successful = true;
                }
            }
            catch (Exception e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                MessageDialog.openError((Shell)iww.getShell(), (String)DefineViewTableDialog.getString("modelCreationError.title"), (String)DefineViewTableDialog.getString("modelCreationError.message"));
                if (successful) {
                    if (this.selectedModel == null || this.designerProperties.isViewModelDifferent((IFile)this.selectedModel)) {
                        this.selectedModel = this.designerProperties.getViewModel();
                        if (this.selectedModel != null) {
                            this.selectedViewModelText.setText(this.selectedModel.getName());
                        }
                    }
                    if (!projectDefined) {
                        this.designerProperties.setProjectName(this.selectedModel.getProject().getName());
                    }
                }
            }
        }
        finally {
            if (successful) {
                if (this.selectedModel == null || this.designerProperties.isViewModelDifferent((IFile)this.selectedModel)) {
                    this.selectedModel = this.designerProperties.getViewModel();
                    if (this.selectedModel != null) {
                        this.selectedViewModelText.setText(this.selectedModel.getName());
                    }
                }
                if (!projectDefined) {
                    this.designerProperties.setProjectName(this.selectedModel.getProject().getName());
                }
            }
        }
    }

    private void handleBrowseWorkspaceForModelPressed() {
        ModelWorkspaceDialog sdDialog = this.createViewModelSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter((Properties)this.designerProperties));
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.selectedModel = (IResource)selections[0];
            this.designerProperties.setViewModelName(this.selectedModel.getName());
            this.selectedViewModelText.setText(this.selectedModel.getName());
            this.updateState();
        }
    }

    public ModelWorkspaceDialog createViewTableSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = DefineViewTableDialog.getString("selectionDialog.title");
        String message = DefineViewTableDialog.getString("selectionDialog.message");
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                ModelResource mr;
                EObject eObj;
                boolean ok = false;
                if (selection != null && selection.length == 1 && selection[0] instanceof EObject && (eObj = (EObject)selection[0]) instanceof Table && (mr = ModelUtilities.getModelResource((Object)eObj)) != null) {
                    ok = ModelIdentifier.isVirtualModelType((ModelResource)mr);
                }
                if (!ok) {
                    String msg = DefineViewTableDialog.getString("selectionDialog.invalidSelection");
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.transformation.ui");
            }
        });
        return result;
    }

    public ModelWorkspaceDialog createViewModelSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = DefineViewTableDialog.getString("viewModel.selectionDialog.title");
        String message = DefineViewTableDialog.getString("viewModel.selectionDialog.message");
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IResource res;
                ModelResource mr;
                boolean ok = false;
                if (selection != null && selection.length == 1 && selection[0] instanceof IResource && (mr = ModelUtilities.getModelResource((Object)(res = (IResource)selection[0]))) != null) {
                    ok = ModelIdentifier.isVirtualModelType((ModelResource)mr);
                }
                if (!ok) {
                    String msg = DefineViewTableDialog.getString("viewModel.selectionDialog.invalidSelection");
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.transformation.ui");
            }
        });
        return result;
    }
}

