/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class EditColumnDialog
extends TitleAreaDialog {
    private static final String EMPTY_STRING = "";
    RelationalColumn column;

    public EditColumnDialog(Shell parent, RelationalColumn column) {
        super(parent);
        this.column = column;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.EditColumnTitle);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EditColumnTitle);
        this.setMessage(NLS.bind((String)Messages.EditingColumnInformation, (Object)this.column.getName()), 1);
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite composite = WidgetFactory.createPanel((Composite)dialogComposite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Label label = new Label(composite, 4);
        label.setText(Messages.Name);
        label.setLayoutData((Object)new GridData());
        final Text columnNameText = new Text(composite, 2048);
        columnNameText.setText(this.column.getName());
        columnNameText.setForeground(Display.getCurrent().getSystemColor(10));
        columnNameText.setLayoutData((Object)new GridData(768));
        columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = columnNameText.getText();
                if (value == null) {
                    value = EditColumnDialog.EMPTY_STRING;
                }
                EditColumnDialog.this.column.setName(value);
                EditColumnDialog.this.validate();
            }
        });
        Label datatype = new Label(composite, 2048);
        datatype.setText(Messages.dataTypeLabel);
        datatype.setLayoutData((Object)new GridData());
        final Combo datatypeCombo = new Combo(composite, 0);
        datatypeCombo.setForeground(Display.getCurrent().getSystemColor(10));
        datatypeCombo.setLayoutData((Object)new GridData(16384, 16384, true, true));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        ArrayList<Object> dTypes = new ArrayList<Object>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            if (!((String)dType).equalsIgnoreCase("integer")) {
                dTypes.add(dType);
            }
            dTypes.add(dType);
            ++n2;
        }
        String[] datatypes = dTypes.toArray(new String[dTypes.size()]);
        datatypeCombo.setItems(datatypes);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)datatypeCombo);
        datatypeCombo.setText(this.column.getDatatype());
        datatypeCombo.redraw();
        datatypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EditColumnDialog.this.column.setDatatype(datatypeCombo.getText());
                EditColumnDialog.this.validate();
            }
        });
        Label label1 = new Label(composite, 4);
        label1.setText(Messages.lengthLabel);
        label1.setLayoutData((Object)new GridData());
        final Text lengthValueText = new Text(composite, 2048);
        lengthValueText.setText(String.valueOf(this.column.getLength()));
        lengthValueText.setForeground(Display.getCurrent().getSystemColor(10));
        lengthValueText.setLayoutData((Object)new GridData(768));
        lengthValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = lengthValueText.getText();
                if (value == null) {
                    value = EditColumnDialog.EMPTY_STRING;
                }
                EditColumnDialog.this.column.setLength(Integer.parseInt(value));
                EditColumnDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        boolean enable = true;
        this.getButton(0).setEnabled(enable);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        super.okPressed();
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof ITeiidXmlColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ITeiidXmlColumnInfo)element).getName();
                    }
                    case 1: {
                        return Boolean.toString(((ITeiidXmlColumnInfo)element).getOrdinality());
                    }
                    case 2: {
                        return ((ITeiidXmlColumnInfo)element).getDatatype();
                    }
                    case 3: {
                        return ((ITeiidXmlColumnInfo)element).getRelativePath();
                    }
                }
            }
            return EditColumnDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }
}

