/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class EditParameterDialog
extends TitleAreaDialog {
    private static final String EMPTY_STRING = "";
    RelationalParameter origParameter;
    RelationalParameter tempParameter;

    public EditParameterDialog(Shell parent, RelationalParameter parameter) {
        super(parent);
        this.origParameter = parameter;
        this.tempParameter = new RelationalParameter();
        this.tempParameter.setDatatype(this.origParameter.getDatatype());
        this.tempParameter.setName(this.origParameter.getName());
        this.tempParameter.setLength(this.origParameter.getLength());
        this.tempParameter.setDirection(this.origParameter.getDirection());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.EditParameterTitle);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EditParameterTitle);
        this.setMessage(NLS.bind((String)Messages.EditingParameterInformation, (Object)this.origParameter.getName()), 1);
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite composite = WidgetFactory.createPanel((Composite)dialogComposite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Label label = new Label(composite, 4);
        label.setText(Messages.Name);
        label.setLayoutData((Object)new GridData());
        final Text columnNameText = new Text(composite, 2048);
        columnNameText.setText(this.origParameter.getName());
        columnNameText.setForeground(Display.getCurrent().getSystemColor(10));
        columnNameText.setLayoutData((Object)new GridData(768));
        columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = columnNameText.getText();
                if (value == null) {
                    value = EditParameterDialog.EMPTY_STRING;
                }
                EditParameterDialog.this.tempParameter.setName(value);
                EditParameterDialog.this.validate();
            }
        });
        Label datatype = new Label(composite, 2048);
        datatype.setText(Messages.dataTypeLabel);
        datatype.setLayoutData((Object)new GridData());
        final Combo datatypeCombo = new Combo(composite, 0);
        datatypeCombo.setForeground(Display.getCurrent().getSystemColor(10));
        datatypeCombo.setLayoutData((Object)new GridData(16384, 16384, true, true));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        ArrayList<Object> dTypes = new ArrayList<Object>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            dTypes.add(dType);
            ++n2;
        }
        String[] datatypes = dTypes.toArray(new String[dTypes.size()]);
        datatypeCombo.setItems(datatypes);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)datatypeCombo);
        datatypeCombo.setText(this.origParameter.getDatatype());
        datatypeCombo.redraw();
        datatypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EditParameterDialog.this.tempParameter.setDatatype(datatypeCombo.getText());
                EditParameterDialog.this.validate();
            }
        });
        Label label1 = new Label(composite, 4);
        label1.setText(Messages.lengthLabel);
        label1.setLayoutData((Object)new GridData());
        final Text lengthValueText = new Text(composite, 2048);
        lengthValueText.setText(String.valueOf(this.origParameter.getLength()));
        lengthValueText.setForeground(Display.getCurrent().getSystemColor(10));
        lengthValueText.setLayoutData((Object)new GridData(768));
        lengthValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = lengthValueText.getText();
                if (value == null) {
                    value = EditParameterDialog.EMPTY_STRING;
                }
                EditParameterDialog.this.tempParameter.setLength(Integer.parseInt(value));
                EditParameterDialog.this.validate();
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.directionLabel);
        label2.setLayoutData((Object)new GridData());
        final Combo directionCombo = new Combo(composite, 0);
        directionCombo.setForeground(Display.getCurrent().getSystemColor(10));
        directionCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        directionCombo.setItems(RelationalConstants.DIRECTION.AS_ARRAY);
        directionCombo.setText(this.origParameter.getDirection());
        directionCombo.redraw();
        directionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EditParameterDialog.this.tempParameter.setDirection(directionCombo.getText());
                EditParameterDialog.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        boolean enable = true;
        this.getButton(0).setEnabled(enable);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        this.origParameter.setDatatype(this.tempParameter.getDatatype());
        this.origParameter.setName(this.tempParameter.getName());
        this.origParameter.setLength(this.tempParameter.getLength());
        this.origParameter.setDirection(this.tempParameter.getDirection());
        super.okPressed();
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof ITeiidXmlColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ITeiidXmlColumnInfo)element).getName();
                    }
                    case 1: {
                        return Boolean.toString(((ITeiidXmlColumnInfo)element).getOrdinality());
                    }
                    case 2: {
                        return ((ITeiidXmlColumnInfo)element).getDatatype();
                    }
                    case 3: {
                        return ((ITeiidXmlColumnInfo)element).getRelativePath();
                    }
                }
            }
            return EditParameterDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }
}

