/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.EventObject;
import org.teiid.designer.transformation.ui.UiConstants;

public class QueryEditorStatusEvent
extends EventObject
implements UiConstants {
    private static final long serialVersionUID = 1L;
    public static final int QUERY_PARSABLE = 0;
    public static final int QUERY_RESOLVABLE = 1;
    public static final int QUERY_VALIDATABLE = 2;
    public static final int QUERY_NOT_PARSABLE = 3;
    public static final int QUERY_HAS_PENDING_CHANGES = 4;
    public static final int QUERY_TAB_CHANGE = 5;
    private int eventType;

    public QueryEditorStatusEvent(Object source, int eventType) {
        super(source);
        if (eventType != 0 && eventType != 1 && eventType != 2 && eventType != 3 && eventType != 4 && eventType != 5) {
            throw new AssertionError((Object)this.invalidEventTypeString(eventType));
        }
        this.eventType = eventType;
    }

    public int getType() {
        return this.eventType;
    }

    public boolean isParsable() {
        return this.eventType == 0 || this.eventType == 1 || this.eventType == 2;
    }

    public boolean isResolvable() {
        return this.eventType == 1 || this.eventType == 2;
    }

    public boolean isValid() {
        return this.eventType == 2;
    }

    public boolean isNotParsable() {
        return this.eventType == 3;
    }

    public boolean hasPendingChanges() {
        return this.eventType == 4;
    }

    public boolean isTabChange() {
        return this.eventType == 5;
    }

    @Override
    public String toString() {
        StringBuffer msg = new StringBuffer(this.getClass().getName());
        msg.append(':');
        String typeStr = Util.getString("QueryEditorStatusEvent.type", new Object[0]);
        msg.append(typeStr);
        msg.append('=');
        switch (this.eventType) {
            case 2: {
                String valid = Util.getString("QueryEditorStatusEvent.valid", new Object[0]);
                msg.append(valid);
                break;
            }
            case 0: {
                String parsable = Util.getString("QueryEditorStatusEvent.parsable", new Object[0]);
                msg.append(parsable);
                break;
            }
            case 3: {
                String notParsable = Util.getString("QueryEditorStatusEvent.notParsable", new Object[0]);
                msg.append(notParsable);
                break;
            }
            case 4: {
                String pendingChanges = Util.getString("QueryEditorStatusEvent.pendingChanges", new Object[0]);
                msg.append(pendingChanges);
                break;
            }
            case 1: {
                String resolvable = Util.getString("QueryEditorStatusEvent.resolvable", new Object[0]);
                msg.append(resolvable);
                break;
            }
            case 5: {
                String tabChange = Util.getString("QueryEditorStatusEvent.tabChange", new Object[0]);
                msg.append(tabChange);
                break;
            }
            default: {
                String unknownType = Util.getString("QueryEditorStatusEvent.unknownType", new Object[0]);
                msg.append(unknownType);
            }
        }
        return msg.toString();
    }

    private String invalidEventTypeString(int eventType) {
        StringBuffer buf = new StringBuffer();
        buf.append(Util.getString("QueryEditorStatusEvent.error", new Object[0]));
        buf.append(": ");
        buf.append(eventType);
        buf.append(' ');
        buf.append(Util.getString("QueryEditorStatusEvent.isNotValid", new Object[0]));
        String result = buf.toString();
        return result;
    }
}

