/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.util.SqlAspectHelper;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.util.EObjectTransfer;

public class SqlPanelDropTargetListener
implements TransferDropTargetListener {
    private static final Transfer[] tranfers = new Transfer[]{EObjectTransfer.getInstance()};
    private SqlEditorPanel sqlPanel;
    private SqlTransformationMappingRoot transformation;
    private Object txnSource;

    public SqlPanelDropTargetListener(SqlEditorPanel sqlPanel, SqlTransformationMappingRoot transformation, Object txnSource) {
        this.sqlPanel = sqlPanel;
        this.transformation = transformation;
        this.txnSource = txnSource;
    }

    public Transfer getTransfer() {
        return EObjectTransfer.getInstance();
    }

    public Transfer[] getTransfers() {
        return tranfers;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = this.isEnabled(event) && this.isInsertOK(event) ? 1 : 0;
    }

    private Point getMousePoint(DropTargetEvent event) {
        Point thePoint = Display.getCurrent().map((Control)this.sqlPanel.getShell(), (Control)this.sqlPanel.getTextViewer().getTextWidget(), event.x, event.y);
        Point correctionPt = this.getXYPanelOffset();
        thePoint.x = thePoint.x - this.sqlPanel.getShell().getBounds().x - correctionPt.x;
        thePoint.y = thePoint.y - this.sqlPanel.getShell().getBounds().y - correctionPt.y;
        return thePoint;
    }

    protected Point getXYPanelOffset() {
        Point newPt = new Point(3, 8);
        newPt.y += this.sqlPanel.getLocation().y;
        newPt.y += this.sqlPanel.getParent().getLocation().y;
        newPt.y += this.sqlPanel.getParent().getParent().getLocation().y;
        newPt.y += this.sqlPanel.getParent().getParent().getParent().getLocation().y;
        return newPt;
    }

    protected boolean isInsertOK(DropTargetEvent event) {
        if (this.dragSourcesAreTables(event)) {
            return this.isMouseInFrom(event) || this.sqlIsEmpty();
        }
        if (this.dragSourcesAreColumns(event) && this.isMouseInSelect(event)) {
            int offset = this.sqlPanel.getCorrectedCaretOffset(this.getDropOffset(event));
            return this.sqlPanel.isInsertOK(offset);
        }
        return false;
    }

    public boolean isMouseInFrom(DropTargetEvent event) {
        int offset = 0;
        try {
            offset = this.sqlPanel.getCorrectedCaretOffset(this.getDropOffset(event));
            if (this.sqlPanel.isIndexWithin(offset, 8)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return false;
    }

    private int getDropOffset(DropTargetEvent event) throws IllegalArgumentException {
        return this.sqlPanel.getTextViewer().getTextWidget().getOffsetAtLocation(this.getMousePoint(event));
    }

    public boolean isMouseInSelect(DropTargetEvent event) {
        int offset = 0;
        try {
            offset = this.sqlPanel.getCorrectedCaretOffset(this.getDropOffset(event));
            if (this.sqlPanel.isIndexWithin(offset, 6)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return false;
    }

    private boolean dragSourcesAreTables(DropTargetEvent event) {
        boolean result = false;
        List eObjList = this.getEventEObjects(event);
        if (!eObjList.isEmpty()) {
            result = TransformationSourceManager.canAdd((EObject)this.transformation, eObjList, (Object)this);
        }
        return result;
    }

    private boolean dragSourcesAreColumns(DropTargetEvent event) {
        boolean result = false;
        List eObjList = this.getEventEObjects(event);
        if (!eObjList.isEmpty()) {
            EObject nextEObj2 = null;
            result = true;
            for (EObject nextEObj2 : eObjList) {
                if (org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper.isColumn((EObject)nextEObj2) && !SqlAspectHelper.isInputParameter((EObject)nextEObj2)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public List getEventEObjects(DropTargetEvent event) {
        Transfer[] transfers = ((DropTarget)event.getSource()).getTransfer();
        int i = 0;
        while (i < transfers.length) {
            if (transfers[i] instanceof EObjectTransfer) {
                EObjectTransfer transfer = (EObjectTransfer)transfers[i];
                if (transfer.getObject() != null && transfer.getObject() instanceof List) {
                    return (List)transfer.getObject();
                }
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean sqlIsEmpty() {
        String sqlText = this.sqlPanel.getText();
        return sqlText == null || sqlText.length() == 0 || sqlText.equals("");
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        final DropTargetEvent dtEvent = event;
        if (this.dragSourcesAreTables(event)) {
            if (this.isMouseInFrom(event) || this.sqlIsEmpty()) {
                UiBusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SqlPanelDropTargetListener.this.executeDropInFrom(SqlPanelDropTargetListener.this.getEventEObjects(dtEvent));
                    }
                });
            }
        } else if (this.dragSourcesAreColumns(event) && this.isMouseInSelect(event)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Add To Select", (Object)this.txnSource);
            boolean succeeded = false;
            try {
                succeeded = this.executeDropInSelect(this.getEventEObjects(event), event);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (this.dragSourcesAreTables(event)) {
            if (this.isMouseInFrom(event)) {
                return true;
            }
            return this.sqlIsEmpty();
        }
        return this.dragSourcesAreColumns(event) && this.isMouseInSelect(event);
    }

    public void executeDropInFrom(List dropList) {
        if (dropList.isEmpty()) {
            return;
        }
        boolean canAdd = false;
        if (this.transformation != null) {
            canAdd = TransformationSourceManager.canAdd((EObject)this.transformation, dropList, (Object)this);
        }
        if (canAdd) {
            boolean canUndo = false;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)"Add Sources", null);
            boolean succeeded = false;
            try {
                TransformationSourceManager.addSources(this.transformation, dropList);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        } else {
            TransformationSourceManager.warnUserAboutInvalidSources(dropList);
        }
    }

    public boolean executeDropInSelect(List dropList, DropTargetEvent event) {
        if (dropList.isEmpty()) {
            return false;
        }
        ArrayList<String> elemNames = new ArrayList<String>(dropList.size());
        ArrayList<String> parentNames = new ArrayList<String>(dropList.size());
        for (EObject eObj : dropList) {
            String elemFullName = TransformationHelper.getSqlEObjectFullName((EObject)eObj);
            EObject parentEObj = eObj.eContainer();
            String groupFullName = TransformationHelper.getSqlEObjectFullName((EObject)parentEObj);
            if (elemFullName == null || groupFullName == null) continue;
            elemNames.add(elemFullName);
            parentNames.add(groupFullName);
        }
        try {
            int offset = this.sqlPanel.getCorrectedCaretOffset(this.getDropOffset(event));
            if (this.sqlPanel.isIndexWithin(offset, 6)) {
                this.sqlPanel.insertElements(elemNames, parentNames, offset, null);
            } else {
                this.sqlPanel.insertElementsAtEndOfSelect(elemNames, parentNames, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public void setTransformation(SqlTransformationMappingRoot transformation) {
        this.transformation = transformation;
    }

    public SqlTransformationMappingRoot getTransformation() {
        return this.transformation;
    }
}

