/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.core.query.SetQueryUtil;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramActionService;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.EditTransformationAction;
import org.teiid.designer.transformation.ui.actions.ITransformationDiagramActionConstants;
import org.teiid.designer.transformation.ui.actions.ReconcileTransformationAction;
import org.teiid.designer.transformation.ui.builder.criteria.QueryCriteriaStrategy;
import org.teiid.designer.transformation.ui.editors.QueryEditorStatusEvent;
import org.teiid.designer.transformation.ui.editors.SqlPanelDropTargetListener;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorEvent;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanelWrapper;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ToggleOptimizer;
import org.teiid.designer.transformation.ui.search.OpenTransformationSearchPageAction2;
import org.teiid.designer.transformation.ui.util.BuilderTreeProvider;
import org.teiid.designer.transformation.ui.util.TransformationUiResourceHelper;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.SqlTransformationStatusChangeEvent;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerSpecialActionManager;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.undo.IUndoManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class TransformationObjectEditorPage
implements ModelObjectEditorPage,
UiConstants,
ITransformationDiagramActionConstants,
IAdaptable,
EventObjectListener,
INotifyChangedListener,
SelectionListener,
IUndoManager {
    private static final String SQL_UPDATE_TXN_DESCRIPTION = TransformationObjectEditorPage.getString("sqlUpdateTxnDescription");
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String COMMA_SPACE = ", ";
    private static final String RIGHT_PARENTH = ")";
    private static final String NAME = TransformationObjectEditorPage.getString("name");
    private static final String TITLE_TEXT = "title.text";
    private static final String TITLE_TOOLTIP = "title.toolTip";
    private static final String SELECT_TAB_TEXT = TransformationObjectEditorPage.getString("selectTab.text");
    private static final String SELECT_TAB_TOOLTIP = TransformationObjectEditorPage.getString("selectTab.toolTip");
    private static final String UPDATE_TAB_TEXT = TransformationObjectEditorPage.getString("updateTab.text");
    private static final String UPDATE_TAB_TOOLTIP = TransformationObjectEditorPage.getString("updateTab.toolTip");
    private static final String SELECT_SQL_MSG = TransformationObjectEditorPage.getString("selectSqlMsg.text");
    private static final String INSERT_SQL_MSG = TransformationObjectEditorPage.getString("insertSqlMsg.text");
    private static final String UPDATE_SQL_MSG = TransformationObjectEditorPage.getString("updateSqlMsg.text");
    private static final String DELETE_SQL_MSG = TransformationObjectEditorPage.getString("deleteSqlMsg.text");
    private static final String IS_VALID_MSG = TransformationObjectEditorPage.getString("isValidMsg.text");
    private static final String INSERT_TAB_TEXT = TransformationObjectEditorPage.getString("insertTab.text");
    private static final String INSERT_TAB_TOOLTIP = TransformationObjectEditorPage.getString("insertTab.toolTip");
    private static final String DELETE_TAB_TEXT = TransformationObjectEditorPage.getString("deleteTab.text");
    private static final String DELETE_TAB_TOOLTIP = TransformationObjectEditorPage.getString("deleteTab.toolTip");
    private static final String SAVE_PENDING_TITLE = TransformationObjectEditorPage.getString("savePendingChanges.title");
    private static final String SAVE_PENDING_MSG = TransformationObjectEditorPage.getString("savePendingChanges.msg");
    private static final String SQL_CHANGES_PENDING_MSG = TransformationObjectEditorPage.getString("sqlChangesPending.msg");
    private static final String USE_DEFAULT_CHECKBOX_TEXT = TransformationObjectEditorPage.getString("useDefaultCheckbox.text");
    private static final String USE_DEFAULT_CHECKBOX_TOOLTIP = TransformationObjectEditorPage.getString("useDefaultCheckbox.toolTip");
    private static final String UPDATE_SQL_TYPE = TransformationObjectEditorPage.getString("update.sqlType");
    private static final String INSERT_SQL_TYPE = TransformationObjectEditorPage.getString("insert.sqlType");
    private static final String DELETE_SQL_TYPE = TransformationObjectEditorPage.getString("delete.sqlType");
    private static final String LOST_SQL_TITLE = TransformationObjectEditorPage.getString("lostSql.title");
    private static final String IS_VALID_AND_RECONCILABLE = TransformationObjectEditorPage.getString("isValidAndReconcilableMsg");
    private static final String IS_VALID_NOT_RECONCILABLE = TransformationObjectEditorPage.getString("isValidNotReconcilableMsg");
    private static final String QUERY_SIZE_MISMATCH_MSG = TransformationObjectEditorPage.getString("querySizeMismatchMsg");
    private static final String QUERY_SIZE_MISMATCH_NO_PROJECTED_SYMBOLS_MSG = TransformationObjectEditorPage.getString("querySizeMismatchNoProjectedSymbolsMsg");
    private static final String QUERY_NAME_MISMATCH_MSG = TransformationObjectEditorPage.getString("queryNameMismatchMsg");
    private static final String QUERY_TYPE_MISMATCH_MSG = TransformationObjectEditorPage.getString("queryTypeMismatchMsg");
    private static final String COMMAND_HAS_REFERENCES_MSG = TransformationObjectEditorPage.getString("commandHasReferencesMsg");
    private static final String NUMBER_REFERENCES_MSG = TransformationObjectEditorPage.getString("numberReferencesMsg");
    private static final String TRANSFORMATION_AUTO_ADJUSTED_MSG = TransformationObjectEditorPage.getString("transformationAutoAdjusted");
    static final String SUPPORTS_UPDATE_TEXT = TransformationObjectEditorPage.getString("supportsUpdatesCheckBox.text");
    private static final String CURSOR_AT_TEXT = TransformationObjectEditorPage.getString("cursorAt.text");
    private static final String PREVIEW_DATA_TOOLTIP = TransformationObjectEditorPage.getString("previewDataTooltip");
    public static final String TRANSACTIONS = "modelerTransactions";
    public static final String THIS_CLASS = "TransformationObjectEditorPage";
    private static final Image ERROR_IMAGE = UiPlugin.getDefault().getImage("icons/full/ovr16/error_co.gif");
    private static final Image WARNING_IMAGE = UiPlugin.getDefault().getImage("icons/full/ovr16/warning_co.gif");
    private static final Image NOT_ALLOWED_IMAGE = UiPlugin.getDefault().getImage("icons/full/cview16/not-allowed.png");
    SqlEditorPanelWrapper sqlEditorPanelWrapper;
    private QueryValidator validator;
    private Composite parent;
    private CTabFolder tabFolderWithUpdateTabs;
    Composite objEditorParent;
    private StackLayout objEditorParentLayout;
    private Composite sqlSelectPanelForUpdate;
    private Composite sqlSelectPanelForNoUpdate;
    private Composite sqlOuterUpdatePanel;
    private Composite sqlOuterInsertPanel;
    private Composite sqlOuterDeletePanel;
    private Object currentItem;
    private CTabItem selectTabForUpdate;
    CTabItem insertTab;
    CTabItem updateTab;
    CTabItem deleteTab;
    private SqlEditorPanel currentSqlEditor;
    private SqlEditorPanel sqlSelectEditorForUpdate;
    private SqlEditorPanel sqlSelectEditorForNoUpdate;
    private SqlEditorPanel sqlInsertEditor;
    private SqlEditorPanel sqlUpdateEditor;
    private SqlEditorPanel sqlDeleteEditor;
    private SqlPanelDropTargetListener seSelectUpdateDropListener;
    private SqlPanelDropTargetListener seSelectNoUpdateDropListener;
    Button chkUseDefaultForInsert;
    Label useDefaultForInsertLabel;
    Button chkUseDefaultForUpdate;
    Label useDefaultForUpdateLabel;
    Button chkUseDefaultForDelete;
    Label useDefaultForDeleteLabel;
    private boolean bUseDefaultForInsert;
    private boolean bUseDefaultForUpdate;
    private boolean bUseDefaultForDelete;
    private boolean targetAllowsUpdates = false;
    private SqlTransformationMappingRoot currentMappingRoot;
    private boolean isDirty = false;
    private ModelObjectEditorPage override;
    private ModelEditor parentModelEditor;
    private List eventListeners;
    private EventListenerList propListeners = new EventListenerList();
    CheckBoxContribution chkSupportsUpdatesContribution;
    CLabel cursorPositionLabel;
    private LabelContribution lblCursorPositionContribution;
    private ToggleOptimizer toggleOptimizerAction;
    private SortableSelectionAction previewDataAction;
    private Action searchTransformationsAction;
    private EditTransformationAction editTransformationAction;
    private boolean noUpdatesAllowed = false;
    private boolean currentReadonlyState = false;
    private boolean deactivated = true;
    private SelectionListener checkBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            TransformationObjectEditorPage.this.handleCheckBoxStateChanged(e);
        }

        public void widgetSelected(SelectionEvent e) {
            TransformationObjectEditorPage.this.handleCheckBoxStateChanged(e);
        }
    };

    private static String getString(String key) {
        return UiConstants.Util.getString("TransformationObjectEditorPage." + key, new Object[0]);
    }

    private static String getString(String key, String parameter) {
        return UiConstants.Util.getString("TransformationObjectEditorPage." + key, (Object)parameter);
    }

    public boolean canClose() {
        return true;
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        this.objEditorParent = new Composite(parent, 0);
        this.objEditorParentLayout = new StackLayout();
        this.objEditorParent.setLayout((Layout)this.objEditorParentLayout);
        GridData gridData0 = new GridData(1808);
        this.objEditorParent.setLayoutData((Object)gridData0);
        this.createCTabFolderWithUpdateTabs(this.objEditorParent);
        this.createSqlControl(this.objEditorParent);
        GridData gridData2 = new GridData(1808);
        if (this.tabFolderWithUpdateTabs != null) {
            this.tabFolderWithUpdateTabs.setLayoutData((Object)gridData2);
        }
        this.objEditorParentLayout.topControl = this.sqlSelectPanelForNoUpdate;
        this.registerListeners();
    }

    private Object getTopControl() {
        return this.objEditorParentLayout.topControl;
    }

    public ModelEditor getParentModelEditor() {
        return this.parentModelEditor;
    }

    private void createSqlControl(Composite parent) {
        this.createSelectControlForNoUpdate(parent);
        this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
    }

    private void createCTabFolderWithUpdateTabs(Composite parent) {
        if (!this.allowsMultipleTabs()) {
            return;
        }
        this.tabFolderWithUpdateTabs = new CTabFolder(parent, 1024);
        this.createSelectTabForUpdate(this.tabFolderWithUpdateTabs);
        this.createUpdateTab(this.tabFolderWithUpdateTabs);
        this.createInsertTab(this.tabFolderWithUpdateTabs);
        this.createDeleteTab(this.tabFolderWithUpdateTabs);
        this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
        this.tabFolderWithUpdateTabs.setLayoutData((Object)this.createTextViewGridData());
        this.addCheckBoxListeners(this.selectTabForUpdate);
    }

    private void createSelectTabForUpdate(CTabFolder tabFolder) {
        GridLayout glOuterGridLayout = new GridLayout();
        this.sqlSelectPanelForUpdate = new Composite((Composite)tabFolder, 0);
        this.sqlSelectPanelForUpdate.setLayout((Layout)glOuterGridLayout);
        this.sqlSelectPanelForUpdate.setLayoutData((Object)this.createTextViewGridData());
        this.sqlSelectEditorForUpdate = this.createEditorPanel(this.sqlSelectPanelForUpdate, 0);
        this.sqlSelectEditorForUpdate.setPanelType(1);
        this.sqlSelectEditorForUpdate.setEditable(true);
        this.selectTabForUpdate = new CTabItem(tabFolder, 0);
        this.selectTabForUpdate.setControl((Control)this.sqlSelectPanelForUpdate);
        this.selectTabForUpdate.setText(SELECT_TAB_TEXT);
        this.selectTabForUpdate.setToolTipText(SELECT_TAB_TOOLTIP);
        this.seSelectUpdateDropListener = this.createDropTargetListener(this.sqlSelectEditorForUpdate, this.currentMappingRoot);
        if (this.seSelectUpdateDropListener != null) {
            DropTarget dropTarget = new DropTarget((Control)this.sqlSelectEditorForUpdate.getTextViewer().getTextWidget(), 3);
            dropTarget.setTransfer(this.seSelectUpdateDropListener.getTransfers());
            dropTarget.addDropListener((DropTargetListener)this.seSelectUpdateDropListener);
        }
        this.resetUndoManager(this.sqlSelectEditorForUpdate);
    }

    private void createSelectControlForNoUpdate(Composite parent) {
        GridLayout glOuterGridLayout = new GridLayout();
        this.sqlSelectPanelForNoUpdate = new Composite(parent, 0);
        this.sqlSelectPanelForNoUpdate.setLayout((Layout)glOuterGridLayout);
        this.sqlSelectPanelForNoUpdate.setLayoutData((Object)this.createTextViewGridData());
        this.sqlSelectEditorForNoUpdate = this.createSelectEditorForNoUpdate(this.sqlSelectPanelForNoUpdate);
        this.sqlSelectEditorForNoUpdate.setPanelType(0);
        this.sqlSelectEditorForNoUpdate.setEditable(true);
        this.seSelectNoUpdateDropListener = this.createDropTargetListener(this.sqlSelectEditorForNoUpdate, this.currentMappingRoot);
        if (this.seSelectNoUpdateDropListener != null) {
            DropTarget dropTarget = new DropTarget((Control)this.sqlSelectEditorForNoUpdate.getTextViewer().getTextWidget(), 3);
            dropTarget.setTransfer(this.seSelectNoUpdateDropListener.getTransfers());
            dropTarget.addDropListener((DropTargetListener)this.seSelectNoUpdateDropListener);
        }
        this.resetUndoManager(this.sqlSelectEditorForNoUpdate);
    }

    protected SqlEditorPanel createSelectEditorForNoUpdate(Composite parent) {
        return this.createEditorPanel(parent, 0);
    }

    private void createUpdateTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 2;
        this.sqlOuterUpdatePanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterUpdatePanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterUpdatePanel.setLayoutData((Object)this.createTextViewGridData());
        this.chkUseDefaultForUpdate = WidgetFactory.createCheckBox((Composite)this.sqlOuterUpdatePanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForUpdate.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        this.useDefaultForUpdateLabel = WidgetFactory.createLabel((Composite)this.sqlOuterUpdatePanel);
        this.useDefaultForUpdateLabel.setText(Messages.DefaultUpdateMessageOK);
        this.sqlUpdateEditor = this.createEditorPanel(this.sqlOuterUpdatePanel, 2);
        this.sqlUpdateEditor.setPanelType(3);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sqlUpdateEditor.setLayoutData(gd);
        this.updateTab = new CTabItem(tabFolder, 0);
        this.updateTab.setControl((Control)this.sqlOuterUpdatePanel);
        if (TransformationHelper.isUpdateAllowed((Object)this.currentMappingRoot)) {
            this.updateTab.getControl().setEnabled(true);
            this.sqlUpdateEditor.setEditable(true);
            this.sqlUpdateEditor.getTextViewer().getTextWidget().setEnabled(true);
            new DropTarget((Control)this.sqlUpdateEditor.getTextViewer().getTextWidget(), 0);
        }
        this.updateTab.setText(UPDATE_TAB_TEXT);
        this.updateTab.setToolTipText(UPDATE_TAB_TOOLTIP);
        this.resetUndoManager(this.sqlUpdateEditor);
    }

    private void createInsertTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 2;
        this.sqlOuterInsertPanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterInsertPanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterInsertPanel.setLayoutData((Object)this.createTextViewGridData());
        this.chkUseDefaultForInsert = WidgetFactory.createCheckBox((Composite)this.sqlOuterInsertPanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForInsert.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        this.useDefaultForInsertLabel = WidgetFactory.createLabel((Composite)this.sqlOuterInsertPanel);
        this.useDefaultForInsertLabel.setText(Messages.DefaultUpdateMessageOK);
        this.sqlInsertEditor = this.createEditorPanel(this.sqlOuterInsertPanel, 1);
        this.sqlInsertEditor.setPanelType(2);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sqlInsertEditor.setLayoutData(gd);
        this.insertTab = new CTabItem(tabFolder, 0);
        this.insertTab.setControl((Control)this.sqlOuterInsertPanel);
        if (TransformationHelper.isInsertAllowed((Object)this.currentMappingRoot)) {
            this.insertTab.getControl().setEnabled(true);
            this.sqlInsertEditor.setEditable(true);
            this.sqlInsertEditor.getTextViewer().getTextWidget().setEnabled(true);
            new DropTarget((Control)this.sqlInsertEditor.getTextViewer().getTextWidget(), 0);
        }
        this.insertTab.setText(INSERT_TAB_TEXT);
        this.insertTab.setToolTipText(INSERT_TAB_TOOLTIP);
        this.resetUndoManager(this.sqlInsertEditor);
    }

    private void createDeleteTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 2;
        this.sqlOuterDeletePanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterDeletePanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterDeletePanel.setLayoutData((Object)this.createTextViewGridData());
        this.chkUseDefaultForDelete = WidgetFactory.createCheckBox((Composite)this.sqlOuterDeletePanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForDelete.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        this.useDefaultForDeleteLabel = WidgetFactory.createLabel((Composite)this.sqlOuterDeletePanel);
        this.useDefaultForDeleteLabel.setText(Messages.DefaultUpdateMessageOK);
        this.sqlDeleteEditor = this.createEditorPanel(this.sqlOuterDeletePanel, 3);
        this.sqlDeleteEditor.setPanelType(4);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sqlDeleteEditor.setLayoutData(gd);
        this.deleteTab = new CTabItem(tabFolder, 0);
        this.deleteTab.setControl((Control)this.sqlOuterDeletePanel);
        if (TransformationHelper.isDeleteAllowed((Object)this.currentMappingRoot)) {
            this.deleteTab.getControl().setEnabled(true);
            this.sqlDeleteEditor.getTextViewer().setEditable(false);
            this.sqlDeleteEditor.setEditable(false);
            this.sqlDeleteEditor.getTextViewer().getTextWidget().setEnabled(false);
            new DropTarget((Control)this.sqlDeleteEditor.getTextViewer().getTextWidget(), 0);
        }
        this.getSqlEditorForItem(this.deleteTab).setEditable(false);
        this.deleteTab.setText(DELETE_TAB_TEXT);
        this.deleteTab.setToolTipText(DELETE_TAB_TOOLTIP);
        this.resetUndoManager(this.sqlDeleteEditor);
    }

    protected SqlEditorPanel createEditorPanel(Composite cmpSqlPanel, int queryType) {
        List aList = SqlEditorPanel.getDefaultActionList();
        this.customizeActionList(aList);
        SqlEditorPanel sepNewSqlEditor = new SqlEditorPanel(cmpSqlPanel, this.validator, queryType, aList);
        sepNewSqlEditor.setLayoutData(this.createTextViewGridData());
        sepNewSqlEditor.addEventListener(this);
        return sepNewSqlEditor;
    }

    private GridData createTextViewGridData() {
        GridData gridData = new GridData(1808);
        return gridData;
    }

    private void registerListeners() {
        this.deactivated = false;
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
        SqlMappingRootCache.addEventListener((EventObjectListener)this);
        if (this.tabFolderWithUpdateTabs != null) {
            this.tabFolderWithUpdateTabs.addSelectionListener((SelectionListener)this);
        }
    }

    private void removeCheckBoxListeners(Object item) {
        if (item == this.insertTab) {
            if (!this.chkUseDefaultForInsert.isDisposed()) {
                this.chkUseDefaultForInsert.removeSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.updateTab) {
            if (!this.chkUseDefaultForUpdate.isDisposed()) {
                this.chkUseDefaultForUpdate.removeSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.deleteTab && !this.chkUseDefaultForDelete.isDisposed()) {
            this.chkUseDefaultForDelete.removeSelectionListener(this.checkBoxListener);
        }
    }

    private void addCheckBoxListeners(Object item) {
        if (item == this.insertTab) {
            if (!this.chkUseDefaultForInsert.isDisposed()) {
                this.chkUseDefaultForInsert.addSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.updateTab) {
            if (!this.chkUseDefaultForUpdate.isDisposed()) {
                this.chkUseDefaultForUpdate.addSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.deleteTab && !this.chkUseDefaultForDelete.isDisposed()) {
            this.chkUseDefaultForDelete.addSelectionListener(this.checkBoxListener);
        }
    }

    protected void showMessageArea(boolean doShow) {
        this.getSqlEditorPanelWrapper().showMessageArea(doShow);
    }

    private SqlEditorPanelWrapper getSqlEditorPanelWrapper() {
        Display display;
        if (this.sqlEditorPanelWrapper == null) {
            List aList = SqlEditorPanel.getDefaultActionList();
            this.customizeActionList(aList);
            this.sqlEditorPanelWrapper = new SqlEditorPanelWrapper(this.parent, null, aList);
            this.sqlEditorPanelWrapper.setCurrentSqlEditorPanel(this.getCurrentSqlEditor());
        }
        if ((display = this.getControl().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransformationObjectEditorPage.this.sqlEditorPanelWrapper.refreshFontManager();
                }
            });
        }
        return this.sqlEditorPanelWrapper;
    }

    private void setCurrentSqlEditor(SqlEditorPanel sep) {
        if (this.currentSqlEditor != sep) {
            this.currentSqlEditor = sep;
            this.getSqlEditorPanelWrapper().setCurrentSqlEditorPanel(this.currentSqlEditor);
        }
    }

    public SqlEditorPanel getCurrentSqlEditor() {
        return this.currentSqlEditor;
    }

    public boolean isCurrentTabSelect() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem == this.sqlSelectPanelForNoUpdate || selectedItem == this.selectTabForUpdate;
    }

    public boolean hasPendingChanges() {
        boolean result = false;
        SqlEditorPanel currentEditor = this.getCurrentSqlEditor();
        if (currentEditor != null && currentEditor.hasPendingChanges()) {
            result = true;
        }
        return result;
    }

    public StyledText getTextWidget() {
        return this.currentSqlEditor.getTextViewer().getTextWidget();
    }

    public Control getControl() {
        return this.objEditorParent;
    }

    public String getTitle() {
        return TransformationObjectEditorPage.getString(TITLE_TEXT, this.getTransformationName());
    }

    public String getTitleToolTip() {
        return TransformationObjectEditorPage.getString(TITLE_TOOLTIP, this.getTransformationName());
    }

    protected String getTransformationName() {
        return NAME;
    }

    public Image getTitleImage() {
        return null;
    }

    public boolean canEdit(Object modelObject, IEditorPart editor) {
        if (this.override != null && this.override.canEdit(modelObject, editor)) {
            return false;
        }
        if (modelObject != null) {
            if (modelObject instanceof InputSet || !(editor instanceof DiagramEditor)) {
                return false;
            }
            if (TransformationHelper.isOperation((Object)modelObject)) {
                return false;
            }
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)modelObject)) {
                EObject target = ((SqlTransformationMappingRoot)modelObject).getTarget();
                return !TransformationHelper.isOperation((Object)target);
            }
            if ((TransformationHelper.isVirtualSqlTable((Object)modelObject) || TransformationHelper.isSqlVirtualProcedure((Object)modelObject)) && TransformationHelper.isValidSqlTransformationTarget((Object)modelObject) && TransformationHelper.getMappingRoot((EObject)((EObject)modelObject), (boolean)false, (boolean)true) != null) {
                return true;
            }
        }
        return false;
    }

    public void edit(Object rootOrVirtualSqlTable) {
        Object obj = this.getEditableObject(rootOrVirtualSqlTable);
        if (obj instanceof SqlTransformationMappingRoot) {
            SqlTransformationMappingRoot workingMappingRoot = (SqlTransformationMappingRoot)obj;
            if (this.deactivated) {
                this.registerListeners();
            }
            this.currentMappingRoot = workingMappingRoot;
            this.validator = new TransformationValidator(this.currentMappingRoot, false);
            new BuilderTreeProvider();
            ElementViewerFactory.setCriteriaStrategy((ICriteriaStrategy)new QueryCriteriaStrategy());
            this.setUseDefaultStates(this.currentMappingRoot);
            this.refreshTabs();
            this.setEditorContent(this.currentItem, true, this, true, false);
            this.objEditorParent.layout();
            this.setEditorFocus(this.currentSqlEditor);
        } else if (obj == null) {
            this.currentMappingRoot = null;
            this.validator = null;
            this.clearSqlEditors();
        }
        this.resetUndoManager(this.getCurrentSqlEditor());
        this.updateActions();
    }

    void refreshTabs() {
        if (!this.isEditorValid()) {
            return;
        }
        this.targetAllowsUpdates = this.getTargetAllowsUpdates();
        if (!this.noUpdatesAllowed && this.targetAllowsUpdates) {
            Object selectedItem = this.getSelectedItem();
            this.objEditorParentLayout.topControl = this.tabFolderWithUpdateTabs;
            if (this.selectTabForUpdate != null && selectedItem == this.selectTabForUpdate && this.sqlSelectEditorForUpdate != null) {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
                this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
            } else if (this.insertTab != null && selectedItem == this.insertTab && this.sqlInsertEditor != null) {
                this.setCurrentSqlEditor(this.sqlInsertEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.insertTab);
            } else if (this.updateTab != null && selectedItem == this.updateTab && this.sqlUpdateEditor != null) {
                this.setCurrentSqlEditor(this.sqlUpdateEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.updateTab);
            } else if (this.deleteTab != null && selectedItem == this.deleteTab && this.sqlDeleteEditor != null) {
                this.setCurrentSqlEditor(this.sqlDeleteEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.deleteTab);
            } else {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
                this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
            }
            if (this.seSelectUpdateDropListener != null && this.sqlSelectEditorForUpdate != null) {
                this.seSelectUpdateDropListener.setTransformation(this.currentMappingRoot);
            }
        } else {
            this.objEditorParentLayout.topControl = this.sqlSelectPanelForNoUpdate;
            this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
            if (this.seSelectNoUpdateDropListener != null) {
                this.seSelectNoUpdateDropListener.setTransformation(this.currentMappingRoot);
            }
        }
        this.currentItem = this.getSelectedItem();
    }

    private void setEditorFocus(final SqlEditorPanel editor) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean gotFocus;
                StyledText st;
                TextViewer tv;
                if (editor != null && (tv = editor.getTextViewer()) != null && (st = tv.getTextWidget()) != null && !st.isDisposed() && (gotFocus = st.setFocus())) {
                    editor.setCaretOffset(0);
                    TransformationObjectEditorPage.this.handleCursorPositionChanged();
                }
            }
        });
    }

    public void refreshEditorContent() {
        this.setEditorContent(this.getSelectedItem(), false, this, true, false);
    }

    private void resetUndoManager(SqlEditorPanel editor) {
        editor.resetUndoRedoHistory();
    }

    private void resetAllUndoManagers() {
        if (this.sqlSelectEditorForUpdate != null) {
            this.resetUndoManager(this.sqlSelectEditorForUpdate);
        }
        if (this.sqlSelectEditorForNoUpdate != null) {
            this.resetUndoManager(this.sqlSelectEditorForNoUpdate);
        }
        if (this.sqlInsertEditor != null) {
            this.resetUndoManager(this.sqlInsertEditor);
        }
        if (this.sqlUpdateEditor != null) {
            this.resetUndoManager(this.sqlUpdateEditor);
        }
        if (this.sqlDeleteEditor != null) {
            this.resetUndoManager(this.sqlDeleteEditor);
        }
    }

    public void setEditorContent(Object item, boolean reconcileTarget, Object txnSource, boolean overwriteDirty, boolean sourceIsEvent) {
        int cmdType = this.getCommandTypeForItem(item);
        boolean showMessage = false;
        if (this.isResourceValid() && this.getControl() != null && !this.getControl().isDisposed()) {
            boolean statusExists;
            SqlTransformationResult selectStatus;
            ICommand newCommand;
            String sqlString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)cmdType);
            boolean isValid = TransformationHelper.isValid((Object)this.currentMappingRoot, (int)cmdType);
            if (sourceIsEvent) {
                showMessage = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sqlString, (int)cmdType, (boolean)false, (Object)txnSource);
            }
            if (!showMessage && !isValid) {
                showMessage = true;
            }
            if ((newCommand = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType)) instanceof ISetQuery) {
                this.updateEditorSetQueryStates((ISetQuery)newCommand);
            }
            Collection externalGroups = this.getExternalBuilderGroups(this.currentMappingRoot);
            this.currentSqlEditor.setExternalBuilderGroups(externalGroups);
            SqlEditorPanel editor = this.getSqlEditorForItem(item);
            this.resetValidators();
            boolean isSelectCached = SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)0);
            SqlTransformationResult existingStatus = selectStatus = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
            if (cmdType != 0) {
                existingStatus = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)cmdType, (boolean)true, null);
            }
            boolean bl = statusExists = selectStatus != null;
            if (overwriteDirty || !editor.hasPendingChanges()) {
                editor.setText(sqlString, this, !statusExists, (QueryValidationResult)existingStatus);
                this.setEditorMessage(item);
            }
            this.setCheckBoxStates(this.currentMappingRoot, item);
            this.setEditableStatus(item);
            EObject targetGroup = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
            boolean allowsUpdates = TransformationHelper.tableSupportsUpdate((EObject)targetGroup);
            if (!ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot) && !(txnSource instanceof ReconcileTransformationAction)) {
                SqlEditorPanelWrapper sepw;
                int changeCode;
                if (reconcileTarget && (changeCode = TransformationMappingHelper.reconcileTargetAttributes((EObject)this.currentMappingRoot, (Object)this).getCode()) == 10 && !(sepw = this.getSqlEditorPanelWrapper()).isMessageAreaVisible()) {
                    sepw.setMessage(TRANSFORMATION_AUTO_ADJUSTED_MSG);
                    sepw.showMessageArea(true);
                }
                if (allowsUpdates) {
                    SqlEditorPanelWrapper sepw2;
                    if (!sourceIsEvent || !isSelectCached) {
                        String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)1);
                        boolean change_1 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)1, (boolean)false, (Object)txnSource);
                        sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)2);
                        boolean change_2 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)2, (boolean)false, (Object)txnSource);
                        sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)3);
                        boolean change_3 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)3, (boolean)false, (Object)txnSource);
                        if (change_1 || change_2 || change_3) {
                            showMessage = true;
                        }
                    } else {
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)1)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)1);
                            showMessage = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)1, (boolean)false, (Object)txnSource);
                        }
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)2)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)2);
                            boolean show = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)2, (boolean)false, (Object)txnSource);
                            if (!showMessage && show) {
                                showMessage = true;
                            }
                        }
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)3)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)3);
                            boolean show = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)3, (boolean)false, (Object)txnSource);
                            if (!showMessage && show) {
                                showMessage = true;
                            }
                        }
                    }
                    if (showMessage && !(sepw2 = this.getSqlEditorPanelWrapper()).isMessageAreaVisible()) {
                        sepw2.setMessage(TRANSFORMATION_AUTO_ADJUSTED_MSG);
                        sepw2.showMessageArea(true);
                    }
                }
            }
            if (isValid) {
                this.notifyEventListeners(new QueryEditorStatusEvent(this, 2));
            } else if (TransformationHelper.isResolvable((Object)this.currentMappingRoot, (int)cmdType)) {
                this.notifyEventListeners(new QueryEditorStatusEvent(this, 1));
            } else if (TransformationHelper.isParsable((Object)this.currentMappingRoot, (int)cmdType)) {
                this.notifyEventListeners(new QueryEditorStatusEvent(this, 0));
            } else {
                this.notifyEventListeners(new QueryEditorStatusEvent(this, 3));
            }
            this.setDirty(editor.hasPendingChanges());
            if (allowsUpdates) {
                final SqlTransformationResult currentSelectStatus = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
                if (selectStatus != null) {
                    UiUtil.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TransformationObjectEditorPage.this.updateUpdateTabs(currentSelectStatus);
                        }
                    }, (boolean)true);
                }
            }
            this.updateReadOnlyState();
        }
    }

    private void updateUpdateTabs(SqlTransformationResult validationResult) {
        IStatus displayStatus;
        IStatus displayStatus2;
        if (validationResult == null) {
            return;
        }
        boolean selectSqlOk = validationResult.isOkToUpdate(0);
        if (selectSqlOk) {
            this.selectTabForUpdate.setImage(null);
            this.selectTabForUpdate.setToolTipText(null);
        } else {
            this.selectTabForUpdate.setImage(UiPlugin.getDefault().getImage("icons/full/ovr16/warning_co.gif"));
            IStatus firstStatus = (IStatus)validationResult.getUpdateStatusList(0).iterator().next();
            this.selectTabForUpdate.setToolTipText(firstStatus.getMessage());
        }
        this.insertTab.setImage(null);
        this.updateTab.setImage(null);
        this.deleteTab.setImage(null);
        String toolTipText = null;
        Image displayImage = null;
        String tabText = INSERT_TAB_TEXT;
        if (this.isUseDefault(1)) {
            tabText = String.valueOf(INSERT_TAB_TEXT) + " (default)";
            displayStatus2 = null;
            if (!validationResult.isOkToUpdate(1)) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(1).iterator().next();
            } else if (!selectSqlOk) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(0).iterator().next();
            }
            if (displayStatus2 != null) {
                toolTipText = displayStatus2.getMessage();
                displayImage = NOT_ALLOWED_IMAGE;
                this.useDefaultForInsertLabel.setText(Messages.DefaultUpdateMessageAmbigious);
            } else {
                this.useDefaultForInsertLabel.setText(Messages.DefaultUpdateMessageOK);
            }
        } else {
            SqlTransformationResult insertResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)1, (boolean)true, null);
            displayStatus = null;
            if (insertResult != null && !insertResult.getStatusList().isEmpty()) {
                displayStatus = (IStatus)insertResult.getStatusList().iterator().next();
            }
            if (displayStatus != null) {
                displayImage = this.getSeverityImage(insertResult.getMaxSeverity());
                toolTipText = displayStatus.getMessage();
            }
        }
        this.insertTab.setImage(displayImage);
        this.insertTab.setToolTipText(toolTipText);
        this.insertTab.setText(tabText);
        displayImage = null;
        toolTipText = null;
        tabText = UPDATE_TAB_TEXT;
        if (this.isUseDefault(2)) {
            tabText = String.valueOf(UPDATE_TAB_TEXT) + " (default)";
            displayStatus2 = null;
            if (!validationResult.isOkToUpdate(2)) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(2).iterator().next();
            } else if (!selectSqlOk) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(0).iterator().next();
            }
            if (displayStatus2 != null) {
                toolTipText = displayStatus2.getMessage();
                displayImage = NOT_ALLOWED_IMAGE;
                this.useDefaultForUpdateLabel.setText(Messages.DefaultUpdateMessageAmbigious);
            } else {
                this.useDefaultForUpdateLabel.setText(Messages.DefaultUpdateMessageOK);
            }
        } else {
            SqlTransformationResult updateResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)2, (boolean)true, null);
            displayStatus = null;
            if (updateResult != null && !updateResult.getStatusList().isEmpty()) {
                displayStatus = (IStatus)updateResult.getStatusList().iterator().next();
            }
            if (displayStatus != null) {
                displayImage = this.getSeverityImage(updateResult.getMaxSeverity());
                toolTipText = displayStatus.getMessage();
            }
        }
        this.updateTab.setImage(displayImage);
        this.updateTab.setToolTipText(toolTipText);
        this.updateTab.setText(tabText);
        displayImage = null;
        toolTipText = null;
        tabText = DELETE_TAB_TEXT;
        if (this.isUseDefault(3)) {
            tabText = String.valueOf(DELETE_TAB_TEXT) + " (default)";
            displayStatus2 = null;
            if (!validationResult.isOkToUpdate(3)) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(3).iterator().next();
            } else if (!selectSqlOk) {
                displayStatus2 = (IStatus)validationResult.getUpdateStatusList(0).iterator().next();
            }
            if (displayStatus2 != null) {
                toolTipText = displayStatus2.getMessage();
                displayImage = NOT_ALLOWED_IMAGE;
                this.useDefaultForDeleteLabel.setText(Messages.DefaultUpdateMessageAmbigious);
            } else {
                this.useDefaultForDeleteLabel.setText(Messages.DefaultUpdateMessageOK);
            }
        } else {
            SqlTransformationResult deleteResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)3, (boolean)true, null);
            displayStatus = null;
            if (deleteResult != null && !deleteResult.getStatusList().isEmpty()) {
                displayStatus = (IStatus)deleteResult.getStatusList().iterator().next();
            }
            if (displayStatus != null) {
                displayImage = this.getSeverityImage(deleteResult.getMaxSeverity());
                toolTipText = displayStatus.getMessage();
            }
        }
        this.deleteTab.setImage(displayImage);
        this.deleteTab.setToolTipText(toolTipText);
        this.deleteTab.setText(tabText);
    }

    private boolean isUseDefault(int updateType) {
        SqlTransformation helper = (SqlTransformation)this.currentMappingRoot.getHelper();
        if (helper == null) {
            return false;
        }
        switch (updateType) {
            case 1: {
                return helper.isInsertSqlDefault();
            }
            case 2: {
                return helper.isUpdateSqlDefault();
            }
            case 3: {
                return helper.isDeleteSqlDefault();
            }
        }
        return false;
    }

    private Image getSeverityImage(int severity) {
        if (severity == 4) {
            return ERROR_IMAGE;
        }
        if (severity == 2) {
            return WARNING_IMAGE;
        }
        return null;
    }

    private void setEditableStatus(Object item) {
        boolean isReadOnly = false;
        if (this.currentMappingRoot != null && ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot)) {
            isReadOnly = true;
        }
        if (isReadOnly) {
            this.getSqlEditorForItem(item).setEditable(false);
        } else if (item == this.selectTabForUpdate || item == this.sqlSelectPanelForNoUpdate) {
            this.getSqlEditorForItem(item).setEditable(true);
        } else if (item == this.insertTab || item == this.updateTab || item == this.deleteTab) {
            boolean allowed = this.isEnableSelected(item);
            boolean useDefault = this.isUseDefaultSelected(item);
            if (allowed && !useDefault) {
                this.getSqlEditorForItem(item).setEditable(true);
            } else {
                this.getSqlEditorForItem(item).setEditable(false);
            }
        }
    }

    private void setEditorMessage(Object item) {
        int cmdType = this.getCommandTypeForItem(item);
        String message = null;
        boolean showMessage = false;
        boolean isTargetValid = TransformationHelper.isTargetValid((Object)this.currentMappingRoot, (int)cmdType);
        switch (cmdType) {
            case 0: {
                SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
                if (!isTargetValid) {
                    IStatus status = TransformationHelper.getTargetValidStatus((Object)this.currentMappingRoot, (int)cmdType);
                    if (status == null) break;
                    message = status.getMessage();
                    showMessage = true;
                    break;
                }
                if (statusResult == null || statusResult.getMaxSeverity() <= 0) break;
                message = statusResult.getFullMessage();
                showMessage = true;
                break;
            }
            case 1: {
                if (!this.isUseDefault(1)) {
                    SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)1, (boolean)true, null);
                    if (statusResult == null || statusResult.getMaxSeverity() <= 0) break;
                    message = statusResult.getFullMessage();
                    showMessage = true;
                    break;
                }
                SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
                if (statusResult == null || statusResult.getUpdateMaxSeverity(1) <= 0) break;
                message = statusResult.getUpdateFullMessage(1);
                showMessage = true;
                break;
            }
            case 2: {
                if (!this.isUseDefault(2)) {
                    SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)2, (boolean)true, null);
                    if (statusResult == null || statusResult.getMaxSeverity() <= 0) break;
                    message = statusResult.getFullMessage();
                    showMessage = true;
                    break;
                }
                SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
                if (statusResult == null || statusResult.getUpdateMaxSeverity(2) <= 0) break;
                message = statusResult.getUpdateFullMessage(2);
                showMessage = true;
                break;
            }
            case 3: {
                if (!this.isUseDefault(3)) {
                    SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)3, (boolean)true, null);
                    if (statusResult == null || statusResult.getMaxSeverity() <= 0) break;
                    message = statusResult.getFullMessage();
                    showMessage = true;
                    break;
                }
                SqlTransformationResult statusResult = SqlMappingRootCache.getSqlTransformationStatus((SqlTransformationMappingRoot)this.currentMappingRoot, (int)0, (boolean)true, null);
                if (statusResult == null || statusResult.getUpdateMaxSeverity(3) <= 0) break;
                message = statusResult.getUpdateFullMessage(3);
                showMessage = true;
            }
        }
        if (message != null) {
            this.currentSqlEditor.setMessage(message);
            this.currentSqlEditor.showMessageArea(showMessage);
        } else if (isTargetValid) {
            this.setMessageDisplayForValidSQL();
        }
    }

    private Collection getExternalBuilderGroups(Object transMappingRoot) {
        ArrayList<Object> externalGroups = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot)) {
            List inParams;
            EObject targetGroup = TransformationHelper.getTransformationLinkTarget((EObject)((EObject)transMappingRoot));
            if (targetGroup instanceof MappingClass) {
                externalGroups = new ArrayList<Object>(1);
                InputSet inputSet = ((MappingClass)targetGroup).getInputSet();
                externalGroups.add(inputSet);
            } else if (TransformationHelper.isSqlProcedure((Object)targetGroup) && !(inParams = TransformationHelper.getInAndInoutParameters((EObject)targetGroup)).isEmpty()) {
                externalGroups = new ArrayList(1);
                externalGroups.add(targetGroup);
            }
        }
        if (externalGroups == null) {
            externalGroups = Collections.EMPTY_LIST;
        }
        return externalGroups;
    }

    private int getCommandTypeForItem(Object item) {
        int type = 0;
        if (item == this.insertTab) {
            type = 1;
        } else if (item == this.updateTab) {
            type = 2;
        } else if (item == this.deleteTab) {
            type = 3;
        }
        return type;
    }

    private SqlEditorPanel getSqlEditorForItem(Object item) {
        if (this.noUpdatesAllowed) {
            return this.sqlSelectEditorForNoUpdate;
        }
        SqlEditorPanel editor = null;
        if (item == this.sqlSelectPanelForNoUpdate) {
            editor = this.sqlSelectEditorForNoUpdate;
        } else if (item == this.selectTabForUpdate) {
            editor = this.sqlSelectEditorForUpdate;
        } else if (item == this.insertTab) {
            editor = this.sqlInsertEditor;
        } else if (item == this.updateTab) {
            editor = this.sqlUpdateEditor;
        } else if (item == this.deleteTab) {
            editor = this.sqlDeleteEditor;
        }
        return editor;
    }

    public String getObjectText() {
        String result = null;
        if (this.currentMappingRoot != null) {
            result = StatusBarUpdater.formatEObjectMessage((EObject)this.currentMappingRoot);
        }
        return result;
    }

    private boolean isEditorValid() {
        return this.getControl() != null && !this.getControl().isDisposed();
    }

    public boolean deactivate() {
        try {
            this.doSave(true);
        }
        catch (Exception err) {
            Util.log((Throwable)err);
        }
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this);
        SqlMappingRootCache.removeEventListener((EventObjectListener)this);
        this.resetAllUndoManagers();
        this.deactivated = true;
        this.edit(null);
        return true;
    }

    private void clearSqlEditors() {
        if (!this.parent.isDisposed()) {
            if (this.sqlSelectEditorForNoUpdate != null) {
                this.sqlSelectEditorForNoUpdate.clear();
            }
            if (this.sqlSelectEditorForUpdate != null) {
                this.sqlSelectEditorForUpdate.clear();
            }
            if (this.sqlInsertEditor != null) {
                this.sqlInsertEditor.clear();
            }
            if (this.sqlUpdateEditor != null) {
                this.sqlUpdateEditor.clear();
            }
            if (this.sqlDeleteEditor != null) {
                this.sqlDeleteEditor.clear();
            }
            if (this.sqlEditorPanelWrapper != null) {
                this.sqlEditorPanelWrapper.clear();
            }
        }
        if (this.sqlSelectEditorForNoUpdate != null) {
            this.sqlSelectEditorForNoUpdate.setQueryValidator(null);
        }
        if (this.sqlSelectEditorForUpdate != null) {
            this.sqlSelectEditorForUpdate.setQueryValidator(null);
        }
        if (this.sqlInsertEditor != null) {
            this.sqlInsertEditor.setQueryValidator(null);
        }
        if (this.sqlUpdateEditor != null) {
            this.sqlUpdateEditor.setQueryValidator(null);
        }
        if (this.sqlDeleteEditor != null) {
            this.sqlDeleteEditor.setQueryValidator(null);
        }
        if (this.sqlEditorPanelWrapper != null) {
            this.sqlEditorPanelWrapper.setQueryValidator(null);
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propListeners.addListener(IPropertyListener.class, (Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propListeners.removeListener(IPropertyListener.class, (Object)listener);
    }

    void handleTransformationStatusChangeEvent(final boolean reconcileTarget, final Object txnSource, final boolean overwriteDirty) {
        if (txnSource != this && !(txnSource instanceof SqlEditorPanel)) {
            if (this.validator != null) {
                boolean didSetText = false;
                if (this.isCurrentTabSelect()) {
                    if (this.objEditorParentLayout.topControl == this.tabFolderWithUpdateTabs && this.sqlSelectEditorForNoUpdate != null) {
                        this.sqlSelectEditorForNoUpdate.setQueryValidator(this.validator);
                        this.setEditorContent(this.getSelectedItem(), reconcileTarget, txnSource, overwriteDirty, true);
                        didSetText = true;
                    } else if (this.sqlSelectEditorForUpdate != null) {
                        this.sqlSelectEditorForUpdate.setQueryValidator(this.validator);
                        UiUtil.runInSwtThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TransformationObjectEditorPage.this.setEditorContent(TransformationObjectEditorPage.this.getSelectedItem(), reconcileTarget, txnSource, overwriteDirty, true);
                            }
                        }, (boolean)true);
                        didSetText = true;
                    }
                }
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TransformationObjectEditorPage.this.refreshTabs();
                    }
                }, (boolean)true);
                if (!didSetText) {
                    this.setEditorContent(this.getSelectedItem(), reconcileTarget, txnSource, overwriteDirty, true);
                }
                UiUtil.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TransformationObjectEditorPage.this.objEditorParent.layout();
                    }
                }, (boolean)true);
            }
        } else {
            this.setEditorMessage(this.getSelectedItem());
        }
        this.updateActions();
    }

    private void resetValidators() {
        this.validator = new TransformationValidator(this.currentMappingRoot, false);
        if (this.sqlSelectEditorForUpdate != null) {
            this.sqlSelectEditorForUpdate.setQueryValidator(this.validator);
        }
        if (this.sqlSelectEditorForNoUpdate != null) {
            this.sqlSelectEditorForNoUpdate.setQueryValidator(this.validator);
        }
        if (this.sqlSelectEditorForUpdate != null) {
            this.sqlSelectEditorForUpdate.setQueryValidator(this.validator);
        }
        if (this.sqlInsertEditor != null) {
            this.sqlInsertEditor.setQueryValidator(this.validator);
        }
        if (this.sqlUpdateEditor != null) {
            this.sqlUpdateEditor.setQueryValidator(this.validator);
        }
        if (this.sqlDeleteEditor != null) {
            this.sqlDeleteEditor.setQueryValidator(this.validator);
        }
    }

    public void notifyChanged(Notification notification) {
        if (!this.isEditorValid()) {
            return;
        }
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            this.handleNotifications(notifications, source);
        } else {
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, null);
        }
    }

    public void handleNotifications(Collection notifications, Object txnSource) {
        Collection validNotifications = this.getValidNotifications(notifications);
        if (!validNotifications.isEmpty()) {
            boolean cfr_ignored_0 = txnSource instanceof TransformationObjectEditorPage;
        }
    }

    private Collection getValidNotifications(Collection notifications) {
        ArrayList<Notification> validNotifications = new ArrayList<Notification>(notifications.size());
        for (Notification notification : notifications) {
            boolean targetSupportsUpdateState;
            Object changedObject;
            if (!NotificationUtilities.isChanged((Notification)notification) || (changedObject = ModelerCore.getModelEditor().getChangedObject(notification)) == null || !(changedObject instanceof EObject)) continue;
            if (changedObject instanceof SqlTransformation) {
                validNotifications.add(notification);
                continue;
            }
            if (!this.isCurrentTransformationLinkTarget((EObject)changedObject) || (targetSupportsUpdateState = TransformationHelper.tableSupportsUpdate((EObject)((EObject)changedObject))) == this.targetAllowsUpdates) continue;
            validNotifications.add(notification);
        }
        return validNotifications;
    }

    private boolean isCurrentTransformationLinkTarget(EObject eObj) {
        EObject linkTarget;
        boolean result = false;
        if (this.currentMappingRoot != null && (linkTarget = TransformationHelper.getTransformationLinkTarget((EObject)this.currentMappingRoot)) != null && linkTarget.equals(eObj)) {
            result = true;
        }
        return result;
    }

    private Object getSelectedItem() {
        Object item = this.getTopControl();
        if (item instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)item;
            CTabItem ti = folder.getSelection();
            if (ti != null) {
                return ti;
            }
            return folder.getItem(0);
        }
        return item;
    }

    boolean getTargetAllowsUpdates() {
        boolean allowsUpdates = false;
        EObject targetEObj = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
        if (targetEObj != null) {
            allowsUpdates = TransformationHelper.tableSupportsUpdate((EObject)targetEObj);
        }
        return allowsUpdates;
    }

    private void setTargetAllowsUpdates(boolean allowsUpdates) {
        EObject targetEObj = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
        if (targetEObj != null) {
            TransformationHelper.setTableSupportsUpdate((EObject)targetEObj, (boolean)allowsUpdates);
            this.resetAllUndoManagers();
        }
    }

    public void contributeExportedActions(IMenuManager theMenuMgr) {
        ModelEditorPage editorPage;
        String actionKey;
        IEditorPart editorPart;
        IAction action = null;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DiagramActionService service = (DiagramActionService)DiagramUiPlugin.getDefault().getActionService(window.getActivePage());
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_TO_SQL_SELECT, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        if (action != null) {
            if (theMenuMgr.find(ModelerActionBarIdManager.getMenuAdditionsMarkerId()) == null) {
                theMenuMgr.add(action);
            } else {
                theMenuMgr.insertBefore(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), action);
            }
        }
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_JOIN_EXPRESSION, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        if (action != null) {
            if (theMenuMgr.find(ModelerActionBarIdManager.getMenuAdditionsMarkerId()) == null) {
                theMenuMgr.add(action);
            } else {
                theMenuMgr.insertBefore(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), action);
            }
        }
    }

    public List<IAction> getAdditionalModelingActions(ISelection selection) {
        ModelEditorPage editorPage;
        String actionKey;
        IEditorPart editorPart;
        ArrayList<IAction> addedActions = new ArrayList<IAction>();
        IAction action = null;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DiagramActionService service = (DiagramActionService)DiagramUiPlugin.getDefault().getActionService(window.getActivePage());
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_TO_SQL_SELECT, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        if (action != null && action.isEnabled()) {
            addedActions.add(action);
        }
        action = null;
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_JOIN_EXPRESSION, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        if (action != null && action.isEnabled()) {
            addedActions.add(action);
        }
        return addedActions;
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        if (toolBarMgr == null) {
            return;
        }
        int iAction = 0;
        if (this.currentMappingRoot != null) {
            SortableSelectionAction actualPreviewDataAction;
            boolean addedButton = false;
            if (this.currentMappingRoot != null && (actualPreviewDataAction = ModelerSpecialActionManager.getAction((String)"org.teiid.designer.runtime.ui.preview.PreviewTableDataContextAction")) != null) {
                this.previewDataAction = actualPreviewDataAction.getClone();
                this.previewDataAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/previewVirtualData.png"));
                this.previewDataAction.setToolTipText(PREVIEW_DATA_TOOLTIP);
                this.previewDataAction.setSelection((ISelection)new StructuredSelection((Object)this.currentMappingRoot.getTarget()));
                toolBarMgr.add((IAction)this.previewDataAction);
                toolBarMgr.add((IContributionItem)new Separator());
                ++iAction;
                addedButton = true;
                this.updateActions();
            }
            this.searchTransformationsAction = new OpenTransformationSearchPageAction2();
            toolBarMgr.add((IAction)this.searchTransformationsAction);
            ++iAction;
            addedButton = true;
            if (!TransformationHelper.isOperation((Object)this.currentMappingRoot.getTarget())) {
                this.editTransformationAction = new EditTransformationAction();
                if (this.isResourceValid()) {
                    this.editTransformationAction.setSelection((ISelection)new StructuredSelection((Object)this.getTargetResource()));
                }
                toolBarMgr.add((IAction)this.editTransformationAction);
                ++iAction;
                addedButton = true;
            }
            if (addedButton) {
                toolBarMgr.add((IContributionItem)new Separator());
            }
        }
        toolBarMgr.add((IContributionItem)this.getLabelContributionForCursorPosition());
        toolBarMgr.add((IContributionItem)new Separator());
        if (!(this.currentMappingRoot == null || TransformationHelper.isMappingClass((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isStagingTable((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isOperation((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isSqlProcedure((Object)this.currentMappingRoot.getTarget()))) {
            toolBarMgr.add((IContributionItem)this.getCheckBoxContributionForSupportsUpdates());
            toolBarMgr.add((IContributionItem)new Separator());
        }
        List separatorLocs = this.getSeparatorLocations();
        IAction reconcileAction = this.contributeReconcileAction();
        if (reconcileAction != null) {
            toolBarMgr.add(reconcileAction);
            ++iAction;
        }
        List<IAction> sqlActions = this.getSqlEditorPanelWrapper().getActions();
        for (IAction obj : sqlActions) {
            if (obj instanceof ToggleOptimizer) {
                this.toggleOptimizerAction = (ToggleOptimizer)obj;
            }
            toolBarMgr.add((IAction)((Action)obj));
            if (!separatorLocs.contains(new Integer(++iAction))) continue;
            toolBarMgr.add((IContributionItem)new Separator());
        }
    }

    private void updateActions() {
        if (this.previewDataAction != null && this.currentMappingRoot != null) {
            StructuredSelection newSelection = new StructuredSelection((Object)this.currentMappingRoot.getTarget());
            this.previewDataAction.setSelection((ISelection)newSelection);
            if (this.isDirty() && this.previewDataAction.isEnabled()) {
                this.previewDataAction.setEnabled(false);
            } else {
                this.previewDataAction.setEnabled(this.previewDataAction.isApplicable((ISelection)newSelection));
            }
        }
        if (this.editTransformationAction != null && this.isResourceValid()) {
            this.editTransformationAction.setSelection((ISelection)new StructuredSelection((Object)this.getTargetResource()));
        }
    }

    protected IAction contributeReconcileAction() {
        IAction reconcileAction = null;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DiagramActionService service = (DiagramActionService)DiagramUiPlugin.getDefault().getActionService(window.getActivePage());
        try {
            ModelEditorPage editorPage;
            String actionKey;
            IEditorPart editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && (reconcileAction = service.getAction(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.RECONCILE_TRANSFORMATION, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) instanceof ReconcileTransformationAction) {
                ((ReconcileTransformationAction)reconcileAction).setTransObjectEditorPage(this);
            }
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        return reconcileAction;
    }

    CheckBoxContribution getCheckBoxContributionForSupportsUpdates() {
        if (this.chkSupportsUpdatesContribution == null) {
            this.chkSupportsUpdatesContribution = new CheckBoxContribution(SUPPORTS_UPDATE_TEXT);
            this.chkSupportsUpdatesContribution.setToolTipText(TransformationObjectEditorPage.getString("supportsUpdatesCheckBox.toolTip"));
        }
        return this.chkSupportsUpdatesContribution;
    }

    void handleSupportsUpdatesCheckBoxChanged() {
        this.doSave(false);
        this.setTargetAllowsUpdates(this.getCheckBoxContributionForSupportsUpdates().getSelection());
        this.getCheckBoxContributionForSupportsUpdates().getControl().update();
        this.refreshEditorContent();
    }

    private LabelContribution getLabelContributionForCursorPosition() {
        if (this.lblCursorPositionContribution == null) {
            this.lblCursorPositionContribution = new LabelContribution("Cursor at (0, 0)         ");
        }
        return this.lblCursorPositionContribution;
    }

    private String getCurrentCursorPosition() {
        String sPosition = CURSOR_AT_TEXT;
        int column = 0;
        int row = 0;
        if (this.currentSqlEditor != null) {
            column = 1 + this.currentSqlEditor.getCaretXPosition();
            row = 1 + this.currentSqlEditor.getCaretYPosition();
        }
        sPosition = String.valueOf(sPosition) + row + COMMA_SPACE + column + RIGHT_PARENTH;
        return sPosition;
    }

    void handleCursorPositionChanged() {
        this.getLabelContributionForCursorPosition().setText(this.getCurrentCursorPosition());
    }

    protected List getSeparatorLocations() {
        ArrayList<Integer> separatorLocs = new ArrayList<Integer>(6);
        separatorLocs.add(new Integer(3));
        separatorLocs.add(new Integer(5));
        separatorLocs.add(new Integer(6));
        separatorLocs.add(new Integer(8));
        separatorLocs.add(new Integer(10));
        return separatorLocs;
    }

    public void doSave(boolean isClosing) {
        if (this.parent.isDisposed()) {
            return;
        }
        boolean saveChanges = true;
        SqlEditorPanel theEditor = this.getCurrentSqlEditor();
        if (theEditor.hasPendingChanges()) {
            if (isClosing) {
                saveChanges = MessageDialog.openQuestion((Shell)this.parent.getShell(), (String)SAVE_PENDING_TITLE, (String)SAVE_PENDING_MSG);
            }
            if (saveChanges) {
                theEditor.setQueryValidator(this.validator);
                theEditor.setText(theEditor.getText());
            } else {
                this.setDirty(false);
            }
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IFindReplaceTarget.class) && this.currentSqlEditor != null) {
            return this.currentSqlEditor.getTextViewer().getFindReplaceTarget();
        }
        if (key.equals(IUndoManager.class)) {
            return this;
        }
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        Object eventSource = e.getSource();
        if (eventSource == this.getTopControl()) {
            this.handleTabSelectionChanged();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void handleTabSelectionChanged() {
        Object previousItem = this.currentItem;
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != previousItem) {
            int cmdType;
            String previousSql;
            if (this.currentSqlEditor.hasPendingChanges() && TransformationHelper.isUserSqlDifferent((String)(previousSql = this.currentSqlEditor.getText()), (Object)this.currentMappingRoot, (int)(cmdType = this.getCommandTypeForItem(previousItem)))) {
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)previousSql, (int)cmdType, (boolean)true, (Object)this);
            }
            if (!this.targetAllowsUpdates) {
                selectedItem = this.sqlSelectPanelForNoUpdate;
                this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
            } else if (selectedItem == this.selectTabForUpdate) {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
            } else if (selectedItem == this.insertTab) {
                this.setCurrentSqlEditor(this.sqlInsertEditor);
            } else if (selectedItem == this.updateTab) {
                this.setCurrentSqlEditor(this.sqlUpdateEditor);
            } else if (selectedItem == this.deleteTab) {
                this.setCurrentSqlEditor(this.sqlDeleteEditor);
            }
            this.currentItem = selectedItem;
            this.setEditorContent(this.currentItem, true, this, true, false);
            this.currentSqlEditor.getTextViewer().getTextWidget().setSelection(0);
            this.currentSqlEditor.getTextViewer().getTextWidget().setFocus();
            this.handleCursorPositionChanged();
        }
    }

    void handleCheckBoxStateChanged(SelectionEvent e) {
        Object eventSource = e.getSource();
        Object selectedItem = this.getSelectedItem();
        boolean allowed = this.isEnableSelected(selectedItem);
        boolean useDefault = this.isUseDefaultSelected(selectedItem);
        if (selectedItem == this.insertTab) {
            this.bUseDefaultForInsert = useDefault;
        } else if (selectedItem == this.updateTab) {
            this.bUseDefaultForUpdate = useDefault;
        } else if (selectedItem == this.deleteTab) {
            this.bUseDefaultForDelete = useDefault;
        }
        this.setCheckBoxEnabledStates(selectedItem);
        if (eventSource == this.chkUseDefaultForInsert || eventSource == this.chkUseDefaultForUpdate || eventSource == this.chkUseDefaultForDelete) {
            this.handleUseDefaultCheckBoxChanged(eventSource, useDefault, allowed);
        }
        this.setEditableStatus(selectedItem);
    }

    private boolean handleUseDefaultCheckBoxChanged(Object eventSource, boolean useDefault, boolean isAllowed) {
        Object selectedItem = this.getSelectedItem();
        boolean abortUseDefault = false;
        if (selectedItem == this.insertTab && eventSource == this.chkUseDefaultForInsert || selectedItem == this.updateTab && eventSource == this.chkUseDefaultForUpdate || selectedItem == this.deleteTab && eventSource == this.chkUseDefaultForDelete) {
            String typeStr = BLANK;
            int cmdType = 0;
            if (selectedItem == this.insertTab) {
                typeStr = INSERT_SQL_TYPE;
                cmdType = 1;
            } else if (selectedItem == this.updateTab) {
                typeStr = UPDATE_SQL_TYPE;
                cmdType = 2;
            } else if (selectedItem == this.deleteTab) {
                typeStr = DELETE_SQL_TYPE;
                cmdType = 3;
            }
            if (useDefault) {
                boolean shouldReplace = this.shouldReplaceSqlText(typeStr);
                if (shouldReplace) {
                    if (cmdType == 1) {
                        TransformationHelper.setInsertSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                        if (this.chkUseDefaultForInsert.getSelection()) {
                            this.useDefaultForInsertLabel.setText(Messages.DefaultUpdateMessageOK);
                        }
                    } else if (cmdType == 2) {
                        TransformationHelper.setUpdateSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                        if (this.chkUseDefaultForInsert.getSelection()) {
                            this.useDefaultForUpdateLabel.setText(Messages.DefaultUpdateMessageOK);
                        }
                    } else if (cmdType == 3) {
                        TransformationHelper.setDeleteSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                        if (this.chkUseDefaultForInsert.getSelection()) {
                            this.useDefaultForDeleteLabel.setText(Messages.DefaultUpdateMessageOK);
                        }
                    }
                    SqlMappingRootCache.invalidateStatus((Object)this.currentMappingRoot, (boolean)true, (Object)this);
                    this.setEditorContent(selectedItem, true, this, true, false);
                } else {
                    abortUseDefault = true;
                    this.removeCheckBoxListeners(selectedItem);
                    if (selectedItem == this.insertTab) {
                        this.chkUseDefaultForInsert.setSelection(false);
                    } else if (selectedItem == this.updateTab) {
                        this.chkUseDefaultForUpdate.setSelection(false);
                    } else if (selectedItem == this.deleteTab) {
                        this.chkUseDefaultForDelete.setSelection(false);
                    }
                    this.addCheckBoxListeners(selectedItem);
                }
            } else if (!useDefault) {
                if (cmdType == 1) {
                    TransformationHelper.setInsertSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                    this.useDefaultForInsertLabel.setText(Messages.DefaultUpdateMessageOverride);
                } else if (cmdType == 2) {
                    TransformationHelper.setUpdateSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                    this.useDefaultForUpdateLabel.setText(Messages.DefaultUpdateMessageOverride);
                } else if (cmdType == 3) {
                    TransformationHelper.setDeleteSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                    this.useDefaultForDeleteLabel.setText(Messages.DefaultUpdateMessageOverride);
                }
                SqlMappingRootCache.invalidateStatus((Object)this.currentMappingRoot, (boolean)true, (Object)this);
                String sql = this.currentSqlEditor.getText();
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sql, (int)cmdType, (boolean)false, (Object)this);
                this.setEditorContent(selectedItem, true, this, true, false);
            }
        }
        return abortUseDefault;
    }

    private void updateEditorSetQueryStates(ISetQuery unionQuery) {
        List queries = SetQueryUtil.getQueryList((ISetQuery)unionQuery);
        int nQueries = queries.size();
        ArrayList<Boolean> reconciledList = new ArrayList<Boolean>(nQueries);
        int i = 0;
        while (i < nQueries) {
            IQueryCommand qCommand = (IQueryCommand)queries.get(i);
            boolean nameMatchReqd = false;
            if (i == 0) {
                nameMatchReqd = true;
            }
            boolean isReconciled = TransformationMappingHelper.targetAndCommandReconcile((EObject)this.currentMappingRoot, (ICommand)qCommand, (boolean)nameMatchReqd);
            reconciledList.add(new Boolean(isReconciled));
            ++i;
        }
        this.getCurrentSqlEditor().setSetQueryReconciledStates(reconciledList);
    }

    private void setUseDefaultStates(SqlTransformationMappingRoot transMappingRoot) {
        if (transMappingRoot != null) {
            this.bUseDefaultForInsert = TransformationHelper.isInsertSqlDefault((EObject)transMappingRoot);
            this.bUseDefaultForUpdate = TransformationHelper.isUpdateSqlDefault((EObject)transMappingRoot);
            this.bUseDefaultForDelete = TransformationHelper.isDeleteSqlDefault((EObject)transMappingRoot);
        }
    }

    private void setCheckBoxStates(Object transMappingRoot, Object item) {
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot)) {
            this.removeCheckBoxListeners(item);
            int cmdType = this.getCommandTypeForItem(item);
            if (cmdType == 1) {
                this.bUseDefaultForInsert = TransformationHelper.isInsertSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForInsert.isDisposed()) {
                    this.chkUseDefaultForInsert.setSelection(this.bUseDefaultForInsert);
                }
            } else if (cmdType == 2) {
                this.bUseDefaultForUpdate = TransformationHelper.isUpdateSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForUpdate.isDisposed()) {
                    this.chkUseDefaultForUpdate.setSelection(this.bUseDefaultForUpdate);
                }
            } else if (cmdType == 3) {
                this.bUseDefaultForDelete = TransformationHelper.isDeleteSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForDelete.isDisposed()) {
                    this.chkUseDefaultForDelete.setSelection(this.bUseDefaultForDelete);
                }
            }
            this.setCheckBoxEnabledStates(item);
            this.addCheckBoxListeners(item);
            this.setSupportsUpdatesCheckBoxState();
        }
    }

    private void setSupportsUpdatesCheckBoxState() {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TransformationObjectEditorPage.this.getCheckBoxContributionForSupportsUpdates().setEnabled(true);
                TransformationObjectEditorPage.this.getCheckBoxContributionForSupportsUpdates().setSelection(TransformationObjectEditorPage.this.getTargetAllowsUpdates());
            }
        }, (boolean)true);
    }

    private void setCheckBoxEnabledStates(final Object item) {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean enableState = TransformationObjectEditorPage.this.isEnableSelected(item);
                if (item == TransformationObjectEditorPage.this.insertTab && !TransformationObjectEditorPage.this.chkUseDefaultForInsert.isDisposed()) {
                    TransformationObjectEditorPage.this.chkUseDefaultForInsert.setEnabled(enableState);
                } else if (item == TransformationObjectEditorPage.this.updateTab && !TransformationObjectEditorPage.this.chkUseDefaultForUpdate.isDisposed()) {
                    TransformationObjectEditorPage.this.chkUseDefaultForUpdate.setEnabled(enableState);
                } else if (item == TransformationObjectEditorPage.this.deleteTab && !TransformationObjectEditorPage.this.chkUseDefaultForDelete.isDisposed()) {
                    TransformationObjectEditorPage.this.chkUseDefaultForDelete.setEnabled(enableState);
                }
            }
        }, (boolean)true);
    }

    boolean isEnableSelected(Object item) {
        boolean result = false;
        if (item == this.insertTab) {
            result = true;
        } else if (item == this.updateTab) {
            result = true;
        } else if (item == this.deleteTab) {
            result = true;
        }
        return result;
    }

    private boolean isUseDefaultSelected(Object item) {
        boolean result = false;
        if (item == this.insertTab) {
            result = this.chkUseDefaultForInsert.getSelection();
        } else if (item == this.updateTab) {
            result = this.chkUseDefaultForUpdate.getSelection();
        } else if (item == this.deleteTab) {
            result = this.chkUseDefaultForDelete.getSelection();
        }
        return result;
    }

    private boolean shouldReplaceSqlText(String typeStr) {
        MessageBox box = new MessageBox(this.parent.getShell(), 65728);
        box.setMessage(TransformationObjectEditorPage.getString("lostSqlText.text", typeStr));
        box.setText(LOST_SQL_TITLE);
        Boolean bShouldDropSqlText = new Boolean(box.open() == 64);
        return bShouldDropSqlText;
    }

    public void processEvent(EventObject e) {
        if (!this.isEditorValid()) {
            return;
        }
        if (this.isEditorValid()) {
            SqlTransformationStatusChangeEvent stsce;
            EObject eventMappingRoot;
            if (e instanceof SqlEditorEvent && this.currentMappingRoot != null) {
                this.handleSqlEditorEvent((SqlEditorEvent)e);
            } else if (e instanceof SqlTransformationStatusChangeEvent && (eventMappingRoot = (stsce = (SqlTransformationStatusChangeEvent)e).getMappingRoot()) != null && eventMappingRoot.eResource() != null && ModelerCore.getModelEditor().equals(eventMappingRoot, (EObject)this.currentMappingRoot)) {
                this.handleTransformationStatusChangeEvent(false, e.getSource(), stsce.isOverwriteDirty());
            }
        }
    }

    private void handleSqlEditorEvent(SqlEditorEvent sqlEvent) {
        Object eventSource = sqlEvent.getSource();
        int eventType = sqlEvent.getType();
        if (eventSource instanceof SqlEditorPanel) {
            if (eventType == 5) {
                this.handleCursorPositionChanged();
            } else if (eventType == 0) {
                this.handleSqlEditorChangesPending();
            } else if (eventType == 4 || eventType == 3 || eventType == 2) {
                this.handleSqlEditorCommandEvent(sqlEvent.getCommand(), sqlEvent.getSQLString(), eventType, eventSource);
            } else if (eventType == 1) {
                this.handleSqlEditorChanged(sqlEvent.getSQLString(), eventSource);
            }
        } else if (eventType == 0) {
            this.handleSqlEditorChangesPending();
        }
    }

    private void handleSqlEditorCommandEvent(ICommand command, String sqlString, int eventType, Object eventSource) {
        Object selectedItem = this.getSelectedItem();
        int cmdType = this.getCommandTypeForItem(selectedItem);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)SQL_UPDATE_TXN_DESCRIPTION, (Object)this);
        boolean succeeded = false;
        try {
            TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sqlString, (int)cmdType, (boolean)false, (Object)this);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)this.currentMappingRoot, (Object)this);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        ICommand newCommand = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType);
        if (newCommand instanceof ISetQuery) {
            this.updateEditorSetQueryStates((ISetQuery)newCommand);
        }
        this.updateMessagePanel();
        this.setDirty(false);
        if (eventType == 4) {
            this.notifyEventListeners(new QueryEditorStatusEvent(this, 2));
        } else if (eventType == 3) {
            this.notifyEventListeners(new QueryEditorStatusEvent(this, 1));
        } else if (eventType == 2) {
            this.notifyEventListeners(new QueryEditorStatusEvent(this, 0));
        }
    }

    private void handleSqlEditorChanged(String sqlString, Object eventSource) {
        int cmdType = this.getCommandTypeForItem(this.getSelectedItem());
        if (TransformationHelper.isUserSqlDifferent((String)sqlString, (Object)this.currentMappingRoot, (int)cmdType)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (String)SQL_UPDATE_TXN_DESCRIPTION, (Object)this);
            boolean succeeded = false;
            try {
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sqlString, (int)cmdType, (boolean)false, (Object)this);
                TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)this.currentMappingRoot, (Object)this);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.getSqlEditorPanelWrapper().showMessageArea(true);
        this.setDirty(false);
        this.notifyEventListeners(new QueryEditorStatusEvent(this, 3));
    }

    private void handleSqlEditorChangesPending() {
        this.getSqlEditorPanelWrapper().setMessage(SQL_CHANGES_PENDING_MSG);
        this.getSqlEditorPanelWrapper().showMessageArea(true);
        this.setDirty(true);
        this.notifyEventListeners(new QueryEditorStatusEvent(this, 4));
    }

    public boolean canRedo() {
        return this.getCurrentSqlEditor().getUndoManager().redoable();
    }

    public boolean canUndo() {
        return this.getCurrentSqlEditor().getUndoManager().undoable();
    }

    public String getRedoLabel() {
        return TransformationObjectEditorPage.getString("redoMenuLabel");
    }

    public String getUndoLabel() {
        return TransformationObjectEditorPage.getString("undoMenuLabel");
    }

    public void redo(IProgressMonitor monitor) {
        this.getCurrentSqlEditor().getUndoManager().redo();
        monitor.done();
    }

    public void undo(IProgressMonitor monitor) {
        this.getCurrentSqlEditor().getUndoManager().undo();
        monitor.done();
    }

    public void addEventListener(EventObjectListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
        }
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public void removeEventListener(EventObjectListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    private void notifyEventListeners(EventObject event) {
        if (this.toggleOptimizerAction != null) {
            this.toggleOptimizerAction.setAllowOptimization(true);
        }
        if (this.eventListeners != null) {
            for (EventObjectListener listener : this.eventListeners) {
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    private void setMessageDisplayForValidSQL() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == this.insertTab) {
            this.getSqlEditorPanelWrapper().setMessage(String.valueOf(INSERT_SQL_MSG) + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else if (selectedItem == this.updateTab) {
            this.getSqlEditorPanelWrapper().setMessage(String.valueOf(UPDATE_SQL_MSG) + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else if (selectedItem == this.deleteTab) {
            this.getSqlEditorPanelWrapper().setMessage(String.valueOf(DELETE_SQL_MSG) + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else {
            String sqlTypeMsg = SELECT_SQL_MSG;
            int cmdType = this.getCommandTypeForItem(selectedItem);
            boolean[] statusArray = TransformationMappingHelper.compareQueryTargetAndSQLOutput((EObject)this.currentMappingRoot, (int)cmdType);
            boolean targetAndSQLOutSizesOK = statusArray[0];
            boolean targetAndSQLOutNamesOK = statusArray[1];
            boolean targetAndSQLOutTypesOK = statusArray[2];
            int refCount = TransformationSqlHelper.getReferenceCount((Object)this.currentMappingRoot, (int)cmdType);
            if (targetAndSQLOutSizesOK && targetAndSQLOutNamesOK && targetAndSQLOutTypesOK && refCount == 0) {
                this.getSqlEditorPanelWrapper().setMessage(String.valueOf(sqlTypeMsg) + SPACE + IS_VALID_AND_RECONCILABLE);
                this.getSqlEditorPanelWrapper().showMessageArea(false);
            } else {
                StringBuffer buff = new StringBuffer(String.valueOf(sqlTypeMsg) + SPACE + IS_VALID_NOT_RECONCILABLE);
                if (!targetAndSQLOutSizesOK) {
                    if (cmdType == 0) {
                        ICommand cmd = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType);
                        List symbols = CommandHelper.getProjectedSymbols((ICommand)cmd);
                        if (symbols.isEmpty()) {
                            buff.append("\n" + QUERY_SIZE_MISMATCH_NO_PROJECTED_SYMBOLS_MSG);
                        } else {
                            buff.append("\n" + QUERY_SIZE_MISMATCH_MSG);
                        }
                    } else {
                        buff.append("\n" + QUERY_SIZE_MISMATCH_MSG);
                    }
                } else if (!targetAndSQLOutNamesOK) {
                    buff.append("\n" + QUERY_NAME_MISMATCH_MSG);
                } else if (!targetAndSQLOutTypesOK) {
                    buff.append("\n" + QUERY_TYPE_MISMATCH_MSG);
                }
                if (refCount > 0) {
                    buff.append("\n" + COMMAND_HAS_REFERENCES_MSG);
                    buff.append("\n" + NUMBER_REFERENCES_MSG + refCount);
                }
                this.getSqlEditorPanelWrapper().setMessage(buff.toString());
                this.getSqlEditorPanelWrapper().showMessageArea(true);
            }
        }
    }

    public void updateReadOnlyState() {
        if (this.currentMappingRoot != null) {
            boolean isReadOnly = ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot);
            if (isReadOnly != this.currentReadonlyState) {
                this.currentReadonlyState = isReadOnly;
                if (this.getCurrentSqlEditor() != null) {
                    this.getSqlEditorPanelWrapper().updateReadOnlyState(isReadOnly);
                    this.setEditableStatus(this.currentItem);
                }
                this.notifyEventListeners((EventObject)new SqlTransformationStatusChangeEvent((EObject)this.currentMappingRoot, (Object)this));
            }
            this.getCheckBoxContributionForSupportsUpdates().setEnabled(!isReadOnly);
            this.updateReadOnlyStateOfCheckBoxes(isReadOnly);
        }
    }

    private void updateReadOnlyStateOfCheckBoxes(final boolean isReadOnly) {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TransformationObjectEditorPage.this.chkUseDefaultForInsert != null) {
                    TransformationObjectEditorPage.this.chkUseDefaultForInsert.setEnabled(!isReadOnly);
                }
                if (TransformationObjectEditorPage.this.chkUseDefaultForUpdate != null) {
                    TransformationObjectEditorPage.this.chkUseDefaultForUpdate.setEnabled(!isReadOnly);
                }
                if (TransformationObjectEditorPage.this.chkUseDefaultForDelete != null) {
                    TransformationObjectEditorPage.this.chkUseDefaultForDelete.setEnabled(!isReadOnly);
                }
            }
        }, (boolean)true);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        Iterator listeners = this.propListeners.getListeners(IPropertyListener.class);
        while (listeners.hasNext()) {
            ((IPropertyListener)listeners.next()).propertyChanged((Object)this, 257);
        }
        this.updateActions();
    }

    public boolean isEditingObject(Object modelObject) {
        if (this.currentMappingRoot != null && modelObject != null) {
            SqlTransformationMappingRoot workingMappingRoot;
            if (modelObject instanceof InputSet) {
                return false;
            }
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)modelObject) ? modelObject.equals(this.currentMappingRoot) : (TransformationHelper.isVirtualSqlTable((Object)modelObject) || TransformationHelper.isSqlVirtualProcedure((Object)modelObject)) && !TransformationHelper.isXmlDocument((Object)modelObject) && (workingMappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)((EObject)modelObject))) != null && workingMappingRoot.equals(this.currentMappingRoot)) {
                return true;
            }
        }
        return false;
    }

    public Object getEditableObject(Object modelObject) {
        SqlTransformationMappingRoot workingMappingRoot = null;
        EObject targetObject = null;
        targetObject = modelObject instanceof Diagram ? ((Diagram)modelObject).getTarget() : (EObject)modelObject;
        if (targetObject != null && targetObject.eResource() != null && TransformationUiResourceHelper.isSqlTransformationResource(targetObject)) {
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)targetObject)) {
                workingMappingRoot = (SqlTransformationMappingRoot)targetObject;
            } else if ((TransformationHelper.isVirtualSqlTable((Object)targetObject) || TransformationHelper.isSqlVirtualProcedure((Object)targetObject)) && TransformationHelper.isValidSqlTransformationTarget((Object)targetObject)) {
                workingMappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)targetObject);
            }
            if (workingMappingRoot != null) {
                return workingMappingRoot;
            }
        }
        return null;
    }

    public boolean isResourceValid() {
        ModelResource mr;
        return this.currentMappingRoot != null && this.currentMappingRoot.eResource() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)this.currentMappingRoot)) != null;
    }

    private IResource getTargetResource() {
        if (this.currentMappingRoot != null && this.currentMappingRoot.eResource() != null) {
            ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)this.currentMappingRoot);
            return mr.getResource();
        }
        return null;
    }

    public SqlTransformationMappingRoot getCurrentMappingRoot() {
        return this.currentMappingRoot;
    }

    public void initialize(MultiPageModelEditor editor) {
        if (editor instanceof ModelEditor) {
            this.parentModelEditor = (ModelEditor)editor;
        }
    }

    public void updateMessagePanel() {
        this.setEditorMessage(this.getSelectedItem());
    }

    public void setOverride(ModelObjectEditorPage editor) {
        this.override = editor;
    }

    public boolean isNoUpdatesAllowed() {
        return this.noUpdatesAllowed;
    }

    public void setNoUpdatesAllowed(boolean theNoUpdatesAllowed) {
        this.noUpdatesAllowed = theNoUpdatesAllowed;
    }

    protected List customizeActionList(List initialActionList) {
        return initialActionList;
    }

    protected boolean allowsMultipleTabs() {
        return true;
    }

    protected SqlPanelDropTargetListener createDropTargetListener(SqlEditorPanel sqlPanel, SqlTransformationMappingRoot transformation) {
        return new SqlPanelDropTargetListener(sqlPanel, transformation, this);
    }

    class CheckBoxContribution
    extends ControlContribution {
        private Button chkSupportsUpdates;
        private String toolTip;
        private static final int BUTTON_GRID_STYLE = 320;
        Combo cbx;

        public CheckBoxContribution(String id) {
            super(id);
            this.cbx = null;
        }

        protected Control createControl(Composite parent) {
            this.chkSupportsUpdates = WidgetFactory.createCheckBox((Composite)parent, (String)SUPPORTS_UPDATE_TEXT, (int)320);
            if (this.toolTip != null) {
                this.chkSupportsUpdates.setToolTipText(this.toolTip);
            }
            this.chkSupportsUpdates.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TransformationObjectEditorPage.this.handleSupportsUpdatesCheckBoxChanged();
                }
            });
            this.chkSupportsUpdates.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((CheckBoxContribution)CheckBoxContribution.this).TransformationObjectEditorPage.this.chkSupportsUpdatesContribution = null;
                }
            });
            this.chkSupportsUpdates.setEnabled(!TransformationObjectEditorPage.this.currentReadonlyState);
            this.chkSupportsUpdates.setSelection(TransformationObjectEditorPage.this.getTargetAllowsUpdates());
            return this.chkSupportsUpdates;
        }

        public Control getControl() {
            return this.chkSupportsUpdates;
        }

        public void setSelection(boolean b) {
            if (this.chkSupportsUpdates != null) {
                this.chkSupportsUpdates.setSelection(b);
            }
        }

        public boolean getSelection() {
            if (this.chkSupportsUpdates != null) {
                return this.chkSupportsUpdates.getSelection();
            }
            return true;
        }

        public void setEnabled(boolean enabled) {
            if (this.chkSupportsUpdates != null) {
                this.chkSupportsUpdates.setEnabled(enabled);
            }
        }

        public void setToolTipText(String text) {
            this.toolTip = text;
        }
    }

    class LabelContribution
    extends ControlContribution {
        private static final int LABEL_GRID_STYLE = 32;
        Combo cbx;
        String sText;

        public LabelContribution(String sText) {
            super("myId");
            this.cbx = null;
            this.sText = sText;
        }

        protected Control createControl(Composite parent) {
            TransformationObjectEditorPage.this.cursorPositionLabel = WidgetFactory.createLabel((Composite)parent, (int)32, (String)this.sText);
            return TransformationObjectEditorPage.this.cursorPositionLabel;
        }

        public void setText(String text) {
            TransformationObjectEditorPage.this.cursorPositionLabel.setText(text);
        }
    }
}

