/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors.sqleditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.query.ui.sqleditor.component.QueryDisplayComponent;

public class SqlDisplayPanel
extends Composite
implements UiConstants {
    private ColorManager colorManager;
    private IVerticalRuler verticalRuler;
    private SqlTextViewer sqlTextViewer;
    private Document sqlDocument;
    private QueryDisplayComponent queryDisplayComponent;
    protected static final int VERTICAL_RULER_WIDTH = 0;

    public SqlDisplayPanel(Composite parent) {
        super(parent, 8);
        this.init();
    }

    private void init() {
        QueryValidatorImpl validator = new QueryValidatorImpl();
        this.queryDisplayComponent = new QueryDisplayComponent((QueryValidator)validator, -1);
        this.colorManager = new ColorManager();
        this.verticalRuler = new VerticalRuler(0);
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer(this, this.verticalRuler, styles, this.colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setDocument((IDocument)this.sqlDocument);
        this.sqlTextViewer.setEditable(false);
        this.sqlTextViewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        Control control = this.sqlTextViewer.getControl();
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData);
    }

    public void setText(String sql) {
        if (sql != null) {
            this.queryDisplayComponent.setText(sql, true, null);
            this.refreshWithDisplayComponent();
        }
    }

    public void setQueryValidator(QueryValidator validator) {
        this.queryDisplayComponent.setQueryValidator(validator);
    }

    public String getText() {
        return this.sqlDocument.get();
    }

    private void refreshWithDisplayComponent() {
        String sql = this.queryDisplayComponent.toString();
        this.sqlDocument.set(sql);
    }

    public ICommand getCommand() {
        return this.queryDisplayComponent.getCommand();
    }

    public void dispose() {
        super.dispose();
    }

    public TextViewer getTextViewer() {
        return this.sqlTextViewer;
    }

    public class QueryValidationResultImpl
    implements QueryValidationResult {
        private boolean isParsable = false;
        private boolean isResolvable = false;
        private boolean isValidatable = false;
        private ICommand command = null;
        private Collection<IStatus> statuses = null;

        public QueryValidationResultImpl(ICommand command, IStatus status) {
            if (status != null) {
                this.statuses = new ArrayList<IStatus>(1);
                this.statuses.add(status);
            } else {
                this.statuses = Collections.emptyList();
            }
            this.command = command;
            this.isParsable = command != null;
        }

        public boolean isParsable() {
            return this.isParsable;
        }

        public boolean isResolvable() {
            return this.isResolvable;
        }

        public boolean isValidatable() {
            return this.isValidatable;
        }

        public ICommand getCommand() {
            return this.command;
        }

        public Collection<IStatus> getStatusList() {
            return this.statuses;
        }

        public Collection<IStatus> getUpdateStatusList() {
            return Collections.EMPTY_LIST;
        }

        public Collection<IStatus> getUpdateStatusList(int cmdType) {
            return Collections.EMPTY_LIST;
        }
    }

    class QueryValidatorImpl
    implements QueryValidator {
        QueryValidatorImpl() {
        }

        public QueryValidationResult validateSql(String sqlString, int type, boolean cacheResult) {
            ICommand command = null;
            Status status = null;
            try {
                IQueryParser parser = ModelerCore.getTeiidQueryService().getQueryParser();
                command = parser.parseDesignerCommand(sqlString);
            }
            catch (Exception e) {
                status = new Status(4, "org.teiid.designer.query.ui", 0, e.getMessage(), (Throwable)e);
            }
            return new QueryValidationResultImpl(command, (IStatus)status);
        }

        public IQueryMetadataInterface getQueryMetadata() {
            return null;
        }

        public boolean isValidRoot() {
            return true;
        }

        public EObject getTransformationRoot() {
            return null;
        }

        public void setElementSymbolOptimization(QueryValidator.ElementSymbolOptimization status) {
        }

        public boolean shouldValidate() {
            return true;
        }
    }
}

