/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors.sqleditor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.ISubqueryContainer;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.CreateFunctionAction;
import org.teiid.designer.transformation.ui.builder.CriteriaBuilder;
import org.teiid.designer.transformation.ui.builder.ExpressionBuilder;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorEvent;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorInternalEvent;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.DownFont;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ExpandSelect;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ExportToFile;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ImportFromFile;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.LaunchCreateFunction;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.LaunchCriteriaBuilder;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.LaunchExpressionBuilder;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ToggleMessage;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ToggleOptimizer;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.UpFont;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.Validate;
import org.teiid.designer.transformation.ui.wizards.sqlbuilder.SQLTemplateDialog;
import org.teiid.designer.transformation.util.SqlStringUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.text.ScaledFontManager;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.text.TextFontManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.sqleditor.component.AliasSymbolDisplayNode;
import org.teiid.query.ui.sqleditor.component.DeleteDisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeConstants;
import org.teiid.query.ui.sqleditor.component.DisplayNodeUtils;
import org.teiid.query.ui.sqleditor.component.FunctionDisplayNode;
import org.teiid.query.ui.sqleditor.component.GroupSymbolFinder;
import org.teiid.query.ui.sqleditor.component.QueryDisplayComponent;
import org.teiid.query.ui.sqleditor.component.QueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SelectDisplayNode;
import org.teiid.query.ui.sqleditor.component.SetQueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SqlIndexLocator;
import org.teiid.query.ui.sqleditor.component.UpdateDisplayNode;
import org.teiid.query.ui.sqleditor.component.WhereDisplayNode;

public class SqlEditorPanel
extends SashForm
implements UiConstants,
DisplayNodeConstants,
SelectionListener,
ISelectionChangedListener,
IPropertyChangeListener,
KeyListener,
MouseListener,
IMenuListener {
    private static final String QUERY_CHANGES_PENDING_MESSAGE = Util.getString("SqlEditorPanel.changesPendingMsg", new Object[0]);
    private static final String IMPORT_PROBLEM = "SqlEditorPanel.importProb";
    private static final String EXPORT_PROBLEM = "SqlEditorPanel.exportProb";
    private static final String EXPORT_SQL_DIALOG_TITLE = "SqlEditorPanel.exportSqlDialog.title";
    private static final String IMPORT_SQL_DIALOG_TITLE = "SqlEditorPanel.importSqlDialog.title";
    private static final String IMPORT_SQL_PROBLEM_DIALOG_TITLE = "SqlEditorPanel.importSqlProblemDialog.title";
    private static final String EXPORT_DEFAULT_FILENAME = "SqlEditorPanel.exportDefaultFile.text";
    private static final String EXPORT_DEFAULT_FILEEXT = "SqlEditorPanel.exportDefaultExtension.text";
    private static final String MONITOR_VALIDATING_SQL = "SqlEditorPanel.validatingSQL";
    public static final String ACTION_ID_VALIDATE = "Validate";
    public static final String ACTION_ID_LAUNCH_CRITERIA_BUILDER = "LaunchCriteriaBuilder";
    public static final String ACTION_ID_LAUNCH_EXPRESSION_BUILDER = "LaunchExpressionBuilder";
    public static final String ACTION_ID_LAUNCH_CREATE_FUNCTION = "LaunchCreateFunction";
    public static final String ACTION_ID_EXPAND_SELECT = "ExpandSelect";
    public static final String ACTION_ID_TOGGLE_MESSAGE = "ToggleMessage";
    public static final String ACTION_ID_TOGGLE_OPTIMIZER = "ToggleOptimizer";
    public static final String ACTION_ID_UP_FONT = "UpFont";
    public static final String ACTION_ID_DOWN_FONT = "DownFont";
    public static final String ACTION_ID_IMPORT_FROM_FILE = "ImportFromFile";
    public static final String ACTION_ID_EXPORT_TO_FILE = "ExportToFile";
    public static final String APPLY_TEMPLATE_ACTION_TEXT = "SqlEditorPanel.applyTemplateActionText";
    public static final String APPLY_TEMPLATE_ACTION_TOOLTIP = "SqlEditorPanel.applyTemplateActionTooltip";
    public static final String CREATE_FUNCTION_ACTION_TEXT = "SqlEditorPanel.createFunctionActionText";
    public static final String CREATE_FUNCTION_ACTION_TOOLTIP = "SqlEditorPanel.createFunctionActionTooltip";
    public static final String[] DEFAULT_INCLUDED_ACTIONS = new String[]{"Validate", "LaunchCriteriaBuilder", "LaunchExpressionBuilder", "ExpandSelect", "ToggleMessage", "ToggleOptimizer", "UpFont", "DownFont", "ImportFromFile", "ExportToFile"};
    private ColorManager colorManager;
    private Color currentBkgdColor;
    private Color widgetBkgdColor;
    private IVerticalRuler verticalRuler;
    SqlTextViewer sqlTextViewer;
    private StyledTextEditor textEditor;
    IDocument sqlDocument;
    private boolean messageShowing = true;
    StyledTextEditor messageArea;
    QueryDisplayComponent queryDisplayComponent;
    ViewForm sqlViewForm;
    private String panelSqlText = null;
    boolean validateSelected = false;
    boolean hasPendingChanges = false;
    boolean isCompleteRefresh = false;
    private boolean hasUserError = false;
    private boolean isEditable = true;
    private TextFontManager tfmManager;
    private boolean selectExpansionEnabled = true;
    private boolean selectDropsEnabled = true;
    private int caretOffset = -1;
    private int caretXPosition = 0;
    private int caretYPosition = 0;
    private List<IAction> actionList = null;
    Validate validateAction;
    LaunchCriteriaBuilder launchCriteriaBuilderAction;
    LaunchExpressionBuilder launchExpressionBuilderAction;
    LaunchCreateFunction launchCreateFunctionAction;
    ExpandSelect expandSelectAction;
    ToggleMessage toggleMessageAction;
    ToggleOptimizer toggleOptimizerAction;
    UpFont upFontAction;
    DownFont downFontAction;
    ImportFromFile importFromFileAction;
    ExportToFile exportToFileAction;
    private Action applyTemplateAction;
    private Action createFunctionAction;
    List includedActionsList;
    private Object eventSource;
    protected static final int VERTICAL_RULER_WIDTH = 0;
    private List eventListeners;
    private List internalEventListeners;
    private Collection externalBuilderGroups = null;
    String savedSql = "";
    String currentMessage = "";
    private List setQueryStates;
    private int panelType = 0;

    public SqlEditorPanel(Composite parent, QueryValidator queryValidator, int queryType) {
        super(parent, 512);
        this.init(queryValidator, queryType);
        this.includedActionsList = SqlEditorPanel.getDefaultActionList();
    }

    public SqlEditorPanel(Composite parent, QueryValidator queryValidator, int queryType, List actionsList) {
        super(parent, 512);
        this.init(queryValidator, queryType);
        this.includedActionsList = actionsList;
    }

    private void init(QueryValidator queryValidator, int queryType) {
        this.queryDisplayComponent = new QueryDisplayComponent(queryValidator, queryType);
        this.colorManager = new ColorManager();
        this.currentBkgdColor = this.getDisplay().getSystemColor(22);
        this.widgetBkgdColor = this.getDisplay().getSystemColor(22);
        this.sqlViewForm = new ViewForm((Composite)this, 2048);
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)this.sqlViewForm, this.verticalRuler, styles, this.colorManager);
        this.sqlViewForm.setContent(this.sqlTextViewer.getControl());
        this.sqlTextViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.character == '\u007f' || event.stateMask == 262144 && event.character == ' ') {
                    event.doit = false;
                    SqlEditorPanel.this.sqlTextViewer.showAssistance();
                }
            }
        });
        this.sqlTextViewer.getTextWidget().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent event) {
                SqlEditorPanel.this.sqlTextViewer.handleDoubleClick();
            }

            public void mouseUp(MouseEvent event) {
            }

            public void mouseDown(MouseEvent event) {
                SqlEditorPanel.this.captureCaretInfo();
            }
        });
        this.sqlTextViewer.getTextWidget().addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                SqlEditorPanel.this.fireEditorInternalEvent(1);
            }
        });
        this.textEditor = new StyledTextEditor((TextViewer)this.sqlTextViewer);
        this.textEditor.setAlwaysAllowPaste(true);
        this.textEditor.addMenuListener((IMenuListener)this);
        this.sqlDocument = this.textEditor.getDocument();
        this.sqlTextViewer.setEditable(true);
        this.isEditable = true;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean optimizationOn = prefStore.getBoolean("sqlOptimizationOn");
        this.queryDisplayComponent.setOptimizerOn(optimizationOn);
        this.sqlTextViewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.textEditor.setLayoutData((Object)gridData);
        ViewForm msgViewForm = new ViewForm((Composite)this, 2048);
        int messageAreaStyle = 584;
        this.messageArea = StyledTextEditor.createReadOnlyEditor((Composite)msgViewForm, (int)messageAreaStyle);
        this.messageArea.setLayoutData((Object)gridData);
        this.messageArea.setBackground(this.widgetBkgdColor);
        msgViewForm.setContent((Control)this.messageArea.getTextWidget());
        this.sqlTextViewer.getTextWidget().addSelectionListener((SelectionListener)this);
        this.sqlTextViewer.addSelectionChangedListener(this);
        this.sqlTextViewer.getTextWidget().addKeyListener((KeyListener)this);
        this.sqlTextViewer.getTextWidget().addMouseListener((MouseListener)this);
        int[] wts = new int[]{4, 1};
        this.setWeights(wts);
        this.showMessageArea(false);
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.sqlDocument.addDocumentListener((IDocumentListener)new DocumentChangeListener());
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        this.applyTemplateAction = new Action(null){

            public void run() {
                SqlEditorPanel.this.handleApplyTemplate();
            }
        };
        this.applyTemplateAction.setToolTipText(Util.getString(APPLY_TEMPLATE_ACTION_TOOLTIP, new Object[0]));
        this.applyTemplateAction.setText(Util.getString(APPLY_TEMPLATE_ACTION_TEXT, new Object[0]));
        this.applyTemplateAction.setEnabled(true);
        manager.add((IAction)this.applyTemplateAction);
        this.createFunctionAction = new Action(null){

            public void run() {
                SqlEditorPanel.this.launchCreateFunction();
            }
        };
        this.createFunctionAction.setToolTipText(Util.getString(CREATE_FUNCTION_ACTION_TOOLTIP, new Object[0]));
        this.createFunctionAction.setText(Util.getString(CREATE_FUNCTION_ACTION_TEXT, new Object[0]));
        this.createFunctionAction.setEnabled(true);
        manager.add((IAction)this.createFunctionAction);
    }

    private void handleApplyTemplate() {
        SQLTemplateDialog templateDialog = new SQLTemplateDialog(UiUtil.getWorkbenchShellOnlyIfUiThread(), SQLTemplateDialog.ALL_TEMPLATES);
        if (templateDialog.open() == 0) {
            boolean okToInsertOrReplace = true;
            if (templateDialog.getInsertOption() == 0) {
                okToInsertOrReplace = MessageDialog.openConfirm((Shell)templateDialog.getShell(), (String)Messages.confirmSqlReplaceDialogTitle, (String)Messages.confirmSqlReplaceDialogMessage);
            }
            if (okToInsertOrReplace) {
                int offset = this.getCaretOffset();
                String currentSQL = this.getText();
                String newSql = SqlStringUtil.insertSql((String)currentSQL, (String)templateDialog.getSQL(), (int)templateDialog.getInsertOption(), (int)offset);
                this.setText(newSql, (Object)templateDialog);
            }
        }
    }

    public void resetUndoRedoHistory() {
        this.textEditor.resetUndoRedoHistory();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propStr = e.getProperty();
        if (propStr != null && (propStr.equals("startClausesOnNewLine") || propStr.equals("indentClauseContent")) && !this.isDisposed() && this.isVisible()) {
            this.setText(this.getText());
        }
    }

    public void setQueryValidator(QueryValidator validator) {
        this.queryDisplayComponent.setQueryValidator(validator);
    }

    public String getText() {
        return this.sqlDocument.get();
    }

    void setTextInTransaction(String proposedSqlText, Object source, boolean doResolveAndValidate, QueryValidationResult result, IProgressMonitor monitor) {
        block11: {
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                try {
                    requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Setting Sql Text", (Object)source);
                    this.eventSource = source;
                    boolean setSqlText = this.hasPendingChanges;
                    if (!setSqlText) {
                        setSqlText = TransformationHelper.stringsDifferent((String)this.panelSqlText, (String)proposedSqlText);
                    }
                    if (setSqlText) {
                        this.panelSqlText = proposedSqlText;
                        TransformationHelper.setSqlString((Object)this.queryDisplayComponent.getMappingRoot(), (String)this.panelSqlText, (int)this.queryDisplayComponent.getQueryType(), (boolean)false, (Object)this);
                        this.queryDisplayComponent.setText(this.panelSqlText, doResolveAndValidate, result, monitor);
                        this.refreshWithDisplayComponent();
                        monitor.worked(10);
                        this.eventSource = this;
                    }
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + this.getClass().getName() + ".setTextInTransaction()");
                    if (!requiredStart) break block11;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block11;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public void setText(final String sql, final Object source, final boolean doResolveAndValidate, final QueryValidationResult theResult) {
        if (doResolveAndValidate) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor theMonitor) {
                    theMonitor.beginTask(SqlEditorPanel.MONITOR_VALIDATING_SQL, 100);
                    theMonitor.worked(20);
                    SqlEditorPanel.this.setTextInTransaction(sql, source, doResolveAndValidate, theResult, theMonitor);
                    theMonitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                UiConstants.Util.log(e.getTargetException());
            }
            catch (Exception e) {
                UiConstants.Util.log((Object)e.getMessage());
            }
        } else {
            this.setTextInTransaction(sql, source, doResolveAndValidate, theResult, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void clear() {
        this.savedSql = "";
        this.panelSqlText = null;
        this.queryDisplayComponent.reset();
        this.refreshWithDisplayComponent();
    }

    private void setText(String sql, Object source) {
        this.setText(sql, source, true, null);
    }

    public void setText(String sql) {
        this.eventSource = this;
        String theSql = sql;
        if (sql == null) {
            theSql = "";
        }
        this.queryDisplayComponent.setText(theSql, true, null);
        this.refreshWithDisplayComponent();
    }

    public void validate() {
        String panelText = this.getText();
        this.validateSelected = true;
        this.setText(panelText, this);
    }

    public boolean threadIsNotDisplayThread() {
        return this.getDisplay() != null && Thread.currentThread() != this.getDisplay().getThread();
    }

    private void refreshWithDisplayComponent() {
        this.hasPendingChanges = false;
        this.isCompleteRefresh = true;
        if (this.threadIsNotDisplayThread()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SqlEditorPanel.this.setMessage(SqlEditorPanel.this.queryDisplayComponent);
                    SqlEditorPanel.this.sqlDocument.set(SqlEditorPanel.this.queryDisplayComponent.toDisplayString());
                    SqlEditorPanel.this.setQueryTextBackground();
                }
            });
        } else {
            this.setMessage(this.queryDisplayComponent);
            this.sqlDocument.set(this.queryDisplayComponent.toDisplayString());
            this.setQueryTextBackground();
        }
    }

    void fireEditorEvent() {
        if (this.eventSource == null) {
            this.eventSource = this;
        }
        boolean isParsable = this.queryDisplayComponent.isParsable();
        boolean isResolvable = this.queryDisplayComponent.isResolvable();
        boolean isValidatable = this.queryDisplayComponent.isValidatable();
        SqlEditorEvent event = null;
        event = this.hasPendingChanges ? new SqlEditorEvent(this.eventSource, 0) : (!isParsable ? new SqlEditorEvent(this.eventSource, this.getText(), 1) : (!isResolvable ? new SqlEditorEvent(this.eventSource, this.getCommand(), this.getText(), 2) : (!isValidatable ? new SqlEditorEvent(this.eventSource, this.getCommand(), this.getText(), 3) : new SqlEditorEvent(this.eventSource, this.getCommand(), this.getText(), 4))));
        this.notifyEventListeners(event);
    }

    private void notifyCaretChanged() {
        this.notifyEventListeners(new SqlEditorEvent(this, 5));
    }

    protected void fireEditorInternalEvent(int eventType) {
        SqlEditorInternalEvent event = new SqlEditorInternalEvent(this, eventType);
        this.notifyInternalEventListeners(event);
    }

    public void addEventListener(EventObjectListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
        }
        this.eventListeners.add(listener);
    }

    public void removeEventListener(EventObjectListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    private void notifyEventListeners(EventObject event) {
        if (this.eventListeners != null) {
            for (EventObjectListener listener : this.eventListeners) {
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    public void addInternalEventListener(EventObjectListener listener) {
        if (this.internalEventListeners == null) {
            this.internalEventListeners = new ArrayList();
        }
        this.internalEventListeners.add(listener);
    }

    public void removeInternalEventListener(EventObjectListener listener) {
        if (this.internalEventListeners != null) {
            this.internalEventListeners.remove(listener);
        }
    }

    private void notifyInternalEventListeners(EventObject event) {
        if (this.internalEventListeners != null) {
            for (EventObjectListener listener : this.internalEventListeners) {
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    public ICommand getCommand() {
        return this.queryDisplayComponent.getCommand();
    }

    public void showMessageArea(final boolean show) {
        if (!this.isDisposed()) {
            if (show != this.messageShowing) {
                if (this.threadIsNotDisplayThread()) {
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (show) {
                                SqlEditorPanel.this.setMaximizedControl(null);
                                SqlEditorPanel.this.setMessage(SqlEditorPanel.this.currentMessage);
                            } else {
                                SqlEditorPanel.this.setMaximizedControl((Control)SqlEditorPanel.this.sqlViewForm);
                            }
                        }
                    });
                } else if (show) {
                    this.setMaximizedControl(null);
                    this.setMessage(this.currentMessage);
                } else {
                    this.setMaximizedControl((Control)this.sqlViewForm);
                }
                this.messageShowing = !this.messageShowing;
            }
            this.fireEditorInternalEvent(3);
        }
    }

    public boolean isMessageAreaVisible() {
        return this.messageShowing;
    }

    void setMessage(QueryDisplayComponent displayComponent) {
        this.setMessage(this.queryDisplayComponent.getStatusMessage());
    }

    public void setMessage(String messageText) {
        this.currentMessage = messageText;
        if (!this.messageArea.isDisposed()) {
            if (this.threadIsNotDisplayThread()) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SqlEditorPanel.this.currentMessage != null) {
                            SqlEditorPanel.this.messageArea.setText(SqlEditorPanel.this.currentMessage);
                        } else {
                            SqlEditorPanel.this.messageArea.setText("");
                        }
                    }
                });
            } else if (this.currentMessage != null) {
                this.messageArea.setText(this.currentMessage);
            } else {
                this.messageArea.setText("");
            }
        }
    }

    public void setSelectDropsEnabled(boolean status) {
        this.selectDropsEnabled = status;
    }

    public void setSelectExpansionEnabled(boolean status) {
        this.selectExpansionEnabled = status;
    }

    public void setSetQueryReconciledStates(List reconciledStates) {
        this.setQueryStates = reconciledStates;
        this.setTextViewerBackgroundColors(this.getCaretOffset());
    }

    void setQueryTextBackground() {
        StyledText sqlTextArea = this.sqlTextViewer.getTextWidget();
        if (sqlTextArea != null) {
            Color bkgdColor = this.widgetBkgdColor;
            if (this.hasPendingChanges || this.hasUserError) {
                bkgdColor = this.colorManager.getColor(ColorManager.BACKGROUND_INVALID);
            } else if (this.isEditable()) {
                bkgdColor = this.queryDisplayComponent.isValidatable() ? this.colorManager.getColor(ColorManager.BACKGROUND_VALID) : this.colorManager.getColor(ColorManager.BACKGROUND_INVALID);
            }
            this.setSqlTextAreaBackgroundColor(bkgdColor);
            StyledText styledText = this.sqlTextViewer.getTextWidget();
            int textLength = styledText.getText().length();
            int wholeStartLine = 0;
            int wholeEndLine = styledText.getLineAtOffset(textLength);
            int nAllLines = wholeEndLine - wholeStartLine + 1;
            styledText.setLineBackground(wholeStartLine, nAllLines, bkgdColor);
        }
    }

    private void setSqlTextAreaBackgroundColor(Color bkgdColor) {
        StyledText sqlTextArea = this.sqlTextViewer.getTextWidget();
        if (sqlTextArea != null && !this.currentBkgdColor.getRGB().equals((Object)bkgdColor.getRGB())) {
            this.currentBkgdColor = bkgdColor;
            sqlTextArea.setBackground(bkgdColor);
        }
    }

    public void setEditable(final boolean status) {
        this.isEditable = status;
        if (this.threadIsNotDisplayThread()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SqlEditorPanel.this.sqlTextViewer.setEditable(status);
                    SqlEditorPanel.this.setQueryTextBackground();
                }
            });
        } else {
            this.sqlTextViewer.setEditable(status);
            this.setQueryTextBackground();
        }
        this.fireEditorInternalEvent(2);
    }

    public void setExternalBuilderGroups(Collection groups) {
        this.externalBuilderGroups = groups;
    }

    public void setOptimizerOn(boolean status) {
        boolean isOn;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean currentValue = prefStore.getBoolean("sqlOptimizationOn");
        if (status != currentValue) {
            prefStore.setValue("sqlOptimizationOn", status);
        }
        if (status != (isOn = this.isOptimizerOn())) {
            this.queryDisplayComponent.setOptimizerOn(status);
            if (!this.hasPendingChanges()) {
                this.refreshWithDisplayComponent();
            }
            this.fireEditorInternalEvent(6);
        }
    }

    public boolean isOptimizerOn() {
        return this.queryDisplayComponent.isOptimizerOn();
    }

    public boolean canOptimize() {
        return this.queryDisplayComponent.canOptimize();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isParsable() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isParsable();
    }

    public boolean isResolvable() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isResolvable();
    }

    public boolean isValid() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isValidatable();
    }

    public boolean isDefaultQuery() {
        return this.queryDisplayComponent.isDefaultQuery();
    }

    public void setHasError(boolean status) {
        this.hasUserError = status;
        this.setQueryTextBackground();
    }

    public boolean canUseExpressionBuilder() {
        if (!this.isEditable() || !this.isParsable()) {
            return false;
        }
        int caretIndex = this.getCorrectedCaretOffset();
        return this.isIndexWithin(caretIndex, 3) || this.isInsertAllowed(caretIndex, 3);
    }

    public boolean canCreateFunction() {
        if (!this.isEditable() || !this.isParsable()) {
            return false;
        }
        int caretIndex = this.getCorrectedCaretOffset();
        return this.isIndexWithin(caretIndex, 3);
    }

    public boolean canUseCriteriaBuilder() {
        if (!this.isEditable() || !this.isParsable()) {
            return false;
        }
        int caretIndex = this.getCorrectedCaretOffset();
        List displayNodes = this.queryDisplayComponent.getDisplayNodeList();
        DisplayNode criteriaNode = DisplayNodeUtils.getNodeTypeAtIndex((List)displayNodes, (int)caretIndex, (int)2);
        return criteriaNode != null || this.commandHasEditableCriteriaClause(caretIndex) || this.isInsertAllowed(caretIndex, 2);
    }

    private ExpressionBuilder getExpressionBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(shell);
        expressionBuilder.create();
        return expressionBuilder;
    }

    private CriteriaBuilder getCriteriaBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(shell);
        criteriaBuilder.create();
        return criteriaBuilder;
    }

    public void showExpressionBuilder() {
        int index = this.getCorrectedCaretOffset();
        DisplayNode expressionNode = this.getExpressionAtIndex(index);
        int startIndex = 0;
        int endIndex = 0;
        boolean replaceMode = false;
        if (expressionNode != null) {
            startIndex = expressionNode.getStartIndex();
            endIndex = expressionNode.getEndIndex();
            replaceMode = true;
        }
        List groups = this.getGroupsForBuilderTree(true);
        while (groups.contains(null) && groups.size() > 0) {
            groups.remove(null);
        }
        ElementViewerFactory.setViewerInput((Object)groups);
        ExpressionBuilder builder = this.getExpressionBuilder();
        builder.setLanguageObject((ILanguageObject)(replaceMode ? (IExpression)expressionNode.getLanguageObject() : null));
        int status = builder.open();
        if (status == 0) {
            ILanguageObject langObj = builder.getLanguageObject();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            String langString = visitor.returnSQLString(langObj);
            if (replaceMode) {
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                currentSQL.replace(startIndex, endIndex + 1, langString);
                this.setText(currentSQL.toString(), this);
            } else {
                if (this.queryDisplayComponent.isIndexWithin(index, 6)) {
                    DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
                    try {
                        ILanguageObject selectObj = clauseNode.getLanguageObject();
                        if (selectObj != null && selectObj instanceof ISelect && ((ISelect)selectObj).isStar()) {
                            boolean isAtClauseEnd = DisplayNodeUtils.isIndexAtClauseEnd((DisplayNode)clauseNode, (int)index);
                            this.queryDisplayComponent.expandSelect(index);
                            if (isAtClauseEnd) {
                                DisplayNode newClauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
                                index = newClauseNode.getEndIndex();
                            }
                        }
                    }
                    catch (NullPointerException npe) {
                        UiPlugin.getDefault().getPluginUtil().log(4, (Throwable)npe, "Clause Node was null at index: " + index);
                        UiPlugin.getDefault().getPluginUtil().log(4, (Throwable)npe, "Text was: " + this.getText());
                    }
                }
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                int newIndex = this.adjustIndexForInsert(index);
                String newExpressionString = this.adjustStringForInsert(langString, newIndex);
                currentSQL.insert(newIndex, newExpressionString);
                this.setText(currentSQL.toString(), this);
            }
            this.setCaretOffset(0);
        }
    }

    public void showCriteriaBuilder() {
        int index = this.getCorrectedCaretOffset();
        DisplayNode criteriaNode = this.getCriteriaAtIndex(index, false);
        int startIndex = 0;
        int endIndex = 0;
        boolean replaceMode = false;
        if (criteriaNode != null) {
            startIndex = criteriaNode.getStartIndex();
            endIndex = criteriaNode.getEndIndex();
            replaceMode = true;
        }
        List groups = this.getGroupsForBuilderTree(true);
        while (groups.contains(null) && groups.size() > 0) {
            groups.remove(null);
        }
        ElementViewerFactory.setViewerInput((Object)groups);
        CriteriaBuilder builder = this.getCriteriaBuilder();
        builder.setLanguageObject((ILanguageObject)(replaceMode ? (ICriteria)criteriaNode.getLanguageObject() : null));
        int status = builder.open();
        if (status == 0) {
            ILanguageObject newCriteria = builder.getLanguageObject();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            String criteriaString = visitor.returnSQLString(newCriteria);
            if (replaceMode) {
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                currentSQL.replace(startIndex, endIndex + 1, criteriaString);
                this.setText(currentSQL.toString(), this);
            } else {
                DisplayNode commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
                if (commandNode != null) {
                    DisplayNode optionNode;
                    if (commandNode instanceof QueryDisplayNode) {
                        DisplayNode whereNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(9);
                        DisplayNode fromNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(8);
                        if (fromNode != null && whereNode == null) {
                            index = fromNode.getEndIndex();
                        }
                    } else if (commandNode instanceof DeleteDisplayNode) {
                        optionNode = ((DeleteDisplayNode)commandNode).getClauseDisplayNode(13);
                        index = optionNode != null ? optionNode.getStartIndex() : commandNode.getEndIndex();
                    } else if (commandNode instanceof UpdateDisplayNode) {
                        optionNode = ((UpdateDisplayNode)commandNode).getClauseDisplayNode(13);
                        index = optionNode != null ? optionNode.getStartIndex() : commandNode.getEndIndex();
                    }
                }
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                while (currentSQL.charAt(index) == '\n' || currentSQL.charAt(index) == ';') {
                    --index;
                }
                currentSQL.insert(index + 1, " WHERE " + criteriaString);
                this.setText(currentSQL.toString(), this);
            }
            this.setCaretOffset(0);
        }
    }

    public void launchCreateFunction() {
        int index = this.getCorrectedCaretOffset();
        String functionName = null;
        int numArgs = 0;
        this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
        List nodeList = this.queryDisplayComponent.getDisplayNodesAtIndex(index);
        if (nodeList.size() == 1) {
            IExpression expression;
            Object node = nodeList.get(0);
            if (node instanceof FunctionDisplayNode && (expression = (IExpression)((FunctionDisplayNode)node).getLanguageObject()) instanceof IFunction) {
                IFunction function = (IFunction)expression;
                functionName = function.getName();
                numArgs = function.getArgs().length;
            }
            CreateFunctionAction action = new CreateFunctionAction();
            action.run(functionName, numArgs);
        }
    }

    public List getGroupsForBuilderTree(boolean forExpression) {
        SqlIndexLocator indexLocator = new SqlIndexLocator(this.queryDisplayComponent, this.getCorrectedCaretOffset());
        GroupSymbolFinder finder = new GroupSymbolFinder(indexLocator, this.externalBuilderGroups);
        return finder.find();
    }

    public boolean hasPendingChanges() {
        return this.hasPendingChanges;
    }

    public void insertElements(List elementNames, List parentNames, int index, Object source) {
        this.eventSource = source;
        boolean okToInsert = this.isInsertOK(index);
        if (!okToInsert) {
            return;
        }
        this.queryDisplayComponent.insertElements(elementNames, parentNames, index);
        this.refreshWithDisplayComponent();
    }

    public void insertElementsAtEndOfSelect(List elementNames, List parentNames, Object source) {
        SelectDisplayNode selectNode = this.queryDisplayComponent.getSelectDisplayNode();
        if (selectNode != null) {
            int selectEndIndex = selectNode.getEndIndex();
            this.insertElements(elementNames, parentNames, selectEndIndex + 1, source);
        } else if (this.isDefaultQuery()) {
            String currentQuery = this.getText();
            int insertIndex = currentQuery.toUpperCase().indexOf("SELECT") + "SELECT".length();
            this.insertElements(elementNames, parentNames, insertIndex, source);
        } else if (this.getText().trim().length() == 0) {
            StringBuffer sb = new StringBuffer("SELECT");
            Iterator iter = elementNames.iterator();
            while (iter.hasNext()) {
                String elemName = (String)iter.next();
                sb.append(" " + elemName);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(" FROM");
            HashSet uniqueNames = new HashSet();
            uniqueNames.addAll(parentNames);
            iter = uniqueNames.iterator();
            while (iter.hasNext()) {
                String grpName = (String)iter.next();
                sb.append(" " + grpName);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            this.setText(sb.toString(), source);
        }
    }

    public boolean isInsertOK(int index) {
        List nodes = this.queryDisplayComponent.getDisplayNodesAtIndex(index);
        if (nodes.size() == 1) {
            DisplayNode expressionNode;
            DisplayNode node = (DisplayNode)nodes.get(0);
            if (DisplayNodeUtils.isWithinSelect((DisplayNode)node) && !this.selectDropsEnabled) {
                return false;
            }
            if (node.isInExpression() && (expressionNode = DisplayNodeUtils.getExpressionForNode((DisplayNode)node)) != null && !(expressionNode instanceof AliasSymbolDisplayNode)) {
                return false;
            }
        } else if (nodes.size() == 2) {
            DisplayNode expressionNode;
            DisplayNode node1 = (DisplayNode)nodes.get(0);
            DisplayNode node2 = (DisplayNode)nodes.get(1);
            if ((DisplayNodeUtils.isWithinSelect((DisplayNode)node1) || DisplayNodeUtils.isWithinSelect((DisplayNode)node1)) && !this.selectDropsEnabled) {
                return false;
            }
            if (node1.isInExpression() && node2.isInExpression() && (expressionNode = DisplayNodeUtils.getExpressionForNode((DisplayNode)node1)) != null && !(expressionNode instanceof AliasSymbolDisplayNode)) {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrentCaretWithinSelect() {
        return this.isIndexWithin(this.getCorrectedCaretOffset(), 6);
    }

    public boolean isCurrentCaretWithinFrom() {
        return this.isIndexWithin(this.getCorrectedCaretOffset(), 8);
    }

    public boolean isIndexWithin(int index, int nodeType) {
        if (!this.isParsable()) {
            return false;
        }
        return DisplayNodeUtils.isIndexWithin((List)this.queryDisplayComponent.getDisplayNodeList(), (int)index, (int)nodeType);
    }

    public boolean commandHasCriteriaClause(int index) {
        boolean result = false;
        if (this.isParsable()) {
            DisplayNode commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
            if (commandNode instanceof QueryDisplayNode) {
                if (((QueryDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                    result = true;
                }
            } else if (commandNode instanceof UpdateDisplayNode) {
                if (((UpdateDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                    result = true;
                }
            } else if (commandNode instanceof DeleteDisplayNode && ((DeleteDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                result = true;
            }
        }
        return result;
    }

    public boolean isCommandUnion() {
        ICommand command;
        boolean result = false;
        if (this.isParsable() && (command = this.queryDisplayComponent.getCommand()) instanceof ISetQuery) {
            result = true;
        }
        return result;
    }

    public DisplayNode getCurrentCommandDisplayNode() {
        return this.queryDisplayComponent.getCommandDisplayNodeAtIndex(this.getCorrectedCaretOffset());
    }

    public int getCurrentUnionCommandSegmentIndex() {
        DisplayNode currentCommandDN;
        int index = -1;
        if (this.isCommandUnion() && (currentCommandDN = this.getCurrentCommandDisplayNode()) instanceof QueryDisplayNode) {
            SetQueryDisplayNode sqdn = (SetQueryDisplayNode)this.queryDisplayComponent.getDisplayNode();
            return sqdn.getQueryDisplayNodes().indexOf(currentCommandDN);
        }
        return index;
    }

    public boolean isSubQuerySelected() {
        DisplayNode currentCommandDN = this.getCurrentCommandDisplayNode();
        if (currentCommandDN instanceof QueryDisplayNode) {
            DisplayNode parent = currentCommandDN.getParent();
            while (parent != null) {
                if (parent.getLanguageObject() instanceof ISubqueryContainer) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }
        return false;
    }

    public boolean commandHasEditableCriteriaClause(int index) {
        return this.commandHasCriteriaClause(index) && this.isEditable();
    }

    public boolean isInsertAllowed(int index, int type) {
        if (!this.isParsable()) {
            return false;
        }
        return this.queryDisplayComponent.isInsertAllowed(index, type);
    }

    public DisplayNode getExpressionAtIndex(int index) {
        List displayNodes;
        DisplayNode result = null;
        if (this.isParsable() && (result = DisplayNodeUtils.getNodeTypeAtIndex((List)(displayNodes = this.queryDisplayComponent.getDisplayNodeList()), (int)index, (int)3)) instanceof AliasSymbolDisplayNode) {
            result = (DisplayNode)result.getChildren().get(0);
        }
        return result;
    }

    public DisplayNode getCriteriaAtIndex(int index, boolean getOuterMost) {
        DisplayNode result = null;
        if (this.isParsable()) {
            DisplayNode clauseNode;
            DisplayNode commandNode;
            List displayNodes = this.queryDisplayComponent.getDisplayNodeList();
            result = DisplayNodeUtils.getNodeTypeAtIndex((List)displayNodes, (int)index, (int)2);
            if (getOuterMost) {
                while (result != null) {
                    DisplayNode parent = result.getParent();
                    if (parent == null || !(parent.getLanguageObject() instanceof ICriteria)) break;
                    result = parent;
                }
            }
            if (result == null && (commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index)) != null && commandNode instanceof QueryDisplayNode && (clauseNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(9)) != null && DisplayNodeUtils.isEditableCriteria((DisplayNode)(result = ((WhereDisplayNode)clauseNode).getCriteria()))) {
                return result;
            }
        }
        return result;
    }

    public List<IAction> getActions() {
        if (this.actionList == null) {
            this.actionList = new ArrayList<IAction>(11);
            if (this.includedActionsList.contains(ACTION_ID_VALIDATE)) {
                this.validateAction = new Validate(this);
                this.validateAction.setToolTipText(Util.getString("SqlEditorPanel.Validate.tooltip", new Object[0]));
                this.actionList.add((IAction)this.validateAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_LAUNCH_CRITERIA_BUILDER)) {
                this.launchCriteriaBuilderAction = new LaunchCriteriaBuilder(this);
                this.launchCriteriaBuilderAction.setToolTipText(Util.getString("SqlEditorPanel.LaunchCriteriaBuilder.tooltip", new Object[0]));
                this.actionList.add((IAction)this.launchCriteriaBuilderAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_LAUNCH_EXPRESSION_BUILDER)) {
                this.launchExpressionBuilderAction = new LaunchExpressionBuilder(this);
                this.launchExpressionBuilderAction.setToolTipText(Util.getString("SqlEditorPanel.LaunchExpressionBuilder.tooltip", new Object[0]));
                this.actionList.add((IAction)this.launchExpressionBuilderAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_EXPAND_SELECT)) {
                this.expandSelectAction = new ExpandSelect(this);
                this.expandSelectAction.setToolTipText(Util.getString("SqlEditorPanel.ExpandSelect.tooltip", new Object[0]));
                this.actionList.add((IAction)this.expandSelectAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_UP_FONT)) {
                this.upFontAction = new UpFont(this);
                this.upFontAction.setToolTipText(Util.getString("SqlEditorPanel.UpFont.tooltip", new Object[0]));
                this.actionList.add((IAction)this.upFontAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_DOWN_FONT)) {
                this.downFontAction = new DownFont(this);
                this.downFontAction.setToolTipText(Util.getString("SqlEditorPanel.DownFont.tooltip", new Object[0]));
                this.actionList.add((IAction)this.downFontAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_TOGGLE_MESSAGE)) {
                this.toggleMessageAction = new ToggleMessage(this);
                this.toggleMessageAction.setToolTipText(Util.getString("SqlEditorPanel.ToggleMessage.tooltip", new Object[0]));
                this.actionList.add((IAction)this.toggleMessageAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_TOGGLE_OPTIMIZER)) {
                this.toggleOptimizerAction = new ToggleOptimizer(this);
                this.toggleOptimizerAction.setToolTipText(Util.getString("SqlEditorPanel.ToggleOptimizer.tooltip", new Object[0]));
                this.actionList.add((IAction)this.toggleOptimizerAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_IMPORT_FROM_FILE)) {
                this.importFromFileAction = new ImportFromFile(this);
                this.importFromFileAction.setToolTipText(Util.getString("SqlEditorPanel.ImportFromFile.tooltip", new Object[0]));
                this.actionList.add((IAction)this.importFromFileAction);
            }
            if (this.includedActionsList.contains(ACTION_ID_EXPORT_TO_FILE)) {
                this.exportToFileAction = new ExportToFile(this);
                this.exportToFileAction.setToolTipText(Util.getString("SqlEditorPanel.ExportToFile.tooltip", new Object[0]));
                this.actionList.add((IAction)this.exportToFileAction);
            }
            this.launchCreateFunctionAction = new LaunchCreateFunction(this);
            this.launchCreateFunctionAction.setToolTipText("Create Function");
        }
        return this.actionList;
    }

    public static List getDefaultActionList() {
        return new ArrayList<String>(Arrays.asList(DEFAULT_INCLUDED_ACTIONS));
    }

    public void dispose() {
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public void setCaretOffset(int posn) {
        int textLength;
        if (posn < 0) {
            posn = 0;
        }
        if (posn > (textLength = this.getText().length())) {
            posn = textLength;
        }
        this.caretOffset = posn;
        this.sqlTextViewer.getTextWidget().setCaretOffset(posn);
        this.setTextViewerBackgroundColors(posn);
        this.fireEditorInternalEvent(5);
    }

    private void setTextViewerBackgroundColors(int caretPosn) {
        if (!this.isEditable()) {
            this.setQueryTextBackground();
            return;
        }
        if (this.isIndexWithin(caretPosn, 4)) {
            int nAllLines;
            int wholeEndLine;
            int wholeStartLine;
            StyledText styledText = this.sqlTextViewer.getTextWidget();
            int textLength = styledText.getText().length();
            DisplayNode wholeCommandNode = this.getQueryDisplayComponent().getDisplayNode();
            DisplayNode commandNode = this.getQueryDisplayComponent().getCommandDisplayNodeAtIndex(caretPosn);
            if (commandNode != null && !commandNode.equals(wholeCommandNode)) {
                wholeStartLine = 0;
                wholeEndLine = styledText.getLineAtOffset(textLength);
                nAllLines = wholeEndLine - wholeStartLine + 1;
                int startIndex = commandNode.getStartIndex();
                int endIndex = commandNode.getEndIndex();
                int startLine = wholeStartLine;
                int endLine = wholeEndLine;
                if (startIndex >= 0 && endIndex <= textLength) {
                    startLine = styledText.getLineAtOffset(startIndex);
                    endLine = styledText.getLineAtOffset(endIndex);
                }
                int nLines = endLine - startLine + 1;
                this.setSqlTextAreaBackgroundColor(this.colorManager.getColor(ColorManager.BACKGROUND_UNFOCUSED));
                styledText.setLineBackground(wholeStartLine, nAllLines, this.colorManager.getColor(ColorManager.BACKGROUND_UNFOCUSED));
                styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
            } else {
                wholeStartLine = 0;
                wholeEndLine = styledText.getLineAtOffset(textLength);
                nAllLines = wholeEndLine - wholeStartLine + 1;
                this.setSqlTextAreaBackgroundColor(this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
                styledText.setLineBackground(wholeStartLine, nAllLines, this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
            }
            if (wholeCommandNode instanceof SetQueryDisplayNode) {
                List queryNodes = ((SetQueryDisplayNode)wholeCommandNode).getQueryDisplayNodes();
                if (this.setQueryStates != null && this.setQueryStates.size() == queryNodes.size()) {
                    int i = 0;
                    while (i < queryNodes.size()) {
                        boolean isReconciled = (Boolean)this.setQueryStates.get(i);
                        if (!isReconciled) {
                            DisplayNode node = (DisplayNode)queryNodes.get(i);
                            int startIndex = node.getStartIndex();
                            int endIndex = node.getEndIndex();
                            if (startIndex >= 0 && endIndex <= textLength) {
                                int startLine = styledText.getLineAtOffset(startIndex);
                                int endLine = styledText.getLineAtOffset(endIndex);
                                int nLines = endLine - startLine + 1;
                                if (node.equals(commandNode)) {
                                    styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.NON_RECD_UNION_QUERY_FOCUSED));
                                } else {
                                    styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.NON_RECD_UNION_QUERY_UNFOCUSED));
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    void captureCaretInfo() {
        this.caretOffset = this.sqlTextViewer.getTextWidget().getCaretOffset();
        this.caretYPosition = this.sqlTextViewer.getTextWidget().getLineAtOffset(this.caretOffset);
        this.caretXPosition = this.caretOffset - this.sqlTextViewer.getTextWidget().getOffsetAtLine(this.caretYPosition);
        this.setTextViewerBackgroundColors(this.caretOffset);
        this.fireEditorInternalEvent(5);
        this.notifyCaretChanged();
    }

    public int getCorrectedCaretOffset() {
        return this.getCorrectedCaretOffset(this.caretOffset);
    }

    public int getCorrectedCaretOffset(int visibleCaretOffset) {
        return this.queryDisplayComponent.getCorrectedIndex(visibleCaretOffset);
    }

    public TextViewer getTextViewer() {
        return this.sqlTextViewer;
    }

    public QueryDisplayComponent getQueryDisplayComponent() {
        return this.queryDisplayComponent;
    }

    public TextFontManager getFontManager() {
        if (this.tfmManager == null) {
            this.tfmManager = new TextFontManager((TextViewer)this.sqlTextViewer, new ScaledFontManager());
        }
        return this.tfmManager;
    }

    public IUndoManager getUndoManager() {
        return this.textEditor.getUndoManager();
    }

    public void expandCurrentSelect() {
        if (this.canExpandCurrentSelect()) {
            this.eventSource = this;
            int index = this.getCorrectedCaretOffset();
            this.queryDisplayComponent.expandSelect(index);
            this.refreshWithDisplayComponent();
        }
    }

    public boolean canExpandCurrentSelect() {
        if (this.hasPendingChanges || !this.selectExpansionEnabled) {
            return false;
        }
        int index = this.getCorrectedCaretOffset();
        return this.queryDisplayComponent.canExpandSelect(index);
    }

    private int adjustIndexForInsert(int index) {
        if (this.hasPendingChanges || !this.queryDisplayComponent.isParsable()) {
            return index;
        }
        DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
        if (clauseNode != null) {
            List nodesAtIndex = DisplayNodeUtils.getDisplayNodesAtIndex((List)clauseNode.getDisplayNodeList(), (int)index);
            int nNodes = nodesAtIndex.size();
            DisplayNode node = null;
            if (nNodes != 1 && nNodes != 2) {
                return index;
            }
            node = (DisplayNode)nodesAtIndex.get(0);
            if (node.getParent() != null && node.getParent() instanceof AliasSymbolDisplayNode) {
                node = node.getParent();
            }
            return node.getEndIndex() + 1;
        }
        return index;
    }

    private String adjustStringForInsert(String insertString, int index) {
        if (this.hasPendingChanges || !this.queryDisplayComponent.isParsable()) {
            return insertString;
        }
        DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
        if (clauseNode != null) {
            List displayNodes = clauseNode.getDisplayNodeList();
            boolean isAtClauseStart = DisplayNodeUtils.isIndexAtClauseStart((DisplayNode)clauseNode, (int)index);
            boolean isAtClauseEnd = DisplayNodeUtils.isIndexAtClauseEnd((DisplayNode)clauseNode, (int)index);
            boolean isRightBeforeComma = DisplayNodeUtils.isIndexRightBeforeComma((List)displayNodes, (int)index);
            boolean isRightAfterComma = DisplayNodeUtils.isIndexRightAfterComma((List)displayNodes, (int)index);
            if (isAtClauseStart) {
                return " " + insertString + ",";
            }
            if (isRightAfterComma) {
                return String.valueOf(insertString) + ",";
            }
            if (isAtClauseEnd || isRightBeforeComma) {
                return "," + insertString;
            }
            return insertString;
        }
        return insertString;
    }

    public static int getVerticalRulerWidth() {
        return 0;
    }

    public void exportToFile() {
        block19: {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.*"});
            dlg.setText(Util.getString(EXPORT_SQL_DIALOG_TITLE, new Object[0]));
            dlg.setFileName(Util.getString(EXPORT_DEFAULT_FILENAME, new Object[0]));
            String fileStr = dlg.open();
            if (fileStr != null && fileStr.indexOf(46) == -1) {
                fileStr = String.valueOf(fileStr) + "." + Util.getString(EXPORT_DEFAULT_FILEEXT, new Object[0]);
            }
            if (fileStr != null) {
                FileWriter fw = null;
                BufferedWriter out = null;
                PrintWriter pw = null;
                try {
                    try {
                        fw = new FileWriter(fileStr);
                        out = new BufferedWriter(fw);
                        pw = new PrintWriter(out);
                        String sqlText = this.getText();
                        pw.write(sqlText);
                    }
                    catch (Exception e) {
                        String msg = Util.getString(EXPORT_PROBLEM, new Object[0]);
                        Util.log(4, (Throwable)e, msg);
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    pw.close();
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                pw.close();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void importFromFile() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setFilterExtensions(new String[]{"*.sql;*.txt", "*.*"});
        dlg.setText(Util.getString(IMPORT_SQL_DIALOG_TITLE, new Object[0]));
        String fileStr = dlg.open();
        if (fileStr != null) {
            FileReader fr = null;
            BufferedReader in = null;
            try {
                try {
                    String str;
                    fr = new FileReader(fileStr);
                    in = new BufferedReader(fr);
                    StringBuffer all = new StringBuffer();
                    String delimiter = this.sqlTextViewer.getTextWidget().getLineDelimiter();
                    while ((str = in.readLine()) != null) {
                        all.append(str);
                        all.append(delimiter);
                    }
                    String sqlText = all.toString();
                    this.setText(sqlText, this);
                }
                catch (Exception e) {
                    String msg;
                    PluginUtil pluginUtil = UiPlugin.getDefault().getPluginUtil();
                    String msg2 = pluginUtil.getString(IMPORT_PROBLEM, new Object[0]);
                    pluginUtil.log(4, (Throwable)e, msg2);
                    String dialogMessage = String.valueOf(msg2) + "\n" + e.getMessage();
                    this.displayError(shell, Util.getString(IMPORT_SQL_PROBLEM_DIALOG_TITLE, new Object[0]), dialogMessage);
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException e2) {
                        msg = Util.getString(IMPORT_PROBLEM, new Object[0]);
                        Util.log(4, (Throwable)e2, msg);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e3) {
                        msg = Util.getString(IMPORT_PROBLEM, new Object[0]);
                        Util.log(4, (Throwable)e3, msg);
                    }
                }
            }
            finally {
                String msg;
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException e) {
                    msg = Util.getString(IMPORT_PROBLEM, new Object[0]);
                    Util.log(4, (Throwable)e, msg);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    msg = Util.getString(IMPORT_PROBLEM, new Object[0]);
                    Util.log(4, (Throwable)e, msg);
                }
            }
        }
    }

    private void displayError(final Shell shell, final String dialogTitle, final String message) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)dialogTitle, (String)message);
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        this.captureCaretInfo();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.captureCaretInfo();
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.captureCaretInfo();
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.captureCaretInfo();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.captureCaretInfo();
    }

    public int getCaretYPosition() {
        return this.caretYPosition;
    }

    public int getCaretXPosition() {
        return this.caretXPosition;
    }

    public void setHasPendingChanges() {
        this.hasPendingChanges = true;
        this.setMessage(QUERY_CHANGES_PENDING_MESSAGE);
        this.fireEditorInternalEvent(1);
        this.fireEditorEvent();
    }

    public void setPanelType(int type) {
        this.panelType = type;
    }

    public int getPanelType() {
        return this.panelType;
    }

    class DocumentChangeListener
    implements IDocumentListener {
        DocumentChangeListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (SqlEditorPanel.this.validateSelected || SqlEditorPanel.this.isCompleteRefresh) {
                SqlEditorPanel.this.validateSelected = false;
                SqlEditorPanel.this.isCompleteRefresh = false;
                SqlEditorPanel.this.hasPendingChanges = false;
                SqlEditorPanel.this.savedSql = SqlEditorPanel.this.getText();
                SqlEditorPanel.this.fireEditorInternalEvent(0);
                SqlEditorPanel.this.fireEditorEvent();
            } else if (!SqlEditorPanel.this.hasPendingChanges) {
                String newSql = SqlEditorPanel.this.getText();
                boolean sqlChanged = this.hasSqlChanged(newSql.trim());
                SqlEditorPanel.this.savedSql = newSql;
                if (sqlChanged) {
                    SqlEditorPanel.this.setHasPendingChanges();
                }
            }
        }

        boolean hasSqlChanged(String newSql) {
            return TransformationHelper.stringsDifferent((String)newSql, (String)SqlEditorPanel.this.savedSql);
        }
    }
}

