/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors.sqleditor;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorInternalEvent;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.ImportFromFile;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.LaunchCriteriaBuilder;
import org.teiid.designer.transformation.ui.editors.sqleditor.actions.LaunchExpressionBuilder;
import org.teiid.designer.ui.common.util.UiUtil;

public class SqlEditorPanelWrapper
extends SqlEditorPanel
implements EventObjectListener {
    private SqlEditorPanel sepCurrentSqlEditorPanel;

    public SqlEditorPanelWrapper(Composite parent, QueryValidator queryValidator) {
        super(parent, queryValidator, 0);
    }

    public SqlEditorPanelWrapper(Composite parent, QueryValidator queryValidator, List actionList) {
        super(parent, queryValidator, 0, actionList);
    }

    public void setCurrentSqlEditorPanel(SqlEditorPanel sep) {
        if (this.sepCurrentSqlEditorPanel != null) {
            this.sepCurrentSqlEditorPanel.removeInternalEventListener(this);
        }
        this.sepCurrentSqlEditorPanel = sep;
        this.sepCurrentSqlEditorPanel.addInternalEventListener(this);
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SqlEditorPanelWrapper.this.refreshFontManager();
            }
        }, (boolean)true);
    }

    public void refreshFontManager() {
        if (this.getFontManager() != null) {
            this.getFontManager().setViewer(this.getCurrentSqlEditorPanel().getTextViewer());
            this.getFontManager().updateTextWidget();
        }
    }

    public SqlEditorPanel getCurrentSqlEditorPanel() {
        return this.sepCurrentSqlEditorPanel;
    }

    @Override
    public boolean canUseCriteriaBuilder() {
        return this.getCurrentSqlEditorPanel().canUseCriteriaBuilder();
    }

    @Override
    public void showCriteriaBuilder() {
        this.getCurrentSqlEditorPanel().showCriteriaBuilder();
    }

    @Override
    public boolean canUseExpressionBuilder() {
        return this.getCurrentSqlEditorPanel().canUseExpressionBuilder();
    }

    @Override
    public boolean canOptimize() {
        SqlEditorPanel sqlPanel = this.getCurrentSqlEditorPanel();
        return sqlPanel.canOptimize();
    }

    @Override
    public boolean isOptimizerOn() {
        return this.getCurrentSqlEditorPanel().isOptimizerOn();
    }

    @Override
    public void setOptimizerOn(boolean onStatus) {
        this.getCurrentSqlEditorPanel().setOptimizerOn(onStatus);
    }

    @Override
    public void showExpressionBuilder() {
        this.getCurrentSqlEditorPanel().showExpressionBuilder();
    }

    @Override
    public void showMessageArea(boolean show) {
        if (this.getCurrentSqlEditorPanel() != null) {
            this.getCurrentSqlEditorPanel().showMessageArea(show);
        }
    }

    @Override
    public boolean isMessageAreaVisible() {
        return this.getCurrentSqlEditorPanel().isMessageAreaVisible();
    }

    @Override
    public void validate() {
        this.getCurrentSqlEditorPanel().validate();
    }

    @Override
    public boolean isEditable() {
        return this.getCurrentSqlEditorPanel().isEditable();
    }

    @Override
    public boolean isParsable() {
        return this.getCurrentSqlEditorPanel().isParsable();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.getCurrentSqlEditorPanel().hasPendingChanges();
    }

    @Override
    public boolean canExpandCurrentSelect() {
        return this.getCurrentSqlEditorPanel().canExpandCurrentSelect();
    }

    @Override
    public void expandCurrentSelect() {
        this.getCurrentSqlEditorPanel().expandCurrentSelect();
    }

    @Override
    public void exportToFile() {
        this.getCurrentSqlEditorPanel().exportToFile();
    }

    @Override
    public void importFromFile() {
        this.getCurrentSqlEditorPanel().importFromFile();
    }

    @Override
    public void setMessage(String messageText) {
        this.getCurrentSqlEditorPanel().setMessage(messageText);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propStr = e.getProperty();
        if (propStr != null && (propStr.equals("startClausesOnNewLine") || propStr.equals("indentClauseContent")) && !this.isDisposed() && this.isVisible()) {
            this.getCurrentSqlEditorPanel().setText(this.getCurrentSqlEditorPanel().getText());
        }
    }

    public void processEvent(EventObject e) {
        if (e instanceof SqlEditorInternalEvent) {
            this.fireEditorInternalEvent(((SqlEditorInternalEvent)e).getType());
        }
    }

    public void updateReadOnlyState(boolean isReadOnly) {
        if (this.getLaunchCriteriaBuilderAction() != null) {
            this.getLaunchCriteriaBuilderAction().setEnabled(!isReadOnly);
        }
        if (this.getLaunchExpressionBuilderAction() != null) {
            this.getLaunchExpressionBuilderAction().setEnabled(!isReadOnly);
        }
        if (this.getImportFromFileAction() != null) {
            this.getImportFromFileAction().setEnabled(!isReadOnly);
        }
    }

    private LaunchCriteriaBuilder getLaunchCriteriaBuilderAction() {
        Iterator<IAction> iter = this.getActions().iterator();
        IAction nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof LaunchCriteriaBuilder)) continue;
            return (LaunchCriteriaBuilder)nextObj;
        }
        return null;
    }

    private LaunchExpressionBuilder getLaunchExpressionBuilderAction() {
        Iterator<IAction> iter = this.getActions().iterator();
        IAction nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof LaunchExpressionBuilder)) continue;
            return (LaunchExpressionBuilder)nextObj;
        }
        return null;
    }

    private ImportFromFile getImportFromFileAction() {
        Iterator<IAction> iter = this.getActions().iterator();
        IAction nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof ImportFromFile)) continue;
            return (ImportFromFile)nextObj;
        }
        return null;
    }
}

