/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors.sqleditor;

import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.query.ui.sqleditor.sql.SqlAutoIndentStrategy;
import org.teiid.query.ui.sqleditor.sql.SqlCodeScanner;
import org.teiid.query.ui.sqleditor.sql.SqlCompletionProcessor;
import org.teiid.query.ui.sqleditor.sql.SqlDoubleClickStrategy;
import org.teiid.query.ui.sqleditor.sql.SqlTextHover;
import org.teiid.query.ui.sqleditor.sql.SqlWordStrategy;

public class SqlSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ColorManager colorManager;

    public SqlSourceViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SqlCompletionProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SqlCompletionProcessor(), "sql_code");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        assistant.setContextInformationPopupBackground(this.colorManager.getColor(new RGB(0, 191, 255)));
        return assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SqlDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        SqlCodeScanner scanner = new SqlCodeScanner(this.colorManager);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        RuleBasedScanner multiLineScanner = new RuleBasedScanner();
        multiLineScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.MULTI_LINE_COMMENT))));
        dr = new DefaultDamagerRepairer((ITokenScanner)multiLineScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_code");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_code");
        return reconciler;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        SqlWordStrategy keyword = new SqlWordStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)keyword, "__dftl_partition_content_type");
        return formatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new SqlAutoIndentStrategy()};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SqlTextHover();
    }
}

