/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors.sqleditor.actions;

import java.util.EventObject;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorInternalEvent;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractAction;

public class ToggleOptimizer
extends AbstractAction
implements EventObjectListener {
    private SqlEditorPanel panel;
    private boolean allowOptimization = true;

    public ToggleOptimizer(SqlEditorPanel sqlPanel) {
        super((AbstractUiPlugin)UiPlugin.getDefault(), 2);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/short_names.gif"));
        this.panel = sqlPanel;
        this.setEnabled(true);
        boolean isOn = sqlPanel.isOptimizerOn();
        this.setChecked(isOn);
        sqlPanel.addInternalEventListener(this);
    }

    public void processEvent(EventObject e) {
        int type;
        if (this.allowOptimization && e instanceof SqlEditorInternalEvent && ((type = ((SqlEditorInternalEvent)e).getType()) == 6 || type == 1 || type == 0)) {
            boolean isOn = this.panel.isOptimizerOn();
            this.setChecked(isOn);
            if (this.panel.hasPendingChanges()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    protected void doRun() {
        if (this.allowOptimization) {
            boolean optimizerOn = this.panel.isOptimizerOn();
            this.panel.setOptimizerOn(!optimizerOn);
        }
    }

    public void setAllowOptimization(boolean theAllowOptimization) {
        this.allowOptimization = theAllowOptimization;
        this.setEnabled(this.allowOptimization);
    }
}

