/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.figure;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierFigure;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class TransformationDiagramFigure
extends FreeformLayer {
    private static final String TARGET_TITLE = "VIEW";
    private static final String SOURCES_TITLE = "SOURCES";
    private static final String SUID_LABEL = "suid";
    private static final String EMPTY_LABEL = "";
    private DiagramModelNode dNode;

    public TransformationDiagramFigure(DiagramModelNode dNode) {
        this.dNode = dNode;
        this.init();
    }

    private void init() {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setOpaque(true);
        RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.transformation.backgroundcolor");
        this.setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
    }

    protected void paintFigure(Graphics theGraphics) {
        super.paintFigure(theGraphics);
        if (this.dNode.getModelObject() == null) {
            return;
        }
        boolean doMorePainting = false;
        EObject modelObject = this.dNode.getModelObject();
        if (modelObject instanceof DiagramProxy && ((DiagramProxy)modelObject).getType() == "transformationDiagramType") {
            doMorePainting = true;
        } else {
            boolean bl = doMorePainting = !ModelObjectUtilities.isStale((EObject)this.dNode.getModelObject());
        }
        if (doMorePainting) {
            if (!TransformationDiagramUtil.isTreeLayout()) {
                this.paintBkgdAndTitles(theGraphics);
            }
            this.paintSuidAndAliasDecorators(theGraphics);
        }
    }

    private void paintBkgdAndTitles(Graphics theGraphics) {
        Font boldFont = ScaledFontManager.getFont((int)4);
        Dimension targetDim = FigureUtilities.getStringExtents((String)TARGET_TITLE, (Font)boldFont);
        int headerHeight = targetDim.height + 10;
        int targetTableWidth = this.getWidthOfTarget();
        int widthOfTargetPanel = targetTableWidth + 30 + 30;
        theGraphics.setForegroundColor(ColorConstants.black);
        theGraphics.setBackgroundColor(ColorConstants.cyan);
        theGraphics.fillRectangle(0, 0, widthOfTargetPanel, 3000);
        theGraphics.drawRectangle(0, 0, widthOfTargetPanel, 3000);
        theGraphics.drawRectangle(0, 0, 3000, headerHeight);
        theGraphics.setForegroundColor(ColorConstants.buttonDarker);
        int startingPoint = widthOfTargetPanel / 2 - targetDim.width / 2;
        theGraphics.setFont(boldFont);
        theGraphics.drawString(TARGET_TITLE, startingPoint, 7);
        startingPoint = widthOfTargetPanel + 30 + 30;
        theGraphics.drawString(SOURCES_TITLE, startingPoint, 7);
    }

    private int getWidthOfTarget() {
        int widthOfTarget = 0;
        DiagramModelNode thisDiagramNode = null;
        EObject targetOfDiagram = null;
        List childFigures = this.getChildren();
        Object nextObj2 = null;
        for (Object nextObj2 : childFigures) {
            if (nextObj2 instanceof UmlClassifierFigure) {
                thisDiagramNode = ((UmlClassifierFigure)nextObj2).getDiagramModelNode();
                if (targetOfDiagram == null) {
                    EObject modelObject;
                    Diagram diagram = thisDiagramNode.getDiagram();
                    if (diagram != null) {
                        targetOfDiagram = diagram.getTarget();
                    }
                    if ((modelObject = thisDiagramNode.getModelObject()) == targetOfDiagram) {
                        widthOfTarget = thisDiagramNode.getWidth();
                    }
                }
            }
            if (widthOfTarget > 0) break;
        }
        if (widthOfTarget < 10) {
            widthOfTarget = 10;
        }
        return widthOfTarget;
    }

    private void paintSuidAndAliasDecorators(Graphics theGraphics) {
        EObject tRoot;
        Diagram diagram = (Diagram)this.dNode.getModelObject();
        EObject virtualTable = diagram.getTarget();
        if (virtualTable != null && virtualTable.eResource() != null && (tRoot = TransformationHelper.getTransformationMappingRoot((EObject)virtualTable)) != null) {
            Point thePoint;
            Font smallFont;
            EObject targetTableEObject = TransformationHelper.getTransformationLinkTarget((EObject)tRoot);
            if (TransformationHelper.tableSupportsUpdate((EObject)targetTableEObject)) {
                smallFont = ScaledFontManager.getFont((int)-1);
                theGraphics.setFont(smallFont);
                theGraphics.setForegroundColor(ColorConstants.black);
                Dimension suidDim = FigureUtilities.getStringExtents((String)SUID_LABEL, (Font)smallFont);
                int strHeight = suidDim.height;
                List sources = TransformationHelper.getSourceEObjects((EObject)tRoot);
                if (!sources.isEmpty()) {
                    EObject nextSource2 = null;
                    DiagramModelNode sourceDNode = null;
                    String suidString = null;
                    for (EObject nextSource2 : sources) {
                        sourceDNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextSource2, (DiagramModelNode)this.dNode);
                        if (sourceDNode == null || (suidString = this.getSuidText(nextSource2, tRoot)) == null) continue;
                        thePoint = new Point(sourceDNode.getPosition());
                        thePoint.x += 5;
                        thePoint.y -= strHeight;
                        theGraphics.drawString(suidString, thePoint);
                    }
                }
                DiagramModelNode targetNode = DiagramUiUtilities.getDiagramModelNode((EObject)targetTableEObject, (DiagramModelNode)this.dNode);
                Point thePoint2 = new Point(targetNode.getPosition());
                thePoint2.x = thePoint2.x + targetNode.getWidth() - suidDim.width - 3;
                thePoint2.y -= strHeight;
                theGraphics.drawString(SUID_LABEL, thePoint2);
            }
            smallFont = ScaledFontManager.getFont((int)-1);
            theGraphics.setFont(smallFont);
            theGraphics.setForegroundColor(ColorConstants.black);
            List sources = TransformationHelper.getSourceEObjects((EObject)tRoot);
            if (!sources.isEmpty()) {
                EObject nextSource3 = null;
                DiagramModelNode sourceDNode = null;
                for (EObject nextSource3 : sources) {
                    List aliases;
                    sourceDNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextSource3, (DiagramModelNode)this.dNode);
                    if (sourceDNode == null || (aliases = TransformationHelper.getSqlAliasesForSource((Object)tRoot, (EObject)nextSource3)) == null || aliases.isEmpty() || aliases.size() <= 1) continue;
                    String aliasString = EMPTY_LABEL + aliases.size();
                    int strWidth = FigureUtilities.getStringExtents((String)aliasString, (Font)smallFont).width;
                    thePoint = new Point(sourceDNode.getPosition());
                    thePoint.x = thePoint.x - 2 - strWidth;
                    thePoint.y += 3;
                    theGraphics.drawString(aliasString, thePoint);
                }
            }
        }
    }

    private String getSuidText(EObject sourceEObject, EObject tRoot) {
        EObject targetTableEObject;
        String text = null;
        if (SqlAspectHelper.isTable((EObject)sourceEObject) && (targetTableEObject = TransformationHelper.getTransformationLinkTarget((EObject)tRoot)) != null && TransformationHelper.tableSupportsUpdate((EObject)targetTableEObject)) {
            text = "s";
            if (TransformationHelper.supportsUpdate((EObject)tRoot, (EObject)sourceEObject)) {
                text = String.valueOf(text) + "u";
            }
            if (TransformationHelper.supportsInsert((EObject)tRoot, (EObject)sourceEObject)) {
                text = String.valueOf(text) + "i";
            }
            if (TransformationHelper.supportsDelete((EObject)tRoot, (EObject)sourceEObject)) {
                text = String.valueOf(text) + "d";
            }
        }
        return text;
    }
}

