/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.figure;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigureFactory;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.NotationFigureGenerator;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.figure.TransformationDiagramFigure;
import org.teiid.designer.transformation.ui.figure.TransformationFigure;
import org.teiid.designer.transformation.ui.model.TransformationDiagramNode;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;

public class TransformationDiagramFigureFactory
extends AbstractDiagramFigureFactory
implements UiConstants {
    private static final int TRANSFORM = 1;
    private static final int TRANSFORM_DIAGRAM = 0;
    private static final int DEPENEDNCY_DIAGRAM = 2;

    public Figure createFigure(Object modelObject, String sNotationId) {
        Figure newFigure = null;
        switch (this.getObjectType(modelObject)) {
            case 0: 
            case 1: 
            case 2: {
                newFigure = this.createFigure(modelObject);
                break;
            }
            default: {
                NotationFigureGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getFigureGenerator(sNotationId);
                if (generator != null) {
                    newFigure = generator.createFigure(modelObject);
                    break;
                }
                ModelerCore.Util.log(4, Util.getString("DiagramErrors.figureGeneratorFailure", new Object[0]));
            }
        }
        return newFigure;
    }

    public Figure createFigure(Object modelObject) {
        Object newFigure = null;
        ColorPalette colorPalette = null;
        int objectType = this.getObjectType(modelObject);
        switch (objectType) {
            case 0: 
            case 2: {
                if (objectType == 2) {
                    newFigure = new FreeformLayer();
                    newFigure.setLayoutManager((LayoutManager)new FreeformLayout());
                    newFigure.setOpaque(true);
                    RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.dependency.backgroundcolor");
                    newFigure.setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
                    break;
                }
                newFigure = new TransformationDiagramFigure((DiagramModelNode)modelObject);
                break;
            }
            case 1: {
                TransformationNode tNode = (TransformationNode)((Object)modelObject);
                colorPalette = this.getColorPalette((DiagramModelNode)modelObject);
                newFigure = new TransformationFigure(tNode, "T", colorPalette);
                if (tNode.isUnion()) {
                    ((TransformationFigure)((Object)newFigure)).setSubscript("u");
                }
                if (!(modelObject instanceof DiagramModelNode)) break;
                DiagramModelNode node = (DiagramModelNode)modelObject;
                ((DiagramFigure)newFigure).setDiagramModelNode(node);
                if (node.hasErrors()) {
                    ((DiagramFigure)newFigure).updateForError(true);
                    break;
                }
                if (!node.hasWarnings()) break;
                ((DiagramFigure)newFigure).updateForWarning(true);
                break;
            }
        }
        return newFigure;
    }

    private int getObjectType(Object modelObject) {
        int objectType = -1;
        if (modelObject != null) {
            if (modelObject instanceof TransformationDiagramNode) {
                Diagram d = (Diagram)((TransformationDiagramNode)((Object)modelObject)).getModelObject();
                objectType = d.getType() != null && d.getType().equals("dependencyDiagramType") ? 2 : 0;
            } else if (modelObject instanceof TransformationNode) {
                objectType = 1;
            }
        }
        return objectType;
    }

    private ColorPalette getColorPalette(DiagramModelNode node) {
        return DiagramUiPlugin.getDiagramTypeManager().getDiagram("transformationDiagramType").getColorPaletteManager().getColorPalette(node.getModelObject());
    }
}

