/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.figure;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Font;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.XQueryTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.model.TransformationNode;

public class TransformationFigure
extends AbstractDiagramFigure {
    private ImageFigure transformationIcon;
    private Label subscript = new Label("u");
    private TransformationNode tNode = null;
    private ImageFigure errorIcon;
    private ImageFigure warningIcon;
    private int status = 0;

    public TransformationFigure(TransformationNode tNode, String name, ColorPalette colorPalette) {
        super(colorPalette);
        this.tNode = tNode;
        this.init(name);
        this.createComponent();
    }

    private void init(String name) {
        this.transformationIcon = this.isOnDependencyDiagram() ? (this.tNode.getModelObject() instanceof XQueryTransformationMappingRoot ? new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/Xtransformation_node.gif")) : new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/transformation_node.gif"))) : (this.tNode.getModelObject() instanceof XQueryTransformationMappingRoot ? new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/arrow_xtransformation_node.gif")) : new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/arrow_transformation_node.gif")));
        this.add((IFigure)this.transformationIcon);
        this.transformationIcon.setSize(this.transformationIcon.getPreferredSize());
        if (this.subscript != null) {
            this.subscript.setFont(DiagramUiUtilities.getToolTipFont());
            this.subscript.setForegroundColor(ColorConstants.black);
            this.subscript.setBackgroundColor(this.getBackgroundColor());
            this.setLabelSize(this.subscript);
        }
    }

    private void createComponent() {
        this.setInitialSize();
        this.layoutThisFigure(this.getSize());
    }

    private void setLabelSize(Label label) {
        Font theFont = label.getFont();
        int labelWidth = FigureUtilities.getTextExtents((String)label.getText(), (Font)theFont).width;
        if (label.getIcon() != null) {
            labelWidth += label.getIcon().getBounds().width;
        }
        int labelHeight = FigureUtilities.getTextExtents((String)label.getText(), (Font)theFont).height;
        label.setSize(labelWidth, labelHeight);
    }

    private void setInitialSize() {
        int maxWidth = 40;
        int maxHeight = 60;
        if (this.isOnDependencyDiagram()) {
            maxHeight = 40;
        }
        this.setSize(new Dimension(maxWidth, maxHeight));
    }

    private void layoutThisFigure(Dimension newSize) {
        int centerX = newSize.width / 2;
        int centerY = newSize.height / 2;
        if (this.getChildren().contains(this.subscript)) {
            if (this.isOnDependencyDiagram()) {
                this.subscript.setLocation(new Point(centerX + 3, centerY - 2));
            } else {
                this.subscript.setLocation(new Point(centerX + 7, centerY));
            }
        }
    }

    public void updateForSize(Dimension size) {
        this.layoutThisFigure(size);
        this.repaint();
    }

    public void layoutComponent() {
        this.layoutThisFigure(this.getSize());
    }

    public void updateSize() {
    }

    public IFigure getToolTip() {
        List<String> toolTips = this.tNode.getToolTipStrings();
        if (toolTips != null && !toolTips.isEmpty()) {
            super.setToolTip(super.createToolTip(toolTips));
        }
        return super.getToolTip();
    }

    public void setSubscript(String ss) {
        if (ss != null) {
            if (!this.getChildren().contains(this.subscript)) {
                if (this.subscript.getText() != null && !this.subscript.getText().equals(ss)) {
                    this.subscript.setText(ss);
                }
                this.add((IFigure)this.subscript);
            } else if (this.subscript.getText() != null && !this.subscript.getText().equals(ss)) {
                this.subscript.setText(ss);
            }
        } else if (this.getChildren().contains(this.subscript)) {
            this.remove((IFigure)this.subscript);
        }
        this.layoutComponent();
    }

    private boolean isOnDependencyDiagram() {
        Diagram diagram;
        return this.tNode != null && (diagram = this.tNode.getDiagram()) != null && diagram.getType() != null && diagram.getType().equals("dependencyDiagramType");
    }

    public void updateForError(boolean hasErrors) {
        if (hasErrors) {
            if (this.errorIcon == null) {
                this.updateTransformationIcon(4);
                this.errorIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/error_co.gif"));
                if (this.errorIcon != null) {
                    this.add((IFigure)this.errorIcon);
                    int centerX = this.getBounds().width / 2;
                    int centerY = this.getBounds().height / 2;
                    if (this.isOnDependencyDiagram()) {
                        this.errorIcon.setLocation(new Point(centerX - 11, centerY - 2));
                    } else {
                        this.errorIcon.setLocation(new Point(centerX - 7, centerY));
                    }
                    this.errorIcon.setSize(this.errorIcon.getPreferredSize());
                }
            }
            this.status = 4;
        } else if (this.errorIcon != null) {
            this.updateTransformationIcon(0);
            this.remove((IFigure)this.errorIcon);
            this.errorIcon = null;
            this.status = 0;
        }
    }

    public void updateForWarning(boolean hasWarnings) {
        if (hasWarnings) {
            if (this.warningIcon == null) {
                this.updateTransformationIcon(2);
                this.warningIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/warning_co.gif"));
                if (this.warningIcon != null) {
                    this.add((IFigure)this.warningIcon);
                    int centerX = this.getBounds().width / 2;
                    int centerY = this.getBounds().height / 2;
                    if (this.isOnDependencyDiagram()) {
                        this.warningIcon.setLocation(new Point(centerX - 3, centerY + 2));
                    } else {
                        this.warningIcon.setLocation(new Point(centerX - 7, centerY));
                    }
                    this.warningIcon.setSize(this.warningIcon.getPreferredSize());
                }
            }
            this.status = 2;
        } else if (this.warningIcon != null) {
            this.updateTransformationIcon(0);
            this.remove((IFigure)this.warningIcon);
            this.warningIcon = null;
            this.status = 0;
        }
    }

    private void updateTransformationIcon(int newStatus) {
        if (newStatus == this.status) {
            return;
        }
        this.remove((IFigure)this.transformationIcon);
        this.transformationIcon = this.isOnDependencyDiagram() ? (newStatus > 1 ? new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/transformation_node_red.gif")) : new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/transformation_node.gif"))) : (newStatus > 1 ? new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/arrow_transformation_node_red.gif")) : new ImageFigure(UiPlugin.getDefault().getImage("icons/full/cview20/arrow_transformation_node.gif")));
        this.add((IFigure)this.transformationIcon);
        this.transformationIcon.setSize(this.transformationIcon.getPreferredSize());
    }
}

