/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.layout.DefaultLayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutGroup;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutUtilities;
import org.teiid.designer.diagram.ui.layout.TreeLayout;
import org.teiid.designer.diagram.ui.layout.spring.SpringLayout;
import org.teiid.designer.diagram.ui.model.AbstractFreeDiagramModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.AbstractDefaultEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.AbstractFreeEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.DiagramXYLayoutEditPolicy;
import org.teiid.designer.diagram.ui.util.LassoDragTracker;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.part.TransformationDiagramLayout;
import org.teiid.designer.transformation.ui.part.TransformationEditPart;
import org.teiid.designer.ui.IDiagramTypeEditPart;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.query.ui.UiPlugin;

public class TransformationDiagramEditPart
extends AbstractDiagramEditPart
implements IPropertyChangeListener,
IDiagramTypeEditPart {
    static DragTracker m_dragTracker = null;
    private boolean isDependencyDiagram = false;
    private TransformationDiagramLayout diagramLayout = new TransformationDiagramLayout();
    private String sCurrentRouterStyle = "DiagramRouterStyles.fan.textid";

    protected IFigure createFigure() {
        Figure newFigure = this.getFigureFactory().createFigure(this.getModel());
        this.setCurrentDiagramFont(ScaledFontManager.getFont());
        if (this.getDiagramType() != null && this.getDiagramType().equals("dependencyDiagramType")) {
            this.isDependencyDiagram = true;
        }
        return newFigure;
    }

    private String getDiagramType() {
        return ((Diagram)((DiagramModelNode)this.getModel()).getModelObject()).getType();
    }

    protected void createEditPolicies() {
        this.setSelectablePart(false);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramXYLayoutEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (m_dragTracker == null) {
            m_dragTracker = new LassoDragTracker();
        }
        return m_dragTracker;
    }

    private boolean hasChildren() {
        return this.getViewer().getContents().getChildren().size() > 0;
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String prop = evt.getPropertyName();
        if (prop.equals("children")) {
            this.layout();
        }
        if (prop.equals("layout")) {
            this.layout();
        }
    }

    public void propertyChange(PropertyChangeEvent theEvent) {
        if (theEvent.getProperty().equals("treeDiagramLayout")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelEditorManager.open((EObject)TransformationDiagramEditPart.this.getModelObject(), (boolean)true);
                }
            });
        }
    }

    public void layout(boolean layoutChildren) {
        if (!this.hasChildren()) {
            return;
        }
        if (layoutChildren) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(layoutChildren);
            }
        }
        if (!((DiagramModelNode)this.getModel()).wasLayedOut() || this.isDependencyDiagram) {
            this.layout();
        } else {
            ((DiagramModelNode)this.getModel()).recoverObjectProperties();
        }
        ArrayList arylSourceConnections = new ArrayList();
        if (!arylSourceConnections.isEmpty()) {
            for (NodeConnectionModel ncmSourceConn : arylSourceConnections) {
                ncmSourceConn.setRouterStyle(this.sCurrentRouterStyle);
                ncmSourceConn.layout();
            }
        }
    }

    public void layout() {
        if (!this.hasChildren()) {
            return;
        }
        if (this.getDiagramType() != null && this.getDiagramType().equals("dependencyDiagramType")) {
            this.runDependencyLayout();
        } else {
            this.diagramLayout.setDiagramNode((DiagramModelNode)this.getModel());
            this.diagramLayout.run();
            this.getFigure().repaint();
        }
        this.updateAnchorsAndLinks();
    }

    private void runDependencyLayout() {
        EObject primaryVG = ((Diagram)((DiagramModelNode)this.getModel()).getModelObject()).getTarget();
        DiagramModelNode vgDiagramNode = DiagramUiUtilities.getDiagramModelNode((EObject)primaryVG, (DiagramModelNode)((DiagramModelNode)this.getModel()));
        ArrayList<Object> tNodesAndTables = new ArrayList<Object>();
        List allChildren = ((DiagramModelNode)this.getModel()).getChildren();
        Iterator iter = allChildren.iterator();
        Object nextNode = null;
        while (iter.hasNext()) {
            nextNode = iter.next();
            if (!(nextNode instanceof DiagramModelNode) || nextNode instanceof AbstractFreeDiagramModelNode) continue;
            tNodesAndTables.add(nextNode);
        }
        LayoutGroup layoutGroup = new LayoutGroup(tNodesAndTables);
        if (layoutGroup.getType() == 1) {
            DefaultLayoutNode rootNode = new DefaultLayoutNode(vgDiagramNode);
            TreeLayout layout = new TreeLayout(layoutGroup.getLayoutNodes(), 10, 10, 400, 400);
            layout.setRoot((LayoutNode)rootNode);
            layout.setOrientation(0);
            layout.setFixedSpacing(true);
            layout.setFixedXSpacing(100.0);
            layout.setFixedYSpacing(100.0);
            layout.setUseObjectsSizes(true);
            layout.run();
            layoutGroup.setFinalPositions();
        } else {
            LayoutUtilities.runColumnLayout((LayoutGroup)layoutGroup, (int)20);
            SpringLayout layout = new SpringLayout(layoutGroup.getLayoutNodes());
            layout.setAutoEdgeLength(true);
            layout.setStartLocation(20, 20);
            layout.setAutomaticSingleSpacing(true);
            layout.setSpecifyLayoutSize(true);
            layout.setEpsilon(0.2);
            layout.setHorizontalAlignment(0);
            layout.setUseObjectsSizes(false);
            layout.setVerticalAlignment(3);
            layout.setXSpacing(400.0);
            layout.setYSpacing(400.0);
            int size = (int)layout.getSizeEstimate();
            layout.setLayoutSize((double)(size * 2));
            layout.run();
            layoutGroup.setFinalPositions();
        }
    }

    private void updateAnchorsAndLinks() {
        EditPart canvasEditPart = this.getViewer().getContents();
        List canvasChildren = canvasEditPart.getChildren();
        Iterator iter = canvasChildren.iterator();
        EditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (EditPart)iter.next();
            if (!(nextEditPart instanceof DiagramEditPart) || nextEditPart instanceof AbstractFreeEditPart) continue;
            ((DiagramEditPart)nextEditPart).createOrUpdateAnchorsLocations(false);
            ((AbstractDefaultEditPart)nextEditPart).refreshAllLabels();
        }
    }

    public boolean hasConnections() {
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getSourceConnections().isEmpty() && nextEditPart.getTargetConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void refreshFont(boolean refreshChildren) {
        super.refreshFont(refreshChildren);
        if (this.hasChildren()) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(true);
            }
        }
    }

    protected void refreshVisuals() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (this.sCurrentRouterStyle.equals("DiagramRouterStyles.fan.textid")) {
            cLayer.setConnectionRouter((ConnectionRouter)new FanRouter());
        }
    }

    public DiagramEditPart getTransformEditPart() {
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (!(nextEditPart instanceof TransformationEditPart)) continue;
            return nextEditPart;
        }
        return null;
    }

    public DiagramModelNode getTargetOfTransform() {
        List sourceConnections;
        DiagramModelNode targetGroupNode = null;
        DiagramEditPart transformEP = this.getTransformEditPart();
        if (transformEP != null && (sourceConnections = transformEP.getSourceConnections()).size() == 1) {
            NodeConnectionEditPart sourceConnection = (NodeConnectionEditPart)sourceConnections.iterator().next();
            targetGroupNode = (DiagramModelNode)((NodeConnectionModel)sourceConnection.getModel()).getTargetNode();
        }
        return targetGroupNode;
    }

    public void updateForPreferences() {
        RGB currentBkgdColor = this.isDependencyDiagram ? PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.dependency.backgroundcolor") : PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.transformation.backgroundcolor");
        this.getFigure().setBackgroundColor(GlobalUiColorManager.getColor((RGB)currentBkgdColor));
        this.refreshFont(true);
        this.layout(false);
    }

    public void activate() {
        super.activate();
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

