/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.layout.DiagramLayout;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlPackageNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;

public class TransformationDiagramLayout
extends DiagramLayout {
    public static final int TOP_MARGIN = 50;
    public static final int LEFT_PANEL_LEFT_MARGIN = 30;
    public static final int LEFT_PANEL_RIGHT_MARGIN = 30;
    public static final int RIGHT_PANEL_LEFT_MARGIN = 30;
    public static final int TABLE_GAP = 20;
    private DiagramModelNode modelRoot = null;
    private DiagramModelNode transformationNode = null;
    private DiagramModelNode diagramModelNode = null;

    public TransformationDiagramLayout() {
    }

    public TransformationDiagramLayout(List newNodes) {
        super(newNodes);
    }

    public int run() {
        if (TransformationDiagramUtil.isTreeLayout()) {
            this.layoutInTree();
        } else {
            this.layoutInPanels();
        }
        return 0;
    }

    public void setDiagramNode(DiagramModelNode diagramModelNode) {
        this.clear();
        this.diagramModelNode = diagramModelNode;
        this.setTransformation(this.getTransformationNode());
        this.setRoot(this.getRootNode());
        this.setSourceNodes();
    }

    public void setRoot(DiagramModelNode rootNode) {
        this.modelRoot = rootNode;
    }

    public void setTransformation(DiagramModelNode transNode) {
        this.transformationNode = transNode;
    }

    private void layoutInPanels() {
        if (this.modelRoot == null) {
            return;
        }
        int rootX = 30;
        int rootY = 50;
        int transX = 0;
        int transY = 0;
        int stackX = 0;
        this.modelRoot.setPosition(new Point(rootX, rootY));
        transY = 50;
        transX = rootX + this.modelRoot.getWidth() + 30 - this.transformationNode.getWidth() / 2;
        this.transformationNode.setPosition(new Point(transX, transY));
        stackX = rootX + this.modelRoot.getWidth() + 30 + 30;
        if (this.getComponentCount() > 0) {
            DiagramModelNode[] nodeArray = this.getNodeArray();
            int currentX = stackX;
            int nNodes = nodeArray.length;
            int i = 0;
            while (i < nNodes) {
                DiagramModelNode next = nodeArray[i];
                next.setPosition(new Point(currentX, rootY));
                currentX += next.getSize().width + 20;
                ++i;
            }
        }
    }

    private void layoutInTree() {
        if (this.modelRoot == null) {
            return;
        }
        int rootX = 10;
        int rootY = 10;
        int transX = 0;
        int transY = 0;
        int stackX = 0;
        int minNodeWidth = 9999;
        int minNodeHeight = 9999;
        int maxNodeWidth = 0;
        int maxNodeHeight = 0;
        int stackHeight = 0;
        this.modelRoot.setPosition(new Point(rootX, rootY));
        transY = this.modelRoot.getY() + this.modelRoot.getHeight() / 2 - this.transformationNode.getHeight() / 2;
        this.transformationNode.setPosition(new Point(transX, transY));
        transX = rootX + this.modelRoot.getWidth() + 90;
        stackX = transX + this.transformationNode.getWidth() + 120;
        if (this.getComponentCount() > 0) {
            DiagramModelNode[] nodeArray = this.getNodeArray();
            int currentY = 50;
            int nNodes = nodeArray.length;
            int i = 0;
            while (i < nNodes) {
                DiagramModelNode next = nodeArray[i];
                maxNodeWidth = Math.max(next.getSize().width, maxNodeWidth);
                maxNodeHeight = Math.max(next.getSize().height, maxNodeHeight);
                minNodeWidth = Math.min(next.getSize().width, minNodeWidth);
                minNodeHeight = Math.min(next.getSize().height, minNodeHeight);
                currentY = stackHeight + 50;
                next.setPosition(new Point(stackX, currentY));
                stackHeight = stackHeight + next.getSize().height + 10;
                ++i;
            }
        }
        if (stackHeight >= this.modelRoot.getHeight()) {
            rootY = stackHeight / 2 - this.modelRoot.getHeight() / 2 + 10;
            this.modelRoot.setPosition(new Point(rootX, rootY));
        }
        transY = this.modelRoot.getY() + this.modelRoot.getHeight() / 2 - this.transformationNode.getHeight() / 2;
        this.transformationNode.setPosition(new Point(transX, transY));
    }

    private void setSourceNodes() {
        Iterator iter = this.getCurrentSourceNodes().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            this.add(nextNode);
        }
    }

    private DiagramModelNode getTransformationNode() {
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof TransformationNode)) continue;
            return nextNode;
        }
        return null;
    }

    private List getCurrentSourceNodes() {
        DiagramModelNode rootNode = this.getRootNode();
        ArrayList<DiagramModelNode> currentSourceNodes = new ArrayList<DiagramModelNode>();
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof UmlClassifierNode) && !(nextNode instanceof UmlPackageNode) || nextNode == rootNode) continue;
            currentSourceNodes.add(nextNode);
        }
        return currentSourceNodes;
    }

    private DiagramModelNode getRootNode() {
        EObject targetObject;
        DiagramModelNode root = null;
        DiagramModelNode transformationModelNode = this.getTransformationNode();
        Diagram diagram = transformationModelNode.getDiagram();
        if (diagram != null && (targetObject = diagram.getTarget()) != null) {
            root = DiagramUiUtilities.getDiagramModelNode((EObject)targetObject, (DiagramModelNode)transformationModelNode.getParent());
        }
        return root;
    }
}

