/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.part;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.ChopBoxAnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.notation.NotationPartGenerator;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPartFactory;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DropEditPartHelper;
import org.teiid.designer.diagram.ui.part.LabelEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.connection.TransformationAnchorManager;
import org.teiid.designer.transformation.ui.connection.TransformationLink;
import org.teiid.designer.transformation.ui.figure.TransformationDiagramFigureFactory;
import org.teiid.designer.transformation.ui.model.TransformationDiagramNode;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.ui.part.TransformationDiagramEditPart;
import org.teiid.designer.transformation.ui.part.TransformationDropEditPartHelper;
import org.teiid.designer.transformation.ui.part.TransformationEditPart;
import org.teiid.designer.transformation.ui.part.TransformationLinkEditPart;
import org.teiid.designer.transformation.util.TransformationHelper;

public class TransformationDiagramPartFactory
extends AbstractDiagramEditPartFactory
implements UiConstants {
    private DiagramFigureFactory figureFactory;
    private static final String diagramTypeId = "transformationDiagramType";

    public EditPart createEditPart(EditPart iContext, Object iModel) {
        Object transform;
        AbstractDiagramEditPart editPart = null;
        if (this.figureFactory == null) {
            this.figureFactory = new TransformationDiagramFigureFactory();
        }
        if (iModel instanceof TransformationDiagramNode) {
            editPart = new TransformationDiagramEditPart();
            ((AbstractDiagramEditPart)editPart).setFigureFactory(this.figureFactory);
            transform = this.getTransformation(iModel);
            if (transform != null) {
                ((TransformationDiagramEditPart)editPart).setDropHelper(new TransformationDropEditPartHelper(transform));
            }
        } else if (iModel instanceof TransformationNode) {
            editPart = new TransformationEditPart(diagramTypeId);
            editPart.setFigureFactory(this.figureFactory);
            ((DiagramEditPart)editPart).setResizable(false);
            transform = this.getTransformation(iModel);
            if (transform != null) {
                ((TransformationEditPart)editPart).setDropHelper(new TransformationDropEditPartHelper(transform));
            }
        } else if (iModel instanceof LabelModelNode) {
            editPart = new LabelEditPart();
            ((DiagramEditPart)editPart).setResizable(false);
        } else if (iModel instanceof TransformationLink) {
            editPart = this.getConnectionEditPart(iModel);
        } else {
            NotationPartGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getEditPartGenerator(this.getNotationId());
            if (generator != null) {
                editPart = generator.createEditPart(iContext, iModel, diagramTypeId);
            } else {
                ModelerCore.Util.log(4, String.valueOf(Util.getString("DiagramErrors.partGeneratorFailure", new Object[0])) + " Model Object = " + iModel);
            }
        }
        if (editPart != null) {
            if (editPart instanceof UmlClassifierEditPart && (transform = this.getTransformation(iModel)) != null) {
                ((UmlClassifierEditPart)editPart).setDropHelper((DropEditPartHelper)new TransformationDropEditPartHelper(transform));
            }
            if (editPart instanceof NodeConnectionEditPart) {
                editPart.setModel(iModel);
                ((NodeConnectionEditPart)editPart).setSourceAndTarget(iContext);
            } else if (editPart instanceof DiagramEditPart) {
                editPart.setModel(iModel);
                ((DiagramEditPart)editPart).setNotationId(this.getNotationId());
                ((DiagramEditPart)editPart).setSelectionHandler(this.getSelectionHandler());
                ((DiagramEditPart)editPart).setDiagramTypeId(diagramTypeId);
            }
        } else {
            ModelerCore.Util.log(4, String.valueOf(Util.getString("DiagramErrors.editPartFailure", new Object[0])) + " Model Object = " + iModel);
        }
        if (editPart instanceof DiagramEditPart) {
            ((DiagramEditPart)editPart).setUnderConstruction(true);
        }
        return editPart;
    }

    public NodeConnectionEditPart getConnectionEditPart(Object iModel) {
        return new TransformationLinkEditPart();
    }

    public AnchorManager getAnchorManager(DiagramEditPart editPart) {
        if (editPart instanceof TransformationEditPart) {
            return new ChopBoxAnchorManager(editPart);
        }
        return new TransformationAnchorManager(editPart);
    }

    private Object getTransformation(Object iModel) {
        if (iModel instanceof TransformationDiagramNode) {
            Diagram diagram = (Diagram)((TransformationDiagramNode)((Object)iModel)).getModelObject();
            if (diagram != null) {
                return TransformationSourceManager.getTransformationFromDiagram(diagram);
            }
        } else {
            DiagramModelNode parentClassifierNode;
            if (iModel instanceof TransformationNode) {
                return ((TransformationNode)((Object)iModel)).getModelObject();
            }
            if (iModel instanceof UmlClassifierNode && (parentClassifierNode = DiagramUiUtilities.getClassifierParentNode((DiagramModelNode)((DiagramModelNode)iModel))) != null) {
                EObject diagramTransform;
                TransformationDiagramNode tdep;
                Diagram diagram;
                EObject thisTransform = null;
                if (TransformationHelper.isValidSqlTransformationTarget((Object)parentClassifierNode.getModelObject()) && (thisTransform = TransformationHelper.getTransformationMappingRoot((EObject)parentClassifierNode.getModelObject())) != null && (diagram = (Diagram)(tdep = (TransformationDiagramNode)parentClassifierNode.getParent()).getModelObject()) != null && (diagramTransform = TransformationSourceManager.getTransformationFromDiagram(diagram)) != null && diagramTransform.equals(thisTransform)) {
                    return thisTransform;
                }
            }
        }
        return null;
    }
}

