/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.EditableEditPart;
import org.teiid.designer.diagram.ui.util.HiliteDndNodeSelectionEditPolicy;
import org.teiid.designer.diagram.ui.util.SelectionTracker;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartEditPolicy;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.figure.TransformationFigure;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class TransformationEditPart
extends AbstractDiagramEditPart
implements EditableEditPart {
    private ChopboxAnchor singleAnchor;
    private DragTracker myDragTracker = null;

    public TransformationEditPart() {
    }

    public TransformationEditPart(String diagramTypeId) {
        this.setDiagramTypeId(diagramTypeId);
        this.init();
    }

    public void init() {
        if (this.getAnchorManager() == null) {
            this.setAnchorManager(this.getEditPartFactory().getAnchorManager((DiagramEditPart)this));
        }
    }

    protected IFigure createFigure() {
        Point location = new Point(100, 100);
        TransformationFigure transformFigure = (TransformationFigure)this.getFigureFactory().createFigure(this.getModel());
        transformFigure.setLocation(location);
        return transformFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HiliteDndNodeSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPartEditPolicy());
    }

    public void edit() {
        Diagram diagram;
        if (ModelEditorManager.canEdit((EObject)((DiagramModelNode)this.getModel()).getModelObject())) {
            ModelEditorManager.edit((EObject)((DiagramModelNode)this.getModel()).getModelObject());
        } else if (((DiagramModelNode)this.getModel()).getModelObject() != null && (diagram = ((DiagramModelNode)this.getModel()).getDiagram()) != null && diagram.getTarget() != null && TransformationHelper.isOperation((Object)diagram.getTarget())) {
            ModelEditorManager.edit((EObject)diagram.getTarget());
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.getSelectionHandler().handleDoubleClick(this.getModelObject());
        }
    }

    protected List getModelChildren() {
        List children = ((TransformationNode)((Object)this.getModel())).getChildren();
        return children;
    }

    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("size")) {
            this.resizeChildren();
        }
        super.propertyChange(evt);
        if (prop.equals("connection")) {
            this.refresh();
            this.createOrUpdateAnchorsLocations(true);
            this.refreshAllLabels();
        }
        if (prop.equals("location")) {
            ((DiagramModelNode)this.getModel()).updateAssociations();
        }
        if (prop.equals("subscript")) {
            ((TransformationFigure)this.getDiagramFigure()).setSubscript(((TransformationNode)((Object)this.getModel())).getSubscript());
            this.refreshVisuals();
        }
    }

    public void resizeChildren() {
        this.getDiagramFigure().updateForSize(((DiagramModelNode)this.getModel()).getSize());
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectionTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    public ConnectionAnchor getAnchor() {
        if (this.singleAnchor == null) {
            this.singleAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.singleAnchor;
    }

    protected List getModelSourceConnections() {
        return ((TransformationNode)((Object)this.getModel())).getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return ((TransformationNode)((Object)this.getModel())).getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getAnchor();
    }
}

