/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.BindingsTablePanel;

public class BindingCellModifier
implements ICellModifier {
    private BindingsTablePanel bindingsTablePanel;

    public BindingCellModifier(BindingsTablePanel bindingsTablePanel) {
        this.bindingsTablePanel = bindingsTablePanel;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.bindingsTablePanel.getColumnNames().indexOf(property);
        boolean result = false;
        switch (columnIndex) {
            case 0: {
                if (this.bindingsTablePanel.isTargetLocked()) break;
                result = true;
                break;
            }
            case 1: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.bindingsTablePanel.getColumnNames().indexOf(property);
        String result = null;
        Binding binding = (Binding)element;
        switch (columnIndex) {
            case 0: {
                result = binding.getCurrentAttrName();
                break;
            }
            case 1: {
                result = binding.getCurrentSymbol();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.bindingsTablePanel.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        Binding binding = (Binding)item.getData();
        switch (columnIndex) {
            case 0: {
                String currentName = binding.getCurrentAttrName();
                String newName = ((String)value).trim();
                if (newName == null || newName.length() <= 0 || currentName == null || currentName.equalsIgnoreCase(newName)) break;
                binding.setNewAttrName(newName);
                break;
            }
        }
        this.bindingsTablePanel.getBindingList().bindingChanged(binding);
    }
}

