/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.PluginConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;

public class BindingLabelProvider
extends ModelExplorerLabelProvider
implements ITableLabelProvider,
PluginConstants.Images {
    private boolean showDatatype = false;

    public BindingLabelProvider(boolean showDatatype) {
        this.showDatatype = showDatatype;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        Binding binding = (Binding)element;
        switch (columnIndex) {
            case 0: {
                result = binding.getAttributeText(this.showDatatype);
                break;
            }
            case 1: {
                result = binding.getSqlSymbolText(this.showDatatype);
                break;
            }
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        Binding binding = (Binding)element;
        switch (columnIndex) {
            case 0: {
                Object attr = binding.getAttribute();
                if (attr == null || !(attr instanceof EObject)) break;
                image = super.getImage(attr);
                break;
            }
            case 1: {
                IExpression sqlSymbol = binding.getCurrentSymbol();
                if (!(sqlSymbol instanceof IExpression)) break;
                image = this.getImageForSymbol(sqlSymbol);
                break;
            }
        }
        return image;
    }

    private Image getImageForSymbol(IExpression seSymbol) {
        Image result = null;
        if (seSymbol != null && seSymbol instanceof IAliasSymbol) {
            seSymbol = ((IAliasSymbol)seSymbol).getSymbol();
        }
        if (seSymbol instanceof IElementSymbol) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_symbol.gif");
        } else if (seSymbol instanceof IAggregateSymbol) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_function.gif");
        } else if (seSymbol instanceof IConstant) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_constant.gif");
        } else if (seSymbol instanceof IExpressionSymbol) {
            IExpression expression = ((IExpressionSymbol)seSymbol).getExpression();
            if (expression != null && expression instanceof IConstant) {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_constant.gif");
            } else if (expression != null && expression instanceof IFunction) {
                result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_function.gif");
            }
        }
        if (result == null) {
            result = UiPlugin.getDefault().getImage("icons/full/obj16/tn_undefined.gif");
        }
        return result;
    }
}

