/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.ColumnEntryDialog;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;

public class ColumnEntryPanel
extends Composite
implements ModifyListener {
    private static final int BUTTON_GRID_STYLE = 32;
    private static final String START_MESSAGE = UiConstants.Util.getString("ColumnEntryPanel.startMessage", new Object[0]);
    private static final String COLUMN_LABEL_TEXT = UiConstants.Util.getString("ColumnEntryPanel.columnLabel.text", new Object[0]);
    private static final String DATATYPE_LABEL_TEXT = UiConstants.Util.getString("ColumnEntryPanel.datatypeLabel.text", new Object[0]);
    private static final String SET_DATATYPE_BUTTON_TEXT = UiConstants.Util.getString("ColumnEntryPanel.setDatatypeButton.text", new Object[0]);
    private static final String NO_COLUMN_NAME_ENTERED = UiConstants.Util.getString("ColumnEntryPanel.noColumnNameEntered", new Object[0]);
    private static final String NO_DATATYPE_ENTERED = UiConstants.Util.getString("ColumnEntryPanel.noDatatypeSelected", new Object[0]);
    private static final String INVALID_COLUMN_NAME_ = UiConstants.Util.getString("ColumnEntryPanel.invalidColumnName", new Object[0]);
    private Text columnText;
    private Text datatypeText;
    private CLabel messageLabel;
    private EObject datatype;
    private int length = 0;
    private ColumnEntryDialog dlg;
    private Button datatypeButton;
    private RelationalStringNameValidator nameValidator;

    public ColumnEntryPanel(ColumnEntryDialog dlg, Composite parent) {
        super(parent, 0);
        this.dlg = dlg;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.setLayoutData(gridData);
        Label columnLabel = new Label((Composite)this, 0);
        columnLabel.setText(String.valueOf(COLUMN_LABEL_TEXT) + " ");
        GridData columnLabelGridData = new GridData(128);
        columnLabelGridData.horizontalSpan = 1;
        columnLabel.setLayoutData((Object)columnLabelGridData);
        this.columnText = WidgetFactory.createTextField((Composite)this);
        this.columnText.setTextLimit(50);
        this.columnText.addModifyListener((ModifyListener)this);
        GridData columnTextGridData = new GridData(768);
        columnTextGridData.horizontalSpan = 4;
        columnTextGridData.widthHint = 100;
        this.columnText.setLayoutData((Object)columnTextGridData);
        Label datatypeLabel = new Label((Composite)this, 0);
        datatypeLabel.setText(DATATYPE_LABEL_TEXT);
        GridData datatypeLabelGridData = new GridData(900);
        datatypeLabelGridData.horizontalSpan = 1;
        datatypeLabel.setLayoutData((Object)datatypeLabelGridData);
        this.datatypeText = WidgetFactory.createTextField((Composite)this);
        this.datatypeText.addModifyListener((ModifyListener)this);
        this.datatypeText.setEditable(false);
        GridData datatypeTextGridData = new GridData(768);
        datatypeTextGridData.horizontalSpan = 3;
        datatypeTextGridData.widthHint = 100;
        this.datatypeText.setLayoutData((Object)datatypeTextGridData);
        this.datatypeButton = WidgetFactory.createButton((Composite)this, (String)SET_DATATYPE_BUTTON_TEXT, (int)32);
        this.datatypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnEntryPanel.this.datatypeButtonPressed();
            }
        });
        this.messageLabel = WidgetFactory.createLabel((Composite)this);
        this.messageLabel.setText(START_MESSAGE);
        GridData messageData = new GridData(1808);
        messageData.grabExcessHorizontalSpace = true;
        messageData.grabExcessVerticalSpace = true;
        messageData.horizontalSpan = 3;
        this.messageLabel.setLayoutData((Object)messageData);
    }

    void datatypeButtonPressed() {
        Object[] result;
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(shell, null);
        boolean canSetLength = false;
        dialog.setEditLength(canSetLength);
        int status = dialog.open();
        if (status == 0 && (result = dialog.getResult()).length > 0) {
            if (canSetLength) {
                this.length = dialog.getLength();
            }
            this.datatype = (EObject)result[0];
            this.datatypeText.setText(ModelerCore.getModelEditor().getName(this.datatype));
        }
        this.validate();
    }

    public String getColumnName() {
        return this.columnText.getText();
    }

    private void validate() {
        String text = this.columnText.getText();
        if (text == null || text.trim().equals("")) {
            this.setError(NO_COLUMN_NAME_ENTERED);
            this.dlg.setOkEnabled(false);
        } else if (!this.isValidColumn(text)) {
            this.setError(INVALID_COLUMN_NAME_);
            this.dlg.setOkEnabled(false);
        } else if (this.datatype == null) {
            this.setError(NO_DATATYPE_ENTERED);
            this.dlg.setOkEnabled(false);
        } else {
            this.setError(null);
            this.dlg.setOkEnabled(true);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    private boolean isValidColumn(String text) {
        if (this.nameValidator == null) {
            this.nameValidator = new RelationalStringNameValidator();
        }
        return this.nameValidator.isValidName(text);
    }

    private void setError(String message) {
        if (this.messageLabel != null) {
            if (message == null) {
                this.messageLabel.setImage(null);
            } else {
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                this.messageLabel.setImage(image);
            }
            this.messageLabel.setText(message);
            this.messageLabel.redraw();
        }
    }

    public EObject getDatatype() {
        return this.datatype;
    }

    public int getLength() {
        return this.length;
    }
}

