/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.BindingList;
import org.teiid.designer.transformation.ui.reconciler.ColumnEntryDialog;
import org.teiid.designer.transformation.ui.reconciler.SqlList;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;

public class ReconcilerObject {
    private final String BIND_ATTRIBUTES_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.bindTheAttributes", new Object[0]);
    private final String HAS_UNMATCHED_SQL_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.hasUnmatchedSQL", new Object[0]);
    private final String HAS_UNBOUND_ATTRIBUTES_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.hasUnboundAttributes", new Object[0]);
    private final String HAS_TYPE_CONFLICTS_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.hasTypeConflicts", new Object[0]);
    private final String NO_SQL_PROJECTED_SYMBOLS_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.noSqlProjectedSymbols", new Object[0]);
    private final String IS_RECONCILED_MESSAGE = UiConstants.Util.getString("ReconcilerObject.statusMessage.isReconciled", new Object[0]);
    private final String NEW_COLUMN_DIALOG_TITLE = UiConstants.Util.getString("ReconcilerObject.newColumnDialog.title", new Object[0]);
    private EObject targetGroup;
    private boolean isTargetLocked = false;
    private BindingList bindingList = new BindingList();
    private SqlList sqlList = new SqlList();
    private ICommand originalCommand = null;
    private List originalSymbols = new ArrayList();
    private List originalInputParamSymbols = new ArrayList();
    private IQueryCommand modifiedCommand = null;
    private boolean sqlModifiable = true;
    private boolean isSelectDistinct = false;

    public ReconcilerObject(EObject targetGroup, ICommand originalCommand, boolean targetLocked) {
        this.originalCommand = originalCommand;
        this.targetGroup = targetGroup;
        this.isTargetLocked = targetLocked;
        this.init();
    }

    private void init() {
        if (this.originalCommand != null && this.originalCommand instanceof IQueryCommand) {
            this.sqlModifiable = true;
            this.modifiedCommand = (IQueryCommand)this.originalCommand.clone();
            this.originalSymbols.addAll(CommandHelper.getProjectedSymbols((ICommand)this.modifiedCommand));
            this.isSelectDistinct = this.isSelectDistinct((IQueryCommand)this.originalCommand);
        }
        List originalInputParams = TransformationSqlHelper.getProcedureInputParams((ICommand)this.originalCommand);
        for (ISPParameter param : originalInputParams) {
            IElementSymbol eSymbol = param.getParameterSymbol();
            this.originalInputParamSymbols.add(eSymbol);
        }
        List targetAttributes = TransformationHelper.getTargetAttributes((EObject)this.targetGroup);
        ArrayList<IExpression> workingSymbolList = new ArrayList<IExpression>(this.originalSymbols.size());
        workingSymbolList.addAll(this.originalSymbols);
        for (EObject attribute : targetAttributes) {
            String attrShortName = TransformationHelper.getSqlEObjectName((EObject)attribute);
            IExpression seSymbol = this.getSymbolWithShortName(attrShortName, workingSymbolList);
            if (seSymbol != null) {
                this.bindingList.add(new Binding(attribute, seSymbol));
                continue;
            }
            this.bindingList.add(new Binding(attribute));
        }
        if (!workingSymbolList.isEmpty()) {
            this.sqlList.addAll(workingSymbolList);
        }
    }

    private IExpression getSymbolWithShortName(String name, List<IExpression> workingSymbolList) {
        IExpression result = null;
        Iterator<IExpression> iter = workingSymbolList.iterator();
        while (iter.hasNext()) {
            IExpression seSymbol = iter.next();
            String symbolName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)seSymbol, (boolean)false);
            if (symbolName == null || !symbolName.equalsIgnoreCase(name)) continue;
            result = seSymbol;
            iter.remove();
            break;
        }
        return result;
    }

    public String getStatus() {
        boolean hasUnboundAttributes = this.hasUnboundBindings();
        boolean hasUnmatchedSQL = this.hasUnmatchedSQL();
        boolean hasTypeConflicts = this.hasTypeConflicts();
        String message = this.IS_RECONCILED_MESSAGE;
        if (!this.modifiedSqlHasProjectedSymbols()) {
            message = this.NO_SQL_PROJECTED_SYMBOLS_MESSAGE;
        } else if (hasUnmatchedSQL) {
            message = hasUnboundAttributes ? this.BIND_ATTRIBUTES_MESSAGE : this.HAS_UNMATCHED_SQL_MESSAGE;
        } else if (hasUnboundAttributes) {
            message = this.HAS_UNBOUND_ATTRIBUTES_MESSAGE;
        } else if (hasTypeConflicts) {
            message = this.HAS_TYPE_CONFLICTS_MESSAGE;
        }
        return message;
    }

    public int getStatusType() {
        int statusType = 0;
        boolean hasUnboundAttributes = this.hasUnboundBindings();
        boolean hasUnmatchedSQL = this.hasUnmatchedSQL();
        boolean hasTypeConflicts = this.hasTypeConflicts();
        boolean sqlHasProjectedSymbols = this.modifiedSqlHasProjectedSymbols();
        if (hasUnboundAttributes || hasUnmatchedSQL || hasTypeConflicts || !sqlHasProjectedSymbols) {
            statusType = 3;
        }
        return statusType;
    }

    public BindingList getBindingList() {
        return this.bindingList;
    }

    public SqlList getSqlList() {
        return this.sqlList;
    }

    public void refresh() {
        this.bindingList.refresh(true);
        this.sqlList.refresh(true);
        this.updateCommandFromBindings();
    }

    public String getOriginalSql() {
        return this.originalCommand.toString();
    }

    public void addBinding(Binding binding) {
        this.bindingList.add(binding);
        this.updateCommandFromBindings();
    }

    public void removeSymbol(IExpression symbol) {
        this.sqlList.remove(symbol);
        this.updateCommandFromBindings();
    }

    public void addSymbols(List symbols) {
        this.sqlList.addAll(symbols);
        this.updateCommandFromBindings();
    }

    public void removeSymbols(List symbols) {
        this.sqlList.removeAll(symbols);
        this.updateCommandFromBindings();
    }

    public boolean hasUnboundBindings() {
        boolean hasUnbound = false;
        List bindings = this.bindingList.getAll();
        for (Binding binding : bindings) {
            if (binding.isBound()) continue;
            hasUnbound = true;
            break;
        }
        return hasUnbound;
    }

    public boolean hasUnmatchedSQL() {
        return this.sqlList.size() > 0;
    }

    public boolean hasTypeConflicts() {
        return this.bindingList.hasTypeConflict();
    }

    public boolean hasTypeConflict(int index) {
        boolean hasConflict = false;
        if (index >= 0 && index < this.bindingList.size()) {
            Binding binding = this.bindingList.get(index);
            hasConflict = binding.hasTypeConflict();
        }
        return hasConflict;
    }

    public void unbind(List bindings) {
        ArrayList<IExpression> unboundSQL = new ArrayList<IExpression>(bindings.size());
        Iterator iter = bindings.iterator();
        Binding binding = null;
        while (iter.hasNext()) {
            binding = (Binding)iter.next();
            IExpression symbol = binding.getCurrentSymbol();
            if (symbol != null) {
                unboundSQL.add(symbol);
            }
            binding.setOriginalSymbol(null);
        }
        this.bindingList.refresh(true);
        this.addSymbols(unboundSQL);
    }

    public void bind(List bindings, List sqlSymbols) {
        Binding binding = null;
        IExpression sqlSymbol = null;
        if (bindings.size() == sqlSymbols.size()) {
            int i = 0;
            while (i < bindings.size()) {
                binding = (Binding)bindings.get(i);
                sqlSymbol = (IExpression)sqlSymbols.get(i);
                if (binding.getCurrentSymbol() == null) {
                    binding.setNewSymbol(sqlSymbol);
                }
                ++i;
            }
        }
        this.bindingList.refresh(true);
        this.removeSymbols(sqlSymbols);
    }

    public void createNewBindings(List<IExpression> sqlSymbols) {
        if (sqlSymbols != null && !sqlSymbols.isEmpty()) {
            for (IExpression symbol : sqlSymbols) {
                String symbolShortName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)symbol, (boolean)false);
                if (this.bindingList.hasRemovedBindingMatch(symbolShortName)) {
                    Binding removedBinding = this.bindingList.getRemovedBindingMatch(symbolShortName);
                    removedBinding.setNewSymbol(symbol);
                    this.addBinding(removedBinding);
                } else {
                    Binding newBinding = new Binding(symbolShortName, symbol);
                    this.addBinding(newBinding);
                }
                this.removeSymbol(symbol);
            }
        } else {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            ColumnEntryDialog dialog = new ColumnEntryDialog(shell, this.NEW_COLUMN_DIALOG_TITLE);
            dialog.open();
            String newColumnName = dialog.getColumnName();
            EObject datatype = dialog.getDatatype();
            if (newColumnName != null) {
                Binding newBinding = new Binding(newColumnName);
                newBinding.setNewAttrDatatype(datatype);
                this.addBinding(newBinding);
            }
        }
    }

    public boolean shouldEnableBind(List selectedBindings, List selectedSymbols) {
        boolean bindEnabled = false;
        if (this.sqlModifiable) {
            int nBindings = selectedBindings.size();
            int nSymbols = selectedSymbols.size();
            if (nBindings > 0 && nSymbols > 0 && nBindings == nSymbols) {
                bindEnabled = true;
                for (Binding binding : selectedBindings) {
                    if (binding.getCurrentSymbol() == null) continue;
                    bindEnabled = false;
                    break;
                }
            }
        }
        return bindEnabled;
    }

    public boolean shouldEnableUnbind(List selectedBindings) {
        boolean unbindEnabled = false;
        if (this.sqlModifiable && selectedBindings.size() > 0) {
            for (Binding binding : selectedBindings) {
                if (binding.getCurrentSymbol() == null) continue;
                unbindEnabled = true;
                break;
            }
        }
        return unbindEnabled;
    }

    public boolean shouldEnableCreateNew(List selectedSymbols) {
        boolean enableCreate = false;
        if (selectedSymbols.size() > 0 && !this.isTargetLocked()) {
            enableCreate = true;
            Iterator iter = selectedSymbols.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        return enableCreate;
    }

    public boolean hasValidModifications() {
        boolean hasMods = false;
        if (this.hasValidSqlModifications() || this.hasTargetAttributesToDelete() || this.hasTargetAttributesToCreate() || this.hasTargetAttributesToRename() || this.hasTargetAttributeTypeMods()) {
            hasMods = true;
        }
        return hasMods;
    }

    public boolean hasValidSqlModifications() {
        boolean hasValidSqlMods = false;
        if (this.hasModifiedSql() && this.modifiedSqlHasProjectedSymbols()) {
            hasValidSqlMods = true;
        }
        return hasValidSqlMods;
    }

    public boolean hasModifiedSql() {
        boolean sqlModified = false;
        if (this.sqlModifiable && this.originalCommand != null && this.modifiedCommand != null) {
            String originalSQL = this.originalCommand.toString();
            String modifiedSQL = this.modifiedCommand.toString();
            if (this.originalCommand instanceof IQueryCommand && this.isSelectStar((IQueryCommand)this.originalCommand)) {
                originalSQL = this.expandSelectStar((IQueryCommand)this.originalCommand);
            }
            sqlModified = !modifiedSQL.equals(originalSQL);
        }
        return sqlModified;
    }

    public String getModifiedSql() {
        String sql = null;
        if (this.modifiedCommand != null) {
            sql = this.modifiedCommand.toString();
        }
        return sql;
    }

    public boolean modifiedSqlHasProjectedSymbols() {
        List symbolList;
        boolean hasSymbols = false;
        if (this.modifiedCommand != null && (symbolList = CommandHelper.getProjectedSymbols((ICommand)this.modifiedCommand)) != null && symbolList.size() > 0) {
            hasSymbols = true;
        }
        return hasSymbols;
    }

    public boolean isTargetLocked() {
        return this.isTargetLocked;
    }

    public boolean isInputParameterSymbol(IExpression symbol) {
        boolean isInputParamSymbol = false;
        if (this.originalInputParamSymbols.contains(symbol)) {
            isInputParamSymbol = true;
        }
        return isInputParamSymbol;
    }

    public void setTargetLocked(boolean shouldLock) {
        if (this.isTargetLocked != shouldLock) {
            this.isTargetLocked = shouldLock;
        }
    }

    private boolean isSelectStar(IQueryCommand queryCommand) {
        ISelect select;
        boolean isSelectStar = false;
        if (queryCommand != null && (select = queryCommand.getProjectedQuery().getSelect()) != null) {
            isSelectStar = select.isStar();
        }
        return isSelectStar;
    }

    private boolean isSelectDistinct(IQueryCommand queryCommand) {
        ISelect select;
        boolean isSelectDistinct = false;
        if (queryCommand != null && (select = queryCommand.getProjectedQuery().getSelect()) != null) {
            isSelectDistinct = select.isDistinct();
        }
        return isSelectDistinct;
    }

    private String expandSelectStar(IQueryCommand queryCommand) {
        IQueryCommand qComm = (IQueryCommand)queryCommand.clone();
        if (qComm != null) {
            ISelect select = queryCommand.getProjectedQuery().getSelect();
            boolean isDistinct = select.isDistinct();
            if (select.isStar()) {
                List symbols = CommandHelper.getProjectedSymbols((ICommand)queryCommand);
                IQueryService queryService = ModelerCore.getTeiidQueryService();
                IQueryFactory factory = queryService.createQueryFactory();
                ISelect newSelect = factory.createSelect(symbols);
                if (isDistinct) {
                    newSelect.setDistinct(isDistinct);
                }
                queryCommand.getProjectedQuery().setSelect(newSelect);
            }
        }
        return qComm.toString();
    }

    public boolean hasTargetAttributesToRename() {
        boolean hasNameChange = false;
        if (!this.isTargetLocked()) {
            for (Binding binding : this.bindingList.getAll()) {
                if (!binding.hasAttrNameModification()) continue;
                hasNameChange = true;
                break;
            }
        }
        return hasNameChange;
    }

    public void applyTargetAttributeRenames(Object txnSource) {
        if (!this.isTargetLocked()) {
            for (Binding binding : this.bindingList.getAll()) {
                if (!binding.hasAttrNameModification()) continue;
                binding.applyAttrNameModification(txnSource);
            }
        }
    }

    public boolean hasTargetAttributeTypeMods() {
        boolean hasTypeChange = false;
        if (!this.isTargetLocked()) {
            for (Binding binding : this.bindingList.getAll()) {
                if (!binding.hasAttrTypeModification()) continue;
                hasTypeChange = true;
                break;
            }
        }
        return hasTypeChange;
    }

    public void applyTargetAttributeTypeMods(Object txnSource) {
        if (!this.isTargetLocked()) {
            for (Binding binding : this.bindingList.getAll()) {
                if (!binding.hasAttrTypeModification()) continue;
                binding.applyAttrTypeModification(txnSource);
            }
        }
    }

    public boolean hasTargetAttributesToCreate() {
        boolean hasNew = false;
        if (!this.isTargetLocked()) {
            for (Binding binding : this.bindingList.getAll()) {
                Object attr = binding.getAttribute();
                if (!(attr instanceof String)) continue;
                hasNew = true;
                break;
            }
        }
        return hasNew;
    }

    public List getTargetAttributeNamesToCreate() {
        if (this.isTargetLocked()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> newAttrNames = new ArrayList<Object>();
        for (Binding binding : this.bindingList.getAll()) {
            Object attr = binding.getAttribute();
            if (!(attr instanceof String)) continue;
            newAttrNames.add(attr);
        }
        return newAttrNames;
    }

    public Map getCreatedAttrLengthMap() {
        if (this.isTargetLocked()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Object, Integer> symbolLengthMap = new HashMap<Object, Integer>();
        for (Binding binding : this.bindingList.getAll()) {
            Object attr = binding.getAttribute();
            if (!(attr instanceof String)) continue;
            int length = binding.getCurrentSymbolLength();
            symbolLengthMap.put(attr, new Integer(length));
        }
        return symbolLengthMap;
    }

    public boolean hasTargetAttributesToDelete() {
        boolean hasDeleteAttr = false;
        if (!this.isTargetLocked()) {
            List deletedBindings = this.bindingList.getRemovedList();
            for (Binding binding : deletedBindings) {
                Object attr = binding.getAttribute();
                if (attr instanceof String) continue;
                hasDeleteAttr = true;
                break;
            }
        }
        return hasDeleteAttr;
    }

    public List getTargetAttributesToDelete() {
        ArrayList<Object> attrs = new ArrayList<Object>();
        if (!this.isTargetLocked()) {
            List deletedBindings = this.bindingList.getRemovedList();
            for (Binding binding : deletedBindings) {
                Object attr = binding.getAttribute();
                if (attr instanceof String) continue;
                attrs.add(attr);
            }
        }
        return attrs;
    }

    public void updateCommandFromBindings() {
        ArrayList<IExpression> unmatchedSymbols = new ArrayList<IExpression>();
        unmatchedSymbols.addAll(this.sqlList.getAll());
        ArrayList<IExpression> newSymbols = new ArrayList<IExpression>();
        for (Binding binding : this.bindingList.getAll()) {
            if (binding.isBound() && !binding.isInputParamBinding()) {
                IExpression symbol = binding.createBindingSymbol();
                if (this.isInputParameterSymbol(symbol)) continue;
                newSymbols.add(binding.createBindingSymbol());
                continue;
            }
            String attrName = binding.getCurrentAttrName();
            IExpression seSymbol = this.getSymbolWithShortName(attrName, unmatchedSymbols);
            if (seSymbol != null && !this.isInputParameterSymbol(seSymbol)) {
                newSymbols.add(seSymbol);
                continue;
            }
            if (unmatchedSymbols.isEmpty()) continue;
            seSymbol = (IExpression)unmatchedSymbols.get(0);
            if (seSymbol != null && !this.isInputParameterSymbol(seSymbol)) {
                newSymbols.add(seSymbol);
            }
            unmatchedSymbols.remove(0);
        }
        for (IExpression sym : unmatchedSymbols) {
            if (sym == null || this.isInputParameterSymbol(sym)) continue;
            newSymbols.add(sym);
        }
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        ISelect newSelect = factory.createSelect(newSymbols);
        if (this.isSelectDistinct) {
            newSelect.setDistinct(true);
        }
        if (this.modifiedCommand instanceof IQuery) {
            ((IQuery)this.modifiedCommand).setSelect(newSelect);
        } else if (this.modifiedCommand instanceof ISetQuery) {
            ((ISetQuery)this.modifiedCommand).getProjectedQuery().setSelect(newSelect);
        }
    }

    public List getOriginalSymbols() {
        return this.originalSymbols;
    }

    public ICommand getModifiedCommand() {
        return this.modifiedCommand;
    }

    public ICommand getOriginalCommand() {
        return this.originalCommand;
    }

    public Collection getUnreferencedGroupSymbols() {
        Collection allGroupSymbols = TransformationSqlHelper.getGroupSymbols((ICommand)this.originalCommand);
        ArrayList unreferencedGroupSymbols = new ArrayList(allGroupSymbols);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IElementCollectorVisitor elementCollectorVisitor = queryService.getElementCollectorVisitor(true);
        Collection referencedElementSymbols = elementCollectorVisitor.findElements((ILanguageObject)this.originalCommand, true);
        for (IExpression nextSymbol : referencedElementSymbols) {
            IGroupSymbol nextGS;
            if (nextSymbol instanceof IAliasSymbol) {
                IGroupSymbol nextGS2;
                IExpression theSymbol = ((IAliasSymbol)nextSymbol).getSymbol();
                if (!(theSymbol instanceof IElementSymbol) || !TransformationSqlHelper.containsGroupSymbol((Collection)allGroupSymbols, (IGroupSymbol)(nextGS2 = ((IElementSymbol)theSymbol).getGroupSymbol()))) continue;
                unreferencedGroupSymbols.remove(nextGS2);
                continue;
            }
            if (!(nextSymbol instanceof IElementSymbol) || !TransformationSqlHelper.containsGroupSymbol((Collection)allGroupSymbols, (IGroupSymbol)(nextGS = ((IElementSymbol)nextSymbol).getGroupSymbol()))) continue;
            unreferencedGroupSymbols.remove(nextGS);
        }
        return unreferencedGroupSymbols;
    }

    public Collection getReferencedGroupSymbols() {
        Collection allGroupSymbols = TransformationSqlHelper.getGroupSymbols((ICommand)this.originalCommand);
        ArrayList<IGroupSymbol> referencedGroupSymbols = new ArrayList<IGroupSymbol>(allGroupSymbols.size());
        for (IExpression nextSymbol : this.originalSymbols) {
            IGroupSymbol nextGS;
            if (nextSymbol instanceof IAliasSymbol) {
                IGroupSymbol nextGS2;
                IExpression theSymbol = ((IAliasSymbol)nextSymbol).getSymbol();
                if (!(theSymbol instanceof IElementSymbol) || TransformationSqlHelper.containsGroupSymbol(referencedGroupSymbols, (IGroupSymbol)(nextGS2 = ((IElementSymbol)theSymbol).getGroupSymbol()))) continue;
                referencedGroupSymbols.add(nextGS2);
                continue;
            }
            if (!(nextSymbol instanceof IElementSymbol) || TransformationSqlHelper.containsGroupSymbol(referencedGroupSymbols, (IGroupSymbol)(nextGS = ((IElementSymbol)nextSymbol).getGroupSymbol()))) continue;
            referencedGroupSymbols.add(nextGS);
        }
        return referencedGroupSymbols;
    }

    public List getAvailableElementSymbols() {
        ArrayList availableSymbolList = new ArrayList();
        Collection groupSymbols = TransformationSqlHelper.getGroupSymbols((ICommand)this.originalCommand);
        if (!groupSymbols.isEmpty()) {
            List extraGroupEObjects = TransformationSqlHelper.getGroupSymbolEObjects((Collection)groupSymbols);
            for (EObject nextGroup : extraGroupEObjects) {
                SqlAlias sqlAlias = TransformationFactory.eINSTANCE.createSqlAlias();
                sqlAlias.setAliasedObject(nextGroup);
                String aliasName = TransformationHelper.getSqlEObjectFullName((EObject)nextGroup);
                sqlAlias.setAlias(aliasName);
                List newElementSymbols = TransformationSqlHelper.createElemSymbols((SqlAlias)sqlAlias);
                if (newElementSymbols.isEmpty()) continue;
                availableSymbolList.addAll(newElementSymbols);
            }
        }
        return availableSymbolList;
    }
}

