/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.builder.ExpressionBuilder;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlDisplayPanel;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.BindingList;
import org.teiid.designer.transformation.ui.reconciler.BindingsTablePanel;
import org.teiid.designer.transformation.ui.reconciler.IBindingListViewer;
import org.teiid.designer.transformation.ui.reconciler.ISqlListViewer;
import org.teiid.designer.transformation.ui.reconciler.QueryReconcilerHelper;
import org.teiid.designer.transformation.ui.reconciler.ReconcilerDialog;
import org.teiid.designer.transformation.ui.reconciler.ReconcilerObject;
import org.teiid.designer.transformation.ui.reconciler.SqlList;
import org.teiid.designer.transformation.ui.reconciler.SqlTablePanel;
import org.teiid.designer.udf.IFunctionDescriptor;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.query.ui.builder.util.ElementViewerFactory;

public class ReconcilerPanel
extends SashForm
implements ISelectionChangedListener,
SelectionListener {
    private static final int BUTTON_GRID_STYLE = 320;
    private final String BIND_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.bindButton.text", new Object[0]);
    private final String UNBIND_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.unbindButton.text", new Object[0]);
    private final String NEW_ATTR_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.newAttrButton.text", new Object[0]);
    private final String SET_TO_NULL_BUTTON_TEXT = UiConstants.Util.getString("ReconcilerPanel.setToNullButton.text", new Object[0]);
    private final String SET_TO_EXPRESSION_BUTTON_TOOLTIP = UiConstants.Util.getString("ReconcilerPanel.setToExpressionButton.toolTip", new Object[0]);
    private final String SHOW_SQL_CHECKBOX_TEXT = UiConstants.Util.getString("ReconcilerPanel.showSqlCheckbox.text", new Object[0]);
    private final String QUERY_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.queryScope.text", new Object[0]);
    private final String UNION_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.unionScope.text", new Object[0]);
    private final String UNION_SEGMENT_SCOPE_TEXT = UiConstants.Util.getString("ReconcilerPanel.unionSegmentScope.text", new Object[0]);
    private final String DIALOG_STATUS_TITLE = UiConstants.Util.getString("ReconcilerPanel.statusTitle", new Object[0]);
    private final String EXPRESSION = "expr";
    private QueryReconcilerHelper reconcilerHelper;
    private ReconcilerObject reconcilerObject;
    private boolean isUnion = false;
    private List builderGroups = new ArrayList();
    private Composite controlsPanel;
    private BindingsTablePanel bindingsPanel;
    SqlTablePanel sqlListPanel;
    private boolean sqlShowing = true;
    private SqlDisplayPanel sqlDisplay;
    private ReconcilerDialog reconcilerDialog = null;
    private SashForm topSplitter;
    private Button showSqlCheckbox;
    private Button bindButton;
    private Button unbindButton;
    private Button newAttrButton;
    private Button nullButton;
    private Button expressionButton;
    private boolean isReadOnly = false;
    private Font fNewBoldFont;

    public ReconcilerPanel(Composite parent, ReconcilerDialog dialog, Object transformationObj, boolean isUnion, int unionQuerySegment, List builderGroups) {
        super(parent, 512);
        if (transformationObj instanceof SqlTransformationMappingRoot) {
            this.reconcilerHelper = new QueryReconcilerHelper((SqlTransformationMappingRoot)transformationObj, unionQuerySegment);
            this.reconcilerObject = this.reconcilerHelper.getReconcilerObject();
        }
        if (transformationObj instanceof EObject) {
            this.isReadOnly = ModelObjectUtilities.isReadOnly((EObject)((EObject)transformationObj));
        }
        this.isUnion = isUnion;
        this.reconcilerDialog = dialog;
        this.builderGroups.addAll(builderGroups);
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        this.createControlsPanel();
        this.createSqlDisplayPanel();
        int[] wts = new int[]{4, 1};
        this.setWeights(wts);
        if (this.reconcilerObject != null) {
            BindingList bList = this.reconcilerObject.getBindingList();
            SqlList sList = this.reconcilerObject.getSqlList();
            this.bindingsPanel.setBindingList(bList);
            this.sqlListPanel.setSqlList(sList);
            this.sqlListPanel.setAvailableSymbolNames(this.reconcilerObject.getAvailableElementSymbols());
            bList.addChangeListener(new BindingChangeHandler());
            sList.addChangeListener(new SqlChangeHandler());
        }
        this.bindingsPanel.selectFirstUnbound();
        this.sqlListPanel.selectIndex(0);
        this.setButtonStates();
        String sql = null;
        if (this.reconcilerObject != null) {
            sql = this.reconcilerObject.getModifiedSql();
        }
        this.setSqlDisplay(sql);
        this.reconcilerDialog.setTitle(this.DIALOG_STATUS_TITLE);
        this.updateMessageArea();
        this.bindingsPanel.setTargetLocked(this.reconcilerObject.isTargetLocked());
        this.bindingsPanel.setButtonStates();
        this.bindingsPanel.updateRowColors();
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean showSql = prefStore.getBoolean("transformation.ui.preference.showSqlDisplay");
        this.showSqlCheckbox.setSelection(showSql);
        this.showSqlArea(showSql);
        this.showSqlCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ReconcilerPanel.this.toggleSqlButtonPressed();
            }
        });
        this.bindingsPanel.addTableSelectionListener(this);
        this.sqlListPanel.addTableSelectionListener(this);
        this.bindingsPanel.addTargetLockedCheckboxListener(this);
        this.updateSqlAndMessageDisplay();
    }

    private void createControlsPanel() {
        this.topSplitter = new SashForm((Composite)this, 256);
        this.createBindingTablePanel(this.topSplitter);
        this.controlsPanel = new Composite((Composite)this.topSplitter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.controlsPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.controlsPanel.setLayoutData((Object)gridData);
        this.createBindButtonPanel();
        this.sqlListPanel = new SqlTablePanel(this.controlsPanel, this.isReadOnly);
        this.topSplitter.setWeights(new int[]{60, 40});
    }

    private void createBindingTablePanel(SashForm splitter) {
        boolean isPrimary = this.reconcilerHelper.isPrimarySelectClause();
        Composite panel = new Composite((Composite)splitter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginRight = 0;
        panel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gridData);
        Label lblSecondaryMessage = null;
        lblSecondaryMessage = this.isUnion ? (isPrimary ? WidgetFactory.createLabel((Composite)panel, (String)this.UNION_SCOPE_TEXT) : WidgetFactory.createLabel((Composite)panel, (String)this.UNION_SEGMENT_SCOPE_TEXT)) : WidgetFactory.createLabel((Composite)panel, (String)this.QUERY_SCOPE_TEXT);
        if (!isPrimary) {
            lblSecondaryMessage.setFont(this.getBoldFont(lblSecondaryMessage.getFont()));
        }
        this.bindingsPanel = new BindingsTablePanel(panel, this.isReadOnly);
        this.showSqlCheckbox = WidgetFactory.createCheckBox((Composite)panel, (String)this.SHOW_SQL_CHECKBOX_TEXT);
    }

    private Font getBoldFont(Font f) {
        if (this.fNewBoldFont == null) {
            FontData data = f.getFontData()[0];
            data.setStyle(1);
            this.fNewBoldFont = GlobalUiFontManager.getFont((FontData)data);
        }
        return this.fNewBoldFont;
    }

    private void updateMessageArea() {
        String message = this.reconcilerObject.getStatus();
        int statusType = this.reconcilerObject.getStatusType();
        if (statusType == 0 && this.reconcilerObject.hasValidModifications()) {
            message = String.valueOf(message) + "  Press OK to accept changes.";
        }
        this.reconcilerDialog.setMessage(message, statusType);
    }

    private void createBindButtonPanel() {
        Composite bindButtonPanel = new Composite(this.controlsPanel, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        bindButtonPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        bindButtonPanel.setLayoutData((Object)gridData);
        this.bindButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.BIND_BUTTON_TEXT, (int)320);
        this.bindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReconcilerPanel.this.bindButtonPressed();
            }
        });
        this.unbindButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.UNBIND_BUTTON_TEXT, (int)320);
        this.unbindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReconcilerPanel.this.unbindButtonPressed();
            }
        });
        this.newAttrButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.NEW_ATTR_BUTTON_TEXT, (int)320);
        this.newAttrButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReconcilerPanel.this.newAttributeButtonPressed();
            }
        });
        this.nullButton = WidgetFactory.createButton((Composite)bindButtonPanel, (String)this.SET_TO_NULL_BUTTON_TEXT, (int)320);
        this.nullButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReconcilerPanel.this.setToNullButtonPressed();
            }
        });
        this.expressionButton = WidgetFactory.createButton((Composite)bindButtonPanel, null, (int)320);
        this.expressionButton.setImage(UiPlugin.getDefault().getImage("icons/full/cview20/launch_expression_builder.gif"));
        this.expressionButton.setToolTipText(this.SET_TO_EXPRESSION_BUTTON_TOOLTIP);
        this.expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ReconcilerPanel.this.expressionButtonPressed();
            }
        });
    }

    private void createSqlDisplayPanel() {
        this.sqlDisplay = new SqlDisplayPanel((Composite)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.sqlDisplay.setLayoutData(gridData);
        if (this.reconcilerObject != null) {
            this.setSqlDisplay(this.reconcilerObject.getModifiedSql());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source.equals(this.bindingsPanel.getTableViewer())) {
            this.bindingsPanel.setButtonStates();
        } else if (source.equals(this.sqlListPanel.getTableViewer())) {
            this.sqlListPanel.setButtonStates();
            this.bindingsPanel.setButtonStates();
        }
        this.setButtonStates();
    }

    public void widgetSelected(SelectionEvent event) {
        boolean isLocked = this.bindingsPanel.isTargetLocked();
        this.reconcilerHelper.setTargetLocked(isLocked);
        this.setButtonStates();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void showSqlArea(boolean show) {
        if (show != this.sqlShowing) {
            if (show) {
                this.setMaximizedControl(null);
            } else {
                this.setMaximizedControl((Control)this.topSplitter);
            }
            this.sqlShowing = !this.sqlShowing;
        }
    }

    public boolean isSqlAreaVisible() {
        return this.sqlShowing;
    }

    private void setSqlDisplay(String sqlString) {
        if (sqlString != null) {
            this.sqlDisplay.setText(sqlString);
        } else {
            this.sqlDisplay.setText("");
        }
    }

    private void setButtonStates() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        List selectedSymbols = this.sqlListPanel.getSelectedSymbols();
        if (!this.isReadOnly) {
            this.bindButton.setEnabled(this.reconcilerObject.shouldEnableBind(selectedBindings, selectedSymbols));
            this.unbindButton.setEnabled(this.reconcilerObject.shouldEnableUnbind(selectedBindings));
            this.newAttrButton.setEnabled(true);
            this.nullButton.setEnabled(!selectedBindings.isEmpty());
            this.expressionButton.setEnabled(!selectedBindings.isEmpty());
        } else {
            this.bindButton.setEnabled(false);
            this.unbindButton.setEnabled(false);
            this.newAttrButton.setEnabled(false);
            this.nullButton.setEnabled(false);
            this.expressionButton.setEnabled(false);
        }
    }

    void bindButtonPressed() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        List selectedSymbols = this.sqlListPanel.getSelectedSymbols();
        Binding lastSelectedBinding = this.getLastBinding(selectedBindings);
        int lastSelectedIndex = this.getLastSymbolIndex(selectedSymbols);
        this.reconcilerObject.bind(selectedBindings, selectedSymbols);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.selectNextUnbound(lastSelectedBinding);
        this.sqlListPanel.selectIndex(lastSelectedIndex);
        this.bindingsPanel.updateRowColors();
        this.sqlListPanel.setButtonStates();
    }

    void unbindButtonPressed() {
        List selectedBindings = this.bindingsPanel.getSelectedBindings();
        Binding lastSelection = this.getLastBinding(selectedBindings);
        this.reconcilerObject.unbind(selectedBindings);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.selectNextBound(lastSelection);
        this.bindingsPanel.updateRowColors();
        this.sqlListPanel.setButtonStates();
    }

    void newAttributeButtonPressed() {
        List selectedSqlList = this.sqlListPanel.getSelectedSymbols();
        this.reconcilerObject.createNewBindings(selectedSqlList);
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
        this.bindingsPanel.updateRowColors();
    }

    private Binding getLastBinding(List bindings) {
        Binding last = null;
        if (bindings.size() > 0) {
            last = (Binding)bindings.get(bindings.size() - 1);
        }
        return last;
    }

    private int getLastSymbolIndex(List symbols) {
        SqlList sqlList = this.sqlListPanel.getSqlList();
        int indexOfLast = 0;
        if (sqlList.size() > 0) {
            IExpression symbol = sqlList.getSymbolAt(sqlList.size() - 1);
            indexOfLast = sqlList.indexOf(symbol);
        }
        return indexOfLast;
    }

    public boolean hasValidModifications() {
        return this.reconcilerObject.hasValidModifications();
    }

    public void applyAllModifications(int uIndex, Object txnSource) {
        this.reconcilerHelper.applyAllModifications(uIndex, txnSource);
    }

    public void applyPreModifications(Object txnSource) {
        this.reconcilerHelper.applyPreModifications(txnSource);
    }

    public boolean hasPreModifications() {
        return this.reconcilerHelper.hasPreModifications();
    }

    public String getModifiedSql() {
        return this.reconcilerObject.getModifiedSql();
    }

    void toggleSqlButtonPressed() {
        boolean isCurrentlyVisible = this.isSqlAreaVisible();
        this.showSqlArea(!isCurrentlyVisible);
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("transformation.ui.preference.showSqlDisplay", !isCurrentlyVisible);
        UiPlugin.getDefault().savePreferences();
    }

    void updateSqlAndMessageDisplay() {
        this.reconcilerObject.updateCommandFromBindings();
        String sql = this.reconcilerObject.getModifiedSql();
        this.setSqlDisplay(sql);
        this.updateMessageArea();
    }

    void setToNullButtonPressed() {
        if (this.reconcilerObject != null) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryFactory factory = queryService.createQueryFactory();
            List selectedBindings = this.bindingsPanel.getSelectedBindings();
            this.reconcilerObject.unbind(this.bindingsPanel.getSelectedBindings());
            ArrayList<IExpressionSymbol> symbolsList = new ArrayList<IExpressionSymbol>(selectedBindings.size());
            int i = 0;
            while (i < selectedBindings.size()) {
                IConstant nullConstant = factory.createConstant(null);
                IExpressionSymbol nullExpression = factory.createExpressionSymbol("expr", (IExpression)nullConstant);
                symbolsList.add(nullExpression);
                ++i;
            }
            this.reconcilerObject.bind(selectedBindings, symbolsList);
            this.bindingsPanel.updateRowColors();
        }
        this.bindingsPanel.getBindingList().refresh(true);
        this.setButtonStates();
    }

    private Shell getCurrentShell() {
        return UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    void expressionButtonPressed() {
        if (this.reconcilerObject != null) {
            if (!this.builderGroups.isEmpty()) {
                ElementViewerFactory.setViewerInput((Object)this.builderGroups);
            }
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getCurrentShell());
            expressionBuilder.create();
            List selBindings = this.bindingsPanel.getSelectedBindings();
            IExpression startingLO = null;
            if (selBindings.size() == 1) {
                IExpression expSymbol = null;
                IExpression symbol = ((Binding)selBindings.get(0)).getCurrentSymbol();
                if (symbol instanceof IAliasSymbol) {
                    expSymbol = ((IAliasSymbol)symbol).getSymbol();
                    if (expSymbol instanceof IExpressionSymbol) {
                        startingLO = ((IExpressionSymbol)expSymbol).getExpression();
                    }
                } else if (symbol instanceof IExpressionSymbol) {
                    startingLO = ((IExpressionSymbol)symbol).getExpression();
                }
            }
            expressionBuilder.setLanguageObject((ILanguageObject)startingLO);
            int status = expressionBuilder.open();
            if (status == 0) {
                boolean result;
                ILanguageObject langObj = expressionBuilder.getLanguageObject();
                if (langObj instanceof IFunction && !(result = this.syncFunction((IFunction)langObj))) {
                    return;
                }
                List selectedBindings = this.bindingsPanel.getSelectedBindings();
                this.reconcilerObject.unbind(this.bindingsPanel.getSelectedBindings());
                ArrayList<IExpressionSymbol> symbolsList = new ArrayList<IExpressionSymbol>(1);
                if (langObj != null && langObj instanceof IExpression) {
                    IQueryService queryService = ModelerCore.getTeiidQueryService();
                    IQueryFactory factory = queryService.createQueryFactory();
                    IExpressionSymbol newExpression = factory.createExpressionSymbol("expr", (IExpression)langObj);
                    symbolsList.add(newExpression);
                    this.reconcilerObject.bind(selectedBindings, symbolsList);
                    this.bindingsPanel.getBindingList().refresh(true);
                    this.bindingsPanel.updateRowColors();
                    this.setButtonStates();
                }
            }
        }
    }

    private boolean syncFunction(IFunction function) {
        IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
        String functionName = function.getName();
        IExpression[] args = function.getArgs();
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            if (args[i].getType() == null) {
                MessageDialog.openWarning((Shell)this.getCurrentShell(), (String)UiConstants.Util.getString("ReconcilerPanel.nestedFunctionTitle", new Object[0]), (String)UiConstants.Util.getString("ReconcilerPanel.nestedFunctionMessage", new Object[0]));
                return false;
            }
            types[i] = args[i].getType();
            ++i;
        }
        IFunctionDescriptor fd = functionLibrary.findFunction(functionName, types);
        if (fd != null) {
            function.setFunctionDescriptor(fd);
            function.setType(fd.getReturnType());
        }
        return true;
    }

    public void dispose() {
        if (this.fNewBoldFont != null && !this.fNewBoldFont.isDisposed()) {
            this.fNewBoldFont.dispose();
        }
        super.dispose();
    }

    public void preDispose() {
        if (this.hasValidModifications()) {
            this.sqlListPanel.preDispose(!this.isUnion);
        }
    }

    class BindingChangeHandler
    implements IBindingListViewer {
        BindingChangeHandler() {
        }

        @Override
        public void addBinding(Binding binding) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void insertBinding(Binding binding, int index) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void addBindings(Object[] bindings) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void removeBinding(Binding binding) {
            IExpression sqlSymbol = binding.getCurrentSymbol();
            if (sqlSymbol instanceof IExpression) {
                IExpression seSymbol = sqlSymbol;
                ReconcilerPanel.this.sqlListPanel.addSymbol(seSymbol);
            }
            ReconcilerPanel.this.sqlListPanel.selectIndex(0);
        }

        @Override
        public void removeBindings(Object[] bindings) {
            int i = 0;
            while (i < bindings.length) {
                Binding binding = (Binding)bindings[i];
                IExpression sqlSymbol = binding.getCurrentSymbol();
                if (sqlSymbol instanceof IExpression) {
                    IExpression seSymbol = sqlSymbol;
                    ReconcilerPanel.this.sqlListPanel.addSymbol(seSymbol);
                }
                ++i;
            }
            ReconcilerPanel.this.sqlListPanel.selectIndex(0);
        }

        @Override
        public void updateBinding(Binding binding) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void refresh(boolean updateLabels) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }
    }

    class SqlChangeHandler
    implements ISqlListViewer {
        SqlChangeHandler() {
        }

        @Override
        public void addSymbol(IExpression symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void insertSymbol(IExpression symbol, int index) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void addSymbols(Object[] symbols) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void removeSymbol(IExpression symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void removeSymbols(Object[] symbols) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void updateSymbol(IExpression symbol) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }

        @Override
        public void refresh(boolean updateLabels) {
            ReconcilerPanel.this.updateSqlAndMessageDisplay();
        }
    }
}

