/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.transformation.ui.reconciler.ISqlListViewer;
import org.teiid.designer.transformation.util.TransformationSqlHelper;

public class SqlList {
    private final int COUNT = 10;
    private List currentSymbolsList = new ArrayList(10);
    private Set<ISqlListViewer> changeListeners = new HashSet<ISqlListViewer>();

    public List getAll() {
        return this.currentSymbolsList;
    }

    public int size() {
        return this.currentSymbolsList.size();
    }

    public void add(IExpression symbol) {
        this.currentSymbolsList.add(this.currentSymbolsList.size(), symbol);
        Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().addSymbol(symbol);
        }
    }

    public boolean containsSymbol(IExpression singleSymbol) {
        return TransformationSqlHelper.containsElementSymbol((Collection)this.getAll(), (IExpression)singleSymbol);
    }

    public void addAll(List theseSymbols) {
        ArrayList<IExpression> addedSymbols = new ArrayList<IExpression>();
        for (IExpression nextSymbol : theseSymbols) {
            if (this.containsSymbol(nextSymbol)) continue;
            addedSymbols.add(nextSymbol);
        }
        if (!addedSymbols.isEmpty()) {
            this.currentSymbolsList.addAll(addedSymbols);
            Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().addSymbols(addedSymbols.toArray());
            }
        }
    }

    public void insert(IExpression symbol, int index) {
        this.currentSymbolsList.add(index, symbol);
        Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().insertSymbol(symbol, index);
        }
    }

    public void remove(IExpression symbol) {
        this.currentSymbolsList.remove(symbol);
        Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeSymbol(symbol);
        }
    }

    public void removeAll(List theseSymbols) {
        if (!theseSymbols.isEmpty()) {
            this.currentSymbolsList.removeAll(theseSymbols);
            Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().removeSymbols(theseSymbols.toArray());
            }
        }
    }

    public void symbolChanged(IExpression symbol) {
        Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateSymbol(symbol);
        }
    }

    public void refresh(boolean updateLabels) {
        Iterator<ISqlListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().refresh(updateLabels);
        }
    }

    public int indexOf(IExpression symbol) {
        return this.currentSymbolsList.indexOf(symbol);
    }

    public IExpression getSymbolAt(int index) {
        IExpression result = null;
        if (index >= 0 && index < this.currentSymbolsList.size()) {
            result = (IExpression)this.currentSymbolsList.get(index);
        }
        return result;
    }

    public IExpression getFirstSymbol() {
        IExpression result = null;
        if (this.currentSymbolsList.size() > 0) {
            result = (IExpression)this.currentSymbolsList.get(0);
        }
        return result;
    }

    public void removeChangeListener(ISqlListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(ISqlListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

