/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.reconciler.AddSqlSymbolsDialog;
import org.teiid.designer.transformation.ui.reconciler.ISqlListViewer;
import org.teiid.designer.transformation.ui.reconciler.SqlLabelProvider;
import org.teiid.designer.transformation.ui.reconciler.SqlList;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.table.TableSizeAdapter;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;

public class SqlTablePanel
extends Composite {
    static final int LABEL_GRID_STYLE = 32;
    private static final int BUTTON_GRID_STYLE = 64;
    private static final String SORT_BUTTON_TEXT = UiConstants.Util.getString("SqlTablePanel.sortButton.text", new Object[0]);
    private static final String UNSORT_BUTTON_TEXT = UiConstants.Util.getString("SqlTablePanel.unsortButton.text", new Object[0]);
    SqlList sqlList = new SqlList();
    private List originalSymbolNames;
    private List availableSymbolNames;
    private Table table;
    TableViewer tableViewer;
    private Button removeButton;
    private Button clearButton;
    private Button addButton;
    private Button sortButton;
    private boolean isReadOnly = false;
    private boolean bUseOriginalOrder = true;
    private ViewerSorter viewerSorter;

    public SqlTablePanel(Composite parent) {
        super(parent, 0);
        this.init();
    }

    public SqlTablePanel(Composite parent, boolean isReadOnly) {
        super(parent, 0);
        this.isReadOnly = isReadOnly;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        WidgetFactory.createLabel((Composite)this, (int)32, (int)1, (String)UiConstants.Util.getString("SqlTablePanel.sqlList.title", new Object[0]));
        this.createTable(this);
        this.createControlButtonPanel();
        this.setButtonStates();
    }

    private void createControlButtonPanel() {
        Composite buttonComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        buttonComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 4;
        GridData gridData = new GridData(64);
        buttonComposite.setLayoutData((Object)gridData);
        this.addButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UiConstants.Util.getString("SqlTablePanel.addButton.text", new Object[0]), (int)64);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SqlTablePanel.this.addButtonPressed();
            }
        });
        this.removeButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UiConstants.Util.getString("SqlTablePanel.removeSqlButton.text", new Object[0]), (int)64);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SqlTablePanel.this.removeSqlButtonPressed();
            }
        });
        this.clearButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UiConstants.Util.getString("SqlTablePanel.clearButton.text", new Object[0]), (int)64);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SqlTablePanel.this.clearButtonPressed();
            }
        });
        this.sortButton = WidgetFactory.createButton((Composite)buttonComposite, (String)SORT_BUTTON_TEXT, (int)64);
        this.sortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SqlTablePanel.this.sortButtonPressed();
            }
        });
        GridData gridData2 = (GridData)this.sortButton.getLayoutData();
        gridData2.widthHint = 45;
        this.sortButton.setLayoutData((Object)gridData2);
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        TableColumn column1 = new TableColumn(this.table, 16384, 0);
        column1.setText(UiConstants.Util.getString("SqlTablePanel.sqlList.column.text", new Object[0]));
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new SqlContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SqlLabelProvider());
        this.tableViewer.setInput((Object)this.sqlList);
        this.tableViewer.getTable().setHeaderVisible(false);
        this.createTableTooltipListeners(this.table);
        new TableSizeAdapter(this.table, 10);
    }

    private void createTableTooltipListeners(final Table table) {
        table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(SqlTablePanel.this.getShell(), 16384);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(SqlTablePanel.this.getShell().getDisplay().getSystemColor(28));
                        this.label.setBackground(SqlTablePanel.this.getShell().getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        Object data = item.getData();
                        String tipText = null;
                        if (data instanceof IExpression) {
                            IQueryService queryService = ModelerCore.getTeiidQueryService();
                            tipText = queryService.getSymbolName((IExpression)data);
                        }
                        if (tipText != null) {
                            this.label.setText(tipText);
                        }
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x + 10, pt.y + 10, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
    }

    void removeSqlButtonPressed() {
        List selections;
        int[] selectedIndices = this.table.getSelectionIndices();
        int lastIndex = 0;
        if (selectedIndices.length > 0) {
            lastIndex = selectedIndices[selectedIndices.length - 1];
        }
        if (!(selections = this.getSelectedSymbols()).isEmpty()) {
            this.sqlList.removeAll(selections);
        }
        this.selectIndex(lastIndex);
        this.setButtonStates();
    }

    void clearButtonPressed() {
        ArrayList contents = new ArrayList(this.sqlList.getAll());
        if (!contents.isEmpty()) {
            this.sqlList.removeAll(contents);
        }
        this.selectIndex(0);
        this.setButtonStates();
    }

    void addButtonPressed() {
        if (this.availableSymbolNames != null && !this.availableSymbolNames.isEmpty()) {
            AddSqlSymbolsDialog dialog = new AddSqlSymbolsDialog(this.getShell(), this.availableSymbolNames);
            int returnStatus = dialog.open();
            if (returnStatus == 1) {
                return;
            }
            List newSymbols = dialog.getSelectedSymbols();
            if (newSymbols != null && !newSymbols.isEmpty()) {
                int[] selectedIndices = this.table.getSelectionIndices();
                int lastIndex = 0;
                if (selectedIndices.length > 0) {
                    lastIndex = selectedIndices[selectedIndices.length - 1];
                }
                this.sqlList.addAll(newSymbols);
                this.selectIndex(lastIndex);
                this.setButtonStates();
            }
        }
    }

    void sortButtonPressed() {
        boolean bl = this.bUseOriginalOrder = !this.bUseOriginalOrder;
        if (this.bUseOriginalOrder) {
            this.tableViewer.setSorter(null);
        } else {
            this.tableViewer.setSorter(this.getViewerSorter());
        }
        this.setButtonStates();
    }

    private ViewerSorter getViewerSorter() {
        if (this.viewerSorter == null) {
            this.viewerSorter = new ViewerSorter();
        }
        return this.viewerSorter;
    }

    public void addTableSelectionListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void removeTableSelectionListener(ISelectionChangedListener listener) {
        this.tableViewer.removeSelectionChangedListener(listener);
    }

    public void setButtonStates() {
        boolean tableIsEmpty;
        this.removeButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.sortButton.setEnabled(true);
        if (this.isReadOnly) {
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.addButton.setEnabled(false);
            return;
        }
        boolean bl = tableIsEmpty = this.table.getItems() == null || this.table.getItems().length == 0;
        if (this.bUseOriginalOrder) {
            this.sortButton.setText(SORT_BUTTON_TEXT);
        } else {
            this.sortButton.setText(UNSORT_BUTTON_TEXT);
        }
        if (tableIsEmpty) {
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.sortButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(this.table.getSelectionIndices().length > 0);
        }
        if (this.availableSymbolNames == null || this.availableSymbolNames.isEmpty()) {
            this.addButton.setEnabled(false);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setSqlList(SqlList list) {
        this.sqlList = list;
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new SqlContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SqlLabelProvider());
        this.tableViewer.setInput((Object)this.sqlList);
        this.tableViewer.getTable().setHeaderVisible(false);
        this.originalSymbolNames = new ArrayList(list.size());
        int i = 0;
        while (i < list.size()) {
            IExpression sym = list.getSymbolAt(i);
            String shortName = TransformationSqlHelper.getSingleElementSymbolShortName((IExpression)sym, (boolean)false);
            this.originalSymbolNames.add(shortName);
            ++i;
        }
        this.setButtonStates();
    }

    public SqlList getSqlList() {
        return this.sqlList;
    }

    public List getSelectedSymbols() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        return selection.toList();
    }

    public void addSymbol(IExpression seSymbol) {
        if (!this.sqlList.containsSymbol(seSymbol)) {
            int index = this.getInsertIndex(seSymbol);
            this.sqlList.insert(seSymbol, index);
        }
    }

    private int getInsertIndex(IExpression seSymbol) {
        int index = this.sqlList.size();
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        String suppliedName = queryService.getSymbolShortName(seSymbol);
        int nSymbols = this.sqlList.size();
        int i = 0;
        while (i < nSymbols) {
            IExpression currentSymbol = this.sqlList.getSymbolAt(i);
            String symbolName = queryService.getSymbolShortName(currentSymbol);
            if (this.isStringBefore(suppliedName, symbolName, this.originalSymbolNames)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private boolean isStringBefore(String str1, String str2, List list) {
        if (this.containsIgnoreCase(list, str1) && this.containsIgnoreCase(list, str2)) {
            int str2Index;
            int str1Index = this.indexOfIgnoreCase(list, str1);
            return str1Index < (str2Index = this.indexOfIgnoreCase(list, str2));
        }
        return false;
    }

    private boolean containsIgnoreCase(Collection collection, String string) {
        if (string == null) {
            return false;
        }
        for (String collStr : collection) {
            if (collStr == null || !collStr.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private int indexOfIgnoreCase(List list, String string) {
        if (string == null || list == null) {
            return -1;
        }
        int nItems = list.size();
        int i = 0;
        while (i < nItems) {
            String listStr = (String)list.get(i);
            if (listStr != null && listStr.equalsIgnoreCase(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectIndex(int index) {
        IExpression nextSelection = this.sqlList.getSymbolAt(index);
        if (nextSelection == null) {
            nextSelection = this.sqlList.getFirstSymbol();
        }
        if (nextSelection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)nextSelection), true);
        }
        this.setButtonStates();
    }

    public List getAvailableSymbolNames() {
        return this.availableSymbolNames;
    }

    public void setAvailableSymbolNames(List availableSymbolNames) {
        this.availableSymbolNames = new ArrayList(availableSymbolNames);
        this.setButtonStates();
    }

    public void preDispose(boolean allowCreateAttributes) {
        if (!this.getSqlList().getAll().isEmpty()) {
            MyMessageDialog myDialog = new MyMessageDialog(this.getShell(), allowCreateAttributes);
            int result = myDialog.open();
            boolean createAttributes = myDialog.getCreateAttributesState();
            TransformationMappingHelper.setCreateTargetAttributes((boolean)createAttributes);
            if (result == 0) {
                this.clearButtonPressed();
            }
        }
    }

    class MyMessageDialog
    extends MessageDialog {
        public boolean createAttributesState;
        public boolean allowCreateAttributes;

        public MyMessageDialog(Shell theParentShell, boolean allowCreateAttributes) {
            super(theParentShell, UiConstants.Util.getString("SqlTablePanel.myMessageDialog.title", new Object[0]), null, UiConstants.Util.getString("SqlTablePanel.myMessageDialog.message", new Object[0]), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.createAttributesState = false;
            this.allowCreateAttributes = false;
            this.allowCreateAttributes = allowCreateAttributes;
        }

        protected Control createCustomArea(Composite theParent) {
            Group group = WidgetFactory.createGroup((Composite)theParent, (String)UiConstants.Util.getString("SqlTablePanel.myMessageDialog.groupTitle", new Object[0]), (int)1808);
            group.setLayoutData((Object)new GridData(1808));
            group.getBorderWidth();
            if (this.allowCreateAttributes) {
                String theText = UiConstants.Util.getString("SqlTablePanel.myMessageDialog.createAttributesMessage", new Object[0]);
                WidgetFactory.createLabel((Composite)group, (String)theText);
                final Button createAttributesOnExitButton = WidgetFactory.createButton((Composite)group, (String)UiConstants.Util.getString("SqlTablePanel.createAttributesOnExitButton.text", new Object[0]), (int)32, (int)1, (int)32);
                createAttributesOnExitButton.setSelection(false);
                createAttributesOnExitButton.setToolTipText(UiConstants.Util.getString("SqlTablePanel.createAttributesOnExitButton.toolTip", new Object[0]));
                createAttributesOnExitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        MyMessageDialog.this.createAttributesState = createAttributesOnExitButton.getSelection();
                    }
                });
            }
            return group;
        }

        public boolean getCreateAttributesState() {
            return this.createAttributesState;
        }
    }

    class SqlContentProvider
    implements IStructuredContentProvider,
    ISqlListViewer {
        SqlContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((SqlList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((SqlList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            SqlTablePanel.this.sqlList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return SqlTablePanel.this.sqlList.getAll().toArray();
        }

        @Override
        public void addSymbol(IExpression symbol) {
            if (SqlTablePanel.this.sqlList.containsSymbol(symbol)) {
                SqlTablePanel.this.tableViewer.add((Object)symbol);
            }
        }

        @Override
        public void insertSymbol(IExpression symbol, int index) {
            if (SqlTablePanel.this.sqlList.containsSymbol(symbol)) {
                SqlTablePanel.this.tableViewer.insert((Object)symbol, index);
            }
        }

        @Override
        public void addSymbols(Object[] symbols) {
            int i = 0;
            while (i < symbols.length) {
                this.addSymbol((IExpression)symbols[i]);
                ++i;
            }
        }

        @Override
        public void removeSymbol(IExpression symbol) {
            SqlTablePanel.this.tableViewer.remove((Object)symbol);
        }

        @Override
        public void removeSymbols(Object[] symbols) {
            SqlTablePanel.this.tableViewer.remove(symbols);
        }

        @Override
        public void updateSymbol(IExpression symbol) {
            SqlTablePanel.this.tableViewer.update((Object)symbol, null);
        }

        @Override
        public void refresh(boolean updateLabels) {
            SqlTablePanel.this.tableViewer.refresh(updateLabels);
        }
    }
}

