/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.search.TransformationSearchHelper;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.search.TransformationSearchDialog;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.tree.AbstractTreeContentProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.SelectModelObjectLabelProvider;

public class TransformationSearchPanel
extends Composite
implements ModifyListener {
    private static final int HISTORY_SIZE = 5;
    private static final String STAGING_TABLE_STR = "<Staging Table>";
    private static final String MAPPING_CLASS_STR = "<Mapping Class>";
    private static final String TABLE_STR = "<Table>";
    private static final String PROCEDURE_STR = "<Procedure>";
    private static final String SQL_MESSAGE_SUFFIX = String.valueOf(CoreStringUtil.Constants.SPACE) + TransformationSearchPanel.getString("TransformationSearchPanel.sqlMessageSuffix");
    private static final String SEARCH_STATUS = TransformationSearchPanel.getString("TransformationSearchPanel.searchStatus");
    private static final String RESULTS_TITLE = TransformationSearchPanel.getString("TransformationSearchPanel.resultsTitle");
    private static final String NO_SELECTION = TransformationSearchPanel.getString("TransformationSearchPanel.noSelection");
    private static final String SQL_TEXT = TransformationSearchPanel.getString("TransformationSearchPanel.sqlText");
    private static final String INPUT = TransformationSearchPanel.getString("TransformationSearchPanel.input");
    private static final String FIND = TransformationSearchPanel.getString("TransformationSearchPanel.find");
    private static final String CASE_SENSITIVE = TransformationSearchPanel.getString("TransformationSearchPanel.caseSensitive");
    private static final String PERFORM_SEARCH = TransformationSearchPanel.getString("TransformationSearchPanel.performSearch");
    private static final String NO_STRING_ENTERED = TransformationSearchPanel.getString("TransformationSearchPanel.noStringEntered");
    CLabel messageLabel;
    CLabel sqlMessageLabel;
    private Combo fFindField;
    private List fFindHistory;
    Button fCaseCheckBox;
    private Button performSearchButton;
    private TreeViewer searchResultsTreeViewer;
    private TextViewer sqlTextViewer;
    Group sqlTextPanel;
    private IDocument sqlDocument;
    private ColorManager colorManager;
    TransformationSearchHelper searchHelper;
    TransformationSearchDialog parentDialog;
    private Collection lastResults = Collections.EMPTY_LIST;
    private String lastSearchString = "";
    EObject lastSelectedTarget;

    private static String getString(String id) {
        return UiConstants.Util.getString(id, new Object[0]);
    }

    private static String getString(String id, Object value1) {
        return UiConstants.Util.getString(id, value1);
    }

    private static String getString(String id, Object value1, Object value2) {
        return UiConstants.Util.getString(id, new Object[]{value1, value2});
    }

    public TransformationSearchPanel(Composite parent, TransformationSearchDialog dialog) {
        super(parent, 0);
        this.parentDialog = dialog;
        this.init();
    }

    private void init() {
        this.fFindHistory = new ArrayList(4);
        this.searchHelper = new TransformationSearchHelper();
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.createInputPanel(this);
        Group searchMessagePanel = WidgetFactory.createGroup((Composite)this, (String)SEARCH_STATUS, (int)4);
        GridData panelGD = new GridData(768);
        panelGD.grabExcessHorizontalSpace = true;
        searchMessagePanel.setLayoutData((Object)panelGD);
        this.messageLabel = WidgetFactory.createLabel((Composite)searchMessagePanel, (int)4);
        this.messageLabel.setText(" ");
        GridData messageLabelGridData = new GridData();
        messageLabelGridData.horizontalAlignment = 4;
        messageLabelGridData.verticalAlignment = 4;
        messageLabelGridData.grabExcessHorizontalSpace = true;
        this.messageLabel.setLayoutData((Object)messageLabelGridData);
        Group searchResultsPanel = WidgetFactory.createGroup((Composite)this, (String)RESULTS_TITLE, (int)4);
        searchResultsPanel.setLayoutData((Object)new GridData(1808));
        this.sqlMessageLabel = WidgetFactory.createLabel((Composite)searchResultsPanel, (int)4);
        this.sqlMessageLabel.setText("No Search Results");
        GridData sqlMessageLabelGridData = new GridData();
        sqlMessageLabelGridData.horizontalAlignment = 4;
        sqlMessageLabelGridData.verticalAlignment = 4;
        sqlMessageLabelGridData.grabExcessHorizontalSpace = true;
        this.sqlMessageLabel.setLayoutData((Object)sqlMessageLabelGridData);
        this.searchResultsTreeViewer = this.createResultsTreeViewer((Composite)searchResultsPanel);
        this.searchResultsTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.searchResultsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                StructuredSelection selection = (StructuredSelection)theEvent.getSelection();
                if (selection.getFirstElement() instanceof EObject || selection.getFirstElement() instanceof SUIDObject) {
                    TransformationSearchPanel.this.setSqlText(selection.getFirstElement());
                } else {
                    TransformationSearchPanel.this.setSqlText(null);
                }
            }
        });
        this.fFindField.removeModifyListener((ModifyListener)this);
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener((ModifyListener)this);
        this.sqlTextPanel = WidgetFactory.createGroup((Composite)this, (String)SQL_TEXT, (int)4);
        GridData pnlGD = new GridData(1808);
        pnlGD.grabExcessHorizontalSpace = true;
        this.sqlTextPanel.setLayoutData((Object)pnlGD);
        this.colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)this.sqlTextPanel, (IVerticalRuler)new VerticalRuler(0), styles, this.colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput((Object)this.sqlDocument);
        this.sqlTextViewer.getTextWidget().setBackground(Display.getCurrent().getSystemColor(19));
        this.sqlTextViewer.setEditable(false);
        this.sqlDocument.set("");
        this.sqlTextViewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    void setSqlText(Object obj) {
        String text = "";
        String sqlMessage = "";
        if (obj != null) {
            SUIDObject suidObj;
            SqlTransformationMappingRoot tRoot;
            if (obj instanceof EObject) {
                SqlTransformationMappingRoot tRoot2 = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)((EObject)obj));
                if (tRoot2 != null) {
                    text = TransformationSearchHelper.getUserSql((SqlTransformationMappingRoot)tRoot2, (int)0);
                    sqlMessage = "SELECT" + SQL_MESSAGE_SUFFIX;
                }
            } else if (obj instanceof SUIDObject && (tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)(suidObj = (SUIDObject)obj).getParent())) != null) {
                text = TransformationSearchHelper.getUserSql((SqlTransformationMappingRoot)tRoot, (int)suidObj.getSqlType());
                sqlMessage = String.valueOf(suidObj.getLabel()) + SQL_MESSAGE_SUFFIX;
            }
        } else {
            sqlMessage = NO_SELECTION;
        }
        this.sqlTextViewer.getDocument().set(text);
        this.setSqlGroupMessage(sqlMessage);
    }

    private Composite createInputPanel(Composite parent) {
        Group panel = WidgetFactory.createGroup((Composite)parent, (String)INPUT, (int)4, (int)1, (int)2);
        panel.setSize(300, 400);
        GridData panelGD = new GridData(768);
        panelGD.grabExcessHorizontalSpace = true;
        panel.setLayoutData((Object)panelGD);
        Label findLabel = new Label((Composite)panel, 16384);
        findLabel.setText(FIND);
        this.setGridData((Control)findLabel, 1, false, 2, false);
        this.fFindField = new Combo((Composite)panel, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 2, false);
        this.fFindField.addModifyListener((ModifyListener)this);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransformationSearchPanel.this.searchHelper.setCaseSensitive(TransformationSearchPanel.this.fCaseCheckBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TransformationSearchPanel.this.searchHelper.setCaseSensitive(TransformationSearchPanel.this.fCaseCheckBox.getSelection());
            }
        };
        this.fCaseCheckBox = WidgetFactory.createButton((Composite)panel, (String)CASE_SENSITIVE, (int)1, (int)2, (int)16416);
        this.fCaseCheckBox.setSelection(false);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.performSearchButton = WidgetFactory.createButton((Composite)parent, (String)PERFORM_SEARCH, (int)1, (int)1, (int)0);
        SelectionListener searchButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransformationSearchPanel.this.performSearch();
                TransformationSearchPanel.this.updateFindHistory();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.performSearchButton.addSelectionListener(searchButtonListener);
        this.updateFindHistory();
        return panel;
    }

    public TreeViewer createResultsTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        viewer.setContentProvider((IContentProvider)new AbstractTreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EObject) {
                    EObject mRootTarget = (EObject)parentElement;
                    SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)mRootTarget);
                    boolean supportsUpdates = false;
                    SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)mRootTarget);
                    if (sqlAspect != null && sqlAspect instanceof SqlTableAspect) {
                        supportsUpdates = ((SqlTableAspect)sqlAspect).supportsUpdate(mRootTarget);
                    }
                    ArrayList<SUIDObject> suidList = new ArrayList<SUIDObject>(4);
                    suidList.add(new SUIDObject(mRootTarget, 0));
                    if (supportsUpdates) {
                        if (TransformationSearchHelper.hasUserSql((SqlTransformationMappingRoot)tRoot, (int)1)) {
                            suidList.add(new SUIDObject(mRootTarget, 1));
                        }
                        if (TransformationSearchHelper.hasUserSql((SqlTransformationMappingRoot)tRoot, (int)2)) {
                            suidList.add(new SUIDObject(mRootTarget, 2));
                        }
                        if (TransformationSearchHelper.hasUserSql((SqlTransformationMappingRoot)tRoot, (int)3)) {
                            suidList.add(new SUIDObject(mRootTarget, 3));
                        }
                    }
                    return suidList.toArray();
                }
                return new Object[0];
            }

            public Object[] getElements(Object theInputElement) {
                return (Object[])theInputElement;
            }

            public Object getParent(Object element) {
                if (element instanceof SUIDObject) {
                    return ((SUIDObject)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof EObject;
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        viewer.getTree().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.keyCode == 27) {
                    event.doit = false;
                    ((Tree)event.widget).getShell().setVisible(false);
                }
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                StructuredSelection selection = (StructuredSelection)theEvent.getSelection();
                if (selection.getFirstElement() instanceof EObject) {
                    TransformationSearchPanel.this.parentDialog.setEditEnabled(true);
                    TransformationSearchPanel.this.lastSelectedTarget = (EObject)selection.getFirstElement();
                } else if (selection.getFirstElement() instanceof SUIDObject) {
                    TransformationSearchPanel.this.parentDialog.setEditEnabled(true);
                    TransformationSearchPanel.this.lastSelectedTarget = ((SUIDObject)selection.getFirstElement()).getParent();
                } else {
                    TransformationSearchPanel.this.parentDialog.setEditEnabled(false);
                    TransformationSearchPanel.this.lastSelectedTarget = null;
                }
            }
        });
        return viewer;
    }

    public EObject getLastSelectedTarget() {
        return this.lastSelectedTarget;
    }

    private void updateCombo(Combo combo, List content) {
        combo.removeAll();
        int i = 0;
        while (i < content.size()) {
            combo.add(content.get(i).toString());
            ++i;
        }
    }

    public void modifyText(ModifyEvent e) {
        this.fFindField.getText().equals("");
        if (this.getFindString() == null || this.getFindString().length() == 0) {
            this.setMessage(NO_STRING_ENTERED);
            this.performSearchButton.setEnabled(false);
        } else {
            this.performSearchButton.setEnabled(true);
            this.setMessage(TransformationSearchPanel.getString("TransformationSearchPanel.changedString", this.getFindString()));
        }
    }

    void performSearch() {
        String findString = this.getFindString();
        this.lastResults = Collections.EMPTY_LIST;
        if (findString != null && findString.length() > 0) {
            Collection results = Collections.EMPTY_LIST;
            try {
                results = this.searchHelper.findTransformationTargets(findString);
            }
            catch (CoreException theException) {
                UiConstants.Util.log(4, theException.getMessage());
            }
            this.searchResultsTreeViewer.setInput((Object)results.toArray());
            this.lastResults = new ArrayList(results);
            this.lastSearchString = findString;
            this.updateState();
            this.setMessage(TransformationSearchPanel.getString("TransformationSearchPanel.searchComplete", this.lastSearchString));
            if (this.lastResults.isEmpty()) {
                this.setSqlTextMessage(TransformationSearchPanel.getString("TransformationSearchPanel.noMatches", this.lastSearchString));
            } else {
                String sizeStr = "" + this.lastResults.size();
                this.setSqlTextMessage(TransformationSearchPanel.getString("TransformationSearchPanel.matchesFound", sizeStr, this.lastSearchString));
            }
            this.parentDialog.setEditEnabled(false);
        }
    }

    public ISelection getViewerSelection() {
        return this.searchResultsTreeViewer.getSelection();
    }

    private String getFindString() {
        return this.fFindField.getText();
    }

    private void updateState() {
        this.performSearchButton.setEnabled(true);
        if (this.getFindString() == null || this.getFindString().length() == 0) {
            this.setMessage(NO_STRING_ENTERED);
            this.performSearchButton.setEnabled(false);
        } else {
            this.setMessage("");
        }
    }

    private void setSqlTextMessage(final String message) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransformationSearchPanel.this.sqlMessageLabel != null && !TransformationSearchPanel.this.sqlMessageLabel.isDisposed()) {
                    TransformationSearchPanel.this.sqlMessageLabel.setText(message);
                    TransformationSearchPanel.this.sqlMessageLabel.redraw();
                }
            }
        });
    }

    private void setSqlGroupMessage(final String message) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransformationSearchPanel.this.sqlTextPanel != null && !TransformationSearchPanel.this.sqlTextPanel.isDisposed()) {
                    TransformationSearchPanel.this.sqlTextPanel.setText(message);
                    TransformationSearchPanel.this.sqlTextPanel.redraw();
                }
            }
        });
    }

    private void setMessage(final String message) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransformationSearchPanel.this.messageLabel != null && !TransformationSearchPanel.this.messageLabel.isDisposed()) {
                    if (message == null) {
                        TransformationSearchPanel.this.messageLabel.setImage(null);
                    }
                    TransformationSearchPanel.this.messageLabel.setText(message);
                    TransformationSearchPanel.this.messageLabel.redraw();
                }
            }
        });
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
        component.setLayoutData((Object)gd);
    }

    void updateFindHistory() {
        this.fFindField.removeModifyListener((ModifyListener)this);
        this.updateHistory(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener((ModifyListener)this);
    }

    private void updateHistory(Combo combo, List history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            this.updateCombo(combo, history);
            combo.setText(findString);
        }
    }

    class MyLabelProvider
    extends SelectModelObjectLabelProvider {
        public String getText(Object theElement) {
            if (theElement instanceof EObject) {
                EObject eo = (EObject)theElement;
                String sText = ModelerCore.getModelEditor().getName(eo);
                if (this.showPath) {
                    String path;
                    String type = this.getType(eo);
                    if (type != null) {
                        sText = String.valueOf(sText) + CoreStringUtil.Constants.SPACE + type + CoreStringUtil.Constants.SPACE;
                    }
                    if ((path = this.getAppendedPath(eo)) != null) {
                        sText = String.valueOf(sText) + " : " + this.getAppendedPath(eo);
                    }
                }
                return sText;
            }
            if (theElement instanceof SUIDObject) {
                return ((SUIDObject)theElement).getLabel();
            }
            return super.getText(theElement);
        }

        private String getType(EObject eObj) {
            if (TransformationHelper.isStagingTable((Object)eObj)) {
                return TransformationSearchPanel.STAGING_TABLE_STR;
            }
            if (TransformationHelper.isMappingClass((Object)eObj)) {
                return TransformationSearchPanel.MAPPING_CLASS_STR;
            }
            if (SqlAspectHelper.isProcedure((EObject)eObj)) {
                return TransformationSearchPanel.PROCEDURE_STR;
            }
            if (SqlAspectHelper.isTable((EObject)eObj)) {
                return TransformationSearchPanel.TABLE_STR;
            }
            return null;
        }

        private String getAppendedPath(EObject eObj) {
            if (TransformationHelper.isMappingClass((Object)eObj)) {
                MappingClass mc = (MappingClass)eObj;
                EObject doc = mc.getMappingClassSet().getTarget();
                IPath pathToDoc = ModelerCore.getModelEditor().getFullPathToParent(doc);
                pathToDoc = pathToDoc.append(ModelerCore.getModelEditor().getName(doc));
                return pathToDoc.toString();
            }
            return ModelerCore.getModelEditor().getFullPathToParent(eObj).toString();
        }
    }

    private class SUIDObject {
        public static final String SELECT_STR = "SELECT";
        public static final String INSERT_STR = "INSERT";
        public static final String UPDATE_STR = "UPDATE";
        public static final String DELETE_STR = "DELETE";
        private int suidValue = 0;
        private String suidLabel = "SELECT";
        private EObject parentEObject;

        public SUIDObject(EObject eObject, int suidID) {
            this.parentEObject = eObject;
            this.suidValue = suidID;
            switch (suidID) {
                case 0: {
                    this.suidLabel = SELECT_STR;
                    break;
                }
                case 1: {
                    this.suidLabel = INSERT_STR;
                    break;
                }
                case 2: {
                    this.suidLabel = UPDATE_STR;
                    break;
                }
                case 3: {
                    this.suidLabel = DELETE_STR;
                    break;
                }
                default: {
                    this.suidLabel = SELECT_STR;
                }
            }
        }

        public String getLabel() {
            return this.suidLabel;
        }

        public EObject getParent() {
            return this.parentEObject;
        }

        public int getSqlType() {
            return this.suidValue;
        }
    }
}

