/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.teiidddl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class ExportDDLToWorkspaceDialog
extends TitleAreaDialog
implements Listener,
UiConstants {
    private Text containerText;
    private Text fileNameText;
    private IContainer container;
    private String fileName;

    public ExportDDLToWorkspaceDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Util.getString("ExportDDLToWorkspaceDialog_title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(1, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDialogPanel(pnl);
        this.setTitle(Util.getString("ExportDDLToWorkspaceDialog_title", new Object[0]));
        this.setErrorMessage(Util.getString("ExportDDLToWorkspaceDialog_errorSelectLocation", new Object[0]));
        return pnl;
    }

    private void createDialogPanel(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridData topCompositeGridData = new GridData(768);
        dialogComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        dialogComposite.setLayout((Layout)topLayout);
        GridData gd = null;
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            Label locationLabel = new Label(dialogComposite, 0);
            locationLabel.setText(Util.getString("ExportDDLToWorkspaceDialog_locationLabel", new Object[0]));
            this.containerText = new Text(dialogComposite, 2052);
            gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.containerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExportDDLToWorkspaceDialog.this.updateStatus();
                }
            });
            this.containerText.setEditable(false);
            Button browseButton = new Button(dialogComposite, 8);
            GridData buttonGridData = new GridData();
            browseButton.setLayoutData((Object)buttonGridData);
            browseButton.setText(Util.getString("ExportDDLToWorkspaceDialog_browseButton", new Object[0]));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExportDDLToWorkspaceDialog.this.handleBrowseForTargetLocation();
                }
            });
        }
        Label fileLabel = new Label(dialogComposite, 0);
        fileLabel.setText(Util.getString("ExportDDLToWorkspaceDialog_fileNameLabel", new Object[0]));
        this.fileNameText = new Text(dialogComposite, 2052);
        gd = new GridData(768);
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.setText(Util.getString("ExportDDLToWorkspaceDialog_defaultFileName", new Object[0]));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDDLToWorkspaceDialog.this.updateStatus();
            }
        });
    }

    public void handleEvent(Event event) {
        this.updateStatus();
    }

    private void handleBrowseForTargetLocation() {
        IContainer container = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (container != null && this.containerText != null) {
            this.container = container;
            this.containerText.setText(container.getFullPath().makeRelative().toString());
        }
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void updateStatus() {
        IStatus status = this.validateLocation();
        if (status.isOK()) {
            status = this.validateName();
        }
        if (status.isOK()) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        }
    }

    private IStatus validateLocation() {
        String locationText = this.containerText.getText();
        if (CoreStringUtil.isEmpty((String)locationText)) {
            return new Status(4, "org.teiid.designer.transformation.ui", Util.getString("ExportDDLToWorkspaceDialog_errorSelectLocation", new Object[0]));
        }
        return new Status(0, "org.teiid.designer.transformation.ui", Util.getString("ExportDDLToWorkspaceDialog_Ok", new Object[0]));
    }

    private IStatus validateName() {
        this.fileName = this.fileNameText.getText();
        if (CoreStringUtil.isEmpty((String)this.fileName)) {
            return new Status(4, "org.teiid.designer.transformation.ui", Util.getString("ExportDDLToWorkspaceDialog_errorEnterFileName", new Object[0]));
        }
        return this.checkFileExists(this.container, this.fileName);
    }

    private IStatus checkFileExists(IContainer container, String fileName) {
        IResource[] resrcs;
        String errorMsg = null;
        boolean exists = false;
        try {
            resrcs = container.members();
        }
        catch (CoreException coreException) {
            return new Status(4, "org.teiid.designer.transformation.ui", Util.getString("ExportDDLToWorkspaceDialog_errorCouldNotGetMembers", new Object[0]));
        }
        int ndx = resrcs.length;
        while (--ndx >= 0) {
            if (!resrcs[ndx].getName().equalsIgnoreCase(fileName)) continue;
            exists = true;
            errorMsg = WidgetUtil.getFileExistsMessage((IFile)container.getFile((IPath)new Path(fileName)));
            break;
        }
        if (!exists) {
            exists = container.getLocation().append(fileName).toFile().exists();
            errorMsg = WidgetUtil.getFileExistsButNotInWorkspaceMessage((IFile)container.getFile((IPath)new Path(fileName)));
        }
        if (!exists) {
            return new Status(0, "org.teiid.designer.transformation.ui", Util.getString("ExportDDLToWorkspaceDialog_Ok", new Object[0]));
        }
        return new Status(4, "org.teiid.designer.transformation.ui", errorMsg);
    }

    public IContainer getTargetContainer() {
        return this.container;
    }

    public String getFileName() {
        return this.fileName;
    }
}

