/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.teiidddl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.teiidddl.TeiidDdlExporter;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;

public class ExportTeiidDdlModelSelectionPage
extends AbstractWizardPage
implements UiConstants {
    private static final String TITLE = Messages.ExportTeiidDdlModelSelectionPage_title;
    private static final String OPTIONS_GROUP = Messages.ExportTeiidDdlModelSelectionPage_ddlExportOptions;
    private static final String USE_NAMES_IN_SOURCE_CHECKBOX = Messages.ExportTeiidDdlModelSelectionPage_nameInSourceOption;
    private static final String USE_NATIVE_TYPE_CHECKBOX = Messages.ExportTeiidDdlModelSelectionPage_nativeTypeOption;
    private final TeiidDdlExporter exporter;
    private Text selectedFileText;
    private Button useNamesInSourceCheckBox;
    private Button useNativeTypeCheckBox;
    final ViewerFilter modelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            ModelerCore.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && (ModelIdentifier.isRelationalViewModel((ModelResource)theModel) || ModelIdentifier.isRelationalSourceModel((ModelResource)theModel))) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    public ExportTeiidDdlModelSelectionPage(TeiidDdlExporter exporter) {
        super(ExportTeiidDdlModelSelectionPage.class.getSimpleName(), TITLE);
        this.exporter = exporter;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(2, false));
        mainPanel.setLayoutData((Object)new GridData(272));
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.setMessage("Select target model for export and define available options");
        new Label(mainPanel, 0);
        new Label(mainPanel, 0);
        this.createSelectModelGroup(mainPanel);
        this.createOptionsGroup(mainPanel);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validatePage();
        }
    }

    private void createSelectModelGroup(Composite parent) {
        Group viewGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.ExportTeiidDdlModelSelectionPage_modelGroupTitle, (int)0, (int)2, (int)3);
        GridData gd_vg = new GridData(768);
        gd_vg.horizontalSpan = 2;
        viewGroup.setLayoutData((Object)gd_vg);
        Label fileLabel = new Label((Composite)viewGroup, 0);
        fileLabel.setText(Messages.ExportTeiidDdlModelSelectionPage_fileLabel);
        this.selectedFileText = new Text((Composite)viewGroup, 2052);
        GridData gridData = new GridData(768);
        this.selectedFileText.setLayoutData((Object)gridData);
        this.selectedFileText.setEditable(false);
        if (this.exporter.getModelResource() != null) {
            this.selectedFileText.setText(this.exporter.getModelResource().getItemName());
        }
        Button browseButton = new Button((Composite)viewGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTeiidDdlModelSelectionPage.this.handleModelBrowse();
            }
        });
    }

    private void createOptionsGroup(Composite parent) {
        this.exporter.setNameInSourceUsed(false);
        this.exporter.setNativeTypeUsed(false);
        Group group = WidgetFactory.createGroup((Composite)parent, (String)OPTIONS_GROUP, (int)768, (int)1, (int)2);
        this.useNamesInSourceCheckBox = WidgetFactory.createCheckBox((Composite)group, (String)USE_NAMES_IN_SOURCE_CHECKBOX, (int)0, (int)2, (boolean)this.exporter.isNameInSourceUsed());
        this.useNamesInSourceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportTeiidDdlModelSelectionPage.this.useNamesInSourceCheckBoxSelected();
            }
        });
        this.useNativeTypeCheckBox = WidgetFactory.createCheckBox((Composite)group, (String)USE_NATIVE_TYPE_CHECKBOX, (int)0, (int)2, (boolean)this.exporter.isNativeTypeUsed());
        this.useNativeTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportTeiidDdlModelSelectionPage.this.useNativeTypeCheckBoxSelected();
            }
        });
    }

    void handleModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)Messages.ExportTeiidDdlModelSelectionPage_selectModelDialogTitle, (String)Messages.ExportTeiidDdlModelSelectionPage_selectModelDialogMessage, (boolean)false, null, (ViewerFilter)this.modelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.selectedFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            ModelResource mr = ModelUtilities.getModelResource((Object)modelFile);
            this.exporter.setModelResource(mr);
        }
        if (this.exporter.getModelResource() != null) {
            this.selectedFileText.setText(this.exporter.getModelResource().getItemName());
        } else {
            this.selectedFileText.setText("");
        }
        this.validatePage();
    }

    private boolean validatePage() {
        IStatus status = this.exporter.validate();
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return true;
        }
        if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage());
            this.setPageComplete(true);
            return true;
        }
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    private void useNamesInSourceCheckBoxSelected() {
        this.exporter.setNameInSourceUsed(this.useNamesInSourceCheckBox.getSelection());
    }

    private void useNativeTypeCheckBoxSelected() {
        this.exporter.setNativeTypeUsed(this.useNativeTypeCheckBox.getSelection());
    }
}

